/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.audio;

import com.mojang.blaze3d.audio.OpenAlUtil;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL10;
import org.slf4j.Logger;

public class Channel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int QUEUED_BUFFER_COUNT = 4;
    public static final int BUFFER_DURATION_SECONDS = 1;
    private final int source;
    private final AtomicBoolean initialized = new AtomicBoolean(true);
    private int streamingBufferSize = 16384;
    @Nullable
    private AudioStream stream;

    @Nullable
    static Channel create() {
        int[] aint = new int[1];
        AL10.alGenSources((int[])aint);
        return OpenAlUtil.checkALError("Allocate new source") ? null : new Channel(aint[0]);
    }

    private Channel(int pSource) {
        this.source = pSource;
    }

    public void destroy() {
        if (this.initialized.compareAndSet(true, false)) {
            AL10.alSourceStop((int)this.source);
            OpenAlUtil.checkALError("Stop");
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to close audio stream", (Throwable)ioexception);
                }
                this.removeProcessedBuffers();
                this.stream = null;
            }
            AL10.alDeleteSources((int[])new int[]{this.source});
            OpenAlUtil.checkALError("Cleanup");
        }
    }

    public void play() {
        AL10.alSourcePlay((int)this.source);
    }

    private int getState() {
        return !this.initialized.get() ? 4116 : AL10.alGetSourcei((int)this.source, (int)4112);
    }

    public void pause() {
        if (this.getState() == 4114) {
            AL10.alSourcePause((int)this.source);
        }
    }

    public void unpause() {
        if (this.getState() == 4115) {
            AL10.alSourcePlay((int)this.source);
        }
    }

    public void stop() {
        if (this.initialized.get()) {
            AL10.alSourceStop((int)this.source);
            OpenAlUtil.checkALError("Stop");
        }
    }

    public boolean playing() {
        return this.getState() == 4114;
    }

    public boolean stopped() {
        return this.getState() == 4116;
    }

    public void setSelfPosition(Vec3 pSource) {
        AL10.alSourcefv((int)this.source, (int)4100, (float[])new float[]{(float)pSource.x, (float)pSource.y, (float)pSource.z});
    }

    public void setPitch(float pPitch) {
        AL10.alSourcef((int)this.source, (int)4099, (float)pPitch);
    }

    public void setLooping(boolean pLooping) {
        AL10.alSourcei((int)this.source, (int)4103, (int)(pLooping ? 1 : 0));
    }

    public void setVolume(float pVolume) {
        AL10.alSourcef((int)this.source, (int)4106, (float)pVolume);
    }

    public void disableAttenuation() {
        AL10.alSourcei((int)this.source, (int)53248, (int)0);
    }

    public void linearAttenuation(float pLinearAttenuation) {
        AL10.alSourcei((int)this.source, (int)53248, (int)53251);
        AL10.alSourcef((int)this.source, (int)4131, (float)pLinearAttenuation);
        AL10.alSourcef((int)this.source, (int)4129, (float)1.0f);
        AL10.alSourcef((int)this.source, (int)4128, (float)0.0f);
    }

    public void setRelative(boolean pRelative) {
        AL10.alSourcei((int)this.source, (int)514, (int)(pRelative ? 1 : 0));
    }

    public void attachStaticBuffer(SoundBuffer pBuffer) {
        pBuffer.getAlBuffer().ifPresent(p_83676_ -> AL10.alSourcei((int)this.source, (int)4105, (int)p_83676_));
    }

    public void attachBufferStream(AudioStream pStream) {
        this.stream = pStream;
        AudioFormat audioformat = pStream.getFormat();
        this.streamingBufferSize = Channel.calculateBufferSize(audioformat, 1);
        this.pumpBuffers(4);
    }

    private static int calculateBufferSize(AudioFormat pFormat, int pSampleAmount) {
        return (int)((float)(pSampleAmount * pFormat.getSampleSizeInBits()) / 8.0f * (float)pFormat.getChannels() * pFormat.getSampleRate());
    }

    private void pumpBuffers(int pReadCount) {
        if (this.stream != null) {
            try {
                int i = 0;
                while (i < pReadCount) {
                    ByteBuffer bytebuffer = this.stream.read(this.streamingBufferSize);
                    if (bytebuffer != null) {
                        new SoundBuffer(bytebuffer, this.stream.getFormat()).releaseAlBuffer().ifPresent(p_83669_ -> AL10.alSourceQueueBuffers((int)this.source, (int[])new int[]{p_83669_}));
                    }
                    ++i;
                }
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to read from audio stream", (Throwable)ioexception);
            }
        }
    }

    public void updateStream() {
        if (this.stream != null) {
            int i = this.removeProcessedBuffers();
            this.pumpBuffers(i);
        }
    }

    private int removeProcessedBuffers() {
        int i = AL10.alGetSourcei((int)this.source, (int)4118);
        if (i > 0) {
            int[] aint = new int[i];
            AL10.alSourceUnqueueBuffers((int)this.source, (int[])aint);
            OpenAlUtil.checkALError("Unqueue buffers");
            AL10.alDeleteBuffers((int[])aint);
            OpenAlUtil.checkALError("Remove processed buffers");
        }
        return i;
    }
}

