/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.audio;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Listener;
import com.mojang.blaze3d.audio.OpenAlUtil;
import com.mojang.logging.LogUtils;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.util.Mth;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALUtil;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;

public class Library {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_DEVICE = 0;
    private static final int DEFAULT_CHANNEL_COUNT = 30;
    private long currentDevice;
    private long context;
    private boolean supportsDisconnections;
    @Nullable
    private String defaultDeviceName;
    private static final ChannelPool EMPTY = new ChannelPool(){

        @Override
        @Nullable
        public Channel acquire() {
            return null;
        }

        @Override
        public boolean release(Channel p_83708_) {
            return false;
        }

        @Override
        public void cleanup() {
        }

        @Override
        public int getMaxCount() {
            return 0;
        }

        @Override
        public int getUsedCount() {
            return 0;
        }
    };
    private ChannelPool staticChannels = EMPTY;
    private ChannelPool streamingChannels = EMPTY;
    private final Listener listener = new Listener();

    public Library() {
        this.defaultDeviceName = Library.getDefaultDeviceName();
    }

    public void init(@Nullable String p_193470_) {
        this.currentDevice = Library.openDeviceOrFallback(p_193470_);
        this.supportsDisconnections = ALC10.alcIsExtensionPresent((long)this.currentDevice, (CharSequence)"ALC_EXT_disconnect");
        ALCCapabilities alccapabilities = ALC.createCapabilities((long)this.currentDevice);
        if (OpenAlUtil.checkALCError(this.currentDevice, "Get capabilities")) {
            throw new IllegalStateException("Failed to get OpenAL capabilities");
        }
        if (!alccapabilities.OpenALC11) {
            throw new IllegalStateException("OpenAL 1.1 not supported");
        }
        this.context = ALC10.alcCreateContext((long)this.currentDevice, null);
        ALC10.alcMakeContextCurrent((long)this.context);
        int i = this.getChannelCount();
        int j = Mth.clamp((int)Mth.sqrt(i), 2, 8);
        int k = Mth.clamp(i - j, 8, 255);
        this.staticChannels = new CountingChannelPool(k);
        this.streamingChannels = new CountingChannelPool(j);
        ALCapabilities alcapabilities = AL.createCapabilities((ALCCapabilities)alccapabilities);
        OpenAlUtil.checkALError("Initialization");
        if (!alcapabilities.AL_EXT_source_distance_model) {
            throw new IllegalStateException("AL_EXT_source_distance_model is not supported");
        }
        AL10.alEnable((int)512);
        if (!alcapabilities.AL_EXT_LINEAR_DISTANCE) {
            throw new IllegalStateException("AL_EXT_LINEAR_DISTANCE is not supported");
        }
        OpenAlUtil.checkALError("Enable per-source distance models");
        LOGGER.info("OpenAL initialized on device {}", (Object)this.getCurrentDeviceName());
    }

    private int getChannelCount() {
        int i1;
        block11: {
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                int i = ALC10.alcGetInteger((long)this.currentDevice, (int)4098);
                if (OpenAlUtil.checkALCError(this.currentDevice, "Get attributes size")) {
                    throw new IllegalStateException("Failed to get OpenAL attributes");
                }
                IntBuffer intbuffer = memorystack.mallocInt(i);
                ALC10.alcGetIntegerv((long)this.currentDevice, (int)4099, (IntBuffer)intbuffer);
                if (OpenAlUtil.checkALCError(this.currentDevice, "Get attributes")) {
                    throw new IllegalStateException("Failed to get OpenAL attributes");
                }
                int j = 0;
                while (j < i) {
                    int k;
                    if ((k = intbuffer.get(j++)) == 0) {
                        break;
                    }
                    int l = intbuffer.get(j++);
                    if (k != 4112) continue;
                    i1 = l;
                    break block11;
                }
            }
            return 30;
        }
        return i1;
    }

    @Nullable
    public static String getDefaultDeviceName() {
        if (!ALC10.alcIsExtensionPresent((long)0L, (CharSequence)"ALC_ENUMERATE_ALL_EXT")) {
            return null;
        }
        ALUtil.getStringList((long)0L, (int)4115);
        return ALC10.alcGetString((long)0L, (int)4114);
    }

    public String getCurrentDeviceName() {
        String s = ALC10.alcGetString((long)this.currentDevice, (int)4115);
        if (s == null) {
            s = ALC10.alcGetString((long)this.currentDevice, (int)4101);
        }
        if (s == null) {
            s = "Unknown";
        }
        return s;
    }

    public synchronized boolean hasDefaultDeviceChanged() {
        String s = Library.getDefaultDeviceName();
        if (Objects.equals(this.defaultDeviceName, s)) {
            return false;
        }
        this.defaultDeviceName = s;
        return true;
    }

    private static long openDeviceOrFallback(@Nullable String p_193473_) {
        OptionalLong optionallong = OptionalLong.empty();
        if (p_193473_ != null) {
            optionallong = Library.tryOpenDevice(p_193473_);
        }
        if (optionallong.isEmpty()) {
            optionallong = Library.tryOpenDevice(Library.getDefaultDeviceName());
        }
        if (optionallong.isEmpty()) {
            optionallong = Library.tryOpenDevice(null);
        }
        if (optionallong.isEmpty()) {
            throw new IllegalStateException("Failed to open OpenAL device");
        }
        return optionallong.getAsLong();
    }

    private static OptionalLong tryOpenDevice(@Nullable String p_193476_) {
        long i = ALC10.alcOpenDevice((CharSequence)p_193476_);
        return i != 0L && !OpenAlUtil.checkALCError(i, "Open device") ? OptionalLong.of(i) : OptionalLong.empty();
    }

    public void cleanup() {
        this.staticChannels.cleanup();
        this.streamingChannels.cleanup();
        ALC10.alcDestroyContext((long)this.context);
        if (this.currentDevice != 0L) {
            ALC10.alcCloseDevice((long)this.currentDevice);
        }
    }

    public Listener getListener() {
        return this.listener;
    }

    @Nullable
    public Channel acquireChannel(Pool pPool) {
        return (pPool == Pool.STREAMING ? this.streamingChannels : this.staticChannels).acquire();
    }

    public void releaseChannel(Channel pChannel) {
        if (!this.staticChannels.release(pChannel) && !this.streamingChannels.release(pChannel)) {
            throw new IllegalStateException("Tried to release unknown channel");
        }
    }

    public String getDebugString() {
        return String.format("Sounds: %d/%d + %d/%d", this.staticChannels.getUsedCount(), this.staticChannels.getMaxCount(), this.streamingChannels.getUsedCount(), this.streamingChannels.getMaxCount());
    }

    public List<String> getAvailableSoundDevices() {
        List list = ALUtil.getStringList((long)0L, (int)4115);
        return list == null ? Collections.emptyList() : list;
    }

    public boolean isCurrentDeviceDisconnected() {
        return this.supportsDisconnections && ALC11.alcGetInteger((long)this.currentDevice, (int)787) == 0;
    }

    static interface ChannelPool {
        @Nullable
        public Channel acquire();

        public boolean release(Channel var1);

        public void cleanup();

        public int getMaxCount();

        public int getUsedCount();
    }

    static class CountingChannelPool
    implements ChannelPool {
        private final int limit;
        private final Set<Channel> activeChannels = Sets.newIdentityHashSet();

        public CountingChannelPool(int pLimit) {
            this.limit = pLimit;
        }

        @Override
        @Nullable
        public Channel acquire() {
            if (this.activeChannels.size() >= this.limit) {
                if (SharedConstants.IS_RUNNING_IN_IDE) {
                    LOGGER.warn("Maximum sound pool size {} reached", (Object)this.limit);
                }
                return null;
            }
            Channel channel = Channel.create();
            if (channel != null) {
                this.activeChannels.add(channel);
            }
            return channel;
        }

        @Override
        public boolean release(Channel pChannel) {
            if (!this.activeChannels.remove(pChannel)) {
                return false;
            }
            pChannel.destroy();
            return true;
        }

        @Override
        public void cleanup() {
            this.activeChannels.forEach(Channel::destroy);
            this.activeChannels.clear();
        }

        @Override
        public int getMaxCount() {
            return this.limit;
        }

        @Override
        public int getUsedCount() {
            return this.activeChannels.size();
        }
    }

    public static enum Pool {
        STATIC,
        STREAMING;

    }
}

