/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.font;

import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class TrueTypeGlyphProvider
implements GlyphProvider {
    private final ByteBuffer fontMemory;
    final STBTTFontinfo font;
    final float oversample;
    private final IntSet skip = new IntArraySet();
    final float shiftX;
    final float shiftY;
    final float pointScale;
    final float ascent;

    public TrueTypeGlyphProvider(ByteBuffer pFontMemory, STBTTFontinfo pFont, float pHeight, float pOversample, float pShiftX, float pShiftY, String pSkip) {
        this.fontMemory = pFontMemory;
        this.font = pFont;
        this.oversample = pOversample;
        pSkip.codePoints().forEach(arg_0 -> ((IntSet)this.skip).add(arg_0));
        this.shiftX = pShiftX * pOversample;
        this.shiftY = pShiftY * pOversample;
        this.pointScale = STBTruetype.stbtt_ScaleForPixelHeight((STBTTFontinfo)pFont, (float)(pHeight * pOversample));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            STBTruetype.stbtt_GetFontVMetrics((STBTTFontinfo)pFont, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2);
            this.ascent = (float)intbuffer.get(0) * this.pointScale;
        }
    }

    @Override
    @Nullable
    public Glyph getGlyph(int pCharacter) {
        Object object1;
        block9: {
            Glyph truetypeglyphprovider$glyph;
            block10: {
                Object $$9;
                if (this.skip.contains(pCharacter)) {
                    return null;
                }
                try (MemoryStack memorystack = MemoryStack.stackPush();){
                    IntBuffer intbuffer = memorystack.mallocInt(1);
                    IntBuffer intbuffer1 = memorystack.mallocInt(1);
                    IntBuffer intbuffer2 = memorystack.mallocInt(1);
                    IntBuffer intbuffer3 = memorystack.mallocInt(1);
                    int i = STBTruetype.stbtt_FindGlyphIndex((STBTTFontinfo)this.font, (int)pCharacter);
                    if (i == 0) {
                        object1 = null;
                        break block9;
                    }
                    STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel((STBTTFontinfo)this.font, (int)i, (float)this.pointScale, (float)this.pointScale, (float)this.shiftX, (float)this.shiftY, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (IntBuffer)intbuffer3);
                    int j = intbuffer2.get(0) - intbuffer.get(0);
                    int k = intbuffer3.get(0) - intbuffer1.get(0);
                    if (j > 0 && k > 0) {
                        IntBuffer intbuffer5 = memorystack.mallocInt(1);
                        IntBuffer intbuffer4 = memorystack.mallocInt(1);
                        STBTruetype.stbtt_GetGlyphHMetrics((STBTTFontinfo)this.font, (int)i, (IntBuffer)intbuffer5, (IntBuffer)intbuffer4);
                        truetypeglyphprovider$glyph = new Glyph(intbuffer.get(0), intbuffer2.get(0), -intbuffer1.get(0), -intbuffer3.get(0), (float)intbuffer5.get(0) * this.pointScale, (float)intbuffer4.get(0) * this.pointScale, i);
                        break block10;
                    }
                    $$9 = null;
                }
                return $$9;
            }
            return truetypeglyphprovider$glyph;
        }
        return object1;
    }

    @Override
    public void close() {
        this.font.free();
        MemoryUtil.memFree((Buffer)this.fontMemory);
    }

    @Override
    public IntSet getSupportedGlyphs() {
        return (IntSet)IntStream.range(0, 65535).filter(p_83863_ -> !this.skip.contains(p_83863_)).collect(IntOpenHashSet::new, IntCollection::add, IntCollection::addAll);
    }

    class Glyph
    implements RawGlyph {
        private final int width;
        private final int height;
        private final float bearingX;
        private final float bearingY;
        private final float advance;
        private final int index;

        Glyph(int p_83882_, int p_83883_, int p_83884_, int p_83885_, float p_83886_, float p_83887_, int p_83888_) {
            this.width = p_83883_ - p_83882_;
            this.height = p_83884_ - p_83885_;
            this.advance = p_83886_ / TrueTypeGlyphProvider.this.oversample;
            this.bearingX = (p_83887_ + (float)p_83882_ + TrueTypeGlyphProvider.this.shiftX) / TrueTypeGlyphProvider.this.oversample;
            this.bearingY = (TrueTypeGlyphProvider.this.ascent - (float)p_83884_ + TrueTypeGlyphProvider.this.shiftY) / TrueTypeGlyphProvider.this.oversample;
            this.index = p_83888_;
        }

        @Override
        public int getPixelWidth() {
            return this.width;
        }

        @Override
        public int getPixelHeight() {
            return this.height;
        }

        @Override
        public float getOversample() {
            return TrueTypeGlyphProvider.this.oversample;
        }

        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public float getBearingX() {
            return this.bearingX;
        }

        @Override
        public float getBearingY() {
            return this.bearingY;
        }

        @Override
        public void upload(int pXOffset, int pYOffset) {
            NativeImage nativeimage = new NativeImage(NativeImage.Format.LUMINANCE, this.width, this.height, false);
            nativeimage.copyFromFont(TrueTypeGlyphProvider.this.font, this.index, this.width, this.height, TrueTypeGlyphProvider.this.pointScale, TrueTypeGlyphProvider.this.pointScale, TrueTypeGlyphProvider.this.shiftX, TrueTypeGlyphProvider.this.shiftY, 0, 0);
            nativeimage.upload(0, pXOffset, pYOffset, 0, 0, this.width, this.height, false, true);
        }

        @Override
        public boolean isColored() {
            return false;
        }
    }
}

