/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.TextComponent;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.util.ArrayUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.slf4j.Logger;

public class GlDebug {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CIRCULAR_LOG_SIZE = 10;
    private static final Queue<LogEntry> MESSAGE_BUFFER = EvictingQueue.create((int)10);
    @Nullable
    private static volatile LogEntry lastEntry;
    private static final List<Integer> DEBUG_LEVELS;
    private static final List<Integer> DEBUG_LEVELS_ARB;
    private static boolean debugEnabled;
    private static int[] ignoredErrors;

    static {
        DEBUG_LEVELS = ImmutableList.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
        DEBUG_LEVELS_ARB = ImmutableList.of((Object)37190, (Object)37191, (Object)37192);
        ignoredErrors = GlDebug.makeIgnoredErrors();
    }

    private static int[] makeIgnoredErrors() {
        String s = System.getProperty("gl.ignore.errors");
        if (s == null) {
            return new int[0];
        }
        String[] astring = Config.tokenize(s, ",");
        int[] aint = new int[]{};
        int i = 0;
        while (i < astring.length) {
            int j;
            String s1 = astring[i].trim();
            int n = j = s1.startsWith("0x") ? Config.parseHexInt(s1, -1) : Config.parseInt(s1, -1);
            if (j < 0) {
                Config.warn("Invalid error id: " + s1);
            } else {
                Config.log("Ignore OpenGL error: " + j);
                aint = ArrayUtils.addIntToArray(aint, j);
            }
            ++i;
        }
        return aint;
    }

    private static String printUnknownToken(int pToken) {
        return "Unknown (0x" + Integer.toHexString(pToken).toUpperCase() + ")";
    }

    public static String sourceToString(int pSource) {
        switch (pSource) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return GlDebug.printUnknownToken(pSource);
    }

    public static String typeToString(int pType) {
        switch (pType) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return GlDebug.printUnknownToken(pType);
    }

    public static String severityToString(int pSeverity) {
        switch (pSeverity) {
            case 33387: {
                return "NOTIFICATION";
            }
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return GlDebug.printUnknownToken(pSeverity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printDebugLog(int p_84039_, int p_84040_, int p_84041_, int p_84042_, int p_84043_, long p_84044_, long p_84045_) {
        Minecraft minecraft;
        if (!(p_84040_ == 33385 || p_84040_ == 33386 || ArrayUtils.contains(ignoredErrors, p_84041_) || Config.isShaders() && p_84039_ == 33352 || (minecraft = Minecraft.getInstance()) != null && minecraft.getWindow() != null && minecraft.getWindow().isClosed() || !GlErrors.isEnabled(p_84041_))) {
            String s = GlDebug.sourceToString(p_84039_);
            String s1 = GlDebug.typeToString(p_84040_);
            String s2 = GlDebug.severityToString(p_84042_);
            String s3 = GLDebugMessageCallback.getMessage((int)p_84043_, (long)p_84044_);
            s3 = StrUtils.trim(s3, " \n\r\t");
            String s4 = String.format("OpenGL %s %s: %s (%s)", s, s1, p_84041_, s3);
            Exception exception = new Exception("Stack trace");
            StackTraceElement[] astacktraceelement = exception.getStackTrace();
            StackTraceElement[] astacktraceelement1 = astacktraceelement.length > 2 ? Arrays.copyOfRange(astacktraceelement, 2, astacktraceelement.length) : astacktraceelement;
            exception.setStackTrace(astacktraceelement1);
            if (p_84040_ == 33356) {
                LOGGER.error(s4, (Throwable)exception);
            } else {
                LOGGER.info(s4, (Throwable)exception);
            }
            if (Config.isShowGlErrors() && TimedEvent.isActive("ShowGlErrorDebug", 10000L)) {
                String s5 = Config.getGlErrorString(p_84041_);
                if (p_84041_ == 0 || Config.equals(s5, "Unknown")) {
                    s5 = s3;
                }
                String s6 = I18n.a("of.message.openglError", p_84041_, s5);
                Minecraft.getInstance().gui.getChat().addMessage(new TextComponent(s6));
            }
            String s7 = GLDebugMessageCallback.getMessage((int)p_84043_, (long)p_84044_);
            Queue<LogEntry> queue = MESSAGE_BUFFER;
            synchronized (queue) {
                LogEntry gldebug$logentry = lastEntry;
                if (gldebug$logentry != null && gldebug$logentry.isSame(p_84039_, p_84040_, p_84041_, p_84042_, s7)) {
                    ++gldebug$logentry.count;
                } else {
                    gldebug$logentry = new LogEntry(p_84039_, p_84040_, p_84041_, p_84042_, s7);
                    MESSAGE_BUFFER.add(gldebug$logentry);
                    lastEntry = gldebug$logentry;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLastOpenGlDebugMessages() {
        Queue<LogEntry> queue = MESSAGE_BUFFER;
        synchronized (queue) {
            ArrayList list = Lists.newArrayListWithCapacity((int)MESSAGE_BUFFER.size());
            for (LogEntry gldebug$logentry : MESSAGE_BUFFER) {
                list.add(gldebug$logentry + " x " + gldebug$logentry.count);
            }
            return list;
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void enableDebugCallback(int pDebugVerbosity, boolean pSynchronous) {
        RenderSystem.assertInInitPhase();
        if (pDebugVerbosity > 0) {
            GLCapabilities glcapabilities = GL.getCapabilities();
            if (glcapabilities.GL_KHR_debug) {
                debugEnabled = true;
                GL11.glEnable((int)37600);
                if (pSynchronous) {
                    GL11.glEnable((int)33346);
                }
                int i = 0;
                while (i < DEBUG_LEVELS.size()) {
                    boolean flag = i < pDebugVerbosity;
                    KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)DEBUG_LEVELS.get(i), null, (boolean)flag);
                    ++i;
                }
                KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make(GLDebugMessageCallback.create(GlDebug::printDebugLog), DebugMemoryUntracker::untrack)), (long)0L);
            } else if (glcapabilities.GL_ARB_debug_output) {
                debugEnabled = true;
                if (pSynchronous) {
                    GL11.glEnable((int)33346);
                }
                int j = 0;
                while (j < DEBUG_LEVELS_ARB.size()) {
                    boolean flag1 = j < pDebugVerbosity;
                    ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)DEBUG_LEVELS_ARB.get(j), null, (boolean)flag1);
                    ++j;
                }
                ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.make(GLDebugMessageARBCallback.create(GlDebug::printDebugLog), DebugMemoryUntracker::untrack)), (long)0L);
            }
        }
    }

    static class LogEntry {
        private final int id;
        private final int source;
        private final int type;
        private final int severity;
        private final String message;
        int count = 1;

        LogEntry(int pSource, int pType, int pId, int pSeverity, String pMessage) {
            this.id = pId;
            this.source = pSource;
            this.type = pType;
            this.severity = pSeverity;
            this.message = pMessage;
        }

        boolean isSame(int pSource, int pType, int pId, int pSeverity, String pMessage) {
            return pType == this.type && pSource == this.source && pId == this.id && pSeverity == this.severity && pMessage.equals(this.message);
        }

        public String toString() {
            return "id=" + this.id + ", source=" + GlDebug.sourceToString(this.source) + ", type=" + GlDebug.typeToString(this.type) + ", severity=" + GlDebug.severityToString(this.severity) + ", message='" + this.message + "'";
        }
    }
}

