/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.GlAlphaState;
import net.optifine.render.GlBlendState;
import net.optifine.render.GlCullState;
import net.optifine.shaders.Shaders;
import net.optifine.util.LockCounter;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBDrawBuffersBlend;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@DontObfuscate
public class GlStateManager {
    private static final boolean ON_LINUX = Util.getPlatform() == Util.OS.LINUX;
    public static final int TEXTURE_COUNT = 12;
    private static final BlendState BLEND = new BlendState();
    private static final DepthState DEPTH = new DepthState();
    private static final CullState CULL = new CullState();
    private static final PolygonOffsetState POLY_OFFSET = new PolygonOffsetState();
    private static final ColorLogicState COLOR_LOGIC = new ColorLogicState();
    private static final StencilState STENCIL = new StencilState();
    private static final ScissorState SCISSOR = new ScissorState();
    private static int activeTexture;
    private static final TextureState[] TEXTURES;
    private static final ColorMask COLOR_MASK;
    private static boolean alphaTest;
    private static int alphaTestFunc;
    private static float alphaTestRef;
    private static LockCounter alphaLock;
    private static GlAlphaState alphaLockState;
    private static LockCounter blendLock;
    private static GlBlendState blendLockState;
    private static LockCounter cullLock;
    private static GlCullState cullLockState;
    public static boolean vboRegions;
    public static int GL_COPY_READ_BUFFER;
    public static int GL_COPY_WRITE_BUFFER;
    public static int GL_ARRAY_BUFFER;
    public static int GL_STATIC_DRAW;
    public static final int GL_QUADS = 7;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    private static int framebufferRead;
    private static int framebufferDraw;
    private static final int[] IMAGE_TEXTURES;
    private static int glProgram;
    public static float lastBrightnessX;
    public static float lastBrightnessY;

    static {
        TEXTURES = (TextureState[])IntStream.range(0, 32).mapToObj(p_157120_ -> new TextureState()).toArray(TextureState[]::new);
        COLOR_MASK = new ColorMask();
        alphaTest = false;
        alphaTestFunc = 519;
        alphaTestRef = 0.0f;
        alphaLock = new LockCounter();
        alphaLockState = new GlAlphaState();
        blendLock = new LockCounter();
        blendLockState = new GlBlendState();
        cullLock = new LockCounter();
        cullLockState = new GlCullState();
        IMAGE_TEXTURES = new int[8];
        glProgram = 0;
        lastBrightnessX = 0.0f;
        lastBrightnessY = 0.0f;
    }

    public static void disableAlphaTest() {
        if (alphaLock.isLocked()) {
            alphaLockState.setDisabled();
        } else {
            alphaTest = false;
            GlStateManager.applyAlphaTest();
        }
    }

    public static void enableAlphaTest() {
        if (alphaLock.isLocked()) {
            alphaLockState.setEnabled();
        } else {
            alphaTest = true;
            GlStateManager.applyAlphaTest();
        }
    }

    public static void alphaFunc(int func, float ref) {
        if (alphaLock.isLocked()) {
            alphaLockState.setFuncRef(func, ref);
        } else {
            alphaTestFunc = func;
            alphaTestRef = ref;
            GlStateManager.applyAlphaTest();
        }
    }

    public static void applyAlphaTest() {
        if (Config.isShaders()) {
            if (alphaTest && alphaTestFunc == 516) {
                Shaders.uniform_alphaTestRef.setValue(alphaTestRef);
            } else {
                Shaders.uniform_alphaTestRef.setValue(0.0f);
            }
        }
    }

    public static void _disableScissorTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.SCISSOR.mode.disable();
    }

    public static void _enableScissorTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.SCISSOR.mode.enable();
    }

    public static void _scissorBox(int pX, int pY, int pWidth, int pHeight) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL20.glScissor((int)pX, (int)pY, (int)pWidth, (int)pHeight);
    }

    public static void _disableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.DEPTH.mode.disable();
    }

    public static void _enableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.DEPTH.mode.enable();
    }

    public static void _depthFunc(int pDepthFunc) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (pDepthFunc != GlStateManager.DEPTH.func) {
            GlStateManager.DEPTH.func = pDepthFunc;
            GL11.glDepthFunc((int)pDepthFunc);
        }
    }

    public static void _depthMask(boolean pFlag) {
        RenderSystem.assertOnRenderThread();
        if (pFlag != GlStateManager.DEPTH.mask) {
            GlStateManager.DEPTH.mask = pFlag;
            GL11.glDepthMask((boolean)pFlag);
        }
    }

    public static void _disableBlend() {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setDisabled();
        } else {
            GlStateManager.BLEND.mode.disable();
        }
    }

    public static void _enableBlend() {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setEnabled();
        } else {
            GlStateManager.BLEND.mode.enable();
        }
    }

    public static void _blendFunc(int pSourceFactor, int pDestFactor) {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setFactors(pSourceFactor, pDestFactor);
        } else if (pSourceFactor != GlStateManager.BLEND.srcRgb || pDestFactor != GlStateManager.BLEND.dstRgb || pSourceFactor != GlStateManager.BLEND.srcAlpha || pDestFactor != GlStateManager.BLEND.dstAlpha) {
            GlStateManager.BLEND.srcRgb = pSourceFactor;
            GlStateManager.BLEND.dstRgb = pDestFactor;
            GlStateManager.BLEND.srcAlpha = pSourceFactor;
            GlStateManager.BLEND.dstAlpha = pDestFactor;
            if (Config.isShaders()) {
                Shaders.uniform_blendFunc.setValue(pSourceFactor, pDestFactor, pSourceFactor, pDestFactor);
            }
            GL11.glBlendFunc((int)pSourceFactor, (int)pDestFactor);
        }
    }

    public static void _blendFuncSeparate(int pSrcFactor, int pDstFactor, int pSrcFactorAlpha, int pDstFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setFactors(pSrcFactor, pDstFactor, pSrcFactorAlpha, pDstFactorAlpha);
        } else if (pSrcFactor != GlStateManager.BLEND.srcRgb || pDstFactor != GlStateManager.BLEND.dstRgb || pSrcFactorAlpha != GlStateManager.BLEND.srcAlpha || pDstFactorAlpha != GlStateManager.BLEND.dstAlpha) {
            GlStateManager.BLEND.srcRgb = pSrcFactor;
            GlStateManager.BLEND.dstRgb = pDstFactor;
            GlStateManager.BLEND.srcAlpha = pSrcFactorAlpha;
            GlStateManager.BLEND.dstAlpha = pDstFactorAlpha;
            if (Config.isShaders()) {
                Shaders.uniform_blendFunc.setValue(pSrcFactor, pDstFactor, pSrcFactorAlpha, pDstFactorAlpha);
            }
            GlStateManager.glBlendFuncSeparate(pSrcFactor, pDstFactor, pSrcFactorAlpha, pDstFactorAlpha);
        }
    }

    public static void _blendEquation(int pMode) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendEquation((int)pMode);
    }

    public static void init(GLCapabilities glCapabilities) {
        RenderSystem.assertOnGameThreadOrInit();
        Config.initDisplay();
        GL_COPY_READ_BUFFER = 36662;
        GL_COPY_WRITE_BUFFER = 36663;
        GL_ARRAY_BUFFER = 34962;
        GL_STATIC_DRAW = 35044;
        boolean flag = true;
        boolean flag1 = true;
        boolean bl = vboRegions = flag && flag1;
        if (!vboRegions) {
            ArrayList<String> list = new ArrayList<String>();
            if (!flag) {
                list.add("OpenGL 1.3, ARB_copy_buffer");
            }
            if (!flag1) {
                list.add("OpenGL 1.4");
            }
            String s = "VboRegions not supported, missing: " + Config.listToString(list);
            Config.dbg(s);
        }
    }

    public static int glGetProgrami(int pProgram, int pPname) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgrami((int)pProgram, (int)pPname);
    }

    public static void glAttachShader(int pProgram, int pShader) {
        RenderSystem.assertOnRenderThread();
        GL20.glAttachShader((int)pProgram, (int)pShader);
    }

    public static void glDeleteShader(int pShader) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteShader((int)pShader);
    }

    public static int glCreateShader(int pType) {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateShader((int)pType);
    }

    public static void glShaderSource(int p_157117_, List<String> p_157118_) {
        RenderSystem.assertOnRenderThread();
        StringBuilder stringbuilder = new StringBuilder();
        for (String s : p_157118_) {
            stringbuilder.append(s);
        }
        byte[] abyte = stringbuilder.toString().getBytes(Charsets.UTF_8);
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(abyte.length + 1));
        bytebuffer.put(abyte);
        bytebuffer.put((byte)0);
        bytebuffer.flip();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            pointerbuffer.put(bytebuffer);
            GL20C.nglShaderSource((int)p_157117_, (int)1, (long)pointerbuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
    }

    public static void glCompileShader(int pShader) {
        RenderSystem.assertOnRenderThread();
        GL20.glCompileShader((int)pShader);
    }

    public static int glGetShaderi(int pShader, int pPname) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderi((int)pShader, (int)pPname);
    }

    public static void _glUseProgram(int pProgram) {
        RenderSystem.assertOnRenderThread();
        if (glProgram != pProgram) {
            GL20.glUseProgram((int)pProgram);
            glProgram = pProgram;
        }
    }

    public static int glCreateProgram() {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int pProgram) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteProgram((int)pProgram);
    }

    public static void glLinkProgram(int pProgram) {
        RenderSystem.assertOnRenderThread();
        GL20.glLinkProgram((int)pProgram);
    }

    public static int _glGetUniformLocation(int pProgram, CharSequence pName) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetUniformLocation((int)pProgram, (CharSequence)pName);
    }

    public static void _glUniform1(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1iv((int)pLocation, (IntBuffer)pValue);
    }

    public static void _glUniform1i(int pLocation, int pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1i((int)pLocation, (int)pValue);
    }

    public static void _glUniform1(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1fv((int)pLocation, (FloatBuffer)pValue);
    }

    public static void _glUniform2(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2iv((int)pLocation, (IntBuffer)pValue);
    }

    public static void _glUniform2(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2fv((int)pLocation, (FloatBuffer)pValue);
    }

    public static void _glUniform3(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3iv((int)pLocation, (IntBuffer)pValue);
    }

    public static void _glUniform3(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3fv((int)pLocation, (FloatBuffer)pValue);
    }

    public static void _glUniform4(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4iv((int)pLocation, (IntBuffer)pValue);
    }

    public static void _glUniform4(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4fv((int)pLocation, (FloatBuffer)pValue);
    }

    public static void _glUniformMatrix2(int pLocation, boolean pTranspose, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix2fv((int)pLocation, (boolean)pTranspose, (FloatBuffer)pValue);
    }

    public static void _glUniformMatrix3(int pLocation, boolean pTranspose, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix3fv((int)pLocation, (boolean)pTranspose, (FloatBuffer)pValue);
    }

    public static void _glUniformMatrix4(int pLocation, boolean pTranspose, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix4fv((int)pLocation, (boolean)pTranspose, (FloatBuffer)pValue);
    }

    public static int _glGetAttribLocation(int pProgram, CharSequence pName) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetAttribLocation((int)pProgram, (CharSequence)pName);
    }

    public static void _glBindAttribLocation(int pProgram, int pIndex, CharSequence pName) {
        RenderSystem.assertOnRenderThread();
        GL20.glBindAttribLocation((int)pProgram, (int)pIndex, (CharSequence)pName);
    }

    public static int _glGenBuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL15.glGenBuffers();
    }

    public static int _glGenVertexArrays() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenVertexArrays();
    }

    public static void _glBindBuffer(int pTarget, int pBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBindBuffer((int)pTarget, (int)pBuffer);
    }

    public static void _glBindVertexArray(int pArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindVertexArray((int)pArray);
    }

    public static void _glBufferData(int pTarget, ByteBuffer pSize, int p_84259_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBufferData((int)pTarget, (ByteBuffer)pSize, (int)p_84259_);
    }

    public static void _glBufferData(int pTarget, long pSize, int p_157073_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBufferData((int)pTarget, (long)pSize, (int)p_157073_);
    }

    @Nullable
    public static ByteBuffer _glMapBuffer(int pTarget, int pAccess) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL15.glMapBuffer((int)pTarget, (int)pAccess);
    }

    public static void _glUnmapBuffer(int pTarget) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glUnmapBuffer((int)pTarget);
    }

    public static void _glDeleteBuffers(int pBuffer) {
        RenderSystem.assertOnRenderThread();
        if (ON_LINUX) {
            GL32C.glBindBuffer((int)34962, (int)pBuffer);
            GL32C.glBufferData((int)34962, (long)0L, (int)35048);
            GL32C.glBindBuffer((int)34962, (int)0);
        }
        GL15.glDeleteBuffers((int)pBuffer);
    }

    public static void _glCopyTexSubImage2D(int pTarget, int pLevel, int pXOffset, int pYOffset, int pX, int pY, int pWidth, int pHeight) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL20.glCopyTexSubImage2D((int)pTarget, (int)pLevel, (int)pXOffset, (int)pYOffset, (int)pX, (int)pY, (int)pWidth, (int)pHeight);
    }

    public static void _glDeleteVertexArrays(int pArray) {
        RenderSystem.assertOnRenderThread();
        GL30.glDeleteVertexArrays((int)pArray);
    }

    public static void _glBindFramebuffer(int pTarget, int pFramebuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (pTarget == 36160) {
            if (framebufferRead == pFramebuffer && framebufferDraw == pFramebuffer) {
                return;
            }
            framebufferRead = pFramebuffer;
            framebufferDraw = pFramebuffer;
        } else if (pTarget == 36008) {
            if (framebufferRead == pFramebuffer) {
                return;
            }
            framebufferRead = pFramebuffer;
        }
        if (pTarget == 36009) {
            if (framebufferDraw == pFramebuffer) {
                return;
            }
            framebufferDraw = pFramebuffer;
        }
        GL30.glBindFramebuffer((int)pTarget, (int)pFramebuffer);
    }

    public static void _glBlitFrameBuffer(int pSrcX0, int pSrcY0, int pSrcX1, int pSrcY1, int pDstX0, int pDstY0, int pDstX1, int pDstY1, int pMask, int pFilter) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBlitFramebuffer((int)pSrcX0, (int)pSrcY0, (int)pSrcX1, (int)pSrcY1, (int)pDstX0, (int)pDstY0, (int)pDstX1, (int)pDstY1, (int)pMask, (int)pFilter);
    }

    public static void _glBindRenderbuffer(int pTarget, int pRenderBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindRenderbuffer((int)pTarget, (int)pRenderBuffer);
    }

    public static void _glDeleteRenderbuffers(int pRenderBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteRenderbuffers((int)pRenderBuffer);
    }

    public static void _glDeleteFramebuffers(int pFrameBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteFramebuffers((int)pFrameBuffer);
    }

    public static int glGenFramebuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenFramebuffers();
    }

    public static int glGenRenderbuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenRenderbuffers();
    }

    public static void _glRenderbufferStorage(int pTarget, int pInternalFormat, int pWidth, int pHeight) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glRenderbufferStorage((int)pTarget, (int)pInternalFormat, (int)pWidth, (int)pHeight);
    }

    public static void _glFramebufferRenderbuffer(int pTarget, int pAttachment, int pRenderBufferTarget, int pRenderBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glFramebufferRenderbuffer((int)pTarget, (int)pAttachment, (int)pRenderBufferTarget, (int)pRenderBuffer);
    }

    public static int glCheckFramebufferStatus(int pTarget) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glCheckFramebufferStatus((int)pTarget);
    }

    public static void _glFramebufferTexture2D(int pTarget, int pAttachment, int pTexTarget, int pTexture, int pLevel) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glFramebufferTexture2D((int)pTarget, (int)pAttachment, (int)pTexTarget, (int)pTexture, (int)pLevel);
    }

    public static int getBoundFramebuffer() {
        RenderSystem.assertOnRenderThread();
        return GlStateManager._getInteger(36006);
    }

    public static void glActiveTexture(int pTexture) {
        RenderSystem.assertOnRenderThread();
        GL13.glActiveTexture((int)pTexture);
    }

    public static void glBlendFuncSeparate(int pSFactorRGB, int pDFactorRGB, int pSFactorAlpha, int pDFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendFuncSeparate((int)pSFactorRGB, (int)pDFactorRGB, (int)pSFactorAlpha, (int)pDFactorAlpha);
    }

    public static String glGetShaderInfoLog(int pShader, int pMaxLength) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderInfoLog((int)pShader, (int)pMaxLength);
    }

    public static String glGetProgramInfoLog(int pProgram, int pMaxLength) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgramInfoLog((int)pProgram, (int)pMaxLength);
    }

    public static void setupLevelDiffuseLighting(Vector3f pLightingVector1, Vector3f pLightingVector2, Matrix4f pMatrix) {
        RenderSystem.assertOnRenderThread();
        Vector4f vector4f = new Vector4f(pLightingVector1);
        vector4f.transform(pMatrix);
        Vector4f vector4f1 = new Vector4f(pLightingVector2);
        vector4f1.transform(pMatrix);
        RenderSystem.setShaderLights(new Vector3f(vector4f), new Vector3f(vector4f1));
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f pLighting1, Vector3f pLighting2) {
        RenderSystem.assertOnRenderThread();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.multiply(Matrix4f.createScaleMatrix(1.0f, -1.0f, 1.0f));
        matrix4f.multiply(Vector3f.YP.rotationDegrees(-22.5f));
        matrix4f.multiply(Vector3f.XP.rotationDegrees(135.0f));
        GlStateManager.setupLevelDiffuseLighting(pLighting1, pLighting2, matrix4f);
    }

    public static void setupGui3DDiffuseLighting(Vector3f pLightingVector1, Vector3f pLightingVector2) {
        RenderSystem.assertOnRenderThread();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.multiply(Vector3f.YP.rotationDegrees(62.0f));
        matrix4f.multiply(Vector3f.XP.rotationDegrees(185.5f));
        matrix4f.multiply(Vector3f.YP.rotationDegrees(-22.5f));
        matrix4f.multiply(Vector3f.XP.rotationDegrees(135.0f));
        GlStateManager.setupLevelDiffuseLighting(pLightingVector1, pLightingVector2, matrix4f);
    }

    public static void _enableCull() {
        RenderSystem.assertOnRenderThread();
        if (cullLock.isLocked()) {
            cullLockState.setEnabled();
        } else {
            GlStateManager.CULL.enable.enable();
        }
    }

    public static void _disableCull() {
        RenderSystem.assertOnRenderThread();
        if (cullLock.isLocked()) {
            cullLockState.setDisabled();
        } else {
            GlStateManager.CULL.enable.disable();
        }
    }

    public static void _polygonMode(int pFace, int pMode) {
        RenderSystem.assertOnRenderThread();
        GL11.glPolygonMode((int)pFace, (int)pMode);
    }

    public static void _enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.fill.enable();
    }

    public static void _disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.fill.disable();
    }

    public static void _polygonOffset(float pFactor, float pUnits) {
        RenderSystem.assertOnRenderThread();
        if (pFactor != GlStateManager.POLY_OFFSET.factor || pUnits != GlStateManager.POLY_OFFSET.units) {
            GlStateManager.POLY_OFFSET.factor = pFactor;
            GlStateManager.POLY_OFFSET.units = pUnits;
            GL11.glPolygonOffset((float)pFactor, (float)pUnits);
        }
    }

    public static void _enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.enable.enable();
    }

    public static void _disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.enable.disable();
    }

    public static void _logicOp(int pLogicOperation) {
        RenderSystem.assertOnRenderThread();
        if (pLogicOperation != GlStateManager.COLOR_LOGIC.op) {
            GlStateManager.COLOR_LOGIC.op = pLogicOperation;
            GL11.glLogicOp((int)pLogicOperation);
        }
    }

    public static void _activeTexture(int pTexture) {
        RenderSystem.assertOnRenderThread();
        if (activeTexture != pTexture - 33984) {
            activeTexture = pTexture - 33984;
            GlStateManager.glActiveTexture(pTexture);
        }
    }

    public static void _enableTexture() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.TEXTURES[GlStateManager.activeTexture].enable = true;
    }

    public static void _disableTexture() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.TEXTURES[GlStateManager.activeTexture].enable = false;
    }

    public static void _texParameter(int pTarget, int pParameterName, float pParameter) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexParameterf((int)pTarget, (int)pParameterName, (float)pParameter);
    }

    public static void _texParameter(int pTarget, int pParameterName, int pParameter) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexParameteri((int)pTarget, (int)pParameterName, (int)pParameter);
    }

    public static int _getTexLevelParameter(int pTarget, int pLevel, int pParameterName) {
        RenderSystem.assertInInitPhase();
        return GL11.glGetTexLevelParameteri((int)pTarget, (int)pLevel, (int)pParameterName);
    }

    public static int _genTexture() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glGenTextures();
    }

    public static void _genTextures(int[] pTextures) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glGenTextures((int[])pTextures);
    }

    public static void _deleteTexture(int pTexture) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (pTexture != 0) {
            int i = 0;
            while (i < IMAGE_TEXTURES.length) {
                if (IMAGE_TEXTURES[i] == pTexture) {
                    GlStateManager.IMAGE_TEXTURES[i] = 0;
                }
                ++i;
            }
            GL11.glDeleteTextures((int)pTexture);
            TextureState[] textureStateArray = TEXTURES;
            int n = TEXTURES.length;
            int n2 = 0;
            while (n2 < n) {
                TextureState glstatemanager$texturestate = textureStateArray[n2];
                if (glstatemanager$texturestate.binding == pTexture) {
                    glstatemanager$texturestate.binding = 0;
                }
                ++n2;
            }
        }
    }

    public static void _deleteTextures(int[] pTextures) {
        RenderSystem.assertOnRenderThreadOrInit();
        TextureState[] textureStateArray = TEXTURES;
        int n = TEXTURES.length;
        int n2 = 0;
        while (n2 < n) {
            TextureState glstatemanager$texturestate = textureStateArray[n2];
            int[] nArray = pTextures;
            int n3 = pTextures.length;
            int n4 = 0;
            while (n4 < n3) {
                int i = nArray[n4];
                if (glstatemanager$texturestate.binding == i) {
                    glstatemanager$texturestate.binding = -1;
                }
                ++n4;
            }
            ++n2;
        }
        GL11.glDeleteTextures((int[])pTextures);
    }

    public static void _bindTexture(int pTexture) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (pTexture != GlStateManager.TEXTURES[GlStateManager.activeTexture].binding) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].binding = pTexture;
            GL11.glBindTexture((int)3553, (int)pTexture);
            if (SmartAnimations.isActive()) {
                SmartAnimations.textureRendered(pTexture);
            }
        }
    }

    public static int _getTextureId(int pTextureId) {
        return pTextureId >= 0 && pTextureId < 12 && GlStateManager.TEXTURES[pTextureId].enable ? GlStateManager.TEXTURES[pTextureId].binding : 0;
    }

    public static int _getActiveTexture() {
        return activeTexture + 33984;
    }

    public static void _texImage2D(int pTarget, int pLevel, int pInternalFormat, int pWidth, int pHeight, int pBorder, int pFormat, int pType, @Nullable IntBuffer pPixels) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexImage2D((int)pTarget, (int)pLevel, (int)pInternalFormat, (int)pWidth, (int)pHeight, (int)pBorder, (int)pFormat, (int)pType, (IntBuffer)pPixels);
    }

    public static void _texSubImage2D(int pTarget, int pLevel, int pXOffset, int pYOffset, int pWidth, int pHeight, int pFormat, int pType, long pPixels) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexSubImage2D((int)pTarget, (int)pLevel, (int)pXOffset, (int)pYOffset, (int)pWidth, (int)pHeight, (int)pFormat, (int)pType, (long)pPixels);
    }

    public static void _getTexImage(int pTex, int pLevel, int pFormat, int pType, long pPixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glGetTexImage((int)pTex, (int)pLevel, (int)pFormat, (int)pType, (long)pPixels);
    }

    public static void _viewport(int pX, int pY, int pWidth, int pHeight) {
        RenderSystem.assertOnRenderThreadOrInit();
        Viewport.INSTANCE.x = pX;
        Viewport.INSTANCE.y = pY;
        Viewport.INSTANCE.width = pWidth;
        Viewport.INSTANCE.height = pHeight;
        GL11.glViewport((int)pX, (int)pY, (int)pWidth, (int)pHeight);
    }

    public static void _colorMask(boolean pRed, boolean pGreen, boolean pBlue, boolean pAlpha) {
        RenderSystem.assertOnRenderThread();
        if (pRed != GlStateManager.COLOR_MASK.red || pGreen != GlStateManager.COLOR_MASK.green || pBlue != GlStateManager.COLOR_MASK.blue || pAlpha != GlStateManager.COLOR_MASK.alpha) {
            GlStateManager.COLOR_MASK.red = pRed;
            GlStateManager.COLOR_MASK.green = pGreen;
            GlStateManager.COLOR_MASK.blue = pBlue;
            GlStateManager.COLOR_MASK.alpha = pAlpha;
            GL11.glColorMask((boolean)pRed, (boolean)pGreen, (boolean)pBlue, (boolean)pAlpha);
        }
    }

    public static void _stencilFunc(int pFunc, int pRef, int pMask) {
        RenderSystem.assertOnRenderThread();
        if (pFunc != GlStateManager.STENCIL.func.func || pFunc != GlStateManager.STENCIL.func.ref || pFunc != GlStateManager.STENCIL.func.mask) {
            GlStateManager.STENCIL.func.func = pFunc;
            GlStateManager.STENCIL.func.ref = pRef;
            GlStateManager.STENCIL.func.mask = pMask;
            GL11.glStencilFunc((int)pFunc, (int)pRef, (int)pMask);
        }
    }

    public static void _stencilMask(int pMask) {
        RenderSystem.assertOnRenderThread();
        if (pMask != GlStateManager.STENCIL.mask) {
            GlStateManager.STENCIL.mask = pMask;
            GL11.glStencilMask((int)pMask);
        }
    }

    public static void _stencilOp(int pSfail, int pDpfail, int pDppass) {
        RenderSystem.assertOnRenderThread();
        if (pSfail != GlStateManager.STENCIL.fail || pDpfail != GlStateManager.STENCIL.zfail || pDppass != GlStateManager.STENCIL.zpass) {
            GlStateManager.STENCIL.fail = pSfail;
            GlStateManager.STENCIL.zfail = pDpfail;
            GlStateManager.STENCIL.zpass = pDppass;
            GL11.glStencilOp((int)pSfail, (int)pDpfail, (int)pDppass);
        }
    }

    public static void _clearDepth(double pDepth) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClearDepth((double)pDepth);
    }

    public static void _clearColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClearColor((float)pRed, (float)pGreen, (float)pBlue, (float)pAlpha);
    }

    public static void _clearStencil(int pIndex) {
        RenderSystem.assertOnRenderThread();
        GL11.glClearStencil((int)pIndex);
    }

    public static void _clear(int pMask, boolean pCheckError) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClear((int)pMask);
        if (pCheckError) {
            GlStateManager._getError();
        }
    }

    public static void _glDrawPixels(int pWidth, int pHeight, int pFormat, int pType, long pPixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glDrawPixels((int)pWidth, (int)pHeight, (int)pFormat, (int)pType, (long)pPixels);
    }

    public static void _vertexAttribPointer(int pIndex, int pSize, int pType, boolean pNormalized, int pStride, long pPointer) {
        RenderSystem.assertOnRenderThread();
        GL20.glVertexAttribPointer((int)pIndex, (int)pSize, (int)pType, (boolean)pNormalized, (int)pStride, (long)pPointer);
    }

    public static void _vertexAttribIPointer(int pIndex, int pSize, int pType, int pStride, long pPointer) {
        RenderSystem.assertOnRenderThread();
        GL30.glVertexAttribIPointer((int)pIndex, (int)pSize, (int)pType, (int)pStride, (long)pPointer);
    }

    public static void _enableVertexAttribArray(int pIndex) {
        RenderSystem.assertOnRenderThread();
        GL20.glEnableVertexAttribArray((int)pIndex);
    }

    public static void _disableVertexAttribArray(int pIndex) {
        RenderSystem.assertOnRenderThread();
        GL20.glDisableVertexAttribArray((int)pIndex);
    }

    public static void _drawElements(int pMode, int pCount, int pType, long pIndices) {
        int i;
        RenderSystem.assertOnRenderThread();
        GL11.glDrawElements((int)pMode, (int)pCount, (int)pType, (long)pIndices);
        if (Config.isShaders() && Shaders.isRenderingWorld && (i = Shaders.activeProgram.getCountInstances()) > 1) {
            int j = 1;
            while (j < i) {
                Shaders.uniform_instanceId.setValue(j);
                GL11.glDrawElements((int)pMode, (int)pCount, (int)pType, (long)pIndices);
                ++j;
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void drawArrays(int mode, int first, int count) {
        int i;
        RenderSystem.assertOnRenderThread();
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
        if (Config.isShaders() && Shaders.isRenderingWorld && (i = Shaders.activeProgram.getCountInstances()) > 1) {
            int j = 1;
            while (j < i) {
                Shaders.uniform_instanceId.setValue(j);
                GL11.glDrawArrays((int)mode, (int)first, (int)count);
                ++j;
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void _pixelStore(int pParameterName, int pParam) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glPixelStorei((int)pParameterName, (int)pParam);
    }

    public static void _readPixels(int pX, int pY, int pWidth, int pHeight, int pFormat, int pType, ByteBuffer pPixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)pX, (int)pY, (int)pWidth, (int)pHeight, (int)pFormat, (int)pType, (ByteBuffer)pPixels);
    }

    public static void _readPixels(int pX, int pY, int pWidth, int pHeight, int pFormat, int pType, long pPixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)pX, (int)pY, (int)pWidth, (int)pHeight, (int)pFormat, (int)pType, (long)pPixels);
    }

    public static int _getError() {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetError();
    }

    public static String _getString(int pName) {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetString((int)pName);
    }

    public static int _getInteger(int pPname) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glGetInteger((int)pPname);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor(red, green, blue, alpha);
    }

    public static int getActiveTextureUnit() {
        return 33984 + activeTexture;
    }

    public static void bindCurrentTexture() {
        GL11.glBindTexture((int)3553, (int)GlStateManager.TEXTURES[GlStateManager.activeTexture].binding);
    }

    public static int getBoundTexture() {
        return GlStateManager.TEXTURES[GlStateManager.activeTexture].binding;
    }

    public static int getBoundTexture(int textureUnit) {
        return GlStateManager.TEXTURES[textureUnit].binding;
    }

    public static void checkBoundTexture() {
        if (Config.isMinecraftThread()) {
            int i = GL11.glGetInteger((int)34016);
            int j = GL11.glGetInteger((int)32873);
            int k = GlStateManager.getActiveTextureUnit();
            int l = GlStateManager.getBoundTexture();
            if (l > 0 && (i != k || j != l)) {
                Config.dbg("checkTexture: act: " + k + ", glAct: " + i + ", tex: " + l + ", glTex: " + j);
            }
        }
    }

    public static void genTextures(IntBuffer buf) {
        GL11.glGenTextures((IntBuffer)buf);
    }

    public static void deleteTextures(IntBuffer buf) {
        buf.rewind();
        while (buf.position() < buf.limit()) {
            int i = buf.get();
            GlStateManager._deleteTexture(i);
        }
        buf.rewind();
    }

    public static void lockAlpha(GlAlphaState stateNew) {
        if (!alphaLock.isLocked()) {
            GlStateManager.getAlphaState(alphaLockState);
            GlStateManager.setAlphaState(stateNew);
            alphaLock.lock();
        }
    }

    public static void unlockAlpha() {
        if (alphaLock.unlock()) {
            GlStateManager.setAlphaState(alphaLockState);
        }
    }

    public static void getAlphaState(GlAlphaState state) {
        if (alphaLock.isLocked()) {
            state.setState(alphaLockState);
        } else {
            state.setState(alphaTest, alphaTestFunc, alphaTestRef);
        }
    }

    public static void setAlphaState(GlAlphaState state) {
        if (alphaLock.isLocked()) {
            alphaLockState.setState(state);
        } else {
            alphaTest = state.isEnabled();
            GlStateManager.alphaFunc(state.getFunc(), state.getRef());
        }
    }

    public static void lockBlend(GlBlendState stateNew) {
        if (!blendLock.isLocked()) {
            GlStateManager.getBlendState(blendLockState);
            GlStateManager.setBlendState(stateNew);
            blendLock.lock();
        }
    }

    public static void unlockBlend() {
        if (blendLock.unlock()) {
            GlStateManager.setBlendState(blendLockState);
        }
    }

    public static void getBlendState(GlBlendState gbs) {
        if (blendLock.isLocked()) {
            gbs.setState(blendLockState);
        } else {
            gbs.setState(GlStateManager.BLEND.mode.enabled, GlStateManager.BLEND.srcRgb, GlStateManager.BLEND.dstRgb, GlStateManager.BLEND.srcAlpha, GlStateManager.BLEND.dstAlpha);
        }
    }

    public static void setBlendState(GlBlendState gbs) {
        if (blendLock.isLocked()) {
            blendLockState.setState(gbs);
        } else {
            GlStateManager.BLEND.mode.setEnabled(gbs.isEnabled());
            if (!gbs.isSeparate()) {
                GlStateManager._blendFunc(gbs.getSrcFactor(), gbs.getDstFactor());
            } else {
                GlStateManager._blendFuncSeparate(gbs.getSrcFactor(), gbs.getDstFactor(), gbs.getSrcFactorAlpha(), gbs.getDstFactorAlpha());
            }
        }
    }

    public static void lockCull(GlCullState stateNew) {
        if (!cullLock.isLocked()) {
            GlStateManager.getCullState(cullLockState);
            GlStateManager.setCullState(stateNew);
            cullLock.lock();
        }
    }

    public static void unlockCull() {
        if (cullLock.unlock()) {
            GlStateManager.setCullState(cullLockState);
        }
    }

    public static void getCullState(GlCullState state) {
        if (cullLock.isLocked()) {
            state.setState(cullLockState);
        } else {
            state.setState(GlStateManager.CULL.enable.enabled, GlStateManager.CULL.mode);
        }
    }

    public static void setCullState(GlCullState state) {
        if (cullLock.isLocked()) {
            cullLockState.setState(state);
        } else {
            GlStateManager.CULL.enable.setEnabled(state.isEnabled());
            GlStateManager.CULL.mode = state.getMode();
        }
    }

    public static void glMultiDrawArrays(int mode, IntBuffer bFirst, IntBuffer bCount) {
        int i;
        GL14.glMultiDrawArrays((int)mode, (IntBuffer)bFirst, (IntBuffer)bCount);
        if (Config.isShaders() && (i = Shaders.activeProgram.getCountInstances()) > 1) {
            int j = 1;
            while (j < i) {
                Shaders.uniform_instanceId.setValue(j);
                GL14.glMultiDrawArrays((int)mode, (IntBuffer)bFirst, (IntBuffer)bCount);
                ++j;
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void glMultiDrawElements(int modeIn, IntBuffer countsIn, int typeIn, PointerBuffer indicesIn) {
        int i;
        RenderSystem.assertOnRenderThread();
        GL14.glMultiDrawElements((int)modeIn, (IntBuffer)countsIn, (int)typeIn, (PointerBuffer)indicesIn);
        if (Config.isShaders() && Shaders.isRenderingWorld && (i = Shaders.activeProgram.getCountInstances()) > 1) {
            int j = 1;
            while (j < i) {
                Shaders.uniform_instanceId.setValue(j);
                GL14.glMultiDrawElements((int)modeIn, (IntBuffer)countsIn, (int)typeIn, (PointerBuffer)indicesIn);
                ++j;
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void clear(int mask) {
        GlStateManager._clear(mask, false);
    }

    public static void bufferSubData(int target, long offset, ByteBuffer data) {
        GL15.glBufferSubData((int)target, (long)offset, (ByteBuffer)data);
    }

    public static void copyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        GL31.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static int getFramebufferRead() {
        return framebufferRead;
    }

    public static int getFramebufferDraw() {
        return framebufferDraw;
    }

    public static void applyCurrentBlend() {
        if (GlStateManager.BLEND.mode.enabled) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        GL14.glBlendFuncSeparate((int)GlStateManager.BLEND.srcRgb, (int)GlStateManager.BLEND.dstRgb, (int)GlStateManager.BLEND.srcAlpha, (int)GlStateManager.BLEND.dstAlpha);
    }

    public static void setBlendsIndexed(GlBlendState[] blends) {
        if (blends != null) {
            int i = 0;
            while (i < blends.length) {
                GlBlendState glblendstate = blends[i];
                if (glblendstate != null) {
                    if (glblendstate.isEnabled()) {
                        GL30.glEnablei((int)3042, (int)i);
                    } else {
                        GL30.glDisablei((int)3042, (int)i);
                    }
                    ARBDrawBuffersBlend.glBlendFuncSeparateiARB((int)i, (int)glblendstate.getSrcFactor(), (int)glblendstate.getDstFactor(), (int)glblendstate.getSrcFactorAlpha(), (int)glblendstate.getDstFactorAlpha());
                }
                ++i;
            }
        }
    }

    public static void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        if (unit >= 0 && unit < IMAGE_TEXTURES.length) {
            if (IMAGE_TEXTURES[unit] == texture) {
                return;
            }
            GlStateManager.IMAGE_TEXTURES[unit] = texture;
        }
        GL42.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
    }

    public static int getProgram() {
        return glProgram;
    }

    static class BlendState {
        public final BooleanState mode = new BooleanState(3042);
        public int srcRgb = 1;
        public int dstRgb = 0;
        public int srcAlpha = 1;
        public int dstAlpha = 0;

        BlendState() {
        }
    }

    static class BooleanState {
        private final int state;
        private boolean enabled;

        public BooleanState(int pState) {
            this.state = pState;
        }

        public void disable() {
            this.setEnabled(false);
        }

        public void enable() {
            this.setEnabled(true);
        }

        public void setEnabled(boolean pEnabled) {
            RenderSystem.assertOnRenderThreadOrInit();
            if (pEnabled != this.enabled) {
                this.enabled = pEnabled;
                if (pEnabled) {
                    GL11.glEnable((int)this.state);
                } else {
                    GL11.glDisable((int)this.state);
                }
            }
        }
    }

    static class ColorLogicState {
        public final BooleanState enable = new BooleanState(3058);
        public int op = 5379;

        ColorLogicState() {
        }
    }

    static class ColorMask {
        public boolean red = true;
        public boolean green = true;
        public boolean blue = true;
        public boolean alpha = true;

        ColorMask() {
        }
    }

    static class CullState {
        public final BooleanState enable = new BooleanState(2884);
        public int mode = 1029;

        CullState() {
        }
    }

    static class DepthState {
        public final BooleanState mode = new BooleanState(2929);
        public boolean mask = true;
        public int func = 513;

        DepthState() {
        }
    }

    @DontObfuscate
    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int p_84652_) {
            this.value = p_84652_;
        }
    }

    public static enum LogicOp {
        AND(5377),
        AND_INVERTED(5380),
        AND_REVERSE(5378),
        CLEAR(5376),
        COPY(5379),
        COPY_INVERTED(5388),
        EQUIV(5385),
        INVERT(5386),
        NAND(5390),
        NOOP(5381),
        NOR(5384),
        OR(5383),
        OR_INVERTED(5389),
        OR_REVERSE(5387),
        SET(5391),
        XOR(5382);

        public final int value;

        private LogicOp(int p_84721_) {
            this.value = p_84721_;
        }
    }

    static class PolygonOffsetState {
        public final BooleanState fill = new BooleanState(32823);
        public final BooleanState line = new BooleanState(10754);
        public float factor;
        public float units;

        PolygonOffsetState() {
        }
    }

    static class ScissorState {
        public final BooleanState mode = new BooleanState(3089);

        ScissorState() {
        }
    }

    @DontObfuscate
    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int p_84757_) {
            this.value = p_84757_;
        }
    }

    static class StencilFunc {
        public int func = 519;
        public int ref;
        public int mask = -1;

        StencilFunc() {
        }
    }

    static class StencilState {
        public final StencilFunc func = new StencilFunc();
        public int mask = -1;
        public int fail = 7680;
        public int zfail = 7680;
        public int zpass = 7680;

        StencilState() {
        }
    }

    static class TextureState {
        public boolean enable;
        public int binding;

        TextureState() {
        }
    }

    public static enum Viewport {
        INSTANCE;

        protected int x;
        protected int y;
        protected int width;
        protected int height;

        public static int x() {
            return Viewport.INSTANCE.x;
        }

        public static int y() {
            return Viewport.INSTANCE.y;
        }

        public static int width() {
            return Viewport.INSTANCE.width;
        }

        public static int height() {
            return Viewport.INSTANCE.height;
        }
    }
}

