/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.optifine.Config;
import net.optifine.util.NativeMemory;
import org.apache.commons.io.IOUtils;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public final class NativeImage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int OFFSET_A = 24;
    private static final int OFFSET_B = 16;
    private static final int OFFSET_G = 8;
    private static final int OFFSET_R = 0;
    private static final Set<StandardOpenOption> OPEN_OPTIONS = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final Format format;
    private final int width;
    private final int height;
    private final boolean useStbFree;
    private long pixels;
    private final long size;
    private static boolean updateBlurMipmap = true;

    public NativeImage(int pFormat, int pWidth, boolean pHeight) {
        this(Format.RGBA, pFormat, pWidth, pHeight);
    }

    public NativeImage(Format p_84972_, int p_84973_, int p_84974_, boolean p_84975_) {
        if (p_84973_ <= 0 || p_84974_ <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + p_84973_ + "x" + p_84974_);
        }
        this.format = p_84972_;
        this.width = p_84973_;
        this.height = p_84974_;
        this.size = (long)p_84973_ * (long)p_84974_ * (long)p_84972_.components();
        this.useStbFree = false;
        this.pixels = p_84975_ ? MemoryUtil.nmemCalloc((long)1L, (long)this.size) : MemoryUtil.nmemAlloc((long)this.size);
        this.checkAllocated();
        NativeMemory.imageAllocated(this);
    }

    private NativeImage(Format pFormat, int pWidth, int pHeight, boolean pUseStbFree, long pPixels) {
        if (pWidth <= 0 || pHeight <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + pWidth + "x" + pHeight);
        }
        this.format = pFormat;
        this.width = pWidth;
        this.height = pHeight;
        this.useStbFree = pUseStbFree;
        this.pixels = pPixels;
        this.size = (long)pWidth * (long)pHeight * (long)pFormat.components();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.format) + " " + this.width + "x" + this.height + "@" + this.pixels + (this.useStbFree ? "S" : "N") + "]";
    }

    private boolean isOutsideBounds(int pX, int pY) {
        return pX < 0 || pX >= this.width || pY < 0 || pY >= this.height;
    }

    public static NativeImage read(InputStream pTextureStream) throws IOException {
        return NativeImage.read(Format.RGBA, pTextureStream);
    }

    public static NativeImage read(@Nullable Format pFormat, InputStream pTextureStream) throws IOException {
        NativeImage nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource(pTextureStream);
            bytebuffer.rewind();
            nativeimage = NativeImage.read(pFormat, bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)pTextureStream);
        }
        return nativeimage;
    }

    public static NativeImage read(ByteBuffer pTextureStream) throws IOException {
        return NativeImage.read(Format.RGBA, pTextureStream);
    }

    public static NativeImage read(@Nullable Format pFormat, ByteBuffer pTextureStream) throws IOException {
        NativeImage nativeimage;
        if (pFormat != null && !pFormat.supportedByStb()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)pFormat));
        }
        if (MemoryUtil.memAddress((ByteBuffer)pTextureStream) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)pTextureStream, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(pFormat == null ? 0 : pFormat.components));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new NativeImage(pFormat == null ? Format.getStbFormat(intbuffer2.get(0)) : pFormat, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
            NativeMemory.imageAllocated(nativeimage);
        }
        return nativeimage;
    }

    public static void setFilter(boolean pLinear, boolean pMipmap) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (updateBlurMipmap) {
            if (pLinear) {
                GlStateManager._texParameter(3553, 10241, pMipmap ? 9987 : 9729);
                GlStateManager._texParameter(3553, 10240, 9729);
            } else {
                int i = Config.getMipmapType();
                GlStateManager._texParameter(3553, 10241, pMipmap ? i : 9728);
                GlStateManager._texParameter(3553, 10240, 9728);
            }
        }
    }

    private void checkAllocated() {
        if (this.pixels == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.pixels != 0L) {
            if (this.useStbFree) {
                STBImage.nstbi_image_free((long)this.pixels);
            } else {
                MemoryUtil.nmemFree((long)this.pixels);
            }
            NativeMemory.imageFreed(this);
        }
        this.pixels = 0L;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Format format() {
        return this.format;
    }

    public int getPixelRGBA(int pX, int pY) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        this.checkAllocated();
        long i = ((long)pX + (long)pY * (long)this.width) * 4L;
        return MemoryUtil.memGetInt((long)(this.pixels + i));
    }

    public void setPixelRGBA(int pX, int pY, int pAbgrColor) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        this.checkAllocated();
        long i = ((long)pX + (long)pY * (long)this.width) * 4L;
        MemoryUtil.memPutInt((long)(this.pixels + i), (int)pAbgrColor);
    }

    public void setPixelLuminance(int pX, int pY, byte pLuminance) {
        RenderSystem.assertOnRenderThread();
        if (!this.format.hasLuminance()) {
            throw new IllegalArgumentException(String.format("setPixelLuminance only works on image with luminance; have %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        this.checkAllocated();
        long i = ((long)pX + (long)pY * (long)this.width) * (long)this.format.components() + (long)(this.format.luminanceOffset() / 8);
        MemoryUtil.memPutByte((long)(this.pixels + i), (byte)pLuminance);
    }

    public byte getRedOrLuminance(int pX, int pY) {
        RenderSystem.assertOnRenderThread();
        if (!this.format.hasLuminanceOrRed()) {
            throw new IllegalArgumentException(String.format("no red or luminance in %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        int i = (pX + pY * this.width) * this.format.components() + this.format.luminanceOrRedOffset() / 8;
        return MemoryUtil.memGetByte((long)(this.pixels + (long)i));
    }

    public byte getGreenOrLuminance(int pX, int pY) {
        RenderSystem.assertOnRenderThread();
        if (!this.format.hasLuminanceOrGreen()) {
            throw new IllegalArgumentException(String.format("no green or luminance in %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        int i = (pX + pY * this.width) * this.format.components() + this.format.luminanceOrGreenOffset() / 8;
        return MemoryUtil.memGetByte((long)(this.pixels + (long)i));
    }

    public byte getBlueOrLuminance(int pX, int pY) {
        RenderSystem.assertOnRenderThread();
        if (!this.format.hasLuminanceOrBlue()) {
            throw new IllegalArgumentException(String.format("no blue or luminance in %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        int i = (pX + pY * this.width) * this.format.components() + this.format.luminanceOrBlueOffset() / 8;
        return MemoryUtil.memGetByte((long)(this.pixels + (long)i));
    }

    public byte getLuminanceOrAlpha(int pX, int pY) {
        if (!this.format.hasLuminanceOrAlpha()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(pX, pY)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", pX, pY, this.width, this.height));
        }
        int i = (pX + pY * this.width) * this.format.components() + this.format.luminanceOrAlphaOffset() / 8;
        return MemoryUtil.memGetByte((long)(this.pixels + (long)i));
    }

    public void blendPixel(int pX, int pY, int pAbgrColor) {
        if (this.format != Format.RGBA) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = this.getPixelRGBA(pX, pY);
        float f = (float)NativeImage.getA(pAbgrColor) / 255.0f;
        float f1 = (float)NativeImage.getB(pAbgrColor) / 255.0f;
        float f2 = (float)NativeImage.getG(pAbgrColor) / 255.0f;
        float f3 = (float)NativeImage.getR(pAbgrColor) / 255.0f;
        float f4 = (float)NativeImage.getA(i) / 255.0f;
        float f5 = (float)NativeImage.getB(i) / 255.0f;
        float f6 = (float)NativeImage.getG(i) / 255.0f;
        float f7 = (float)NativeImage.getR(i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        this.setPixelRGBA(pX, pY, NativeImage.combine(j, k, l, i1));
    }

    @Deprecated
    public int[] makePixelArray() {
        if (this.format != Format.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.checkAllocated();
        int[] aint = new int[this.getWidth() * this.getHeight()];
        int i = 0;
        while (i < this.getHeight()) {
            int j = 0;
            while (j < this.getWidth()) {
                int l1;
                int k = this.getPixelRGBA(j, i);
                int l = NativeImage.getA(k);
                int i1 = NativeImage.getB(k);
                int j1 = NativeImage.getG(k);
                int k1 = NativeImage.getR(k);
                aint[j + i * this.getWidth()] = l1 = l << 24 | k1 << 16 | j1 << 8 | i1;
                ++j;
            }
            ++i;
        }
        return aint;
    }

    public void upload(int pLevel, int pXOffset, int pYOffset, boolean pMipmap) {
        this.upload(pLevel, pXOffset, pYOffset, 0, 0, this.width, this.height, false, pMipmap);
    }

    public void upload(int pLevel, int pXOffset, int pYOffset, int pUnpackSkipPixels, int pUnpackSkipRows, int pWidth, int pHeight, boolean pMipmap, boolean pAutoClose) {
        this.upload(pLevel, pXOffset, pYOffset, pUnpackSkipPixels, pUnpackSkipRows, pWidth, pHeight, false, false, pMipmap, pAutoClose);
    }

    public void upload(int pLevel, int pXOffset, int pYOffset, int pUnpackSkipPixels, int pUnpackSkipRows, int pWidth, int pHeight, boolean pBlur, boolean pClamp, boolean pMipmap, boolean pAutoClose) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this._upload(pLevel, pXOffset, pYOffset, pUnpackSkipPixels, pUnpackSkipRows, pWidth, pHeight, pBlur, pClamp, pMipmap, pAutoClose));
        } else {
            this._upload(pLevel, pXOffset, pYOffset, pUnpackSkipPixels, pUnpackSkipRows, pWidth, pHeight, pBlur, pClamp, pMipmap, pAutoClose);
        }
    }

    private void _upload(int pLevel, int pXOffset, int pYOffset, int pUnpackSkipPixels, int pUnpackSkipRows, int pWidth, int pHeight, boolean pBlur, boolean pClamp, boolean pMipmap, boolean pAutoClose) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.checkAllocated();
        NativeImage.setFilter(pBlur, pMipmap);
        if (pWidth == this.getWidth()) {
            GlStateManager._pixelStore(3314, 0);
        } else {
            GlStateManager._pixelStore(3314, this.getWidth());
        }
        GlStateManager._pixelStore(3316, pUnpackSkipPixels);
        GlStateManager._pixelStore(3315, pUnpackSkipRows);
        this.format.setUnpackPixelStoreState();
        GlStateManager._texSubImage2D(3553, pLevel, pXOffset, pYOffset, pWidth, pHeight, this.format.glFormat(), 5121, this.pixels);
        if (pClamp) {
            GlStateManager._texParameter(3553, 10242, 33071);
            GlStateManager._texParameter(3553, 10243, 33071);
        }
        if (pAutoClose) {
            this.close();
        }
    }

    public void downloadTexture(int pLevel, boolean pOpaque) {
        RenderSystem.assertOnRenderThread();
        this.checkAllocated();
        this.format.setPackPixelStoreState();
        GlStateManager._getTexImage(3553, pLevel, this.format.glFormat(), 5121, this.pixels);
        if (pOpaque && this.format.hasAlpha()) {
            int i = 0;
            while (i < this.getHeight()) {
                int j = 0;
                while (j < this.getWidth()) {
                    this.setPixelRGBA(j, i, this.getPixelRGBA(j, i) | 255 << this.format.alphaOffset());
                    ++j;
                }
                ++i;
            }
        }
    }

    public void downloadDepthBuffer(float p_166401_) {
        RenderSystem.assertOnRenderThread();
        if (this.format.components() != 1) {
            throw new IllegalStateException("Depth buffer must be stored in NativeImage with 1 component.");
        }
        this.checkAllocated();
        this.format.setPackPixelStoreState();
        GlStateManager._readPixels(0, 0, this.width, this.height, 6402, 5121, this.pixels);
    }

    public void drawPixels() {
        RenderSystem.assertOnRenderThread();
        this.format.setUnpackPixelStoreState();
        GlStateManager._glDrawPixels(this.width, this.height, this.format.glFormat(), 5121, this.pixels);
    }

    public void writeToFile(String pFile) throws IOException {
        this.writeToFile(FileSystems.getDefault().getPath(pFile, new String[0]));
    }

    public void writeToFile(File pFile) throws IOException {
        this.writeToFile(pFile.toPath());
    }

    public void copyFromFont(STBTTFontinfo pInfo, int pGlyphIndex, int pWidth, int pHeight, float pScaleX, float pScaleY, float pShiftX, float pShiftY, int pX, int pY) {
        if (pX >= 0 && pX + pWidth <= this.getWidth() && pY >= 0 && pY + pHeight <= this.getHeight()) {
            if (this.format.components() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", pX, pY, pWidth, pHeight, this.getWidth(), this.getHeight()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)pInfo.address(), (long)(this.pixels + (long)pX + (long)(pY * this.getWidth())), (int)pWidth, (int)pHeight, (int)this.getWidth(), (float)pScaleX, (float)pScaleY, (float)pShiftX, (float)pShiftY, (int)pGlyphIndex);
    }

    public void writeToFile(Path pFile) throws IOException {
        if (!this.format.supportedByStb()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.format));
        }
        this.checkAllocated();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(pFile, OPEN_OPTIONS, new FileAttribute[0]);){
            if (!this.writeToChannel(writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + pFile.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] asByteArray() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.writeToChannel(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    private boolean writeToChannel(WritableByteChannel pChannel) throws IOException {
        boolean flag;
        WriteCallback nativeimage$writecallback = new WriteCallback(pChannel);
        try {
            int i = Math.min(this.getHeight(), Integer.MAX_VALUE / this.getWidth() / this.format.components());
            if (i < this.getHeight()) {
                LOGGER.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.getHeight(), (Object)i);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.getWidth(), (int)i, (int)this.format.components(), (long)this.pixels, (int)0) == 0) {
                return false;
            }
            nativeimage$writecallback.throwIfException();
            flag = true;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void copyFrom(NativeImage pOther) {
        if (pOther.format() != this.format) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i = this.format.components();
        this.checkAllocated();
        pOther.checkAllocated();
        if (this.width == pOther.width) {
            MemoryUtil.memCopy((long)pOther.pixels, (long)this.pixels, (long)Math.min(this.size, pOther.size));
        } else {
            int j = Math.min(this.getWidth(), pOther.getWidth());
            int k = Math.min(this.getHeight(), pOther.getHeight());
            int l = 0;
            while (l < k) {
                int i1 = l * pOther.getWidth() * i;
                int j1 = l * this.getWidth() * i;
                MemoryUtil.memCopy((long)(pOther.pixels + (long)i1), (long)(this.pixels + (long)j1), (long)((long)j * (long)i));
                ++l;
            }
        }
    }

    public void fillRect(int pX, int pY, int pWidth, int pHeight, int pValue) {
        int i = pY;
        while (i < pY + pHeight) {
            int j = pX;
            while (j < pX + pWidth) {
                this.setPixelRGBA(j, i, pValue);
                ++j;
            }
            ++i;
        }
    }

    public void copyRect(int pXFrom, int pYFrom, int pXToDelta, int pYToDelta, int pWidth, int pHeight, boolean pMirrorX, boolean pMirrorY) {
        int i = 0;
        while (i < pHeight) {
            int j = 0;
            while (j < pWidth) {
                int k = pMirrorX ? pWidth - 1 - j : j;
                int l = pMirrorY ? pHeight - 1 - i : i;
                int i1 = this.getPixelRGBA(pXFrom + j, pYFrom + i);
                this.setPixelRGBA(pXFrom + pXToDelta + k, pYFrom + pYToDelta + l, i1);
                ++j;
            }
            ++i;
        }
    }

    public void flipY() {
        this.checkAllocated();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i = this.format.components();
            int j = this.getWidth() * i;
            long k = memorystack.nmalloc(j);
            int l = 0;
            while (l < this.getHeight() / 2) {
                int i1 = l * this.getWidth() * i;
                int j1 = (this.getHeight() - 1 - l) * this.getWidth() * i;
                MemoryUtil.memCopy((long)(this.pixels + (long)i1), (long)k, (long)j);
                MemoryUtil.memCopy((long)(this.pixels + (long)j1), (long)(this.pixels + (long)i1), (long)j);
                MemoryUtil.memCopy((long)k, (long)(this.pixels + (long)j1), (long)j);
                ++l;
            }
        }
    }

    public void resizeSubRectTo(int pX, int pY, int pWidth, int pHeight, NativeImage pImage) {
        this.checkAllocated();
        if (pImage.format() != this.format) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i = this.format.components();
        STBImageResize.nstbir_resize_uint8((long)(this.pixels + (long)((pX + pY * this.getWidth()) * i)), (int)pWidth, (int)pHeight, (int)(this.getWidth() * i), (long)pImage.pixels, (int)pImage.getWidth(), (int)pImage.getHeight(), (int)0, (int)i);
    }

    public void untrack() {
        DebugMemoryUntracker.untrack(this.pixels);
    }

    public static NativeImage fromBase64(String pString) throws IOException {
        NativeImage nativeimage;
        byte[] abyte = Base64.getDecoder().decode(pString.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            bytebuffer.rewind();
            nativeimage = NativeImage.read(bytebuffer);
        }
        return nativeimage;
    }

    public static int getA(int pAbgrColor) {
        return pAbgrColor >> 24 & 0xFF;
    }

    public static int getR(int pAbgrColor) {
        return pAbgrColor >> 0 & 0xFF;
    }

    public static int getG(int pAbgrColor) {
        return pAbgrColor >> 8 & 0xFF;
    }

    public static int getB(int pAbgrColor) {
        return pAbgrColor >> 16 & 0xFF;
    }

    public static int combine(int pAlpha, int pBlue, int pGreen, int pRed) {
        return (pAlpha & 0xFF) << 24 | (pBlue & 0xFF) << 16 | (pGreen & 0xFF) << 8 | (pRed & 0xFF) << 0;
    }

    public IntBuffer getBufferRGBA() {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.format}));
        }
        this.checkAllocated();
        return MemoryUtil.memIntBuffer((long)this.pixels, (int)((int)this.size));
    }

    public void fillRGBA(int rgba) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.format}));
        }
        this.checkAllocated();
        MemoryUtil.memSet((long)this.pixels, (int)rgba, (long)this.size);
    }

    public long getSize() {
        return this.size;
    }

    public void downloadFromFramebuffer() {
        this.checkAllocated();
        this.format.setPackPixelStoreState();
        GlStateManager.readPixels(0, 0, this.width, this.height, this.format.glFormat(), 5121, this.pixels);
    }

    public static void setUpdateBlurMipmap(boolean updateBlurMipmap) {
        NativeImage.updateBlurMipmap = updateBlurMipmap;
    }

    public static boolean isUpdateBlurMipmap() {
        return updateBlurMipmap;
    }

    public static enum Format {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        RGB(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 33319, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6403, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        final int components;
        private final int glFormat;
        private final boolean hasRed;
        private final boolean hasGreen;
        private final boolean hasBlue;
        private final boolean hasLuminance;
        private final boolean hasAlpha;
        private final int redOffset;
        private final int greenOffset;
        private final int blueOffset;
        private final int luminanceOffset;
        private final int alphaOffset;
        private final boolean supportedByStb;

        private Format(int p_85148_, int p_85149_, boolean p_85150_, boolean p_85151_, boolean p_85152_, boolean p_85153_, boolean p_85154_, int p_85155_, int p_85156_, int p_85157_, int p_85158_, int p_85159_, boolean p_85160_) {
            this.components = p_85148_;
            this.glFormat = p_85149_;
            this.hasRed = p_85150_;
            this.hasGreen = p_85151_;
            this.hasBlue = p_85152_;
            this.hasLuminance = p_85153_;
            this.hasAlpha = p_85154_;
            this.redOffset = p_85155_;
            this.greenOffset = p_85156_;
            this.blueOffset = p_85157_;
            this.luminanceOffset = p_85158_;
            this.alphaOffset = p_85159_;
            this.supportedByStb = p_85160_;
        }

        public int components() {
            return this.components;
        }

        public void setPackPixelStoreState() {
            RenderSystem.assertOnRenderThread();
            GlStateManager._pixelStore(3333, this.components());
        }

        public void setUnpackPixelStoreState() {
            RenderSystem.assertOnRenderThreadOrInit();
            GlStateManager._pixelStore(3317, this.components());
        }

        public int glFormat() {
            return this.glFormat;
        }

        public boolean hasRed() {
            return this.hasRed;
        }

        public boolean hasGreen() {
            return this.hasGreen;
        }

        public boolean hasBlue() {
            return this.hasBlue;
        }

        public boolean hasLuminance() {
            return this.hasLuminance;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public int redOffset() {
            return this.redOffset;
        }

        public int greenOffset() {
            return this.greenOffset;
        }

        public int blueOffset() {
            return this.blueOffset;
        }

        public int luminanceOffset() {
            return this.luminanceOffset;
        }

        public int alphaOffset() {
            return this.alphaOffset;
        }

        public boolean hasLuminanceOrRed() {
            return this.hasLuminance || this.hasRed;
        }

        public boolean hasLuminanceOrGreen() {
            return this.hasLuminance || this.hasGreen;
        }

        public boolean hasLuminanceOrBlue() {
            return this.hasLuminance || this.hasBlue;
        }

        public boolean hasLuminanceOrAlpha() {
            return this.hasLuminance || this.hasAlpha;
        }

        public int luminanceOrRedOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.redOffset;
        }

        public int luminanceOrGreenOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.greenOffset;
        }

        public int luminanceOrBlueOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.blueOffset;
        }

        public int luminanceOrAlphaOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.alphaOffset;
        }

        public boolean supportedByStb() {
            return this.supportedByStb;
        }

        static Format getStbFormat(int pChannels) {
            switch (pChannels) {
                case 1: {
                    return LUMINANCE;
                }
                case 2: {
                    return LUMINANCE_ALPHA;
                }
                case 3: {
                    return RGB;
                }
            }
            return RGBA;
        }
    }

    public static enum InternalGlFormat {
        RGBA(6408),
        RGB(6407),
        RG(33319),
        RED(6403);

        private final int glFormat;

        private InternalGlFormat(int p_85190_) {
            this.glFormat = p_85190_;
        }

        public int glFormat() {
            return this.glFormat;
        }
    }

    static class WriteCallback
    extends STBIWriteCallback {
        private final WritableByteChannel output;
        @Nullable
        private IOException exception;

        WriteCallback(WritableByteChannel pOutput) {
            this.output = pOutput;
        }

        public void invoke(long p_85204_, long p_85205_, int p_85206_) {
            ByteBuffer bytebuffer = WriteCallback.getData((long)p_85205_, (int)p_85206_);
            try {
                this.output.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.exception = ioexception;
            }
        }

        public void throwIfException() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

