/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class PngInfo {
    public final int width;
    public final int height;
    private static final Object STATIC_MONITOR = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PngInfo(String pFileName, InputStream pTextureStream) throws IOException {
        Object object = STATIC_MONITOR;
        synchronized (object) {
            try (MemoryStack memorystack = MemoryStack.stackPush();
                 StbReader pnginfo$stbreader = PngInfo.createCallbacks(pTextureStream);
                 STBIReadCallback stbireadcallback = STBIReadCallback.create(pnginfo$stbreader::read);
                 STBISkipCallback stbiskipcallback = STBISkipCallback.create(pnginfo$stbreader::skip);
                 STBIEOFCallback stbieofcallback = STBIEOFCallback.create(pnginfo$stbreader::eof);){
                STBIIOCallbacks stbiiocallbacks = STBIIOCallbacks.mallocStack((MemoryStack)memorystack);
                stbiiocallbacks.read((STBIReadCallbackI)stbireadcallback);
                stbiiocallbacks.skip((STBISkipCallbackI)stbiskipcallback);
                stbiiocallbacks.eof((STBIEOFCallbackI)stbieofcallback);
                IntBuffer intbuffer = memorystack.mallocInt(1);
                IntBuffer intbuffer1 = memorystack.mallocInt(1);
                IntBuffer intbuffer2 = memorystack.mallocInt(1);
                if (!STBImage.stbi_info_from_callbacks((STBIIOCallbacks)stbiiocallbacks, (long)0L, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2)) {
                    throw new IOException("Could not read info from the PNG file " + pFileName + " " + STBImage.stbi_failure_reason());
                }
                this.width = intbuffer.get(0);
                this.height = intbuffer1.get(0);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.width) + " x " + this.height;
    }

    private static StbReader createCallbacks(InputStream pTextureStream) {
        return pTextureStream instanceof FileInputStream ? new StbReaderSeekableByteChannel(((FileInputStream)pTextureStream).getChannel()) : new StbReaderBufferedChannel(Channels.newChannel(pTextureStream));
    }

    static abstract class StbReader
    implements AutoCloseable {
        protected boolean closed;

        StbReader() {
        }

        int read(long pFunctionPointer, long p_85225_, int pAdress) {
            try {
                return this.read(p_85225_, pAdress);
            }
            catch (IOException ioexception) {
                this.closed = true;
                return 0;
            }
        }

        void skip(long pFunctionPointer, int p_85222_) {
            try {
                this.skip(p_85222_);
            }
            catch (IOException ioexception) {
                this.closed = true;
            }
        }

        int eof(long pFunctionPointer) {
            return this.closed ? 1 : 0;
        }

        protected abstract int read(long var1, int var3) throws IOException;

        protected abstract void skip(int var1) throws IOException;

        @Override
        public abstract void close() throws IOException;
    }

    static class StbReaderBufferedChannel
    extends StbReader {
        private static final int START_BUFFER_SIZE = 128;
        private final ReadableByteChannel channel;
        private long readBufferAddress = MemoryUtil.nmemAlloc((long)128L);
        private int bufferSize = 128;
        private int read;
        private int consumed;

        StbReaderBufferedChannel(ReadableByteChannel pChannel) {
            this.channel = pChannel;
        }

        private void fillReadBuffer(int pLength) throws IOException {
            ByteBuffer bytebuffer = MemoryUtil.memByteBuffer((long)this.readBufferAddress, (int)this.bufferSize);
            if (pLength + this.consumed > this.bufferSize) {
                this.bufferSize = pLength + this.consumed;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)this.bufferSize);
                this.readBufferAddress = MemoryUtil.memAddress((ByteBuffer)bytebuffer);
            }
            bytebuffer.position(this.read);
            while (pLength + this.consumed > this.read) {
                try {
                    int i = this.channel.read(bytebuffer);
                    if (i != -1) continue;
                    break;
                }
                finally {
                    this.read = bytebuffer.position();
                }
            }
        }

        @Override
        public int read(long pAddress, int p_85246_) throws IOException {
            this.fillReadBuffer(p_85246_);
            if (p_85246_ + this.consumed > this.read) {
                p_85246_ = this.read - this.consumed;
            }
            MemoryUtil.memCopy((long)(this.readBufferAddress + (long)this.consumed), (long)pAddress, (long)p_85246_);
            this.consumed += p_85246_;
            return p_85246_;
        }

        @Override
        public void skip(int pOffset) throws IOException {
            if (pOffset > 0) {
                this.fillReadBuffer(pOffset);
                if (pOffset + this.consumed > this.read) {
                    throw new EOFException("Can't skip past the EOF.");
                }
            }
            if (this.consumed + pOffset < 0) {
                throw new IOException("Can't seek before the beginning: " + (this.consumed + pOffset));
            }
            this.consumed += pOffset;
        }

        @Override
        public void close() throws IOException {
            MemoryUtil.nmemFree((long)this.readBufferAddress);
            this.channel.close();
        }
    }

    static class StbReaderSeekableByteChannel
    extends StbReader {
        private final SeekableByteChannel channel;

        StbReaderSeekableByteChannel(SeekableByteChannel pChannel) {
            this.channel = pChannel;
        }

        @Override
        public int read(long pAddress, int p_85260_) throws IOException {
            ByteBuffer bytebuffer = MemoryUtil.memByteBuffer((long)pAddress, (int)p_85260_);
            return this.channel.read(bytebuffer);
        }

        @Override
        public void skip(int pOffset) throws IOException {
            this.channel.position(this.channel.position() + (long)pOffset);
        }

        @Override
        public int eof(long pFunctionPointer) {
            return super.eof(pFunctionPointer) != 0 && this.channel.isOpen() ? 1 : 0;
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

