/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.MonitorCreator;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.slf4j.Logger;

public class ScreenManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Long2ObjectMap<Monitor> monitors = new Long2ObjectOpenHashMap();
    private final MonitorCreator monitorCreator;

    public ScreenManager(MonitorCreator pMonitorCreator) {
        RenderSystem.assertInInitPhase();
        this.monitorCreator = pMonitorCreator;
        GLFW.glfwSetMonitorCallback(this::onMonitorChange);
        PointerBuffer pointerbuffer = GLFW.glfwGetMonitors();
        if (pointerbuffer != null) {
            int i = 0;
            while (i < pointerbuffer.limit()) {
                long j = pointerbuffer.get(i);
                this.monitors.put(j, (Object)pMonitorCreator.createMonitor(j));
                ++i;
            }
        }
    }

    private void onMonitorChange(long p_85274_, int p_85275_) {
        RenderSystem.assertOnRenderThread();
        if (p_85275_ == 262145) {
            this.monitors.put(p_85274_, (Object)this.monitorCreator.createMonitor(p_85274_));
            LOGGER.debug("Monitor {} connected. Current monitors: {}", (Object)p_85274_, this.monitors);
        } else if (p_85275_ == 262146) {
            this.monitors.remove(p_85274_);
            LOGGER.debug("Monitor {} disconnected. Current monitors: {}", (Object)p_85274_, this.monitors);
        }
    }

    @Nullable
    public Monitor getMonitor(long pMonitorID) {
        RenderSystem.assertInInitPhase();
        return (Monitor)this.monitors.get(pMonitorID);
    }

    @Nullable
    public Monitor findBestMonitor(Window pWindow) {
        long i = GLFW.glfwGetWindowMonitor((long)pWindow.getWindow());
        if (i != 0L) {
            return this.getMonitor(i);
        }
        int j = pWindow.getX();
        int k = j + pWindow.getScreenWidth();
        int l = pWindow.getY();
        int i1 = l + pWindow.getScreenHeight();
        int j1 = -1;
        Monitor monitor = null;
        long k1 = GLFW.glfwGetPrimaryMonitor();
        LOGGER.debug("Selecting monitor - primary: {}, current monitors: {}", (Object)k1, this.monitors);
        for (Monitor monitor1 : this.monitors.values()) {
            int i4;
            int l1 = monitor1.getX();
            int i2 = l1 + monitor1.getCurrentMode().getWidth();
            int j2 = monitor1.getY();
            int k2 = j2 + monitor1.getCurrentMode().getHeight();
            int l2 = ScreenManager.clamp(j, l1, i2);
            int i3 = ScreenManager.clamp(k, l1, i2);
            int j3 = ScreenManager.clamp(l, j2, k2);
            int k3 = ScreenManager.clamp(i1, j2, k2);
            int l3 = Math.max(0, i3 - l2);
            int j4 = l3 * (i4 = Math.max(0, k3 - j3));
            if (j4 > j1) {
                monitor = monitor1;
                j1 = j4;
                continue;
            }
            if (j4 != j1 || k1 != monitor1.getMonitor()) continue;
            LOGGER.debug("Primary monitor {} is preferred to monitor {}", (Object)monitor1, (Object)monitor);
            monitor = monitor1;
        }
        LOGGER.debug("Selected monitor: {}", monitor);
        return monitor;
    }

    public static int clamp(int pValue, int pMin, int pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public void shutdown() {
        RenderSystem.assertOnRenderThread();
        GLFWMonitorCallback glfwmonitorcallback = GLFW.glfwSetMonitorCallback(null);
        if (glfwmonitorcallback != null) {
            glfwmonitorcallback.free();
        }
    }
}

