/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@DontObfuscate
public class TextureUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MIN_MIPMAP_LEVEL = 0;
    private static final int DEFAULT_IMAGE_BUFFER_SIZE = 8192;

    public static int generateTextureId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            int[] aint = new int[ThreadLocalRandom.current().nextInt(15) + 1];
            GlStateManager._genTextures(aint);
            int i = GlStateManager._genTexture();
            GlStateManager._deleteTextures(aint);
            return i;
        }
        return GlStateManager._genTexture();
    }

    public static void releaseTextureId(int pTextureId) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._deleteTexture(pTextureId);
    }

    public static void prepareImage(int pTextureId, int pWidth, int pHeight) {
        TextureUtil.prepareImage(NativeImage.InternalGlFormat.RGBA, pTextureId, 0, pWidth, pHeight);
    }

    public static void prepareImage(NativeImage.InternalGlFormat pTextureId, int pMipmapLevel, int pWidth, int pHeight) {
        TextureUtil.prepareImage(pTextureId, pMipmapLevel, 0, pWidth, pHeight);
    }

    public static void prepareImage(int pTextureId, int pMipmapLevel, int pWidth, int pHeight) {
        TextureUtil.prepareImage(NativeImage.InternalGlFormat.RGBA, pTextureId, pMipmapLevel, pWidth, pHeight);
    }

    public static void prepareImage(NativeImage.InternalGlFormat pPixelFormat, int pTextureId, int pMipmapLevel, int pWidth, int pHeight) {
        RenderSystem.assertOnRenderThreadOrInit();
        TextureUtil.bind(pTextureId);
        if (pMipmapLevel >= 0) {
            GlStateManager._texParameter(3553, 33085, pMipmapLevel);
            GlStateManager._texParameter(3553, 33082, 0);
            GlStateManager._texParameter(3553, 33083, pMipmapLevel);
            GlStateManager._texParameter(3553, 34049, 0.0f);
        }
        int i = 0;
        while (i <= pMipmapLevel) {
            GlStateManager._texImage2D(3553, i, pPixelFormat.glFormat(), pWidth >> i, pHeight >> i, 0, 6408, 5121, null);
            ++i;
        }
    }

    private static void bind(int pTextureId) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._bindTexture(pTextureId);
    }

    public static ByteBuffer readResource(InputStream pInputStream) throws IOException {
        ByteBuffer bytebuffer;
        if (pInputStream instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)pInputStream;
            FileChannel filechannel = fileinputstream.getChannel();
            bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
            while (filechannel.read(bytebuffer) != -1) {
            }
        } else {
            bytebuffer = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel readablebytechannel = Channels.newChannel(pInputStream);
            while (readablebytechannel.read(bytebuffer) != -1) {
                if (bytebuffer.remaining() != 0) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
        }
        return bytebuffer;
    }

    @Nullable
    public static String readResourceAsString(InputStream pInputStream) {
        RenderSystem.assertOnRenderThread();
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource(pInputStream);
            int i = bytebuffer.position();
            bytebuffer.rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)bytebuffer, (int)i);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return null;
    }

    public static void writeAsPNG(String p_157135_, int p_157136_, int p_157137_, int p_157138_, int p_157139_) {
        RenderSystem.assertOnRenderThread();
        TextureUtil.bind(p_157136_);
        int i = 0;
        while (i <= p_157137_) {
            String s = String.valueOf(p_157135_) + "_" + i + ".png";
            int j = p_157138_ >> i;
            int k = p_157139_ >> i;
            try (NativeImage nativeimage = new NativeImage(j, k, false);){
                nativeimage.downloadTexture(i, false);
                nativeimage.writeToFile(s);
                LOGGER.debug("Exported png to: {}", (Object)new File(s).getAbsolutePath());
            }
            catch (IOException ioexception) {
                LOGGER.debug("Unable to write: ", (Throwable)ioexception);
            }
            ++i;
        }
    }

    public static void initTexture(IntBuffer pBuffer, int pWidth, int pHeight) {
        RenderSystem.assertOnRenderThread();
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)pWidth, (int)pHeight, (int)0, (int)32993, (int)33639, (IntBuffer)pBuffer);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
    }
}

