/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.SilentInitException;
import net.minecraftforge.fml.loading.progress.EarlyProgressVisualization;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.util.TextureUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

public final class Window
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final GLFWErrorCallback defaultErrorCallback = GLFWErrorCallback.create(this::defaultErrorCallback);
    private final WindowEventHandler eventHandler;
    private final ScreenManager screenManager;
    private final long window;
    private int windowedX;
    private int windowedY;
    private int windowedWidth;
    private int windowedHeight;
    private Optional<VideoMode> preferredFullscreenVideoMode;
    private boolean fullscreen;
    private boolean actuallyFullscreen;
    private int x;
    private int y;
    private int width;
    private int height;
    private int framebufferWidth;
    private int framebufferHeight;
    private int guiScaledWidth;
    private int guiScaledHeight;
    private double guiScale;
    private String errorSection = "";
    private boolean dirty;
    private int framerateLimit;
    private boolean vsync;
    private boolean closed;

    public Window(WindowEventHandler pEventHandler, ScreenManager pScreenManager, DisplayData pDisplayData, @Nullable String pPreferredFullscreenVideoMode, String pTitle) {
        RenderSystem.assertInInitPhase();
        this.screenManager = pScreenManager;
        this.setBootErrorCallback();
        this.setErrorSection("Pre startup");
        this.eventHandler = pEventHandler;
        Optional<VideoMode> optional = VideoMode.read(pPreferredFullscreenVideoMode);
        this.preferredFullscreenVideoMode = optional.isPresent() ? optional : (pDisplayData.fullscreenWidth.isPresent() && pDisplayData.fullscreenHeight.isPresent() ? Optional.of(new VideoMode(pDisplayData.fullscreenWidth.getAsInt(), pDisplayData.fullscreenHeight.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.actuallyFullscreen = this.fullscreen = pDisplayData.isFullscreen;
        Monitor monitor = pScreenManager.getMonitor(GLFW.glfwGetPrimaryMonitor());
        this.width = pDisplayData.width > 0 ? pDisplayData.width : 1;
        this.windowedWidth = this.width;
        this.height = pDisplayData.height > 0 ? pDisplayData.height : 1;
        this.windowedHeight = this.height;
        GLFW.glfwDefaultWindowHints();
        if (Config.isAntialiasing()) {
            GLFW.glfwWindowHint((int)135181, (int)Config.getAntialiasingLevel());
        }
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        long i = 0L;
        if (Reflector.EarlyProgressVisualization_handOffWindow.exists()) {
            Object object = Reflector.getFieldValue(Reflector.EarlyProgressVisualization_INSTANCE);
            i = Reflector.callLong(object, Reflector.EarlyProgressVisualization_handOffWindow, () -> this.width, () -> this.height, () -> pTitle, () -> this.fullscreen && monitor != null ? monitor.getMonitor() : 0L);
            if (Config.isAntialiasing()) {
                GLFW.glfwDestroyWindow((long)i);
                i = 0L;
            }
        }
        this.window = i != 0L ? i : GLFW.glfwCreateWindow((int)this.width, (int)this.height, (CharSequence)pTitle, (long)(this.fullscreen && monitor != null ? monitor.getMonitor() : 0L), (long)0L);
        if (monitor != null) {
            VideoMode videomode = monitor.getPreferredVidMode(this.fullscreen ? this.preferredFullscreenVideoMode : Optional.empty());
            this.windowedX = this.x = monitor.getX() + videomode.getWidth() / 2 - this.width / 2;
            this.windowedY = this.y = monitor.getY() + videomode.getHeight() / 2 - this.height / 2;
        } else {
            int[] aint1 = new int[1];
            int[] aint = new int[1];
            GLFW.glfwGetWindowPos((long)this.window, (int[])aint1, (int[])aint);
            this.windowedX = this.x = aint1[0];
            this.windowedY = this.y = aint[0];
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        GL.createCapabilities();
        this.setMode();
        this.refreshFramebufferSize();
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, this::onFramebufferResize);
        GLFW.glfwSetWindowPosCallback((long)this.window, this::onMove);
        GLFW.glfwSetWindowSizeCallback((long)this.window, this::onResize);
        GLFW.glfwSetWindowFocusCallback((long)this.window, this::onFocus);
        GLFW.glfwSetCursorEnterCallback((long)this.window, this::onEnter);
    }

    public int getRefreshRate() {
        RenderSystem.assertOnRenderThread();
        return GLX._getRefreshRate(this);
    }

    public boolean shouldClose() {
        return GLX._shouldClose(this);
    }

    public static void checkGlfwError(BiConsumer<Integer, String> pErrorConsumer) {
        RenderSystem.assertInInitPhase();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (i != 0) {
                long j = pointerbuffer.get();
                String s = j == 0L ? "" : MemoryUtil.memUTF8((long)j);
                pErrorConsumer.accept(i, s);
            }
        }
    }

    public void setIcon(InputStream pIconStream16X, InputStream pIconStream32X) {
        RenderSystem.assertInInitPhase();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            if (pIconStream16X == null) {
                throw new FileNotFoundException("/assets/minecraft/icons/custom_icon_16x16.png");
            }
            if (pIconStream32X == null) {
                throw new FileNotFoundException("/assets/minecraft/icons/custom_icon_32x32.png");
            }
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = this.readIconPixels(pIconStream16X, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = this.readIconPixels(pIconStream32X, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't set icon", (Throwable)ioexception1);
        }
    }

    @Nullable
    private ByteBuffer readIconPixels(InputStream pTextureStream, IntBuffer pX, IntBuffer pY, IntBuffer pChannelInFile) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.assertInInitPhase();
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource(pTextureStream);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)pX, (IntBuffer)pY, (IntBuffer)pChannelInFile, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }

    public void setErrorSection(String pErrorSection) {
        this.errorSection = pErrorSection;
        if (pErrorSection.equals("Startup")) {
            TextureUtils.registerTickableTextures();
        }
    }

    private void setBootErrorCallback() {
        RenderSystem.assertInInitPhase();
        GLFW.glfwSetErrorCallback(Window::bootCrash);
    }

    private static void bootCrash(int p_85413_, long p_85414_) {
        RenderSystem.assertInInitPhase();
        String s = "GLFW error " + p_85413_ + ": " + MemoryUtil.memUTF8((long)p_85414_);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(String.valueOf(s) + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new WindowInitFailed(s);
    }

    public void defaultErrorCallback(int p_85383_, long p_85384_) {
        RenderSystem.assertOnRenderThread();
        String s = MemoryUtil.memUTF8((long)p_85384_);
        LOGGER.error("########## GL ERROR ##########");
        LOGGER.error("@ {}", (Object)this.errorSection);
        LOGGER.error("{}: {}", (Object)p_85383_, (Object)s);
    }

    public void setDefaultErrorCallback() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.defaultErrorCallback);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
        TextureUtils.registerResourceListener();
    }

    public void updateVsync(boolean pVsync) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.vsync = pVsync;
        GLFW.glfwSwapInterval((int)(pVsync ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertOnRenderThread();
        this.closed = true;
        Callbacks.glfwFreeCallbacks((long)this.window);
        this.defaultErrorCallback.close();
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
    }

    private void onMove(long p_85389_, int p_85390_, int p_85391_) {
        this.x = p_85390_;
        this.y = p_85391_;
    }

    private void onFramebufferResize(long p_85416_, int p_85417_, int p_85418_) {
        if (p_85416_ == this.window) {
            int i = this.getWidth();
            int j = this.getHeight();
            if (p_85417_ != 0 && p_85418_ != 0) {
                this.framebufferWidth = p_85417_;
                this.framebufferHeight = p_85418_;
                if (this.getWidth() != i || this.getHeight() != j) {
                    this.eventHandler.resizeDisplay();
                }
            }
        }
    }

    private void refreshFramebufferSize() {
        RenderSystem.assertInInitPhase();
        int[] aint = new int[1];
        int[] aint1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.window, (int[])aint, (int[])aint1);
        this.framebufferWidth = aint[0] > 0 ? aint[0] : 1;
        int n = this.framebufferHeight = aint1[0] > 0 ? aint1[0] : 1;
        if (this.framebufferHeight == 0 || this.framebufferWidth == 0) {
            EarlyProgressVisualization.INSTANCE.updateFBSize(w -> {
                this.framebufferWidth = w;
            }, h -> {
                this.framebufferHeight = h;
            });
        }
    }

    private void onResize(long p_85428_, int p_85429_, int p_85430_) {
        this.width = p_85429_;
        this.height = p_85430_;
    }

    private void onFocus(long p_85393_, boolean p_85394_) {
        if (p_85393_ == this.window) {
            this.eventHandler.setWindowActive(p_85394_);
        }
    }

    private void onEnter(long p_85420_, boolean p_85421_) {
        if (p_85421_) {
            this.eventHandler.cursorEntered();
        }
    }

    public void setFramerateLimit(int pLimit) {
        this.framerateLimit = pLimit;
    }

    public int getFramerateLimit() {
        return this.framerateLimit;
    }

    public void updateDisplay() {
        RenderSystem.flipFrame(this.window);
        if (this.fullscreen != this.actuallyFullscreen) {
            this.actuallyFullscreen = this.fullscreen;
            this.updateFullscreen(this.vsync);
        }
    }

    public Optional<VideoMode> getPreferredFullscreenVideoMode() {
        return this.preferredFullscreenVideoMode;
    }

    public void setPreferredFullscreenVideoMode(Optional<VideoMode> pPreferredFullscreenVideoMode) {
        boolean flag = !pPreferredFullscreenVideoMode.equals(this.preferredFullscreenVideoMode);
        this.preferredFullscreenVideoMode = pPreferredFullscreenVideoMode;
        if (flag) {
            this.dirty = true;
        }
    }

    public void changeFullscreenVideoMode() {
        if (this.fullscreen && this.dirty) {
            this.dirty = false;
            this.setMode();
            this.eventHandler.resizeDisplay();
        }
    }

    private void setMode() {
        boolean flag;
        RenderSystem.assertInInitPhase();
        boolean bl = flag = GLFW.glfwGetWindowMonitor((long)this.window) != 0L;
        if (this.fullscreen) {
            Monitor monitor = this.screenManager.findBestMonitor(this);
            if (monitor == null) {
                LOGGER.warn("Failed to find suitable monitor for fullscreen mode");
                this.fullscreen = false;
            } else {
                if (Minecraft.ON_OSX) {
                    MacosUtil.toggleFullscreen(this.window);
                }
                VideoMode videomode = monitor.getPreferredVidMode(this.preferredFullscreenVideoMode);
                if (!flag) {
                    this.windowedX = this.x;
                    this.windowedY = this.y;
                    this.windowedWidth = this.width;
                    this.windowedHeight = this.height;
                }
                this.x = 0;
                this.y = 0;
                this.width = videomode.getWidth();
                this.height = videomode.getHeight();
                GLFW.glfwSetWindowMonitor((long)this.window, (long)monitor.getMonitor(), (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)videomode.getRefreshRate());
            }
        } else {
            this.x = this.windowedX;
            this.y = this.windowedY;
            this.width = this.windowedWidth;
            this.height = this.windowedHeight;
            GLFW.glfwSetWindowMonitor((long)this.window, (long)0L, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-1);
        }
    }

    public void toggleFullScreen() {
        this.fullscreen = !this.fullscreen;
    }

    public void setWindowed(int pWindowedWidth, int pWindowedHeight) {
        this.windowedWidth = pWindowedWidth;
        this.windowedHeight = pWindowedHeight;
        this.fullscreen = false;
        this.setMode();
    }

    private void updateFullscreen(boolean pVsyncEnabled) {
        RenderSystem.assertOnRenderThread();
        try {
            this.setMode();
            this.eventHandler.resizeDisplay();
            this.updateVsync(pVsyncEnabled);
            this.updateDisplay();
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int calculateScale(int pGuiScale, boolean pForceUnicode) {
        int i = 1;
        while (i != pGuiScale && i < this.framebufferWidth && i < this.framebufferHeight && this.framebufferWidth / (i + 1) >= 320 && this.framebufferHeight / (i + 1) >= 240) {
            ++i;
        }
        if (pForceUnicode && i % 2 != 0) {
            ++i;
        }
        return i;
    }

    public void setGuiScale(double pScaleFactor) {
        this.guiScale = pScaleFactor;
        int i = (int)((double)this.framebufferWidth / pScaleFactor);
        this.guiScaledWidth = (double)this.framebufferWidth / pScaleFactor > (double)i ? i + 1 : i;
        int j = (int)((double)this.framebufferHeight / pScaleFactor);
        this.guiScaledHeight = (double)this.framebufferHeight / pScaleFactor > (double)j ? j + 1 : j;
    }

    public void setTitle(String pTitle) {
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)pTitle);
    }

    public long getWindow() {
        return this.window;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public int getWidth() {
        return this.framebufferWidth;
    }

    public int getHeight() {
        return this.framebufferHeight;
    }

    public void setWidth(int pFramebufferWidth) {
        this.framebufferWidth = pFramebufferWidth;
    }

    public void setHeight(int pFramebufferHeight) {
        this.framebufferHeight = pFramebufferHeight;
    }

    public int getScreenWidth() {
        return this.width;
    }

    public int getScreenHeight() {
        return this.height;
    }

    public int getGuiScaledWidth() {
        return this.guiScaledWidth;
    }

    public int getGuiScaledHeight() {
        return this.guiScaledHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getGuiScale() {
        return this.guiScale;
    }

    @Nullable
    public Monitor findBestMonitor() {
        return this.screenManager.findBestMonitor(this);
    }

    public void updateRawMouseInput(boolean pEnableRawMouseMotion) {
        InputConstants.updateRawMouseInput(this.window, pEnableRawMouseMotion);
    }

    public void resizeFramebuffer(int width, int height) {
        this.onFramebufferResize(this.window, width, height);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static class WindowInitFailed
    extends SilentInitException {
        WindowInitFailed(String p_85455_) {
            super(p_85455_);
        }
    }
}

