/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.preprocessor;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class GlslPreprocessor {
    private static final String C_COMMENT = "/\\*(?:[^*]|\\*+[^*/])*\\*+/";
    private static final String LINE_COMMENT = "//[^\\v]*";
    private static final Pattern REGEX_MOJ_IMPORT = Pattern.compile("(#(?:/\\*(?:[^*]|\\*+[^*/])*\\*+/|\\h)*moj_import(?:/\\*(?:[^*]|\\*+[^*/])*\\*+/|\\h)*(?:\"(.*)\"|<(.*)>))");
    private static final Pattern REGEX_VERSION = Pattern.compile("(#(?:/\\*(?:[^*]|\\*+[^*/])*\\*+/|\\h)*version(?:/\\*(?:[^*]|\\*+[^*/])*\\*+/|\\h)*(\\d+))\\b");
    private static final Pattern REGEX_ENDS_WITH_WHITESPACE = Pattern.compile("(?:^|\\v)(?:\\s|/\\*(?:[^*]|\\*+[^*/])*\\*+/|(//[^\\v]*))*\\z");

    public List<String> process(String pShaderData) {
        Context glslpreprocessor$context = new Context();
        List<String> list = this.processImports(pShaderData, glslpreprocessor$context, "");
        list.set(0, this.setVersion(list.get(0), glslpreprocessor$context.glslVersion));
        return list;
    }

    private List<String> processImports(String pShaderData, Context pContext, String pIncludeDirectory) {
        int i = pContext.sourceId;
        int j = 0;
        String s = "";
        ArrayList list = Lists.newArrayList();
        Matcher matcher = REGEX_MOJ_IMPORT.matcher(pShaderData);
        while (matcher.find()) {
            boolean flag;
            if (GlslPreprocessor.isDirectiveDisabled(pShaderData, matcher, j)) continue;
            String s1 = matcher.group(2);
            boolean bl = flag = s1 != null;
            if (!flag) {
                s1 = matcher.group(3);
            }
            if (s1 == null) continue;
            String s2 = pShaderData.substring(j, matcher.start(1));
            String s3 = String.valueOf(pIncludeDirectory) + s1;
            String s4 = this.applyImport(flag, s3);
            if (!Strings.isNullOrEmpty((String)s4)) {
                if (!StringUtil.endsWithNewLine(s4)) {
                    s4 = String.valueOf(s4) + System.lineSeparator();
                }
                int k = ++pContext.sourceId;
                List<String> list1 = this.processImports(s4, pContext, flag ? FileUtil.getFullResourcePath(s3) : "");
                list1.set(0, String.format(Locale.ROOT, "#line %d %d\n%s", 0, k, this.processVersions(list1.get(0), pContext)));
                if (!StringUtils.isBlank((CharSequence)s2)) {
                    list.add(s2);
                }
                list.addAll(list1);
            } else {
                String s6 = flag ? String.format("/*#moj_import \"%s\"*/", s1) : String.format("/*#moj_import <%s>*/", s1);
                list.add(String.valueOf(s) + s2 + s6);
            }
            int l = StringUtil.lineCount(pShaderData.substring(0, matcher.end(1)));
            s = String.format(Locale.ROOT, "#line %d %d", l, i);
            j = matcher.end(1);
        }
        String s5 = pShaderData.substring(j);
        if (!StringUtils.isBlank((CharSequence)s5)) {
            list.add(String.valueOf(s) + s5);
        }
        return list;
    }

    private String processVersions(String pVersionData, Context pContext) {
        Matcher matcher = REGEX_VERSION.matcher(pVersionData);
        if (matcher.find() && GlslPreprocessor.isDirectiveEnabled(pVersionData, matcher)) {
            pContext.glslVersion = Math.max(pContext.glslVersion, Integer.parseInt(matcher.group(2)));
            return String.valueOf(pVersionData.substring(0, matcher.start(1))) + "/*" + pVersionData.substring(matcher.start(1), matcher.end(1)) + "*/" + pVersionData.substring(matcher.end(1));
        }
        return pVersionData;
    }

    private String setVersion(String pVersionData, int pGlslVersion) {
        Matcher matcher = REGEX_VERSION.matcher(pVersionData);
        return matcher.find() && GlslPreprocessor.isDirectiveEnabled(pVersionData, matcher) ? String.valueOf(pVersionData.substring(0, matcher.start(2))) + Math.max(pGlslVersion, Integer.parseInt(matcher.group(2))) + pVersionData.substring(matcher.end(2)) : pVersionData;
    }

    private static boolean isDirectiveEnabled(String pShaderData, Matcher pMatcher) {
        return !GlslPreprocessor.isDirectiveDisabled(pShaderData, pMatcher, 0);
    }

    private static boolean isDirectiveDisabled(String p_166477_, Matcher p_166478_, int p_166479_) {
        int i = p_166478_.start() - p_166479_;
        if (i == 0) {
            return false;
        }
        Matcher matcher = REGEX_ENDS_WITH_WHITESPACE.matcher(p_166477_.substring(p_166479_, p_166478_.start()));
        if (!matcher.find()) {
            return true;
        }
        int j = matcher.end(1);
        return j == p_166478_.start();
    }

    @Nullable
    public abstract String applyImport(boolean var1, String var2);

    static final class Context {
        int glslVersion;
        int sourceId;

        Context() {
        }
    }
}

