/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.shaders.Shaders;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.slf4j.Logger;

@DontObfuscate
public class RenderSystem {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ConcurrentLinkedQueue<RenderCall> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final Tesselator RENDER_THREAD_TESSELATOR = new Tesselator();
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    @Nullable
    private static Thread gameThread;
    @Nullable
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;
    private static final AutoStorageIndexBuffer sharedSequential;
    private static final AutoStorageIndexBuffer sharedSequentialQuad;
    private static final AutoStorageIndexBuffer sharedSequentialLines;
    private static Matrix3f inverseViewRotationMatrix;
    private static Matrix4f projectionMatrix;
    private static Matrix4f savedProjectionMatrix;
    private static PoseStack modelViewStack;
    private static Matrix4f modelViewMatrix;
    private static Matrix4f textureMatrix;
    private static final int[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderFogStart;
    private static float shaderFogEnd;
    private static final float[] shaderFogColor;
    private static FogShape shaderFogShape;
    private static final Vector3f[] shaderLightDirections;
    private static float shaderGameTime;
    private static float shaderLineWidth;
    private static String apiDescription;
    @Nullable
    private static ShaderInstance shader;
    private static boolean fogAllowed;
    private static boolean colorToAttribute;

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new AutoStorageIndexBuffer(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new AutoStorageIndexBuffer(4, 6, (p_157398_, p_157399_) -> {
            p_157398_.accept(p_157399_ + 0);
            p_157398_.accept(p_157399_ + 1);
            p_157398_.accept(p_157399_ + 2);
            p_157398_.accept(p_157399_ + 2);
            p_157398_.accept(p_157399_ + 3);
            p_157398_.accept(p_157399_ + 0);
        });
        sharedSequentialLines = new AutoStorageIndexBuffer(4, 6, (p_157401_, p_157402_) -> {
            p_157401_.accept(p_157402_ + 0);
            p_157401_.accept(p_157402_ + 1);
            p_157401_.accept(p_157402_ + 2);
            p_157401_.accept(p_157402_ + 3);
            p_157401_.accept(p_157402_ + 2);
            p_157401_.accept(p_157402_ + 1);
        });
        inverseViewRotationMatrix = new Matrix3f();
        projectionMatrix = new Matrix4f();
        savedProjectionMatrix = new Matrix4f();
        modelViewStack = new PoseStack();
        modelViewMatrix = new Matrix4f();
        textureMatrix = new Matrix4f();
        shaderTextures = new int[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderFogEnd = 1.0f;
        shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        shaderFogShape = FogShape.SPHERE;
        shaderLightDirections = new Vector3f[2];
        shaderLineWidth = 1.0f;
        apiDescription = "Unknown";
        fogAllowed = true;
        colorToAttribute = false;
        projectionMatrix.setIdentity();
        savedProjectionMatrix.setIdentity();
        modelViewMatrix.setIdentity();
        textureMatrix.setIdentity();
    }

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean pRenderOffThread) {
        boolean flag;
        boolean bl = flag = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || flag == pRenderOffThread) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static void assertInInitPhase() {
        if (!RenderSystem.isInInitPhase()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnGameThreadOrInit() {
        if (!isInInit && !RenderSystem.isOnGameThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnRenderThreadOrInit() {
        if (!isInInit && !RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnGameThread() {
        if (!RenderSystem.isOnGameThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(RenderCall pRenderCall) {
        recordingQueue.add(pRenderCall);
    }

    public static void flipFrame(long pWindowId) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        Tesselator.getInstance().getBuilder().clear();
        GLFW.glfwSwapBuffers((long)pWindowId);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            RenderCall rendercall = recordingQueue.poll();
            rendercall.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int pFrameRateLimit) {
        double d0 = lastDrawTime + 1.0 / (double)pFrameRateLimit;
        double d1 = GLFW.glfwGetTime();
        while (d1 < d0) {
            GLFW.glfwWaitEventsTimeout((double)(d0 - d1));
            d1 = GLFW.glfwGetTime();
        }
        lastDrawTime = d1;
    }

    public static void disableDepthTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._enableDepthTest();
    }

    public static void enableScissor(int pX, int pY, int pWidth, int pHeight) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(pX, pY, pWidth, pHeight);
    }

    public static void disableScissor() {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._disableScissorTest();
    }

    public static void depthFunc(int pDepthFunc) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthFunc(pDepthFunc);
    }

    public static void depthMask(boolean pFlag) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthMask(pFlag);
    }

    public static void enableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableBlend();
    }

    public static void blendFunc(GlStateManager.SourceFactor pSourceFactor, GlStateManager.DestFactor pDestFactor) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFunc(pSourceFactor.value, pDestFactor.value);
    }

    public static void blendFunc(int pSourceFactor, int pDestFactor) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFunc(pSourceFactor, pDestFactor);
    }

    public static void blendFuncSeparate(GlStateManager.SourceFactor pSourceFactor, GlStateManager.DestFactor pDestFactor, GlStateManager.SourceFactor pSourceFactorAlpha, GlStateManager.DestFactor pDestFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate(pSourceFactor.value, pDestFactor.value, pSourceFactorAlpha.value, pDestFactorAlpha.value);
    }

    public static void blendFuncSeparate(int pSourceFactor, int pDestFactor, int pSourceFactorAlpha, int pDestFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate(pSourceFactor, pDestFactor, pSourceFactorAlpha, pDestFactorAlpha);
    }

    public static void blendEquation(int pMode) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendEquation(pMode);
    }

    public static void enableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableCull();
    }

    public static void polygonMode(int pFace, int pMode) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._polygonMode(pFace, pMode);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disablePolygonOffset();
    }

    public static void polygonOffset(float pFactor, float pUnits) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._polygonOffset(pFactor, pUnits);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.LogicOp pOp) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._logicOp(pOp.value);
    }

    public static void activeTexture(int pTexture) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._activeTexture(pTexture);
    }

    public static void enableTexture() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableTexture();
    }

    public static void disableTexture() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableTexture();
    }

    public static void texParameter(int pTarget, int pParameterName, int pParameter) {
        GlStateManager._texParameter(pTarget, pParameterName, pParameter);
    }

    public static void deleteTexture(int pTexture) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._deleteTexture(pTexture);
    }

    public static void bindTextureForSetup(int pTexture) {
        RenderSystem.bindTexture(pTexture);
    }

    public static void bindTexture(int pTexture) {
        GlStateManager._bindTexture(pTexture);
    }

    public static void viewport(int pX, int pY, int pWidth, int pHeight) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._viewport(pX, pY, pWidth, pHeight);
    }

    public static void colorMask(boolean pRed, boolean pGreen, boolean pBlue, boolean pAlpha) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask(pRed, pGreen, pBlue, pAlpha);
    }

    public static void stencilFunc(int pFunc, int pRef, int pMask) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilFunc(pFunc, pRef, pMask);
    }

    public static void stencilMask(int pMask) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilMask(pMask);
    }

    public static void stencilOp(int pSFail, int pDpFail, int pDpPass) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilOp(pSFail, pDpFail, pDpPass);
    }

    public static void clearDepth(double pDepth) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clearDepth(pDepth);
    }

    public static void clearColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clearColor(pRed, pGreen, pBlue, pAlpha);
    }

    public static void clearStencil(int pIndex) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._clearStencil(pIndex);
    }

    public static void clear(int pMask, boolean pCheckError) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clear(pMask, pCheckError);
    }

    public static void setShaderFogStart(float pShaderFogStart) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogStart(pShaderFogStart);
    }

    private static void _setShaderFogStart(float pShaderFogStart) {
        shaderFogStart = pShaderFogStart;
    }

    public static float getShaderFogStart() {
        if (!fogAllowed) {
            return Float.MAX_VALUE;
        }
        RenderSystem.assertOnRenderThread();
        return shaderFogStart;
    }

    public static void setShaderFogEnd(float pShaderFogEnd) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogEnd(pShaderFogEnd);
    }

    private static void _setShaderFogEnd(float pShaderFogEnd) {
        shaderFogEnd = pShaderFogEnd;
    }

    public static float getShaderFogEnd() {
        if (!fogAllowed) {
            return Float.MAX_VALUE;
        }
        RenderSystem.assertOnRenderThread();
        return shaderFogEnd;
    }

    public static void setShaderFogColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogColor(pRed, pGreen, pBlue, pAlpha);
    }

    public static void setShaderFogColor(float pRed, float pGreen, float pBlue) {
        RenderSystem.setShaderFogColor(pRed, pGreen, pBlue, 1.0f);
    }

    private static void _setShaderFogColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.shaderFogColor[0] = pRed;
        RenderSystem.shaderFogColor[1] = pGreen;
        RenderSystem.shaderFogColor[2] = pBlue;
        RenderSystem.shaderFogColor[3] = pAlpha;
    }

    public static float[] getShaderFogColor() {
        RenderSystem.assertOnRenderThread();
        return shaderFogColor;
    }

    public static void setShaderFogShape(FogShape p_202161_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogShape(p_202161_);
    }

    private static void _setShaderFogShape(FogShape p_202040_) {
        shaderFogShape = p_202040_;
    }

    public static FogShape getShaderFogShape() {
        RenderSystem.assertOnRenderThread();
        return shaderFogShape;
    }

    public static void setShaderLights(Vector3f pLightingVector0, Vector3f pLightingVector1) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderLights(pLightingVector0, pLightingVector1);
    }

    public static void _setShaderLights(Vector3f pLightingVector0, Vector3f pLightingVector1) {
        RenderSystem.shaderLightDirections[0] = pLightingVector0;
        RenderSystem.shaderLightDirections[1] = pLightingVector1;
    }

    public static void setupShaderLights(ShaderInstance pInstance) {
        RenderSystem.assertOnRenderThread();
        if (pInstance.LIGHT0_DIRECTION != null) {
            pInstance.LIGHT0_DIRECTION.set(shaderLightDirections[0]);
        }
        if (pInstance.LIGHT1_DIRECTION != null) {
            pInstance.LIGHT1_DIRECTION.set(shaderLightDirections[1]);
        }
    }

    public static void setShaderColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderColor(pRed, pGreen, pBlue, pAlpha));
        } else {
            RenderSystem._setShaderColor(pRed, pGreen, pBlue, pAlpha);
        }
    }

    private static void _setShaderColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.shaderColor[0] = pRed;
        RenderSystem.shaderColor[1] = pGreen;
        RenderSystem.shaderColor[2] = pBlue;
        RenderSystem.shaderColor[3] = pAlpha;
        if (colorToAttribute) {
            Shaders.setDefaultAttribColor(pRed, pGreen, pBlue, pAlpha);
        }
    }

    public static float[] getShaderColor() {
        RenderSystem.assertOnRenderThread();
        return shaderColor;
    }

    public static void drawElements(int pMode, int pCount, int pType) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._drawElements(pMode, pCount, pType, 0L);
    }

    public static void lineWidth(float pShaderLineWidth) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderLineWidth = pShaderLineWidth;
            });
        } else {
            shaderLineWidth = pShaderLineWidth;
        }
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertOnRenderThread();
        return shaderLineWidth;
    }

    public static void pixelStore(int pParameterName, int pParameter) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._pixelStore(pParameterName, pParameter);
    }

    public static void readPixels(int pX, int pY, int pWidth, int pHeight, int pFormat, int pType, ByteBuffer pPixels) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._readPixels(pX, pY, pWidth, pHeight, pFormat, pType, pPixels);
    }

    public static void getString(int p_69520_, Consumer<String> p_69521_) {
        RenderSystem.assertOnRenderThread();
        p_69521_.accept(GlStateManager._getString(p_69520_));
    }

    public static String getBackendDescription() {
        RenderSystem.assertInInitPhase();
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertInInitPhase();
        return GLX._initGlfw();
    }

    public static void initRenderer(int pDebugVerbosity, boolean pSynchronous) {
        RenderSystem.assertInInitPhase();
        GLX._init(pDebugVerbosity, pSynchronous);
        apiDescription = GLX.getOpenGLVersionString();
    }

    public static void setErrorCallback(GLFWErrorCallbackI pCallback) {
        RenderSystem.assertInInitPhase();
        GLX._setGlfwErrorCallback(pCallback);
    }

    public static void renderCrosshair(int p_69882_) {
        RenderSystem.assertOnRenderThread();
        GLX._renderCrosshair(p_69882_, true, true, true);
    }

    public static String getCapsString() {
        RenderSystem.assertOnRenderThread();
        return "Using framebuffer using OpenGL 3.2";
    }

    public static void setupDefaultState(int pX, int pY, int pWidth, int pHeight) {
        RenderSystem.assertInInitPhase();
        GlStateManager._enableTexture();
        GlStateManager._clearDepth(1.0);
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc(515);
        projectionMatrix.setIdentity();
        savedProjectionMatrix.setIdentity();
        modelViewMatrix.setIdentity();
        textureMatrix.setIdentity();
        GlStateManager._viewport(pX, pY, pWidth, pHeight);
    }

    public static int maxSupportedTextureSize() {
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            RenderSystem.assertOnRenderThreadOrInit();
            int i = GlStateManager._getInteger(3379);
            int j = Math.max(32768, i);
            while (j >= 1024) {
                GlStateManager._texImage2D(32868, 0, 6408, j, j, 0, 6408, 5121, null);
                int k = GlStateManager._getTexLevelParameter(32868, 0, 4096);
                if (k != 0) {
                    MAX_SUPPORTED_TEXTURE_SIZE = j;
                    return j;
                }
                j >>= 1;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(i, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int pTarget, IntSupplier pBuffer) {
        GlStateManager._glBindBuffer(pTarget, pBuffer.getAsInt());
    }

    public static void glBindVertexArray(Supplier<Integer> pArray) {
        GlStateManager._glBindVertexArray(pArray.get());
    }

    public static void glBufferData(int pTarget, ByteBuffer pData, int pUsage) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBufferData(pTarget, pData, pUsage);
    }

    public static void glDeleteBuffers(int pBuffer) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glDeleteBuffers(pBuffer);
    }

    public static void glDeleteVertexArrays(int pArray) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glDeleteVertexArrays(pArray);
    }

    public static void glUniform1i(int pLocation, int pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1i(pLocation, pValue);
    }

    public static void glUniform1(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1(pLocation, pValue);
    }

    public static void glUniform2(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform2(pLocation, pValue);
    }

    public static void glUniform3(int pLocation, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform3(pLocation, pValue);
    }

    public static void glUniform4(int pLoctaion, IntBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform4(pLoctaion, pValue);
    }

    public static void glUniform1(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1(pLocation, pValue);
    }

    public static void glUniform2(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform2(pLocation, pValue);
    }

    public static void glUniform3(int pLocation, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform3(pLocation, pValue);
    }

    public static void glUniform4(int pLoctaion, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform4(pLoctaion, pValue);
    }

    public static void glUniformMatrix2(int pLocation, boolean pTranspose, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix2(pLocation, pTranspose, pValue);
    }

    public static void glUniformMatrix3(int pLocation, boolean pTranspose, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix3(pLocation, pTranspose, pValue);
    }

    public static void glUniformMatrix4(int pLocation, boolean pTranspose, FloatBuffer pValue) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix4(pLocation, pTranspose, pValue);
    }

    public static void setupOverlayColor(IntSupplier pTextureId, int pShaderTexture) {
        RenderSystem.assertOnRenderThread();
        int i = pTextureId.getAsInt();
        RenderSystem.setShaderTexture(1, i);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, 0);
    }

    public static void setupLevelDiffuseLighting(Vector3f pLightingVector0, Vector3f pLightingVector1, Matrix4f pMatrix) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupLevelDiffuseLighting(pLightingVector0, pLightingVector1, pMatrix);
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f pLightingVector0, Vector3f pLightingVector1) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupGuiFlatDiffuseLighting(pLightingVector0, pLightingVector1);
    }

    public static void setupGui3DDiffuseLighting(Vector3f pLightingVector0, Vector3f pLightingVector1) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupGui3DDiffuseLighting(pLightingVector0, pLightingVector1);
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> pBufferIdConsumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> pBufferIdConsumer.accept(GlStateManager._glGenBuffers()));
        } else {
            pBufferIdConsumer.accept(GlStateManager._glGenBuffers());
        }
    }

    public static void glGenVertexArrays(Consumer<Integer> pArrayObjectIdConsumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> pArrayObjectIdConsumer.accept(GlStateManager._glGenVertexArrays()));
        } else {
            pArrayObjectIdConsumer.accept(GlStateManager._glGenVertexArrays());
        }
    }

    public static Tesselator renderThreadTesselator() {
        RenderSystem.assertOnRenderThread();
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    @Deprecated
    public static void runAsFancy(Runnable pFancyRunnable) {
        boolean flag = Minecraft.useShaderTransparency();
        if (!flag) {
            pFancyRunnable.run();
        } else {
            Options options = Minecraft.getInstance().options;
            GraphicsStatus graphicsstatus = options.graphicsMode;
            options.graphicsMode = GraphicsStatus.FANCY;
            pFancyRunnable.run();
            options.graphicsMode = graphicsstatus;
        }
    }

    public static void setShader(Supplier<ShaderInstance> pShaderSupplier) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shader = (ShaderInstance)pShaderSupplier.get();
            });
        } else {
            shader = pShaderSupplier.get();
        }
    }

    @Nullable
    public static ShaderInstance getShader() {
        RenderSystem.assertOnRenderThread();
        return shader;
    }

    public static int getTextureId(int pTextureId) {
        return GlStateManager._getTextureId(pTextureId);
    }

    public static void setShaderTexture(int pShaderTexture, ResourceLocation pTextureId) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(pShaderTexture, pTextureId));
        } else {
            RenderSystem._setShaderTexture(pShaderTexture, pTextureId);
        }
    }

    public static void _setShaderTexture(int pShaderTexture, ResourceLocation pTextureId) {
        if (Config.isCustomGuis()) {
            pTextureId = CustomGuis.getTextureLocation(pTextureId);
        }
        if (pShaderTexture >= 0 && pShaderTexture < shaderTextures.length) {
            TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
            AbstractTexture abstracttexture = texturemanager.getTexture(pTextureId);
            RenderSystem.shaderTextures[pShaderTexture] = abstracttexture.getId();
        }
    }

    public static void setShaderTexture(int pShaderTexture, int pTextureId) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(pShaderTexture, pTextureId));
        } else {
            RenderSystem._setShaderTexture(pShaderTexture, pTextureId);
        }
    }

    public static void _setShaderTexture(int pShaderTexture, int pTextureId) {
        if (pShaderTexture >= 0 && pShaderTexture < shaderTextures.length) {
            RenderSystem.shaderTextures[pShaderTexture] = pTextureId;
        }
    }

    public static int getShaderTexture(int pShaderTexture) {
        RenderSystem.assertOnRenderThread();
        return pShaderTexture >= 0 && pShaderTexture < shaderTextures.length ? shaderTextures[pShaderTexture] : 0;
    }

    public static void setProjectionMatrix(Matrix4f pProjectionMatrix) {
        Matrix4f matrix4f = pProjectionMatrix.copy();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = matrix4f;
            });
        } else {
            projectionMatrix = matrix4f;
        }
    }

    public static void setInverseViewRotationMatrix(Matrix3f p_200919_) {
        Matrix3f matrix3f = p_200919_.copy();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                inverseViewRotationMatrix = matrix3f;
            });
        } else {
            inverseViewRotationMatrix = matrix3f;
        }
    }

    public static void setTextureMatrix(Matrix4f pTextureMatrix) {
        Matrix4f matrix4f = pTextureMatrix.copy();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = matrix4f;
            });
        } else {
            textureMatrix = matrix4f;
        }
    }

    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.setIdentity());
        } else {
            textureMatrix.setIdentity();
        }
    }

    public static void applyModelViewMatrix() {
        Matrix4f matrix4f = modelViewStack.last().pose().copy();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = matrix4f;
            });
        } else {
            modelViewMatrix = matrix4f;
        }
    }

    public static void backupProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._backupProjectionMatrix());
        } else {
            RenderSystem._backupProjectionMatrix();
        }
    }

    private static void _backupProjectionMatrix() {
        savedProjectionMatrix = projectionMatrix;
    }

    public static void restoreProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._restoreProjectionMatrix());
        } else {
            RenderSystem._restoreProjectionMatrix();
        }
    }

    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
    }

    public static Matrix4f getProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrix;
    }

    public static Matrix3f getInverseViewRotationMatrix() {
        RenderSystem.assertOnRenderThread();
        return inverseViewRotationMatrix;
    }

    public static Matrix4f getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewMatrix;
    }

    public static PoseStack getModelViewStack() {
        return modelViewStack;
    }

    public static Matrix4f getTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        return textureMatrix;
    }

    public static AutoStorageIndexBuffer getSequentialBuffer(VertexFormat.Mode pFormatMode, int pNeededIndexCount) {
        AutoStorageIndexBuffer rendersystem$autostorageindexbuffer;
        RenderSystem.assertOnRenderThread();
        if (pFormatMode == VertexFormat.Mode.QUADS) {
            rendersystem$autostorageindexbuffer = sharedSequentialQuad;
            if (Config.isRenderRegions()) {
                rendersystem$autostorageindexbuffer.ensureStorage(65536);
            }
        } else {
            rendersystem$autostorageindexbuffer = pFormatMode == VertexFormat.Mode.LINES ? sharedSequentialLines : sharedSequential;
        }
        rendersystem$autostorageindexbuffer.ensureStorage(pNeededIndexCount);
        return rendersystem$autostorageindexbuffer;
    }

    public static void setShaderGameTime(long pTickTime, float p_157449_) {
        float f = ((float)(pTickTime % 24000L) + p_157449_) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = f;
            });
        } else {
            shaderGameTime = f;
        }
    }

    public static float getShaderGameTime() {
        RenderSystem.assertOnRenderThread();
        return shaderGameTime;
    }

    public static void setFogAllowed(boolean fogAllowed) {
        RenderSystem.fogAllowed = fogAllowed;
        if (Config.isShaders()) {
            Shaders.setFogAllowed(fogAllowed);
        }
    }

    public static boolean isFogAllowed() {
        return fogAllowed;
    }

    public static void setColorToAttribute(boolean colorToAttribute) {
        if (Config.isShaders() && RenderSystem.colorToAttribute != colorToAttribute) {
            RenderSystem.colorToAttribute = colorToAttribute;
            if (colorToAttribute) {
                Shaders.setDefaultAttribColor(shaderColor[0], shaderColor[1], shaderColor[2], shaderColor[3]);
            } else {
                Shaders.setDefaultAttribColor();
            }
        }
    }

    public static final class AutoStorageIndexBuffer {
        private final int vertexStride;
        private final int indexStride;
        private final IndexGenerator generator;
        private int name;
        private VertexFormat.IndexType type = VertexFormat.IndexType.BYTE;
        private int indexCount;

        AutoStorageIndexBuffer(int pVertexStride, int pIndexStride, IndexGenerator pGenerator) {
            this.vertexStride = pVertexStride;
            this.indexStride = pIndexStride;
            this.generator = pGenerator;
        }

        void ensureStorage(int pNeededIndexCount) {
            if (pNeededIndexCount > this.indexCount) {
                pNeededIndexCount = Mth.roundToward(pNeededIndexCount * 2, this.indexStride);
                LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.indexCount, (Object)pNeededIndexCount);
                if (this.name == 0) {
                    this.name = GlStateManager._glGenBuffers();
                }
                VertexFormat.IndexType vertexformat$indextype = VertexFormat.IndexType.least(pNeededIndexCount);
                int i = Mth.roundToward(pNeededIndexCount * vertexformat$indextype.bytes, 4);
                GlStateManager._glBindBuffer(34963, this.name);
                GlStateManager._glBufferData(34963, i, 35048);
                ByteBuffer bytebuffer = GlStateManager._glMapBuffer(34963, 35001);
                if (bytebuffer == null) {
                    throw new RuntimeException("Failed to map GL buffer");
                }
                this.type = vertexformat$indextype;
                IntConsumer intconsumer = this.intConsumer(bytebuffer);
                int j = 0;
                while (j < pNeededIndexCount) {
                    this.generator.accept(intconsumer, j * this.vertexStride / this.indexStride);
                    j += this.indexStride;
                }
                GlStateManager._glUnmapBuffer(34963);
                GlStateManager._glBindBuffer(34963, 0);
                this.indexCount = pNeededIndexCount;
                BufferUploader.invalidateElementArrayBufferBinding();
            }
        }

        private IntConsumer intConsumer(ByteBuffer pBuffer) {
            switch (this.type) {
                case BYTE: {
                    return valueIn -> pBuffer.put((byte)valueIn);
                }
                case SHORT: {
                    return valueIn -> pBuffer.putShort((short)valueIn);
                }
            }
            return pBuffer::putInt;
        }

        public int name() {
            return this.name;
        }

        public VertexFormat.IndexType type() {
            return this.type;
        }

        static interface IndexGenerator {
            public void accept(IntConsumer var1, int var2);
        }
    }
}

