/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.util.Mth;

public interface BufferVertexConsumer
extends VertexConsumer {
    public VertexFormatElement currentElement();

    public void nextElement();

    public void putByte(int var1, byte var2);

    public void putShort(int var1, short var2);

    public void putFloat(int var1, float var2);

    @Override
    default public VertexConsumer vertex(double pX, double p_85772_, double pY) {
        if (this.currentElement().getUsage() != VertexFormatElement.Usage.POSITION) {
            return this;
        }
        if (this.currentElement().getType() == VertexFormatElement.Type.FLOAT && this.currentElement().getCount() == 3) {
            this.putFloat(0, (float)pX);
            this.putFloat(4, (float)p_85772_);
            this.putFloat(8, (float)pY);
            this.nextElement();
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    default public VertexConsumer color(int pRed, int pGreen, int pBlue, int pAlpha) {
        VertexFormatElement vertexformatelement = this.currentElement();
        if (vertexformatelement.getUsage() != VertexFormatElement.Usage.COLOR) {
            return this;
        }
        if (vertexformatelement.getType() == VertexFormatElement.Type.UBYTE && vertexformatelement.getCount() == 4) {
            this.putByte(0, (byte)pRed);
            this.putByte(1, (byte)pGreen);
            this.putByte(2, (byte)pBlue);
            this.putByte(3, (byte)pAlpha);
            this.nextElement();
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    default public VertexConsumer uv(float pU, float pV) {
        VertexFormatElement vertexformatelement = this.currentElement();
        if (vertexformatelement.getUsage() == VertexFormatElement.Usage.UV && vertexformatelement.getIndex() == 0) {
            if (vertexformatelement.getType() == VertexFormatElement.Type.FLOAT && vertexformatelement.getCount() == 2) {
                this.putFloat(0, pU);
                this.putFloat(4, pV);
                this.nextElement();
                return this;
            }
            throw new IllegalStateException();
        }
        return this;
    }

    @Override
    default public VertexConsumer overlayCoords(int pU, int pV) {
        return this.uvShort((short)pU, (short)pV, 1);
    }

    @Override
    default public VertexConsumer uv2(int pU, int pV) {
        return this.uvShort((short)pU, (short)pV, 2);
    }

    default public VertexConsumer uvShort(short pU, short pV, int pIndex) {
        VertexFormatElement vertexformatelement = this.currentElement();
        if (vertexformatelement.getUsage() == VertexFormatElement.Usage.UV && vertexformatelement.getIndex() == pIndex) {
            if (vertexformatelement.getType() == VertexFormatElement.Type.SHORT && vertexformatelement.getCount() == 2) {
                this.putShort(0, pU);
                this.putShort(2, pV);
                this.nextElement();
                return this;
            }
            throw new IllegalStateException();
        }
        return this;
    }

    @Override
    default public VertexConsumer normal(float pX, float pY, float pZ) {
        VertexFormatElement vertexformatelement = this.currentElement();
        if (vertexformatelement.getUsage() != VertexFormatElement.Usage.NORMAL) {
            return this;
        }
        if (vertexformatelement.getType() == VertexFormatElement.Type.BYTE && vertexformatelement.getCount() == 3) {
            this.putByte(0, BufferVertexConsumer.normalIntValue(pX));
            this.putByte(1, BufferVertexConsumer.normalIntValue(pY));
            this.putByte(2, BufferVertexConsumer.normalIntValue(pZ));
            this.nextElement();
            return this;
        }
        throw new IllegalStateException();
    }

    public static byte normalIntValue(float pNum) {
        return (byte)((int)(Mth.clamp(pNum, -1.0f, 1.0f) * 127.0f) & 0xFF);
    }
}

