/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.Queues;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public class PoseStack {
    Deque<Pose> freeEntries = new ArrayDeque<Pose>();
    private final Deque<Pose> poseStack = Util.make(Queues.newArrayDeque(), dequeIn -> {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.setIdentity();
        dequeIn.add(new Pose(matrix4f, matrix3f));
    });

    public void translate(double pX, double p_85839_, double pY) {
        Pose posestack$pose = this.poseStack.getLast();
        posestack$pose.pose.multiplyWithTranslation((float)pX, (float)p_85839_, (float)pY);
    }

    public void scale(float pX, float pY, float pZ) {
        Pose posestack$pose = this.poseStack.getLast();
        posestack$pose.pose.mulScale(pX, pY, pZ);
        if (pX == pY && pY == pZ) {
            if (pX > 0.0f) {
                return;
            }
            posestack$pose.normal.mul(-1.0f);
        }
        float f = 1.0f / pX;
        float f1 = 1.0f / pY;
        float f2 = 1.0f / pZ;
        float f3 = Mth.fastInvCubeRoot(f * f1 * f2);
        posestack$pose.normal.mul(Matrix3f.createScaleMatrix(f3 * f, f3 * f1, f3 * f2));
    }

    public void mulPose(Quaternion pQuaternion) {
        Pose posestack$pose = this.poseStack.getLast();
        posestack$pose.pose.multiply(pQuaternion);
        posestack$pose.normal.mul(pQuaternion);
    }

    public void pushPose() {
        Pose posestack$pose = this.poseStack.getLast();
        Pose posestack$pose1 = this.freeEntries.pollLast();
        if (posestack$pose1 == null) {
            posestack$pose1 = new Pose(posestack$pose.pose.copy(), posestack$pose.normal.copy());
        } else {
            posestack$pose1.pose.set(posestack$pose.pose);
            posestack$pose1.normal.load(posestack$pose.normal);
        }
        this.poseStack.addLast(posestack$pose1);
    }

    public void popPose() {
        Pose posestack$pose = this.poseStack.removeLast();
        if (posestack$pose != null) {
            this.freeEntries.add(posestack$pose);
        }
    }

    public Pose last() {
        return this.poseStack.getLast();
    }

    public boolean clear() {
        return this.poseStack.size() == 1;
    }

    public void rotateDegXp(float angle) {
        this.mulPose(Vector3f.XP.rotationDegrees(angle));
    }

    public void rotateDegXn(float angle) {
        this.mulPose(Vector3f.XN.rotationDegrees(angle));
    }

    public void rotateDegYp(float angle) {
        this.mulPose(Vector3f.YP.rotationDegrees(angle));
    }

    public void rotateDegYn(float angle) {
        this.mulPose(Vector3f.YN.rotationDegrees(angle));
    }

    public void rotateDegZp(float angle) {
        this.mulPose(Vector3f.ZP.rotationDegrees(angle));
    }

    public void rotateDegZn(float angle) {
        this.mulPose(Vector3f.ZN.rotationDegrees(angle));
    }

    public void rotateDeg(float angle, float x, float y, float z) {
        Vector3f vector3f = new Vector3f(x, y, z);
        Quaternion quaternion = vector3f.rotationDegrees(angle);
        this.mulPose(quaternion);
    }

    public String toString() {
        return String.valueOf(this.last().toString()) + "Depth: " + this.poseStack.size();
    }

    public void setIdentity() {
        Pose posestack$pose = this.poseStack.getLast();
        posestack$pose.pose.setIdentity();
        posestack$pose.normal.setIdentity();
    }

    public void mulPoseMatrix(Matrix4f pMatrix) {
        this.poseStack.getLast().pose.multiply(pMatrix);
    }

    public static final class Pose {
        final Matrix4f pose;
        final Matrix3f normal;

        Pose(Matrix4f pPose, Matrix3f pNormal) {
            this.pose = pPose;
            this.normal = pNormal;
        }

        public Matrix4f pose() {
            return this.pose;
        }

        public Matrix3f normal() {
            return this.normal;
        }

        public String toString() {
            return String.valueOf(this.pose.toString()) + this.normal.toString();
        }
    }
}

