/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.IForgeVertexConsumer;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.Shaders;

public interface VertexConsumer
extends IForgeVertexConsumer {
    public static final ThreadLocal<RenderEnv> RENDER_ENV = ThreadLocal.withInitial(() -> new RenderEnv(Blocks.AIR.defaultBlockState(), new BlockPos(0, 0, 0)));
    public static final boolean FORGE = Reflector.ForgeHooksClient.exists();

    default public RenderEnv getRenderEnv(BlockState blockState, BlockPos blockPos) {
        RenderEnv renderenv = RENDER_ENV.get();
        renderenv.reset(blockState, blockPos);
        return renderenv;
    }

    public VertexConsumer vertex(double var1, double var3, double var5);

    public VertexConsumer color(int var1, int var2, int var3, int var4);

    public VertexConsumer uv(float var1, float var2);

    public VertexConsumer overlayCoords(int var1, int var2);

    public VertexConsumer uv2(int var1, int var2);

    public VertexConsumer normal(float var1, float var2, float var3);

    public void endVertex();

    default public void vertex(float pX, float pY, float pZ, float pRed, float pGreen, float pBlue, float pAlpha, float pTexU, float pTexV, int pOverlayUV, int pLightmapUV, float pNormalX, float pNormalY, float pNormalZ) {
        this.vertex(pX, pY, pZ);
        this.color(pRed, pGreen, pBlue, pAlpha);
        this.uv(pTexU, pTexV);
        this.overlayCoords(pOverlayUV);
        this.uv2(pLightmapUV);
        this.normal(pNormalX, pNormalY, pNormalZ);
        this.endVertex();
    }

    public void defaultColor(int var1, int var2, int var3, int var4);

    public void unsetDefaultColor();

    default public VertexConsumer color(float pRed, float pGreen, float pBlue, float pAlpha) {
        return this.color((int)(pRed * 255.0f), (int)(pGreen * 255.0f), (int)(pBlue * 255.0f), (int)(pAlpha * 255.0f));
    }

    default public VertexConsumer color(int p_193480_) {
        return this.color(FastColor.ARGB32.red(p_193480_), FastColor.ARGB32.green(p_193480_), FastColor.ARGB32.blue(p_193480_), FastColor.ARGB32.alpha(p_193480_));
    }

    default public VertexConsumer uv2(int pLightmapUV) {
        return this.uv2(pLightmapUV & 0xFFFF, pLightmapUV >> 16 & 0xFFFF);
    }

    default public VertexConsumer overlayCoords(int pOverlayUV) {
        return this.overlayCoords(pOverlayUV & 0xFFFF, pOverlayUV >> 16 & 0xFFFF);
    }

    default public void putBulkData(PoseStack.Pose pPoseEntry, BakedQuad pQuad, float pRed, float pGreen, float pBlue, int pCombinedLight, int pCombinedOverlay) {
        this.a(pPoseEntry, pQuad, this.getTempFloat4(1.0f, 1.0f, 1.0f, 1.0f), pRed, pGreen, pBlue, this.getTempInt4(pCombinedLight, pCombinedLight, pCombinedLight, pCombinedLight), pCombinedOverlay, false);
    }

    default public void putBulkData(PoseStack.Pose matrixEntry, BakedQuad bakedQuad, float[] baseBrightness, float red, float green, float blue, float alpha, int[] lightmapCoords, int overlayCoords, boolean readExistingColor) {
        this.addQuad(matrixEntry, bakedQuad, baseBrightness, red, green, blue, alpha, lightmapCoords, overlayCoords, readExistingColor);
    }

    default public void a(PoseStack.Pose p_85996_, BakedQuad p_85997_, float[] p_85998_, float p_85999_, float p_86000_, float p_86001_, int[] p_86002_, int p_86003_, boolean p_86004_) {
        this.addQuad(p_85996_, p_85997_, p_85998_, p_85999_, p_86000_, p_86001_, 1.0f, p_86002_, p_86003_, p_86004_);
    }

    default public void addQuad(PoseStack.Pose matrixEntryIn, BakedQuad quadIn, float[] colorMuls, float redIn, float greenIn, float blueIn, float alphaIn, int[] combinedLightsIn, int combinedOverlayIn, boolean mulColor) {
        IRandomEntity irandomentity;
        boolean flag1;
        float[] afloat = colorMuls;
        int[] aint = combinedLightsIn;
        int[] aint1 = this.isMultiTexture() ? quadIn.getVertexDataSingle() : quadIn.getVertices();
        this.putSprite(quadIn.getSprite());
        boolean flag = ModelBlockRenderer.isSeparateAoLightValue();
        Vec3i vec3i = quadIn.getDirection().getNormal();
        float f = vec3i.getX();
        float f1 = vec3i.getY();
        float f2 = vec3i.getZ();
        Matrix4f matrix4f = matrixEntryIn.pose();
        Matrix3f matrix3f = matrixEntryIn.normal();
        float f3 = matrix3f.getTransformX(f, f1, f2);
        float f4 = matrix3f.getTransformY(f, f1, f2);
        float f5 = matrix3f.getTransformZ(f, f1, f2);
        int i = 8;
        int j = DefaultVertexFormat.BLOCK.getIntegerSize();
        int k = aint1.length / j;
        boolean bl = flag1 = Config.isShaders() && Shaders.useVelocityAttrib && Config.isMinecraftThread();
        if (flag1 && (irandomentity = RandomEntities.getRandomEntityRendered()) != null) {
            VertexPosition[] avertexposition = quadIn.getVertexPositions(irandomentity.getId());
            this.setQuadVertexPositions(avertexposition);
        }
        int i1 = 0;
        while (i1 < k) {
            Vector3f vector3f;
            float f11;
            float f10;
            float f9;
            float f13;
            int j1 = i1 * j;
            float f6 = Float.intBitsToFloat(aint1[j1 + 0]);
            float f7 = Float.intBitsToFloat(aint1[j1 + 1]);
            float f8 = Float.intBitsToFloat(aint1[j1 + 2]);
            float f12 = 1.0f;
            float f14 = f13 = flag ? 1.0f : afloat[i1];
            if (mulColor) {
                int l = aint1[j1 + 3];
                float f142 = (float)(l & 0xFF) / 255.0f;
                float f15 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f16 = (float)(l >> 16 & 0xFF) / 255.0f;
                f9 = f142 * f13 * redIn;
                f10 = f15 * f13 * greenIn;
                f11 = f16 * f13 * blueIn;
                if (FORGE) {
                    float f17 = (float)(l >> 24 & 0xFF) / 255.0f;
                    f12 = f17 * alphaIn;
                }
            } else {
                f9 = f13 * redIn;
                f10 = f13 * greenIn;
                f11 = f13 * blueIn;
                if (FORGE) {
                    f12 = alphaIn;
                }
            }
            int k1 = aint[i1];
            if (FORGE) {
                k1 = this.applyBakedLighting(aint[i1], aint1, j1);
            }
            float f19 = Float.intBitsToFloat(aint1[j1 + 4]);
            float f20 = Float.intBitsToFloat(aint1[j1 + 5]);
            float f21 = matrix4f.getTransformX(f6, f7, f8, 1.0f);
            float f22 = matrix4f.getTransformY(f6, f7, f8, 1.0f);
            float f18 = matrix4f.getTransformZ(f6, f7, f8, 1.0f);
            if (FORGE && (vector3f = this.applyBakedNormals(aint1, j1, matrixEntryIn.normal())) != null) {
                f3 = vector3f.x();
                f4 = vector3f.y();
                f5 = vector3f.z();
            }
            if (flag) {
                f12 = afloat[i1];
            }
            this.vertex(f21, f22, f18, f9, f10, f11, f12, f19, f20, combinedOverlayIn, k1, f3, f4, f5);
            ++i1;
        }
    }

    default public VertexConsumer vertex(Matrix4f pMatrix, float pX, float pY, float pZ) {
        float f = pMatrix.getTransformX(pX, pY, pZ, 1.0f);
        float f1 = pMatrix.getTransformY(pX, pY, pZ, 1.0f);
        float f2 = pMatrix.getTransformZ(pX, pY, pZ, 1.0f);
        return this.vertex(f, f1, f2);
    }

    default public VertexConsumer normal(Matrix3f pMatrix, float pX, float pY, float pZ) {
        float f = pMatrix.getTransformX(pX, pY, pZ);
        float f1 = pMatrix.getTransformY(pX, pY, pZ);
        float f2 = pMatrix.getTransformZ(pX, pY, pZ);
        return this.normal(f, f1, f2);
    }

    default public void putSprite(TextureAtlasSprite sprite) {
    }

    default public void setSprite(TextureAtlasSprite sprite) {
    }

    default public boolean isMultiTexture() {
        return false;
    }

    default public void setRenderType(RenderType layer) {
    }

    default public RenderType getRenderType() {
        return null;
    }

    default public void setRenderBlocks(boolean renderBlocks) {
    }

    default public Vector3f getTempVec3f(Vector3f vec) {
        return vec.copy();
    }

    default public Vector3f getTempVec3f(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    default public float[] getTempFloat4(float f1, float f2, float f3, float f4) {
        return new float[]{f1, f2, f3, f4};
    }

    default public int[] getTempInt4(int i1, int i2, int i3, int i4) {
        return new int[]{i1, i2, i3, i4};
    }

    default public MultiBufferSource.BufferSource getRenderTypeBuffer() {
        return null;
    }

    default public void setQuadVertexPositions(VertexPosition[] vps) {
    }

    default public void setMidBlock(float mbx, float mby, float mbz) {
    }

    default public VertexConsumer getSecondaryBuilder() {
        return null;
    }

    default public int applyBakedLighting(int lightmapCoord, int[] data, int pos) {
        int i = VertexConsumer.getLightOffset(0);
        int j = LightTexture.block(data[pos + i]);
        int k = LightTexture.sky(data[pos + i]);
        if (j == 0 && k == 0) {
            return lightmapCoord;
        }
        int l = LightTexture.block(lightmapCoord);
        int i1 = LightTexture.sky(lightmapCoord);
        l = Math.max(l, j);
        i1 = Math.max(i1, k);
        return LightTexture.pack(l, i1);
    }

    public static int getLightOffset(int v) {
        return v * 8 + 6;
    }

    default public Vector3f applyBakedNormals(int[] data, int pos, Matrix3f normalTransform) {
        int i = 7;
        int j = data[pos + i];
        byte b0 = (byte)(j >> 0 & 0xFF);
        byte b1 = (byte)(j >> 8 & 0xFF);
        byte b2 = (byte)(j >> 16 & 0xFF);
        if (b0 == 0 && b1 == 0 && b2 == 0) {
            return null;
        }
        Vector3f vector3f = this.getTempVec3f((float)b0 / 127.0f, (float)b1 / 127.0f, (float)b2 / 127.0f);
        vector3f.transform(normalTransform);
        return vector3f;
    }
}

