/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Triple;

public final class Matrix3f {
    private static final int ORDER = 3;
    private static final float G = 3.0f + 2.0f * (float)Math.sqrt(2.0);
    private static final float CS = (float)Math.cos(0.39269908169872414);
    private static final float SS = (float)Math.sin(0.39269908169872414);
    private static final float SQ2 = 1.0f / (float)Math.sqrt(2.0);
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m20;
    protected float m21;
    protected float m22;

    public Matrix3f() {
    }

    public Matrix3f(Quaternion pOther) {
        float f = pOther.i();
        float f1 = pOther.j();
        float f2 = pOther.k();
        float f3 = pOther.r();
        float f4 = 2.0f * f * f;
        float f5 = 2.0f * f1 * f1;
        float f6 = 2.0f * f2 * f2;
        this.m00 = 1.0f - f5 - f6;
        this.m11 = 1.0f - f6 - f4;
        this.m22 = 1.0f - f4 - f5;
        float f7 = f * f1;
        float f8 = f1 * f2;
        float f9 = f2 * f;
        float f10 = f * f3;
        float f11 = f1 * f3;
        float f12 = f2 * f3;
        this.m10 = 2.0f * (f7 + f12);
        this.m01 = 2.0f * (f7 - f12);
        this.m20 = 2.0f * (f9 - f11);
        this.m02 = 2.0f * (f9 + f11);
        this.m21 = 2.0f * (f8 + f10);
        this.m12 = 2.0f * (f8 - f10);
    }

    public static Matrix3f createScaleMatrix(float pM00, float pM11, float pM22) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.m00 = pM00;
        matrix3f.m11 = pM11;
        matrix3f.m22 = pM22;
        return matrix3f;
    }

    public Matrix3f(Matrix4f pOther) {
        this.m00 = pOther.m00;
        this.m01 = pOther.m01;
        this.m02 = pOther.m02;
        this.m10 = pOther.m10;
        this.m11 = pOther.m11;
        this.m12 = pOther.m12;
        this.m20 = pOther.m20;
        this.m21 = pOther.m21;
        this.m22 = pOther.m22;
    }

    public Matrix3f(Matrix3f pOther) {
        this.m00 = pOther.m00;
        this.m01 = pOther.m01;
        this.m02 = pOther.m02;
        this.m10 = pOther.m10;
        this.m11 = pOther.m11;
        this.m12 = pOther.m12;
        this.m20 = pOther.m20;
        this.m21 = pOther.m21;
        this.m22 = pOther.m22;
    }

    private static Pair<Float, Float> approxGivensQuat(float p_8162_, float p_8163_, float p_8164_) {
        float f = 2.0f * (p_8162_ - p_8164_);
        if (G * p_8163_ * p_8163_ < f * f) {
            float f1 = Mth.fastInvSqrt(p_8163_ * p_8163_ + f * f);
            return Pair.of((Object)Float.valueOf(f1 * p_8163_), (Object)Float.valueOf(f1 * f));
        }
        return Pair.of((Object)Float.valueOf(SS), (Object)Float.valueOf(CS));
    }

    private static Pair<Float, Float> qrGivensQuat(float p_8159_, float p_8160_) {
        float f = (float)Math.hypot(p_8159_, p_8160_);
        float f1 = f > 1.0E-6f ? p_8160_ : 0.0f;
        float f2 = Math.abs(p_8159_) + Math.max(f, 1.0E-6f);
        if (p_8159_ < 0.0f) {
            float f3 = f1;
            f1 = f2;
            f2 = f3;
        }
        float f4 = Mth.fastInvSqrt(f2 * f2 + f1 * f1);
        return Pair.of((Object)Float.valueOf(f1 *= f4), (Object)Float.valueOf(f2 *= f4));
    }

    private static Quaternion stepJacobi(Matrix3f pMatrix) {
        Matrix3f matrix3f = new Matrix3f();
        Quaternion quaternion = Quaternion.ONE.copy();
        if (pMatrix.m01 * pMatrix.m01 + pMatrix.m10 * pMatrix.m10 > 1.0E-6f) {
            Pair<Float, Float> pair = Matrix3f.approxGivensQuat(pMatrix.m00, 0.5f * (pMatrix.m01 + pMatrix.m10), pMatrix.m11);
            Float f = (Float)pair.getFirst();
            Float f1 = (Float)pair.getSecond();
            Quaternion quaternion1 = new Quaternion(0.0f, 0.0f, f.floatValue(), f1.floatValue());
            float f2 = f1.floatValue() * f1.floatValue() - f.floatValue() * f.floatValue();
            float f3 = -2.0f * f.floatValue() * f1.floatValue();
            float f4 = f1.floatValue() * f1.floatValue() + f.floatValue() * f.floatValue();
            quaternion.mul(quaternion1);
            matrix3f.setIdentity();
            matrix3f.m00 = f2;
            matrix3f.m11 = f2;
            matrix3f.m10 = -f3;
            matrix3f.m01 = f3;
            matrix3f.m22 = f4;
            pMatrix.mul(matrix3f);
            matrix3f.transpose();
            matrix3f.mul(pMatrix);
            pMatrix.load(matrix3f);
        }
        if (pMatrix.m02 * pMatrix.m02 + pMatrix.m20 * pMatrix.m20 > 1.0E-6f) {
            Pair<Float, Float> pair1 = Matrix3f.approxGivensQuat(pMatrix.m00, 0.5f * (pMatrix.m02 + pMatrix.m20), pMatrix.m22);
            float f5 = -((Float)pair1.getFirst()).floatValue();
            Float f7 = (Float)pair1.getSecond();
            Quaternion quaternion2 = new Quaternion(0.0f, f5, 0.0f, f7.floatValue());
            float f9 = f7.floatValue() * f7.floatValue() - f5 * f5;
            float f11 = -2.0f * f5 * f7.floatValue();
            float f13 = f7.floatValue() * f7.floatValue() + f5 * f5;
            quaternion.mul(quaternion2);
            matrix3f.setIdentity();
            matrix3f.m00 = f9;
            matrix3f.m22 = f9;
            matrix3f.m20 = f11;
            matrix3f.m02 = -f11;
            matrix3f.m11 = f13;
            pMatrix.mul(matrix3f);
            matrix3f.transpose();
            matrix3f.mul(pMatrix);
            pMatrix.load(matrix3f);
        }
        if (pMatrix.m12 * pMatrix.m12 + pMatrix.m21 * pMatrix.m21 > 1.0E-6f) {
            Pair<Float, Float> pair2 = Matrix3f.approxGivensQuat(pMatrix.m11, 0.5f * (pMatrix.m12 + pMatrix.m21), pMatrix.m22);
            Float f6 = (Float)pair2.getFirst();
            Float f8 = (Float)pair2.getSecond();
            Quaternion quaternion3 = new Quaternion(f6.floatValue(), 0.0f, 0.0f, f8.floatValue());
            float f10 = f8.floatValue() * f8.floatValue() - f6.floatValue() * f6.floatValue();
            float f12 = -2.0f * f6.floatValue() * f8.floatValue();
            float f14 = f8.floatValue() * f8.floatValue() + f6.floatValue() * f6.floatValue();
            quaternion.mul(quaternion3);
            matrix3f.setIdentity();
            matrix3f.m11 = f10;
            matrix3f.m22 = f10;
            matrix3f.m21 = -f12;
            matrix3f.m12 = f12;
            matrix3f.m00 = f14;
            pMatrix.mul(matrix3f);
            matrix3f.transpose();
            matrix3f.mul(pMatrix);
            pMatrix.load(matrix3f);
        }
        return quaternion;
    }

    private static void sortSingularValues(Matrix3f pMatrix, Quaternion pQuaternion) {
        float f = pMatrix.m00 * pMatrix.m00 + pMatrix.m10 * pMatrix.m10 + pMatrix.m20 * pMatrix.m20;
        float f1 = pMatrix.m01 * pMatrix.m01 + pMatrix.m11 * pMatrix.m11 + pMatrix.m21 * pMatrix.m21;
        float f2 = pMatrix.m02 * pMatrix.m02 + pMatrix.m12 * pMatrix.m12 + pMatrix.m22 * pMatrix.m22;
        if (f < f1) {
            float f3 = pMatrix.m10;
            pMatrix.m10 = -pMatrix.m00;
            pMatrix.m00 = f3;
            f3 = pMatrix.m11;
            pMatrix.m11 = -pMatrix.m01;
            pMatrix.m01 = f3;
            f3 = pMatrix.m12;
            pMatrix.m12 = -pMatrix.m02;
            pMatrix.m02 = f3;
            Quaternion quaternion = new Quaternion(0.0f, 0.0f, SQ2, SQ2);
            pQuaternion.mul(quaternion);
            f3 = f;
            f = f1;
            f1 = f3;
        }
        if (f < f2) {
            float f4 = pMatrix.m20;
            pMatrix.m20 = -pMatrix.m00;
            pMatrix.m00 = f4;
            f4 = pMatrix.m21;
            pMatrix.m21 = -pMatrix.m01;
            pMatrix.m01 = f4;
            f4 = pMatrix.m22;
            pMatrix.m22 = -pMatrix.m02;
            pMatrix.m02 = f4;
            Quaternion quaternion1 = new Quaternion(0.0f, SQ2, 0.0f, SQ2);
            pQuaternion.mul(quaternion1);
            f2 = f;
        }
        if (f1 < f2) {
            float f5 = pMatrix.m20;
            pMatrix.m20 = -pMatrix.m10;
            pMatrix.m10 = f5;
            f5 = pMatrix.m21;
            pMatrix.m21 = -pMatrix.m11;
            pMatrix.m11 = f5;
            f5 = pMatrix.m22;
            pMatrix.m22 = -pMatrix.m12;
            pMatrix.m12 = f5;
            Quaternion quaternion2 = new Quaternion(SQ2, 0.0f, 0.0f, SQ2);
            pQuaternion.mul(quaternion2);
        }
    }

    public void transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
    }

    public Triple<Quaternion, Vector3f, Quaternion> svdDecompose() {
        Quaternion quaternion = Quaternion.ONE.copy();
        Quaternion quaternion1 = Quaternion.ONE.copy();
        Matrix3f matrix3f = this.copy();
        matrix3f.transpose();
        matrix3f.mul(this);
        int i = 0;
        while (i < 5) {
            quaternion1.mul(Matrix3f.stepJacobi(matrix3f));
            ++i;
        }
        quaternion1.normalize();
        Matrix3f matrix3f4 = new Matrix3f(this);
        matrix3f4.mul(new Matrix3f(quaternion1));
        float f = 1.0f;
        Pair<Float, Float> pair = Matrix3f.qrGivensQuat(matrix3f4.m00, matrix3f4.m10);
        Float f1 = (Float)pair.getFirst();
        Float f2 = (Float)pair.getSecond();
        float f3 = f2.floatValue() * f2.floatValue() - f1.floatValue() * f1.floatValue();
        float f4 = -2.0f * f1.floatValue() * f2.floatValue();
        float f5 = f2.floatValue() * f2.floatValue() + f1.floatValue() * f1.floatValue();
        Quaternion quaternion2 = new Quaternion(0.0f, 0.0f, f1.floatValue(), f2.floatValue());
        quaternion.mul(quaternion2);
        Matrix3f matrix3f1 = new Matrix3f();
        matrix3f1.setIdentity();
        matrix3f1.m00 = f3;
        matrix3f1.m11 = f3;
        matrix3f1.m10 = f4;
        matrix3f1.m01 = -f4;
        matrix3f1.m22 = f5;
        f *= f5;
        matrix3f1.mul(matrix3f4);
        pair = Matrix3f.qrGivensQuat(matrix3f1.m00, matrix3f1.m20);
        float f6 = -((Float)pair.getFirst()).floatValue();
        Float f7 = (Float)pair.getSecond();
        float f8 = f7.floatValue() * f7.floatValue() - f6 * f6;
        float f9 = -2.0f * f6 * f7.floatValue();
        float f10 = f7.floatValue() * f7.floatValue() + f6 * f6;
        Quaternion quaternion3 = new Quaternion(0.0f, f6, 0.0f, f7.floatValue());
        quaternion.mul(quaternion3);
        Matrix3f matrix3f2 = new Matrix3f();
        matrix3f2.setIdentity();
        matrix3f2.m00 = f8;
        matrix3f2.m22 = f8;
        matrix3f2.m20 = -f9;
        matrix3f2.m02 = f9;
        matrix3f2.m11 = f10;
        f *= f10;
        matrix3f2.mul(matrix3f1);
        pair = Matrix3f.qrGivensQuat(matrix3f2.m11, matrix3f2.m21);
        Float f11 = (Float)pair.getFirst();
        Float f12 = (Float)pair.getSecond();
        float f13 = f12.floatValue() * f12.floatValue() - f11.floatValue() * f11.floatValue();
        float f14 = -2.0f * f11.floatValue() * f12.floatValue();
        float f15 = f12.floatValue() * f12.floatValue() + f11.floatValue() * f11.floatValue();
        Quaternion quaternion4 = new Quaternion(f11.floatValue(), 0.0f, 0.0f, f12.floatValue());
        quaternion.mul(quaternion4);
        Matrix3f matrix3f3 = new Matrix3f();
        matrix3f3.setIdentity();
        matrix3f3.m11 = f13;
        matrix3f3.m22 = f13;
        matrix3f3.m21 = f14;
        matrix3f3.m12 = -f14;
        matrix3f3.m00 = f15;
        f *= f15;
        matrix3f3.mul(matrix3f2);
        f = 1.0f / f;
        quaternion.mul((float)Math.sqrt(f));
        Vector3f vector3f = new Vector3f(matrix3f3.m00 * f, matrix3f3.m11 * f, matrix3f3.m22 * f);
        return Triple.of((Object)quaternion, (Object)vector3f, (Object)quaternion1);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther != null && this.getClass() == pOther.getClass()) {
            Matrix3f matrix3f = (Matrix3f)pOther;
            return Float.compare(matrix3f.m00, this.m00) == 0 && Float.compare(matrix3f.m01, this.m01) == 0 && Float.compare(matrix3f.m02, this.m02) == 0 && Float.compare(matrix3f.m10, this.m10) == 0 && Float.compare(matrix3f.m11, this.m11) == 0 && Float.compare(matrix3f.m12, this.m12) == 0 && Float.compare(matrix3f.m20, this.m20) == 0 && Float.compare(matrix3f.m21, this.m21) == 0 && Float.compare(matrix3f.m22, this.m22) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        i = 31 * i + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        i = 31 * i + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        i = 31 * i + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        i = 31 * i + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        i = 31 * i + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        i = 31 * i + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        i = 31 * i + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        return 31 * i + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
    }

    private static int bufferIndex(int pX, int pY) {
        return pY * 3 + pX;
    }

    public void load(FloatBuffer pOther) {
        this.m00 = pOther.get(Matrix3f.bufferIndex(0, 0));
        this.m01 = pOther.get(Matrix3f.bufferIndex(0, 1));
        this.m02 = pOther.get(Matrix3f.bufferIndex(0, 2));
        this.m10 = pOther.get(Matrix3f.bufferIndex(1, 0));
        this.m11 = pOther.get(Matrix3f.bufferIndex(1, 1));
        this.m12 = pOther.get(Matrix3f.bufferIndex(1, 2));
        this.m20 = pOther.get(Matrix3f.bufferIndex(2, 0));
        this.m21 = pOther.get(Matrix3f.bufferIndex(2, 1));
        this.m22 = pOther.get(Matrix3f.bufferIndex(2, 2));
    }

    public void loadTransposed(FloatBuffer pBuffer) {
        this.m00 = pBuffer.get(Matrix3f.bufferIndex(0, 0));
        this.m01 = pBuffer.get(Matrix3f.bufferIndex(1, 0));
        this.m02 = pBuffer.get(Matrix3f.bufferIndex(2, 0));
        this.m10 = pBuffer.get(Matrix3f.bufferIndex(0, 1));
        this.m11 = pBuffer.get(Matrix3f.bufferIndex(1, 1));
        this.m12 = pBuffer.get(Matrix3f.bufferIndex(2, 1));
        this.m20 = pBuffer.get(Matrix3f.bufferIndex(0, 2));
        this.m21 = pBuffer.get(Matrix3f.bufferIndex(1, 2));
        this.m22 = pBuffer.get(Matrix3f.bufferIndex(2, 2));
    }

    public void load(FloatBuffer pBuffer, boolean pTranspose) {
        if (pTranspose) {
            this.loadTransposed(pBuffer);
        } else {
            this.load(pBuffer);
        }
    }

    public void load(Matrix3f pOther) {
        this.m00 = pOther.m00;
        this.m01 = pOther.m01;
        this.m02 = pOther.m02;
        this.m10 = pOther.m10;
        this.m11 = pOther.m11;
        this.m12 = pOther.m12;
        this.m20 = pOther.m20;
        this.m21 = pOther.m21;
        this.m22 = pOther.m22;
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("Matrix3f:\n");
        stringbuilder.append(this.m00);
        stringbuilder.append(" ");
        stringbuilder.append(this.m01);
        stringbuilder.append(" ");
        stringbuilder.append(this.m02);
        stringbuilder.append("\n");
        stringbuilder.append(this.m10);
        stringbuilder.append(" ");
        stringbuilder.append(this.m11);
        stringbuilder.append(" ");
        stringbuilder.append(this.m12);
        stringbuilder.append("\n");
        stringbuilder.append(this.m20);
        stringbuilder.append(" ");
        stringbuilder.append(this.m21);
        stringbuilder.append(" ");
        stringbuilder.append(this.m22);
        stringbuilder.append("\n");
        return stringbuilder.toString();
    }

    public void store(FloatBuffer pBuffer) {
        pBuffer.put(Matrix3f.bufferIndex(0, 0), this.m00);
        pBuffer.put(Matrix3f.bufferIndex(0, 1), this.m01);
        pBuffer.put(Matrix3f.bufferIndex(0, 2), this.m02);
        pBuffer.put(Matrix3f.bufferIndex(1, 0), this.m10);
        pBuffer.put(Matrix3f.bufferIndex(1, 1), this.m11);
        pBuffer.put(Matrix3f.bufferIndex(1, 2), this.m12);
        pBuffer.put(Matrix3f.bufferIndex(2, 0), this.m20);
        pBuffer.put(Matrix3f.bufferIndex(2, 1), this.m21);
        pBuffer.put(Matrix3f.bufferIndex(2, 2), this.m22);
    }

    public void storeTransposed(FloatBuffer pBuffer) {
        pBuffer.put(Matrix3f.bufferIndex(0, 0), this.m00);
        pBuffer.put(Matrix3f.bufferIndex(1, 0), this.m01);
        pBuffer.put(Matrix3f.bufferIndex(2, 0), this.m02);
        pBuffer.put(Matrix3f.bufferIndex(0, 1), this.m10);
        pBuffer.put(Matrix3f.bufferIndex(1, 1), this.m11);
        pBuffer.put(Matrix3f.bufferIndex(2, 1), this.m12);
        pBuffer.put(Matrix3f.bufferIndex(0, 2), this.m20);
        pBuffer.put(Matrix3f.bufferIndex(1, 2), this.m21);
        pBuffer.put(Matrix3f.bufferIndex(2, 2), this.m22);
    }

    public void store(FloatBuffer pBuffer, boolean pTranspose) {
        if (pTranspose) {
            this.storeTransposed(pBuffer);
        } else {
            this.store(pBuffer);
        }
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    public float adjugateAndDet() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float f1 = -(this.m10 * this.m22 - this.m12 * this.m20);
        float f2 = this.m10 * this.m21 - this.m11 * this.m20;
        float f3 = -(this.m01 * this.m22 - this.m02 * this.m21);
        float f4 = this.m00 * this.m22 - this.m02 * this.m20;
        float f5 = -(this.m00 * this.m21 - this.m01 * this.m20);
        float f6 = this.m01 * this.m12 - this.m02 * this.m11;
        float f7 = -(this.m00 * this.m12 - this.m02 * this.m10);
        float f8 = this.m00 * this.m11 - this.m01 * this.m10;
        float f9 = this.m00 * f + this.m01 * f1 + this.m02 * f2;
        this.m00 = f;
        this.m10 = f1;
        this.m20 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m21 = f5;
        this.m02 = f6;
        this.m12 = f7;
        this.m22 = f8;
        return f9;
    }

    public float determinant() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float f1 = -(this.m10 * this.m22 - this.m12 * this.m20);
        float f2 = this.m10 * this.m21 - this.m11 * this.m20;
        return this.m00 * f + this.m01 * f1 + this.m02 * f2;
    }

    public boolean invert() {
        float f = this.adjugateAndDet();
        if ((double)f != 0.0) {
            this.mul(1.0f / f);
            return true;
        }
        return false;
    }

    public void set(int pX, int pY, float pValue) {
        if (pX == 0) {
            if (pY == 0) {
                this.m00 = pValue;
            } else if (pY == 1) {
                this.m01 = pValue;
            } else {
                this.m02 = pValue;
            }
        } else if (pX == 1) {
            if (pY == 0) {
                this.m10 = pValue;
            } else if (pY == 1) {
                this.m11 = pValue;
            } else {
                this.m12 = pValue;
            }
        } else if (pY == 0) {
            this.m20 = pValue;
        } else if (pY == 1) {
            this.m21 = pValue;
        } else {
            this.m22 = pValue;
        }
    }

    public void mul(Matrix3f pMultiplier) {
        float f = this.m00 * pMultiplier.m00 + this.m01 * pMultiplier.m10 + this.m02 * pMultiplier.m20;
        float f1 = this.m00 * pMultiplier.m01 + this.m01 * pMultiplier.m11 + this.m02 * pMultiplier.m21;
        float f2 = this.m00 * pMultiplier.m02 + this.m01 * pMultiplier.m12 + this.m02 * pMultiplier.m22;
        float f3 = this.m10 * pMultiplier.m00 + this.m11 * pMultiplier.m10 + this.m12 * pMultiplier.m20;
        float f4 = this.m10 * pMultiplier.m01 + this.m11 * pMultiplier.m11 + this.m12 * pMultiplier.m21;
        float f5 = this.m10 * pMultiplier.m02 + this.m11 * pMultiplier.m12 + this.m12 * pMultiplier.m22;
        float f6 = this.m20 * pMultiplier.m00 + this.m21 * pMultiplier.m10 + this.m22 * pMultiplier.m20;
        float f7 = this.m20 * pMultiplier.m01 + this.m21 * pMultiplier.m11 + this.m22 * pMultiplier.m21;
        float f8 = this.m20 * pMultiplier.m02 + this.m21 * pMultiplier.m12 + this.m22 * pMultiplier.m22;
        this.m00 = f;
        this.m01 = f1;
        this.m02 = f2;
        this.m10 = f3;
        this.m11 = f4;
        this.m12 = f5;
        this.m20 = f6;
        this.m21 = f7;
        this.m22 = f8;
    }

    public void mul(Quaternion pMultiplier) {
        float f = pMultiplier.i();
        float f1 = pMultiplier.j();
        float f2 = pMultiplier.k();
        float f3 = pMultiplier.r();
        float f4 = 2.0f * f * f;
        float f5 = 2.0f * f1 * f1;
        float f6 = 2.0f * f2 * f2;
        float f7 = f * f1;
        float f8 = f1 * f2;
        float f9 = f2 * f;
        float f10 = f * f3;
        float f11 = f1 * f3;
        float f12 = f2 * f3;
        float f13 = 1.0f - f5 - f6;
        float f14 = 2.0f * (f7 - f12);
        float f15 = 2.0f * (f9 + f11);
        float f16 = 2.0f * (f7 + f12);
        float f17 = 1.0f - f6 - f4;
        float f18 = 2.0f * (f8 - f10);
        float f19 = 2.0f * (f9 - f11);
        float f20 = 2.0f * (f8 + f10);
        float f21 = 1.0f - f4 - f5;
        float f22 = this.m00 * f13 + this.m01 * f16 + this.m02 * f19;
        float f23 = this.m00 * f14 + this.m01 * f17 + this.m02 * f20;
        float f24 = this.m00 * f15 + this.m01 * f18 + this.m02 * f21;
        float f25 = this.m10 * f13 + this.m11 * f16 + this.m12 * f19;
        float f26 = this.m10 * f14 + this.m11 * f17 + this.m12 * f20;
        float f27 = this.m10 * f15 + this.m11 * f18 + this.m12 * f21;
        float f28 = this.m20 * f13 + this.m21 * f16 + this.m22 * f19;
        float f29 = this.m20 * f14 + this.m21 * f17 + this.m22 * f20;
        float f30 = this.m20 * f15 + this.m21 * f18 + this.m22 * f21;
        this.m00 = f22;
        this.m01 = f23;
        this.m02 = f24;
        this.m10 = f25;
        this.m11 = f26;
        this.m12 = f27;
        this.m20 = f28;
        this.m21 = f29;
        this.m22 = f30;
    }

    public void mul(float pMultiplier) {
        this.m00 *= pMultiplier;
        this.m01 *= pMultiplier;
        this.m02 *= pMultiplier;
        this.m10 *= pMultiplier;
        this.m11 *= pMultiplier;
        this.m12 *= pMultiplier;
        this.m20 *= pMultiplier;
        this.m21 *= pMultiplier;
        this.m22 *= pMultiplier;
    }

    public void add(Matrix3f pOther) {
        this.m00 += pOther.m00;
        this.m01 += pOther.m01;
        this.m02 += pOther.m02;
        this.m10 += pOther.m10;
        this.m11 += pOther.m11;
        this.m12 += pOther.m12;
        this.m20 += pOther.m20;
        this.m21 += pOther.m21;
        this.m22 += pOther.m22;
    }

    public void sub(Matrix3f pOther) {
        this.m00 -= pOther.m00;
        this.m01 -= pOther.m01;
        this.m02 -= pOther.m02;
        this.m10 -= pOther.m10;
        this.m11 -= pOther.m11;
        this.m12 -= pOther.m12;
        this.m20 -= pOther.m20;
        this.m21 -= pOther.m21;
        this.m22 -= pOther.m22;
    }

    public float trace() {
        return this.m00 + this.m11 + this.m22;
    }

    public Matrix3f copy() {
        return new Matrix3f(this);
    }

    public float getTransformX(float x, float y, float z) {
        return this.m00 * x + this.m01 * y + this.m02 * z;
    }

    public float getTransformY(float x, float y, float z) {
        return this.m10 * x + this.m11 * y + this.m12 * z;
    }

    public float getTransformZ(float x, float y, float z) {
        return this.m20 * x + this.m21 * y + this.m22 * z;
    }

    public void setRandom(Random r) {
        this.m00 = r.nextFloat();
        this.m01 = r.nextFloat();
        this.m02 = r.nextFloat();
        this.m10 = r.nextFloat();
        this.m11 = r.nextFloat();
        this.m12 = r.nextFloat();
        this.m20 = r.nextFloat();
        this.m21 = r.nextFloat();
        this.m22 = r.nextFloat();
    }

    public void multiplyBackward(Matrix3f other) {
        Matrix3f matrix3f = other.copy();
        matrix3f.mul(this);
        this.load(matrix3f);
    }
}

