/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;

public final class Quaternion {
    public static final Quaternion ONE = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private float i;
    private float j;
    private float k;
    private float r;

    public Quaternion(float pI, float pJ, float pK, float pR) {
        this.i = pI;
        this.j = pJ;
        this.k = pK;
        this.r = pR;
    }

    public Quaternion(Vector3f pRotationAxis, float pRotationAngle, boolean pDegrees) {
        if (pDegrees) {
            pRotationAngle *= (float)Math.PI / 180;
        }
        float f = Quaternion.sin(pRotationAngle / 2.0f);
        this.i = pRotationAxis.x() * f;
        this.j = pRotationAxis.y() * f;
        this.k = pRotationAxis.z() * f;
        this.r = Quaternion.cos(pRotationAngle / 2.0f);
    }

    public Quaternion(float pI, float pJ, float pK, boolean pR) {
        if (pR) {
            pI *= (float)Math.PI / 180;
            pJ *= (float)Math.PI / 180;
            pK *= (float)Math.PI / 180;
        }
        float f = Quaternion.sin(0.5f * pI);
        float f1 = Quaternion.cos(0.5f * pI);
        float f2 = Quaternion.sin(0.5f * pJ);
        float f3 = Quaternion.cos(0.5f * pJ);
        float f4 = Quaternion.sin(0.5f * pK);
        float f5 = Quaternion.cos(0.5f * pK);
        this.i = f * f3 * f5 + f1 * f2 * f4;
        this.j = f1 * f2 * f5 - f * f3 * f4;
        this.k = f * f2 * f5 + f1 * f3 * f4;
        this.r = f1 * f3 * f5 - f * f2 * f4;
    }

    public Quaternion(Quaternion pOther) {
        this.i = pOther.i;
        this.j = pOther.j;
        this.k = pOther.k;
        this.r = pOther.r;
    }

    public static Quaternion fromYXZ(float pY, float pX, float pZ) {
        Quaternion quaternion = ONE.copy();
        quaternion.mul(new Quaternion(0.0f, (float)Math.sin(pY / 2.0f), 0.0f, (float)Math.cos(pY / 2.0f)));
        quaternion.mul(new Quaternion((float)Math.sin(pX / 2.0f), 0.0f, 0.0f, (float)Math.cos(pX / 2.0f)));
        quaternion.mul(new Quaternion(0.0f, 0.0f, (float)Math.sin(pZ / 2.0f), (float)Math.cos(pZ / 2.0f)));
        return quaternion;
    }

    public static Quaternion fromXYZDegrees(Vector3f pDegreesVector) {
        return Quaternion.fromXYZ((float)Math.toRadians(pDegreesVector.x()), (float)Math.toRadians(pDegreesVector.y()), (float)Math.toRadians(pDegreesVector.z()));
    }

    public static Quaternion fromXYZ(Vector3f pRadiansVector) {
        return Quaternion.fromXYZ(pRadiansVector.x(), pRadiansVector.y(), pRadiansVector.z());
    }

    public static Quaternion fromXYZ(float pX, float pY, float pZ) {
        Quaternion quaternion = ONE.copy();
        quaternion.mul(new Quaternion((float)Math.sin(pX / 2.0f), 0.0f, 0.0f, (float)Math.cos(pX / 2.0f)));
        quaternion.mul(new Quaternion(0.0f, (float)Math.sin(pY / 2.0f), 0.0f, (float)Math.cos(pY / 2.0f)));
        quaternion.mul(new Quaternion(0.0f, 0.0f, (float)Math.sin(pZ / 2.0f), (float)Math.cos(pZ / 2.0f)));
        return quaternion;
    }

    public Vector3f toXYZ() {
        float f = this.r() * this.r();
        float f1 = this.i() * this.i();
        float f2 = this.j() * this.j();
        float f3 = this.k() * this.k();
        float f4 = f + f1 + f2 + f3;
        float f5 = 2.0f * this.r() * this.i() - 2.0f * this.j() * this.k();
        float f6 = (float)Math.asin(f5 / f4);
        return Math.abs(f5) > 0.999f * f4 ? new Vector3f(2.0f * (float)Math.atan2(this.i(), this.r()), f6, 0.0f) : new Vector3f((float)Math.atan2(2.0f * this.j() * this.k() + 2.0f * this.i() * this.r(), f - f1 - f2 + f3), f6, (float)Math.atan2(2.0f * this.i() * this.j() + 2.0f * this.r() * this.k(), f + f1 - f2 - f3));
    }

    public Vector3f toXYZDegrees() {
        Vector3f vector3f = this.toXYZ();
        return new Vector3f((float)Math.toDegrees(vector3f.x()), (float)Math.toDegrees(vector3f.y()), (float)Math.toDegrees(vector3f.z()));
    }

    public Vector3f toYXZ() {
        float f = this.r() * this.r();
        float f1 = this.i() * this.i();
        float f2 = this.j() * this.j();
        float f3 = this.k() * this.k();
        float f4 = f + f1 + f2 + f3;
        float f5 = 2.0f * this.r() * this.i() - 2.0f * this.j() * this.k();
        float f6 = (float)Math.asin(f5 / f4);
        return Math.abs(f5) > 0.999f * f4 ? new Vector3f(f6, 2.0f * (float)Math.atan2(this.j(), this.r()), 0.0f) : new Vector3f(f6, (float)Math.atan2(2.0f * this.i() * this.k() + 2.0f * this.j() * this.r(), f - f1 - f2 + f3), (float)Math.atan2(2.0f * this.i() * this.j() + 2.0f * this.r() * this.k(), f - f1 + f2 - f3));
    }

    public Vector3f toYXZDegrees() {
        Vector3f vector3f = this.toYXZ();
        return new Vector3f((float)Math.toDegrees(vector3f.x()), (float)Math.toDegrees(vector3f.y()), (float)Math.toDegrees(vector3f.z()));
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther != null && this.getClass() == pOther.getClass()) {
            Quaternion quaternion = (Quaternion)pOther;
            if (Float.compare(quaternion.i, this.i) != 0) {
                return false;
            }
            if (Float.compare(quaternion.j, this.j) != 0) {
                return false;
            }
            if (Float.compare(quaternion.k, this.k) != 0) {
                return false;
            }
            return Float.compare(quaternion.r, this.r) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.i);
        i = 31 * i + Float.floatToIntBits(this.j);
        i = 31 * i + Float.floatToIntBits(this.k);
        return 31 * i + Float.floatToIntBits(this.r);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("Quaternion[").append(this.r()).append(" + ");
        stringbuilder.append(this.i()).append("i + ");
        stringbuilder.append(this.j()).append("j + ");
        stringbuilder.append(this.k()).append("k]");
        return stringbuilder.toString();
    }

    public float i() {
        return this.i;
    }

    public float j() {
        return this.j;
    }

    public float k() {
        return this.k;
    }

    public float r() {
        return this.r;
    }

    public void mul(Quaternion pMultiplier) {
        float f = this.i();
        float f1 = this.j();
        float f2 = this.k();
        float f3 = this.r();
        float f4 = pMultiplier.i();
        float f5 = pMultiplier.j();
        float f6 = pMultiplier.k();
        float f7 = pMultiplier.r();
        this.i = f3 * f4 + f * f7 + f1 * f6 - f2 * f5;
        this.j = f3 * f5 - f * f6 + f1 * f7 + f2 * f4;
        this.k = f3 * f6 + f * f5 - f1 * f4 + f2 * f7;
        this.r = f3 * f7 - f * f4 - f1 * f5 - f2 * f6;
    }

    public void mul(float pMultiplier) {
        this.i *= pMultiplier;
        this.j *= pMultiplier;
        this.k *= pMultiplier;
        this.r *= pMultiplier;
    }

    public void conj() {
        this.i = -this.i;
        this.j = -this.j;
        this.k = -this.k;
    }

    public void set(float pI, float pJ, float pK, float pR) {
        this.i = pI;
        this.j = pJ;
        this.k = pK;
        this.r = pR;
    }

    private static float cos(float pAngle) {
        return (float)Math.cos(pAngle);
    }

    private static float sin(float pAngle) {
        return (float)Math.sin(pAngle);
    }

    public void normalize() {
        float f = this.i() * this.i() + this.j() * this.j() + this.k() * this.k() + this.r() * this.r();
        if (f > 1.0E-6f) {
            float f1 = Mth.fastInvSqrt(f);
            this.i *= f1;
            this.j *= f1;
            this.k *= f1;
            this.r *= f1;
        } else {
            this.i = 0.0f;
            this.j = 0.0f;
            this.k = 0.0f;
            this.r = 0.0f;
        }
    }

    public void slerp(Quaternion pOther, float pPercentage) {
        throw new UnsupportedOperationException();
    }

    public Quaternion copy() {
        return new Quaternion(this);
    }
}

