/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Matrix3f;
import java.util.Arrays;
import net.minecraft.Util;

public enum SymmetricGroup3 {
    P123(0, 1, 2),
    P213(1, 0, 2),
    P132(0, 2, 1),
    P231(1, 2, 0),
    P312(2, 0, 1),
    P321(2, 1, 0);

    private final int[] permutation;
    private final Matrix3f transformation;
    private static final int ORDER = 3;
    private static final SymmetricGroup3[][] cayleyTable;

    static {
        cayleyTable = Util.make(new SymmetricGroup3[SymmetricGroup3.values().length][SymmetricGroup3.values().length], p_109188_ -> {
            SymmetricGroup3[] symmetricGroup3Array = SymmetricGroup3.values();
            int n = symmetricGroup3Array.length;
            int n2 = 0;
            while (n2 < n) {
                SymmetricGroup3 symmetricgroup3 = symmetricGroup3Array[n2];
                SymmetricGroup3[] symmetricGroup3Array2 = SymmetricGroup3.values();
                int n3 = symmetricGroup3Array2.length;
                int n4 = 0;
                while (n4 < n3) {
                    SymmetricGroup3 symmetricgroup32;
                    SymmetricGroup3 symmetricgroup31 = symmetricGroup3Array2[n4];
                    int[] aint = new int[3];
                    int i = 0;
                    while (i < 3) {
                        aint[i] = symmetricgroup3.permutation[symmetricgroup31.permutation[i]];
                        ++i;
                    }
                    p_109188_[symmetricgroup3.ordinal()][symmetricgroup31.ordinal()] = symmetricgroup32 = Arrays.stream(SymmetricGroup3.values()).filter(p_175577_ -> Arrays.equals(p_175577_.permutation, aint)).findFirst().get();
                    ++n4;
                }
                ++n2;
            }
        });
    }

    private SymmetricGroup3(int p_109176_, int p_109177_, int p_109178_) {
        this.permutation = new int[]{p_109176_, p_109177_, p_109178_};
        this.transformation = new Matrix3f();
        this.transformation.set(0, this.permutation(0), 1.0f);
        this.transformation.set(1, this.permutation(1), 1.0f);
        this.transformation.set(2, this.permutation(2), 1.0f);
    }

    public SymmetricGroup3 compose(SymmetricGroup3 pOther) {
        return cayleyTable[this.ordinal()][pOther.ordinal()];
    }

    public int permutation(int pElement) {
        return this.permutation[pElement];
    }

    public Matrix3f transformation() {
        return this.transformation;
    }
}

