/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Vector3f;
import com.mojang.realmsclient.KeyCombo;
import com.mojang.realmsclient.client.Ping;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerPlayerList;
import com.mojang.realmsclient.dto.RealmsServerPlayerLists;
import com.mojang.realmsclient.dto.RegionPingResult;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsCreateRealmScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsParentalConsentScreen;
import com.mojang.realmsclient.gui.screens.RealmsPendingInvitesScreen;
import com.mojang.realmsclient.util.RealmsPersistence;
import com.mojang.realmsclient.util.RealmsTextureManager;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

public class RealmsMainScreen
extends RealmsScreen {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation ON_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/on_icon.png");
    private static final ResourceLocation OFF_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/off_icon.png");
    private static final ResourceLocation EXPIRED_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/expired_icon.png");
    private static final ResourceLocation EXPIRES_SOON_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/expires_soon_icon.png");
    private static final ResourceLocation LEAVE_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/leave_icon.png");
    private static final ResourceLocation INVITATION_ICONS_LOCATION = new ResourceLocation("realms", "textures/gui/realms/invitation_icons.png");
    private static final ResourceLocation INVITE_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/invite_icon.png");
    static final ResourceLocation WORLDICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/world_icon.png");
    private static final ResourceLocation LOGO_LOCATION = new ResourceLocation("realms", "textures/gui/title/realms.png");
    private static final ResourceLocation CONFIGURE_LOCATION = new ResourceLocation("realms", "textures/gui/realms/configure_icon.png");
    private static final ResourceLocation QUESTIONMARK_LOCATION = new ResourceLocation("realms", "textures/gui/realms/questionmark.png");
    private static final ResourceLocation NEWS_LOCATION = new ResourceLocation("realms", "textures/gui/realms/news_icon.png");
    private static final ResourceLocation POPUP_LOCATION = new ResourceLocation("realms", "textures/gui/realms/popup.png");
    private static final ResourceLocation DARKEN_LOCATION = new ResourceLocation("realms", "textures/gui/realms/darken.png");
    static final ResourceLocation CROSS_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/cross_icon.png");
    private static final ResourceLocation TRIAL_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/trial_icon.png");
    static final ResourceLocation BUTTON_LOCATION = new ResourceLocation("minecraft", "textures/gui/widgets.png");
    static final Component NO_PENDING_INVITES_TEXT = new TranslatableComponent("mco.invites.nopending");
    static final Component PENDING_INVITES_TEXT = new TranslatableComponent("mco.invites.pending");
    static final List<Component> TRIAL_MESSAGE_LINES = ImmutableList.of((Object)new TranslatableComponent("mco.trial.message.line1"), (Object)new TranslatableComponent("mco.trial.message.line2"));
    static final Component SERVER_UNITIALIZED_TEXT = new TranslatableComponent("mco.selectServer.uninitialized");
    static final Component SUBSCRIPTION_EXPIRED_TEXT = new TranslatableComponent("mco.selectServer.expiredList");
    static final Component SUBSCRIPTION_RENEW_TEXT = new TranslatableComponent("mco.selectServer.expiredRenew");
    static final Component TRIAL_EXPIRED_TEXT = new TranslatableComponent("mco.selectServer.expiredTrial");
    static final Component SUBSCRIPTION_CREATE_TEXT = new TranslatableComponent("mco.selectServer.expiredSubscribe");
    static final Component SELECT_MINIGAME_PREFIX = new TranslatableComponent("mco.selectServer.minigame").append(" ");
    private static final Component POPUP_TEXT = new TranslatableComponent("mco.selectServer.popup");
    private static final Component SERVER_EXPIRED_TOOLTIP = new TranslatableComponent("mco.selectServer.expired");
    private static final Component SERVER_EXPIRES_SOON_TOOLTIP = new TranslatableComponent("mco.selectServer.expires.soon");
    private static final Component SERVER_EXPIRES_IN_DAY_TOOLTIP = new TranslatableComponent("mco.selectServer.expires.day");
    private static final Component SERVER_OPEN_TOOLTIP = new TranslatableComponent("mco.selectServer.open");
    private static final Component SERVER_CLOSED_TOOLTIP = new TranslatableComponent("mco.selectServer.closed");
    private static final Component LEAVE_SERVER_TOOLTIP = new TranslatableComponent("mco.selectServer.leave");
    private static final Component CONFIGURE_SERVER_TOOLTIP = new TranslatableComponent("mco.selectServer.configure");
    private static final Component SERVER_INFO_TOOLTIP = new TranslatableComponent("mco.selectServer.info");
    private static final Component NEWS_TOOLTIP = new TranslatableComponent("mco.news");
    static final Component UNITIALIZED_WORLD_NARRATION = new TranslatableComponent("gui.narrate.button", SERVER_UNITIALIZED_TEXT);
    static final Component TRIAL_TEXT = CommonComponents.joinLines(TRIAL_MESSAGE_LINES);
    private static List<ResourceLocation> teaserImages = ImmutableList.of();
    static final RealmsDataFetcher REALMS_DATA_FETCHER = new RealmsDataFetcher(Minecraft.getInstance(), RealmsClient.create());
    static boolean overrideConfigure;
    private static int lastScrollYPosition;
    static volatile boolean hasParentalConsent;
    static volatile boolean checkedParentalConsent;
    static volatile boolean checkedClientCompatability;
    @Nullable
    static Screen realmsGenericErrorScreen;
    private static boolean regionsPinged;
    private final RateLimiter inviteNarrationLimiter;
    private boolean dontSetConnectedToRealms;
    final Screen lastScreen;
    RealmSelectionList realmSelectionList;
    private boolean realmsSelectionListAdded;
    private Button playButton;
    private Button backButton;
    private Button renewButton;
    private Button configureButton;
    private Button leaveButton;
    @Nullable
    private List<Component> toolTip;
    private List<RealmsServer> realmsServers = ImmutableList.of();
    volatile int numberOfPendingInvites;
    int animTick;
    private boolean hasFetchedServers;
    boolean popupOpenedByUser;
    private boolean justClosedPopup;
    private volatile boolean trialsAvailable;
    private volatile boolean createdTrial;
    private volatile boolean showingPopup;
    volatile boolean hasUnreadNews;
    @Nullable
    volatile String newsLink;
    private int carouselIndex;
    private int carouselTick;
    private boolean hasSwitchedCarouselImage;
    private List<KeyCombo> keyCombos;
    long lastClickTime;
    private ReentrantLock connectLock = new ReentrantLock();
    private MultiLineLabel formattedPopup = MultiLineLabel.EMPTY;
    HoveredElement hoveredElement;
    private Button showPopupButton;
    private PendingInvitesButton pendingInvitesButton;
    private Button newsButton;
    private Button createTrialButton;
    private Button buyARealmButton;
    private Button closeButton;

    static {
        lastScrollYPosition = -1;
    }

    public RealmsMainScreen(Screen pLastScreen) {
        super(NarratorChatListener.NO_TITLE);
        this.lastScreen = pLastScreen;
        this.inviteNarrationLimiter = RateLimiter.create((double)0.01666666753590107);
    }

    private boolean shouldShowMessageInList() {
        if (RealmsMainScreen.hasParentalConsent() && this.hasFetchedServers) {
            if (this.trialsAvailable && !this.createdTrial) {
                return true;
            }
            for (RealmsServer realmsserver : this.realmsServers) {
                if (!realmsserver.ownerUUID.equals(this.minecraft.getUser().getUuid())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean shouldShowPopup() {
        if (RealmsMainScreen.hasParentalConsent() && this.hasFetchedServers) {
            return this.popupOpenedByUser ? true : this.realmsServers.isEmpty();
        }
        return false;
    }

    @Override
    public void init() {
        this.keyCombos = Lists.newArrayList((Object[])new KeyCombo[]{new KeyCombo(new char[]{'3', '2', '1', '4', '5', '6'}, () -> {
            overrideConfigure = !overrideConfigure;
        }), new KeyCombo(new char[]{'9', '8', '7', '1', '2', '3'}, () -> {
            if (RealmsClient.currentEnvironment == RealmsClient.Environment.STAGE) {
                this.switchToProd();
            } else {
                this.switchToStage();
            }
        }), new KeyCombo(new char[]{'9', '8', '7', '4', '5', '6'}, () -> {
            if (RealmsClient.currentEnvironment == RealmsClient.Environment.LOCAL) {
                this.switchToProd();
            } else {
                this.switchToLocal();
            }
        })});
        if (realmsGenericErrorScreen != null) {
            this.minecraft.setScreen(realmsGenericErrorScreen);
        } else {
            this.connectLock = new ReentrantLock();
            if (checkedClientCompatability && !RealmsMainScreen.hasParentalConsent()) {
                this.checkParentalConsent();
            }
            this.checkClientCompatability();
            if (!this.dontSetConnectedToRealms) {
                this.minecraft.setConnectedToRealms(false);
            }
            this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
            if (RealmsMainScreen.hasParentalConsent()) {
                REALMS_DATA_FETCHER.forceUpdate();
            }
            this.showingPopup = false;
            this.addButtons();
            this.realmSelectionList = new RealmSelectionList();
            if (lastScrollYPosition != -1) {
                this.realmSelectionList.setScrollAmount(lastScrollYPosition);
            }
            this.addWidget(this.realmSelectionList);
            this.realmsSelectionListAdded = true;
            this.magicalSpecialHackyFocus(this.realmSelectionList);
            this.formattedPopup = MultiLineLabel.create(this.font, POPUP_TEXT, 100);
        }
    }

    private static boolean hasParentalConsent() {
        return checkedParentalConsent && hasParentalConsent;
    }

    public void addButtons() {
        this.leaveButton = this.addRenderableWidget(new Button(this.width / 2 - 202, this.height - 32, 90, 20, new TranslatableComponent("mco.selectServer.leave"), p_86679_ -> this.leaveClicked(this.getSelectedServer())));
        this.configureButton = this.addRenderableWidget(new Button(this.width / 2 - 190, this.height - 32, 90, 20, new TranslatableComponent("mco.selectServer.configure"), p_86672_ -> this.configureClicked(this.getSelectedServer())));
        this.playButton = this.addRenderableWidget(new Button(this.width / 2 - 93, this.height - 32, 90, 20, new TranslatableComponent("mco.selectServer.play"), p_86659_ -> this.play(this.getSelectedServer(), this)));
        this.backButton = this.addRenderableWidget(new Button(this.width / 2 + 4, this.height - 32, 90, 20, CommonComponents.GUI_BACK, p_86647_ -> {
            if (!this.justClosedPopup) {
                this.minecraft.setScreen(this.lastScreen);
            }
        }));
        this.renewButton = this.addRenderableWidget(new Button(this.width / 2 + 100, this.height - 32, 90, 20, new TranslatableComponent("mco.selectServer.expiredRenew"), p_86622_ -> this.onRenew(this.getSelectedServer())));
        this.pendingInvitesButton = this.addRenderableWidget(new PendingInvitesButton());
        this.newsButton = this.addRenderableWidget(new NewsButton());
        this.showPopupButton = this.addRenderableWidget(new ShowPopupButton());
        this.closeButton = this.addRenderableWidget(new CloseButton());
        this.createTrialButton = this.addRenderableWidget(new Button(this.width / 2 + 52, this.popupY0() + 137 - 20, 98, 20, new TranslatableComponent("mco.selectServer.trial"), p_86597_ -> {
            if (this.trialsAvailable && !this.createdTrial) {
                Util.getPlatform().openUri("https://aka.ms/startjavarealmstrial");
                this.minecraft.setScreen(this.lastScreen);
            }
        }));
        this.buyARealmButton = this.addRenderableWidget(new Button(this.width / 2 + 52, this.popupY0() + 160 - 20, 98, 20, new TranslatableComponent("mco.selectServer.buy"), p_86565_ -> Util.getPlatform().openUri("https://aka.ms/BuyJavaRealms")));
        this.updateButtonStates(null);
    }

    void updateButtonStates(@Nullable RealmsServer pRealmsServer) {
        this.backButton.active = true;
        if (RealmsMainScreen.hasParentalConsent() && this.hasFetchedServers) {
            boolean flag;
            this.playButton.visible = true;
            this.playButton.active = this.shouldPlayButtonBeActive(pRealmsServer) && !this.shouldShowPopup();
            this.renewButton.visible = this.shouldRenewButtonBeActive(pRealmsServer);
            this.configureButton.visible = this.shouldConfigureButtonBeVisible(pRealmsServer);
            this.leaveButton.visible = this.shouldLeaveButtonBeVisible(pRealmsServer);
            this.createTrialButton.visible = flag = this.shouldShowPopup() && this.trialsAvailable && !this.createdTrial;
            this.createTrialButton.active = flag;
            this.buyARealmButton.visible = this.shouldShowPopup();
            this.closeButton.visible = this.shouldShowPopup() && this.popupOpenedByUser;
            this.renewButton.active = !this.shouldShowPopup();
            this.configureButton.active = !this.shouldShowPopup();
            this.leaveButton.active = !this.shouldShowPopup();
            this.newsButton.active = true;
            this.pendingInvitesButton.active = true;
            this.showPopupButton.active = !this.shouldShowPopup();
        } else {
            RealmsMainScreen.a(this.playButton, this.renewButton, this.configureButton, this.createTrialButton, this.buyARealmButton, this.closeButton, this.newsButton, this.pendingInvitesButton, this.showPopupButton, this.leaveButton);
        }
    }

    private boolean shouldShowPopupButton() {
        return (!this.shouldShowPopup() || this.popupOpenedByUser) && RealmsMainScreen.hasParentalConsent() && this.hasFetchedServers;
    }

    boolean shouldPlayButtonBeActive(@Nullable RealmsServer pRealmsServer) {
        return pRealmsServer != null && !pRealmsServer.expired && pRealmsServer.state == RealmsServer.State.OPEN;
    }

    private boolean shouldRenewButtonBeActive(@Nullable RealmsServer pRealmsServer) {
        return pRealmsServer != null && pRealmsServer.expired && this.isSelfOwnedServer(pRealmsServer);
    }

    private boolean shouldConfigureButtonBeVisible(@Nullable RealmsServer pRealmsServer) {
        return pRealmsServer != null && this.isSelfOwnedServer(pRealmsServer);
    }

    private boolean shouldLeaveButtonBeVisible(@Nullable RealmsServer pRealmsServer) {
        return pRealmsServer != null && !this.isSelfOwnedServer(pRealmsServer);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.pendingInvitesButton != null) {
            this.pendingInvitesButton.tick();
        }
        this.justClosedPopup = false;
        ++this.animTick;
        if (RealmsMainScreen.hasParentalConsent()) {
            REALMS_DATA_FETCHER.init();
            if (REALMS_DATA_FETCHER.isFetchedSinceLastTry(RealmsDataFetcher.Task.SERVER_LIST)) {
                boolean flag;
                List<RealmsServer> list = REALMS_DATA_FETCHER.getServers();
                RealmsServer realmsserver = this.getSelectedServer();
                ServerEntry realmsmainscreen$entry = null;
                this.realmSelectionList.clear();
                boolean bl = flag = !this.hasFetchedServers;
                if (flag) {
                    this.hasFetchedServers = true;
                }
                if (list != null) {
                    boolean flag1 = false;
                    for (RealmsServer realmsserver1 : list) {
                        if (!this.isSelfOwnedNonExpiredServer(realmsserver1)) continue;
                        flag1 = true;
                    }
                    this.realmsServers = list;
                    if (this.shouldShowMessageInList()) {
                        this.realmSelectionList.addEntry(new TrialEntry());
                    }
                    for (RealmsServer realmsserver3 : this.realmsServers) {
                        ServerEntry realmsmainscreen$serverentry = new ServerEntry(realmsserver3);
                        this.realmSelectionList.addEntry(realmsmainscreen$serverentry);
                        if (realmsserver == null || realmsserver.id != realmsserver3.id) continue;
                        realmsmainscreen$entry = realmsmainscreen$serverentry;
                    }
                    if (!regionsPinged && flag1) {
                        regionsPinged = true;
                        this.pingRegions();
                    }
                }
                if (flag) {
                    this.updateButtonStates(null);
                } else {
                    this.realmSelectionList.setSelected(realmsmainscreen$entry);
                }
            }
            if (REALMS_DATA_FETCHER.isFetchedSinceLastTry(RealmsDataFetcher.Task.PENDING_INVITE)) {
                this.numberOfPendingInvites = REALMS_DATA_FETCHER.getPendingInvitesCount();
                if (this.numberOfPendingInvites > 0 && this.inviteNarrationLimiter.tryAcquire(1)) {
                    NarratorChatListener.INSTANCE.sayNow(new TranslatableComponent("mco.configure.world.invite.narration", this.numberOfPendingInvites));
                }
            }
            if (REALMS_DATA_FETCHER.isFetchedSinceLastTry(RealmsDataFetcher.Task.TRIAL_AVAILABLE) && !this.createdTrial) {
                boolean flag2 = REALMS_DATA_FETCHER.isTrialAvailable();
                if (flag2 != this.trialsAvailable && this.shouldShowPopup()) {
                    this.trialsAvailable = flag2;
                    this.showingPopup = false;
                } else {
                    this.trialsAvailable = flag2;
                }
            }
            if (REALMS_DATA_FETCHER.isFetchedSinceLastTry(RealmsDataFetcher.Task.LIVE_STATS)) {
                RealmsServerPlayerLists realmsserverplayerlists = REALMS_DATA_FETCHER.getLivestats();
                block2: for (RealmsServerPlayerList realmsserverplayerlist : realmsserverplayerlists.servers) {
                    for (RealmsServer realmsserver2 : this.realmsServers) {
                        if (realmsserver2.id != realmsserverplayerlist.serverId) continue;
                        realmsserver2.updateServerPing(realmsserverplayerlist);
                        continue block2;
                    }
                }
            }
            if (REALMS_DATA_FETCHER.isFetchedSinceLastTry(RealmsDataFetcher.Task.UNREAD_NEWS)) {
                this.hasUnreadNews = REALMS_DATA_FETCHER.hasUnreadNews();
                this.newsLink = REALMS_DATA_FETCHER.newsLink();
            }
            REALMS_DATA_FETCHER.markClean();
            if (this.shouldShowPopup()) {
                ++this.carouselTick;
            }
            if (this.showPopupButton != null) {
                this.showPopupButton.active = this.showPopupButton.visible = this.shouldShowPopupButton();
            }
        }
    }

    private void pingRegions() {
        new Thread(() -> {
            List<RegionPingResult> list = Ping.pingAllRegions();
            RealmsClient realmsclient = RealmsClient.create();
            PingResult pingresult = new PingResult();
            pingresult.pingResults = list;
            pingresult.worldIds = this.getOwnedNonExpiredWorldIds();
            try {
                realmsclient.sendPingResults(pingresult);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Could not send ping result to Realms: ", throwable);
            }
        }).start();
    }

    private List<Long> getOwnedNonExpiredWorldIds() {
        ArrayList list = Lists.newArrayList();
        for (RealmsServer realmsserver : this.realmsServers) {
            if (!this.isSelfOwnedNonExpiredServer(realmsserver)) continue;
            list.add(realmsserver.id);
        }
        return list;
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
        this.stopRealmsFetcher();
    }

    public void setCreatedTrial(boolean pCreatedTrial) {
        this.createdTrial = pCreatedTrial;
    }

    void onRenew(@Nullable RealmsServer p_193500_) {
        if (p_193500_ != null) {
            String s = "https://aka.ms/ExtendJavaRealms?subscriptionId=" + p_193500_.remoteSubscriptionId + "&profileId=" + this.minecraft.getUser().getUuid() + "&ref=" + (p_193500_.expiredTrial ? "expiredTrial" : "expiredRealm");
            this.minecraft.keyboardHandler.setClipboard(s);
            Util.getPlatform().openUri(s);
        }
    }

    private void checkClientCompatability() {
        if (!checkedClientCompatability) {
            checkedClientCompatability = true;
            new Thread("MCO Compatability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsclient = RealmsClient.create();
                    try {
                        RealmsClient.CompatibleVersionResponse realmsclient$compatibleversionresponse = realmsclient.clientCompatible();
                        if (realmsclient$compatibleversionresponse == RealmsClient.CompatibleVersionResponse.OUTDATED) {
                            realmsGenericErrorScreen = new RealmsClientOutdatedScreen(RealmsMainScreen.this.lastScreen, true);
                            RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(realmsGenericErrorScreen));
                            return;
                        }
                        if (realmsclient$compatibleversionresponse == RealmsClient.CompatibleVersionResponse.OTHER) {
                            realmsGenericErrorScreen = new RealmsClientOutdatedScreen(RealmsMainScreen.this.lastScreen, false);
                            RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(realmsGenericErrorScreen));
                            return;
                        }
                        RealmsMainScreen.this.checkParentalConsent();
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        checkedClientCompatability = false;
                        LOGGER.error("Couldn't connect to realms", (Throwable)realmsserviceexception);
                        if (realmsserviceexception.httpResultCode == 401) {
                            realmsGenericErrorScreen = new RealmsGenericErrorScreen(new TranslatableComponent("mco.error.invalid.session.title"), new TranslatableComponent("mco.error.invalid.session.message"), RealmsMainScreen.this.lastScreen);
                            RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(realmsGenericErrorScreen));
                        }
                        RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(new RealmsGenericErrorScreen(realmsserviceexception, RealmsMainScreen.this.lastScreen)));
                    }
                }
            }.start();
        }
    }

    void checkParentalConsent() {
        new Thread("MCO Compatability Checker #1"){

            @Override
            public void run() {
                RealmsClient realmsclient = RealmsClient.create();
                try {
                    Boolean obool = realmsclient.mcoEnabled();
                    if (obool.booleanValue()) {
                        LOGGER.info("Realms is available for this user");
                        hasParentalConsent = true;
                    } else {
                        LOGGER.info("Realms is not available for this user");
                        hasParentalConsent = false;
                        RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(new RealmsParentalConsentScreen(RealmsMainScreen.this.lastScreen)));
                    }
                    checkedParentalConsent = true;
                }
                catch (RealmsServiceException realmsserviceexception) {
                    LOGGER.error("Couldn't connect to realms", (Throwable)realmsserviceexception);
                    RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(new RealmsGenericErrorScreen(realmsserviceexception, RealmsMainScreen.this.lastScreen)));
                }
            }
        }.start();
    }

    private void switchToStage() {
        if (RealmsClient.currentEnvironment != RealmsClient.Environment.STAGE) {
            new Thread("MCO Stage Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsclient = RealmsClient.create();
                    try {
                        Boolean obool = realmsclient.stageAvailable();
                        if (obool.booleanValue()) {
                            RealmsClient.switchToStage();
                            LOGGER.info("Switched to stage");
                            REALMS_DATA_FETCHER.forceUpdate();
                        }
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        LOGGER.error("Couldn't connect to Realms: {}", (Object)realmsserviceexception.toString());
                    }
                }
            }.start();
        }
    }

    private void switchToLocal() {
        if (RealmsClient.currentEnvironment != RealmsClient.Environment.LOCAL) {
            new Thread("MCO Local Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsclient = RealmsClient.create();
                    try {
                        Boolean obool = realmsclient.stageAvailable();
                        if (obool.booleanValue()) {
                            RealmsClient.switchToLocal();
                            LOGGER.info("Switched to local");
                            REALMS_DATA_FETCHER.forceUpdate();
                        }
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        LOGGER.error("Couldn't connect to Realms: {}", (Object)realmsserviceexception.toString());
                    }
                }
            }.start();
        }
    }

    private void switchToProd() {
        RealmsClient.switchToProd();
        REALMS_DATA_FETCHER.forceUpdate();
    }

    private void stopRealmsFetcher() {
        REALMS_DATA_FETCHER.stop();
    }

    void configureClicked(@Nullable RealmsServer pRealmsServer) {
        if (pRealmsServer != null && (this.minecraft.getUser().getUuid().equals(pRealmsServer.ownerUUID) || overrideConfigure)) {
            this.saveListScrollPosition();
            this.minecraft.setScreen(new RealmsConfigureWorldScreen(this, pRealmsServer.id));
        }
    }

    void leaveClicked(@Nullable RealmsServer pRealmsServer) {
        if (pRealmsServer != null && !this.minecraft.getUser().getUuid().equals(pRealmsServer.ownerUUID)) {
            this.saveListScrollPosition();
            TranslatableComponent component = new TranslatableComponent("mco.configure.world.leave.question.line1");
            TranslatableComponent component1 = new TranslatableComponent("mco.configure.world.leave.question.line2");
            this.minecraft.setScreen(new RealmsLongConfirmationScreen(p_193490_ -> this.leaveServer(p_193490_, pRealmsServer), RealmsLongConfirmationScreen.Type.Info, component, component1, true));
        }
    }

    private void saveListScrollPosition() {
        lastScrollYPosition = (int)this.realmSelectionList.getScrollAmount();
    }

    @Nullable
    private RealmsServer getSelectedServer() {
        if (this.realmSelectionList == null) {
            return null;
        }
        Entry realmsmainscreen$entry = (Entry)this.realmSelectionList.getSelected();
        return realmsmainscreen$entry != null ? realmsmainscreen$entry.getServer() : null;
    }

    private void leaveServer(boolean p_193494_, RealmsServer p_193495_) {
        if (p_193494_) {
            new Thread("Realms-leave-server"){

                @Override
                public void run() {
                    try {
                        RealmsClient realmsclient = RealmsClient.create();
                        realmsclient.uninviteMyselfFrom(p_193495_.id);
                        RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.removeServer(p_193495_));
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        LOGGER.error("Couldn't configure world");
                        RealmsMainScreen.this.minecraft.execute(() -> RealmsMainScreen.this.minecraft.setScreen(new RealmsGenericErrorScreen(realmsserviceexception, (Screen)RealmsMainScreen.this)));
                    }
                }
            }.start();
        }
        this.minecraft.setScreen(this);
    }

    void removeServer(RealmsServer pRealmsServer) {
        this.realmsServers = REALMS_DATA_FETCHER.removeItem(pRealmsServer);
        this.realmSelectionList.children().removeIf(p_193487_ -> {
            RealmsServer realmsserver = p_193487_.getServer();
            return realmsserver != null && realmsserver.id == realmsServer.id;
        });
        this.realmSelectionList.setSelected((Entry)null);
        this.updateButtonStates(null);
        this.playButton.active = false;
    }

    public void resetScreen() {
        if (this.realmSelectionList != null) {
            this.realmSelectionList.setSelected((Entry)null);
        }
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.keyCombos.forEach(KeyCombo::reset);
            this.onClosePopup();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    void onClosePopup() {
        if (this.shouldShowPopup() && this.popupOpenedByUser) {
            this.popupOpenedByUser = false;
        } else {
            this.minecraft.setScreen(this.lastScreen);
        }
    }

    @Override
    public boolean charTyped(char pCodePoint, int pModifiers) {
        this.keyCombos.forEach(p_193484_ -> p_193484_.keyPressed(pCodePoint));
        return true;
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.hoveredElement = HoveredElement.NONE;
        this.toolTip = null;
        this.renderBackground(pPoseStack);
        this.realmSelectionList.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.drawRealmsLogo(pPoseStack, this.width / 2 - 50, 7);
        if (RealmsClient.currentEnvironment == RealmsClient.Environment.STAGE) {
            this.renderStage(pPoseStack);
        }
        if (RealmsClient.currentEnvironment == RealmsClient.Environment.LOCAL) {
            this.renderLocal(pPoseStack);
        }
        if (this.shouldShowPopup()) {
            this.drawPopup(pPoseStack);
        } else {
            if (this.showingPopup) {
                this.updateButtonStates(null);
                if (!this.realmsSelectionListAdded) {
                    this.addWidget(this.realmSelectionList);
                    this.realmsSelectionListAdded = true;
                }
                this.playButton.active = this.shouldPlayButtonBeActive(this.getSelectedServer());
            }
            this.showingPopup = false;
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(pPoseStack, this.toolTip, pMouseX, pMouseY);
        }
        if (this.trialsAvailable && !this.createdTrial && this.shouldShowPopup()) {
            RenderSystem.setShaderTexture(0, TRIAL_ICON_LOCATION);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            int i = 8;
            int j = 8;
            int k = 0;
            if ((Util.getMillis() / 800L & 1L) == 1L) {
                k = 8;
            }
            GuiComponent.blit(pPoseStack, this.createTrialButton.x + this.createTrialButton.getWidth() - 8 - 4, this.createTrialButton.y + this.createTrialButton.getHeight() / 2 - 4, 0.0f, k, 8, 8, 8, 16);
        }
    }

    private void drawRealmsLogo(PoseStack pPoseStack, int pX, int pY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, LOGO_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        GuiComponent.blit(pPoseStack, pX * 2, pY * 2 - 5, 0.0f, 0.0f, 200, 50, 200, 50);
        pPoseStack.popPose();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_86398_, int pMouseY) {
        if (this.isOutsidePopup(pMouseX, p_86398_) && this.popupOpenedByUser) {
            this.popupOpenedByUser = false;
            this.justClosedPopup = true;
            return true;
        }
        return super.mouseClicked(pMouseX, p_86398_, pMouseY);
    }

    private boolean isOutsidePopup(double p_86394_, double p_86395_) {
        int i = this.popupX0();
        int j = this.popupY0();
        return p_86394_ < (double)(i - 5) || p_86394_ > (double)(i + 315) || p_86395_ < (double)(j - 5) || p_86395_ > (double)(j + 171);
    }

    private void drawPopup(PoseStack p_202330_) {
        int i = this.popupX0();
        int j = this.popupY0();
        if (!this.showingPopup) {
            this.carouselIndex = 0;
            this.carouselTick = 0;
            this.hasSwitchedCarouselImage = true;
            this.updateButtonStates(null);
            if (this.realmsSelectionListAdded) {
                this.removeWidget(this.realmSelectionList);
                this.realmsSelectionListAdded = false;
            }
            NarratorChatListener.INSTANCE.sayNow(POPUP_TEXT);
        }
        if (this.hasFetchedServers) {
            this.showingPopup = true;
        }
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 0.7f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture(0, DARKEN_LOCATION);
        boolean k = false;
        int l = 32;
        GuiComponent.blit(p_202330_, 0, 32, 0.0f, 0.0f, this.width, this.height - 40 - 32, 310, 166);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.setShaderTexture(0, POPUP_LOCATION);
        GuiComponent.blit(p_202330_, i, j, 0.0f, 0.0f, 310, 166, 310, 166);
        if (!teaserImages.isEmpty()) {
            RenderSystem.setShaderTexture(0, teaserImages.get(this.carouselIndex));
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            GuiComponent.blit(p_202330_, i + 7, j + 7, 0.0f, 0.0f, 195, 152, 195, 152);
            if (this.carouselTick % 95 < 5) {
                if (!this.hasSwitchedCarouselImage) {
                    this.carouselIndex = (this.carouselIndex + 1) % teaserImages.size();
                    this.hasSwitchedCarouselImage = true;
                }
            } else {
                this.hasSwitchedCarouselImage = false;
            }
        }
        this.formattedPopup.renderLeftAlignedNoShadow(p_202330_, this.width / 2 + 52, j + 7, 10, 0x4C4C4C);
    }

    int popupX0() {
        return (this.width - 310) / 2;
    }

    int popupY0() {
        return this.height / 2 - 80;
    }

    void drawInvitationPendingIcon(PoseStack p_86425_, int p_86426_, int p_86427_, int p_86428_, int p_86429_, boolean p_86430_, boolean p_86431_) {
        boolean flag4;
        boolean flag2;
        boolean flag1;
        int i = this.numberOfPendingInvites;
        boolean flag = this.inPendingInvitationArea(p_86426_, p_86427_);
        boolean bl = flag1 = p_86431_ && p_86430_;
        if (flag1) {
            float f = 0.25f + (1.0f + Mth.sin((float)this.animTick * 0.5f)) * 0.25f;
            int j = 0xFF000000 | (int)(f * 64.0f) << 16 | (int)(f * 64.0f) << 8 | (int)(f * 64.0f) << 0;
            this.fillGradient(p_86425_, p_86428_ - 2, p_86429_ - 2, p_86428_ + 18, p_86429_ + 18, j, j);
            j = 0xFF000000 | (int)(f * 255.0f) << 16 | (int)(f * 255.0f) << 8 | (int)(f * 255.0f) << 0;
            this.fillGradient(p_86425_, p_86428_ - 2, p_86429_ - 2, p_86428_ + 18, p_86429_ - 1, j, j);
            this.fillGradient(p_86425_, p_86428_ - 2, p_86429_ - 2, p_86428_ - 1, p_86429_ + 18, j, j);
            this.fillGradient(p_86425_, p_86428_ + 17, p_86429_ - 2, p_86428_ + 18, p_86429_ + 18, j, j);
            this.fillGradient(p_86425_, p_86428_ - 2, p_86429_ + 17, p_86428_ + 18, p_86429_ + 18, j, j);
        }
        RenderSystem.setShaderTexture(0, INVITE_ICON_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        boolean flag3 = p_86431_ && p_86430_;
        float f2 = flag3 ? 16.0f : 0.0f;
        GuiComponent.blit(p_86425_, p_86428_, p_86429_ - 6, f2, 0.0f, 15, 25, 31, 25);
        boolean bl2 = flag2 = p_86431_ && i != 0;
        if (flag2) {
            int k = (Math.min(i, 6) - 1) * 8;
            int l = (int)(Math.max(0.0f, Math.max(Mth.sin((float)(10 + this.animTick) * 0.57f), Mth.cos((float)this.animTick * 0.35f))) * -6.0f);
            RenderSystem.setShaderTexture(0, INVITATION_ICONS_LOCATION);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            float f1 = flag ? 8.0f : 0.0f;
            GuiComponent.blit(p_86425_, p_86428_ + 4, p_86429_ + 4 + l, k, f1, 8, 8, 48, 16);
        }
        int j1 = p_86426_ + 12;
        boolean bl3 = flag4 = p_86431_ && flag;
        if (flag4) {
            Component component = i == 0 ? NO_PENDING_INVITES_TEXT : PENDING_INVITES_TEXT;
            int i1 = this.font.width(component);
            this.fillGradient(p_86425_, j1 - 3, p_86427_ - 3, j1 + i1 + 3, p_86427_ + 8 + 3, -1073741824, -1073741824);
            this.font.drawShadow(p_86425_, component, (float)j1, (float)p_86427_, -1);
        }
    }

    private boolean inPendingInvitationArea(double p_86572_, double p_86573_) {
        int i = this.width / 2 + 50;
        int j = this.width / 2 + 66;
        int k = 11;
        int l = 23;
        if (this.numberOfPendingInvites != 0) {
            i -= 3;
            j += 3;
            k -= 5;
            l += 5;
        }
        return (double)i <= p_86572_ && p_86572_ <= (double)j && (double)k <= p_86573_ && p_86573_ <= (double)l;
    }

    public void play(@Nullable RealmsServer p_86516_, Screen p_86517_) {
        if (p_86516_ != null) {
            try {
                if (!this.connectLock.tryLock(1L, TimeUnit.SECONDS)) {
                    return;
                }
                if (this.connectLock.getHoldCount() > 1) {
                    return;
                }
            }
            catch (InterruptedException interruptedexception) {
                return;
            }
            this.dontSetConnectedToRealms = true;
            this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(p_86517_, new GetServerDetailsTask(this, p_86517_, p_86516_, this.connectLock)));
        }
    }

    boolean isSelfOwnedServer(RealmsServer p_86684_) {
        return p_86684_.ownerUUID != null && p_86684_.ownerUUID.equals(this.minecraft.getUser().getUuid());
    }

    private boolean isSelfOwnedNonExpiredServer(RealmsServer p_86689_) {
        return this.isSelfOwnedServer(p_86689_) && !p_86689_.expired;
    }

    void drawExpired(PoseStack p_86577_, int p_86578_, int p_86579_, int p_86580_, int p_86581_) {
        RenderSystem.setShaderTexture(0, EXPIRED_ICON_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        GuiComponent.blit(p_86577_, p_86578_, p_86579_, 0.0f, 0.0f, 10, 28, 10, 28);
        if (p_86580_ >= p_86578_ && p_86580_ <= p_86578_ + 9 && p_86581_ >= p_86579_ && p_86581_ <= p_86579_ + 27 && p_86581_ < this.height - 40 && p_86581_ > 32 && !this.shouldShowPopup()) {
            this.a(SERVER_EXPIRED_TOOLTIP);
        }
    }

    void drawExpiring(PoseStack p_86538_, int p_86539_, int p_86540_, int p_86541_, int p_86542_, int p_86543_) {
        RenderSystem.setShaderTexture(0, EXPIRES_SOON_ICON_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.animTick % 20 < 10) {
            GuiComponent.blit(p_86538_, p_86539_, p_86540_, 0.0f, 0.0f, 10, 28, 20, 28);
        } else {
            GuiComponent.blit(p_86538_, p_86539_, p_86540_, 10.0f, 0.0f, 10, 28, 20, 28);
        }
        if (p_86541_ >= p_86539_ && p_86541_ <= p_86539_ + 9 && p_86542_ >= p_86540_ && p_86542_ <= p_86540_ + 27 && p_86542_ < this.height - 40 && p_86542_ > 32 && !this.shouldShowPopup()) {
            if (p_86543_ <= 0) {
                this.a(SERVER_EXPIRES_SOON_TOOLTIP);
            } else if (p_86543_ == 1) {
                this.a(SERVER_EXPIRES_IN_DAY_TOOLTIP);
            } else {
                this.a(new TranslatableComponent("mco.selectServer.expires.days", p_86543_));
            }
        }
    }

    void drawOpen(PoseStack p_86602_, int p_86603_, int p_86604_, int p_86605_, int p_86606_) {
        RenderSystem.setShaderTexture(0, ON_ICON_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        GuiComponent.blit(p_86602_, p_86603_, p_86604_, 0.0f, 0.0f, 10, 28, 10, 28);
        if (p_86605_ >= p_86603_ && p_86605_ <= p_86603_ + 9 && p_86606_ >= p_86604_ && p_86606_ <= p_86604_ + 27 && p_86606_ < this.height - 40 && p_86606_ > 32 && !this.shouldShowPopup()) {
            this.a(SERVER_OPEN_TOOLTIP);
        }
    }

    void drawClose(PoseStack p_86627_, int p_86628_, int p_86629_, int p_86630_, int p_86631_) {
        RenderSystem.setShaderTexture(0, OFF_ICON_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        GuiComponent.blit(p_86627_, p_86628_, p_86629_, 0.0f, 0.0f, 10, 28, 10, 28);
        if (p_86630_ >= p_86628_ && p_86630_ <= p_86628_ + 9 && p_86631_ >= p_86629_ && p_86631_ <= p_86629_ + 27 && p_86631_ < this.height - 40 && p_86631_ > 32 && !this.shouldShowPopup()) {
            this.a(SERVER_CLOSED_TOOLTIP);
        }
    }

    void drawLeave(PoseStack p_86649_, int p_86650_, int p_86651_, int p_86652_, int p_86653_) {
        boolean flag = false;
        if (p_86652_ >= p_86650_ && p_86652_ <= p_86650_ + 28 && p_86653_ >= p_86651_ && p_86653_ <= p_86651_ + 28 && p_86653_ < this.height - 40 && p_86653_ > 32 && !this.shouldShowPopup()) {
            flag = true;
        }
        RenderSystem.setShaderTexture(0, LEAVE_ICON_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        float f = flag ? 28.0f : 0.0f;
        GuiComponent.blit(p_86649_, p_86650_, p_86651_, f, 0.0f, 28, 28, 56, 28);
        if (flag) {
            this.a(LEAVE_SERVER_TOOLTIP);
            this.hoveredElement = HoveredElement.LEAVE;
        }
    }

    void drawConfigure(PoseStack p_86662_, int p_86663_, int p_86664_, int p_86665_, int p_86666_) {
        boolean flag = false;
        if (p_86665_ >= p_86663_ && p_86665_ <= p_86663_ + 28 && p_86666_ >= p_86664_ && p_86666_ <= p_86664_ + 28 && p_86666_ < this.height - 40 && p_86666_ > 32 && !this.shouldShowPopup()) {
            flag = true;
        }
        RenderSystem.setShaderTexture(0, CONFIGURE_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        float f = flag ? 28.0f : 0.0f;
        GuiComponent.blit(p_86662_, p_86663_, p_86664_, f, 0.0f, 28, 28, 56, 28);
        if (flag) {
            this.a(CONFIGURE_SERVER_TOOLTIP);
            this.hoveredElement = HoveredElement.CONFIGURE;
        }
    }

    protected void renderMousehoverTooltip(PoseStack p_86442_, List<Component> p_86443_, int p_86444_, int p_86445_) {
        if (!p_86443_.isEmpty()) {
            int i = 0;
            int j = 0;
            for (Component component : p_86443_) {
                int k = this.font.width(component);
                if (k <= j) continue;
                j = k;
            }
            int i1 = p_86444_ - j - 5;
            int j1 = p_86445_;
            if (i1 < 0) {
                i1 = p_86444_ + 12;
            }
            for (Component component1 : p_86443_) {
                int l = j1 - (i == 0 ? 3 : 0) + i;
                this.fillGradient(p_86442_, i1 - 3, l, i1 + j + 3, j1 + 8 + 3 + i, -1073741824, -1073741824);
                this.font.drawShadow(p_86442_, component1, (float)i1, (float)(j1 + i), 0xFFFFFF);
                i += 10;
            }
        }
    }

    void renderMoreInfo(PoseStack p_86418_, int p_86419_, int p_86420_, int p_86421_, int p_86422_, boolean p_86423_) {
        boolean flag = false;
        if (p_86419_ >= p_86421_ && p_86419_ <= p_86421_ + 20 && p_86420_ >= p_86422_ && p_86420_ <= p_86422_ + 20) {
            flag = true;
        }
        RenderSystem.setShaderTexture(0, QUESTIONMARK_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        float f = p_86423_ ? 20.0f : 0.0f;
        GuiComponent.blit(p_86418_, p_86421_, p_86422_, f, 0.0f, 20, 20, 40, 20);
        if (flag) {
            this.a(SERVER_INFO_TOOLTIP);
        }
    }

    void renderNews(PoseStack p_86433_, int p_86434_, int p_86435_, boolean p_86436_, int p_86437_, int p_86438_, boolean p_86439_, boolean p_86440_) {
        boolean flag = false;
        if (p_86434_ >= p_86437_ && p_86434_ <= p_86437_ + 20 && p_86435_ >= p_86438_ && p_86435_ <= p_86438_ + 20) {
            flag = true;
        }
        RenderSystem.setShaderTexture(0, NEWS_LOCATION);
        if (p_86440_) {
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderSystem.setShaderColor(0.5f, 0.5f, 0.5f, 1.0f);
        }
        boolean flag1 = p_86440_ && p_86439_;
        float f = flag1 ? 20.0f : 0.0f;
        GuiComponent.blit(p_86433_, p_86437_, p_86438_, f, 0.0f, 20, 20, 40, 20);
        if (flag && p_86440_) {
            this.a(NEWS_TOOLTIP);
        }
        if (p_86436_ && p_86440_) {
            int i = flag ? 0 : (int)(Math.max(0.0f, Math.max(Mth.sin((float)(10 + this.animTick) * 0.57f), Mth.cos((float)this.animTick * 0.35f))) * -6.0f);
            RenderSystem.setShaderTexture(0, INVITATION_ICONS_LOCATION);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            GuiComponent.blit(p_86433_, p_86437_ + 10, p_86438_ + 2 + i, 40.0f, 0.0f, 8, 8, 48, 16);
        }
    }

    private void renderLocal(PoseStack p_86532_) {
        String s = "LOCAL!";
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        p_86532_.pushPose();
        p_86532_.translate(this.width / 2 - 25, 20.0, 0.0);
        p_86532_.mulPose(Vector3f.ZP.rotationDegrees(-20.0f));
        p_86532_.scale(1.5f, 1.5f, 1.5f);
        this.font.draw(p_86532_, "LOCAL!", 0.0f, 0.0f, 0x7FFF7F);
        p_86532_.popPose();
    }

    private void renderStage(PoseStack p_86575_) {
        String s = "STAGE!";
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        p_86575_.pushPose();
        p_86575_.translate(this.width / 2 - 25, 20.0, 0.0);
        p_86575_.mulPose(Vector3f.ZP.rotationDegrees(-20.0f));
        p_86575_.scale(1.5f, 1.5f, 1.5f);
        this.font.draw(p_86575_, "STAGE!", 0.0f, 0.0f, -256);
        p_86575_.popPose();
    }

    public RealmsMainScreen newScreen() {
        RealmsMainScreen realmsmainscreen = new RealmsMainScreen(this.lastScreen);
        realmsmainscreen.init(this.minecraft, this.width, this.height);
        return realmsmainscreen;
    }

    public static void updateTeaserImages(ResourceManager p_86407_) {
        Collection<ResourceLocation> collection = p_86407_.listResources("textures/gui/images", p_193497_ -> p_193497_.endsWith(".png"));
        teaserImages = collection.stream().filter(p_193492_ -> p_193492_.getNamespace().equals("realms")).toList();
    }

    void a(Component ... p_86527_) {
        this.toolTip = Arrays.asList(p_86527_);
    }

    private void pendingButtonPress(Button p_86519_) {
        this.minecraft.setScreen(new RealmsPendingInvitesScreen(this.lastScreen));
    }

    static /* synthetic */ void access$0(RealmsMainScreen realmsMainScreen, Button button) {
        realmsMainScreen.pendingButtonPress(button);
    }

    class CloseButton
    extends Button {
        public CloseButton() {
            super(RealmsMainScreen.this.popupX0() + 4, RealmsMainScreen.this.popupY0() + 4, 12, 12, new TranslatableComponent("mco.selectServer.close"), null);
        }

        @Override
        public void onPress() {
            RealmsMainScreen.this.onClosePopup();
        }

        @Override
        public void renderButton(PoseStack p_86777_, int p_86778_, int p_86779_, float p_86780_) {
            RenderSystem.setShaderTexture(0, CROSS_ICON_LOCATION);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            float f = this.isHoveredOrFocused() ? 12.0f : 0.0f;
            CloseButton.blit(p_86777_, this.x, this.y, 0.0f, f, 12, 12, 12, 24);
            if (this.isMouseOver(p_86778_, p_86779_)) {
                RealmsMainScreen.this.a(this.getMessage());
            }
        }
    }

    abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        Entry() {
        }

        @Nullable
        public abstract RealmsServer getServer();
    }

    static enum HoveredElement {
        NONE,
        EXPIRED,
        LEAVE,
        CONFIGURE;

    }

    class NewsButton
    extends Button {
        public NewsButton() {
            super(RealmsMainScreen.this.width - 62, 6, 20, 20, new TranslatableComponent("mco.news"), null);
        }

        @Override
        public void onPress() {
            if (RealmsMainScreen.this.newsLink != null) {
                Util.getPlatform().openUri(RealmsMainScreen.this.newsLink);
                if (RealmsMainScreen.this.hasUnreadNews) {
                    RealmsPersistence.RealmsPersistenceData realmspersistence$realmspersistencedata = RealmsPersistence.readFile();
                    realmspersistence$realmspersistencedata.hasUnreadNews = false;
                    RealmsMainScreen.this.hasUnreadNews = false;
                    RealmsPersistence.writeFile(realmspersistence$realmspersistencedata);
                }
            }
        }

        @Override
        public void renderButton(PoseStack p_86806_, int p_86807_, int p_86808_, float p_86809_) {
            RealmsMainScreen.this.renderNews(p_86806_, p_86807_, p_86808_, RealmsMainScreen.this.hasUnreadNews, this.x, this.y, this.isHoveredOrFocused(), this.active);
        }
    }

    class PendingInvitesButton
    extends Button {
        public PendingInvitesButton() {
            super(RealmsMainScreen.this.width / 2 + 47, 6, 22, 22, TextComponent.EMPTY, arg_0 -> RealmsMainScreen.access$0(RealmsMainScreen.this, arg_0));
        }

        public void tick() {
            this.setMessage(RealmsMainScreen.this.numberOfPendingInvites == 0 ? NO_PENDING_INVITES_TEXT : PENDING_INVITES_TEXT);
        }

        @Override
        public void renderButton(PoseStack p_86817_, int p_86818_, int p_86819_, float p_86820_) {
            RealmsMainScreen.this.drawInvitationPendingIcon(p_86817_, p_86818_, p_86819_, this.x, this.y, this.isHoveredOrFocused(), this.active);
        }
    }

    class RealmSelectionList
    extends RealmsObjectSelectionList<Entry> {
        public RealmSelectionList() {
            super(RealmsMainScreen.this.width, RealmsMainScreen.this.height, 32, RealmsMainScreen.this.height - 40, 36);
        }

        @Override
        public boolean isFocused() {
            return RealmsMainScreen.this.getFocused() == this;
        }

        @Override
        public boolean keyPressed(int p_86840_, int p_86841_, int p_86842_) {
            if (p_86840_ != 257 && p_86840_ != 32 && p_86840_ != 335) {
                return super.keyPressed(p_86840_, p_86841_, p_86842_);
            }
            Entry realmsmainscreen$entry = (Entry)this.getSelected();
            return realmsmainscreen$entry == null ? super.keyPressed(p_86840_, p_86841_, p_86842_) : realmsmainscreen$entry.mouseClicked(0.0, 0.0, 0);
        }

        @Override
        public boolean mouseClicked(double p_86828_, double p_86829_, int p_86830_) {
            if (p_86830_ == 0 && p_86828_ < (double)this.getScrollbarPosition() && p_86829_ >= (double)this.y0 && p_86829_ <= (double)this.y1) {
                int i = RealmsMainScreen.this.realmSelectionList.getRowLeft();
                int j = this.getScrollbarPosition();
                int k = (int)Math.floor(p_86829_ - (double)this.y0) - this.headerHeight + (int)this.getScrollAmount() - 4;
                int l = k / this.itemHeight;
                if (p_86828_ >= (double)i && p_86828_ <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount()) {
                    this.itemClicked(k, l, p_86828_, p_86829_, this.width);
                    this.selectItem(l);
                }
                return true;
            }
            return super.mouseClicked(p_86828_, p_86829_, p_86830_);
        }

        @Override
        public void setSelected(@Nullable Entry p_86849_) {
            super.setSelected(p_86849_);
            if (p_86849_ != null) {
                RealmsMainScreen.this.updateButtonStates(p_86849_.getServer());
            } else {
                RealmsMainScreen.this.updateButtonStates(null);
            }
        }

        @Override
        public void itemClicked(int p_86834_, int p_86835_, double p_86836_, double p_86837_, int p_86838_) {
            Entry realmsmainscreen$entry = (Entry)this.getEntry(p_86835_);
            if (realmsmainscreen$entry instanceof TrialEntry) {
                RealmsMainScreen.this.popupOpenedByUser = true;
            } else {
                RealmsServer realmsserver = realmsmainscreen$entry.getServer();
                if (realmsserver != null) {
                    if (realmsserver.state == RealmsServer.State.UNINITIALIZED) {
                        Minecraft.getInstance().setScreen(new RealmsCreateRealmScreen(realmsserver, RealmsMainScreen.this));
                    } else if (RealmsMainScreen.this.hoveredElement == HoveredElement.CONFIGURE) {
                        RealmsMainScreen.this.configureClicked(realmsserver);
                    } else if (RealmsMainScreen.this.hoveredElement == HoveredElement.LEAVE) {
                        RealmsMainScreen.this.leaveClicked(realmsserver);
                    } else if (RealmsMainScreen.this.hoveredElement == HoveredElement.EXPIRED) {
                        RealmsMainScreen.this.onRenew(realmsserver);
                    } else if (RealmsMainScreen.this.shouldPlayButtonBeActive(realmsserver)) {
                        if (Util.getMillis() - RealmsMainScreen.this.lastClickTime < 250L && this.isSelectedItem(p_86835_)) {
                            RealmsMainScreen.this.play(realmsserver, RealmsMainScreen.this);
                        }
                        RealmsMainScreen.this.lastClickTime = Util.getMillis();
                    }
                }
            }
        }

        @Override
        public int getMaxPosition() {
            return this.getItemCount() * 36;
        }

        @Override
        public int getRowWidth() {
            return 300;
        }
    }

    class ServerEntry
    extends Entry {
        private static final int SKIN_HEAD_LARGE_WIDTH = 36;
        private final RealmsServer serverData;

        public ServerEntry(RealmsServer p_86856_) {
            this.serverData = p_86856_;
        }

        @Override
        public void render(PoseStack p_86866_, int p_86867_, int p_86868_, int p_86869_, int p_86870_, int p_86871_, int p_86872_, int p_86873_, boolean p_86874_, float p_86875_) {
            this.renderMcoServerItem(this.serverData, p_86866_, p_86869_, p_86868_, p_86872_, p_86873_);
        }

        @Override
        public boolean mouseClicked(double p_86858_, double p_86859_, int p_86860_) {
            if (this.serverData.state == RealmsServer.State.UNINITIALIZED) {
                RealmsMainScreen.this.minecraft.setScreen(new RealmsCreateRealmScreen(this.serverData, RealmsMainScreen.this));
            }
            return true;
        }

        private void renderMcoServerItem(RealmsServer p_86879_, PoseStack p_86880_, int p_86881_, int p_86882_, int p_86883_, int p_86884_) {
            this.renderLegacy(p_86879_, p_86880_, p_86881_ + 36, p_86882_, p_86883_, p_86884_);
        }

        private void renderLegacy(RealmsServer p_86886_, PoseStack p_86887_, int p_86888_, int p_86889_, int p_86890_, int p_86891_) {
            if (p_86886_.state == RealmsServer.State.UNINITIALIZED) {
                RenderSystem.setShaderTexture(0, WORLDICON_LOCATION);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                GuiComponent.blit(p_86887_, p_86888_ + 10, p_86889_ + 6, 0.0f, 0.0f, 40, 20, 40, 20);
                float f = 0.5f + (1.0f + Mth.sin((float)RealmsMainScreen.this.animTick * 0.25f)) * 0.25f;
                int k2 = 0xFF000000 | (int)(127.0f * f) << 16 | (int)(255.0f * f) << 8 | (int)(127.0f * f);
                GuiComponent.drawCenteredString(p_86887_, RealmsMainScreen.this.font, SERVER_UNITIALIZED_TEXT, p_86888_ + 10 + 40 + 75, p_86889_ + 12, k2);
            } else {
                int i = 225;
                int j = 2;
                if (p_86886_.expired) {
                    RealmsMainScreen.this.drawExpired(p_86887_, p_86888_ + 225 - 14, p_86889_ + 2, p_86890_, p_86891_);
                } else if (p_86886_.state == RealmsServer.State.CLOSED) {
                    RealmsMainScreen.this.drawClose(p_86887_, p_86888_ + 225 - 14, p_86889_ + 2, p_86890_, p_86891_);
                } else if (RealmsMainScreen.this.isSelfOwnedServer(p_86886_) && p_86886_.daysLeft < 7) {
                    RealmsMainScreen.this.drawExpiring(p_86887_, p_86888_ + 225 - 14, p_86889_ + 2, p_86890_, p_86891_, p_86886_.daysLeft);
                } else if (p_86886_.state == RealmsServer.State.OPEN) {
                    RealmsMainScreen.this.drawOpen(p_86887_, p_86888_ + 225 - 14, p_86889_ + 2, p_86890_, p_86891_);
                }
                if (!RealmsMainScreen.this.isSelfOwnedServer(p_86886_) && !overrideConfigure) {
                    RealmsMainScreen.this.drawLeave(p_86887_, p_86888_ + 225, p_86889_ + 2, p_86890_, p_86891_);
                } else {
                    RealmsMainScreen.this.drawConfigure(p_86887_, p_86888_ + 225, p_86889_ + 2, p_86890_, p_86891_);
                }
                if (!"0".equals(p_86886_.serverPing.nrOfPlayers)) {
                    String s = (Object)((Object)ChatFormatting.GRAY) + p_86886_.serverPing.nrOfPlayers;
                    RealmsMainScreen.this.font.draw(p_86887_, s, (float)(p_86888_ + 207 - RealmsMainScreen.this.font.width(s)), (float)(p_86889_ + 3), 0x808080);
                    if (p_86890_ >= p_86888_ + 207 - RealmsMainScreen.this.font.width(s) && p_86890_ <= p_86888_ + 207 && p_86891_ >= p_86889_ + 1 && p_86891_ <= p_86889_ + 10 && p_86891_ < RealmsMainScreen.this.height - 40 && p_86891_ > 32 && !RealmsMainScreen.this.shouldShowPopup()) {
                        RealmsMainScreen.this.a(new TextComponent(p_86886_.serverPing.playerList));
                    }
                }
                if (RealmsMainScreen.this.isSelfOwnedServer(p_86886_) && p_86886_.expired) {
                    Component component1;
                    Component component;
                    RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderTexture(0, BUTTON_LOCATION);
                    RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    if (p_86886_.expiredTrial) {
                        component = TRIAL_EXPIRED_TEXT;
                        component1 = SUBSCRIPTION_CREATE_TEXT;
                    } else {
                        component = SUBSCRIPTION_EXPIRED_TEXT;
                        component1 = SUBSCRIPTION_RENEW_TEXT;
                    }
                    int l = RealmsMainScreen.this.font.width(component1) + 17;
                    int i1 = 16;
                    int j1 = p_86888_ + RealmsMainScreen.this.font.width(component) + 8;
                    int k1 = p_86889_ + 13;
                    boolean flag = false;
                    if (p_86890_ >= j1 && p_86890_ < j1 + l && p_86891_ > k1 && p_86891_ <= k1 + 16 && p_86891_ < RealmsMainScreen.this.height - 40 && p_86891_ > 32 && !RealmsMainScreen.this.shouldShowPopup()) {
                        flag = true;
                        RealmsMainScreen.this.hoveredElement = HoveredElement.EXPIRED;
                    }
                    int l1 = flag ? 2 : 1;
                    GuiComponent.blit(p_86887_, j1, k1, 0.0f, 46 + l1 * 20, l / 2, 8, 256, 256);
                    GuiComponent.blit(p_86887_, j1 + l / 2, k1, 200 - l / 2, 46 + l1 * 20, l / 2, 8, 256, 256);
                    GuiComponent.blit(p_86887_, j1, k1 + 8, 0.0f, 46 + l1 * 20 + 12, l / 2, 8, 256, 256);
                    GuiComponent.blit(p_86887_, j1 + l / 2, k1 + 8, 200 - l / 2, 46 + l1 * 20 + 12, l / 2, 8, 256, 256);
                    RenderSystem.disableBlend();
                    int i2 = p_86889_ + 11 + 5;
                    int j2 = flag ? 0xFFFFA0 : 0xFFFFFF;
                    RealmsMainScreen.this.font.draw(p_86887_, component, (float)(p_86888_ + 2), (float)(i2 + 1), 15553363);
                    GuiComponent.drawCenteredString(p_86887_, RealmsMainScreen.this.font, component1, j1 + l / 2, i2 + 1, j2);
                } else {
                    if (p_86886_.worldType == RealmsServer.WorldType.MINIGAME) {
                        int l2 = 0xCCAC5C;
                        int k = RealmsMainScreen.this.font.width(SELECT_MINIGAME_PREFIX);
                        RealmsMainScreen.this.font.draw(p_86887_, SELECT_MINIGAME_PREFIX, (float)(p_86888_ + 2), (float)(p_86889_ + 12), 0xCCAC5C);
                        RealmsMainScreen.this.font.draw(p_86887_, p_86886_.getMinigameName(), (float)(p_86888_ + 2 + k), (float)(p_86889_ + 12), 0x6C6C6C);
                    } else {
                        RealmsMainScreen.this.font.draw(p_86887_, p_86886_.getDescription(), (float)(p_86888_ + 2), (float)(p_86889_ + 12), 0x6C6C6C);
                    }
                    if (!RealmsMainScreen.this.isSelfOwnedServer(p_86886_)) {
                        RealmsMainScreen.this.font.draw(p_86887_, p_86886_.owner, (float)(p_86888_ + 2), (float)(p_86889_ + 12 + 11), 0x4C4C4C);
                    }
                }
                RealmsMainScreen.this.font.draw(p_86887_, p_86886_.getName(), (float)(p_86888_ + 2), (float)(p_86889_ + 1), 0xFFFFFF);
                RealmsTextureManager.withBoundFace(p_86886_.ownerUUID, () -> {
                    RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                    GuiComponent.blit(p_86887_, p_86888_ - 36, p_86889_, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                    GuiComponent.blit(p_86887_, p_86888_ - 36, p_86889_, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
                });
            }
        }

        @Override
        public Component getNarration() {
            return this.serverData.state == RealmsServer.State.UNINITIALIZED ? UNITIALIZED_WORLD_NARRATION : new TranslatableComponent("narrator.select", this.serverData.name);
        }

        @Override
        @Nullable
        public RealmsServer getServer() {
            return this.serverData;
        }
    }

    class ShowPopupButton
    extends Button {
        public ShowPopupButton() {
            super(RealmsMainScreen.this.width - 37, 6, 20, 20, new TranslatableComponent("mco.selectServer.info"), null);
        }

        @Override
        public void onPress() {
            RealmsMainScreen.this.popupOpenedByUser = !RealmsMainScreen.this.popupOpenedByUser;
        }

        @Override
        public void renderButton(PoseStack p_86899_, int p_86900_, int p_86901_, float p_86902_) {
            RealmsMainScreen.this.renderMoreInfo(p_86899_, p_86900_, p_86901_, this.x, this.y, this.isHoveredOrFocused());
        }
    }

    class TrialEntry
    extends Entry {
        TrialEntry() {
        }

        @Override
        public void render(PoseStack p_86921_, int p_86922_, int p_86923_, int p_86924_, int p_86925_, int p_86926_, int p_86927_, int p_86928_, boolean p_86929_, float p_86930_) {
            this.renderTrialItem(p_86921_, p_86922_, p_86924_, p_86923_, p_86927_, p_86928_);
        }

        @Override
        public boolean mouseClicked(double p_86910_, double p_86911_, int p_86912_) {
            RealmsMainScreen.this.popupOpenedByUser = true;
            return true;
        }

        private void renderTrialItem(PoseStack p_86914_, int p_86915_, int p_86916_, int p_86917_, int p_86918_, int p_86919_) {
            int i = p_86917_ + 8;
            int j = 0;
            boolean flag = false;
            if (p_86916_ <= p_86918_ && p_86918_ <= (int)RealmsMainScreen.this.realmSelectionList.getScrollAmount() && p_86917_ <= p_86919_ && p_86919_ <= p_86917_ + 32) {
                flag = true;
            }
            int k = 0x7FFF7F;
            if (flag && !RealmsMainScreen.this.shouldShowPopup()) {
                k = 6077788;
            }
            for (Component component : TRIAL_MESSAGE_LINES) {
                GuiComponent.drawCenteredString(p_86914_, RealmsMainScreen.this.font, component, RealmsMainScreen.this.width / 2, i + j, k);
                j += 10;
            }
        }

        @Override
        public Component getNarration() {
            return TRIAL_TEXT;
        }

        @Override
        @Nullable
        public RealmsServer getServer() {
            return null;
        }
    }
}

