/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import java.util.Locale;

public enum Unit {
    B,
    KB,
    MB,
    GB;

    private static final int BASE_UNIT = 1024;

    public static Unit getLargest(long pBytes) {
        if (pBytes < 1024L) {
            return B;
        }
        try {
            int i = (int)(Math.log(pBytes) / Math.log(1024.0));
            String s = String.valueOf("KMGTPE".charAt(i - 1));
            return Unit.valueOf(String.valueOf(s) + "B");
        }
        catch (Exception exception) {
            return GB;
        }
    }

    public static double convertTo(long pBytes, Unit p_86944_) {
        return p_86944_ == B ? (double)pBytes : (double)pBytes / Math.pow(1024.0, p_86944_.ordinal());
    }

    public static String humanReadable(long pBytes) {
        int i = 1024;
        if (pBytes < 1024L) {
            return String.valueOf(pBytes) + " B";
        }
        int j = (int)(Math.log(pBytes) / Math.log(1024.0));
        String s = "" + "KMGTPE".charAt(j - 1);
        return String.format(Locale.ROOT, "%.1f %sB", (double)pBytes / Math.pow(1024.0, j), s);
    }

    public static String humanReadable(long pBytes, Unit p_86949_) {
        return String.format("%." + (p_86949_ == GB ? "1" : "0") + "f %s", Unit.convertTo(pBytes, p_86949_), p_86949_.name());
    }
}

