/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.exception.RealmsDefaultUncaughtExceptionHandler;
import com.mojang.realmsclient.gui.screens.RealmsDownloadLatestWorldScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;

public class FileDownload {
    static final Logger LOGGER = LogUtils.getLogger();
    volatile boolean cancelled;
    volatile boolean finished;
    volatile boolean error;
    volatile boolean extracting;
    @Nullable
    private volatile File tempFile;
    volatile File resourcePackPath;
    @Nullable
    private volatile HttpGet request;
    @Nullable
    private Thread currentThread;
    private final RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).build();
    private static final String[] INVALID_FILE_NAMES = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    public long contentLength(String p_86990_) {
        long i;
        CloseableHttpClient closeablehttpclient = null;
        HttpGet httpget = null;
        try {
            httpget = new HttpGet(p_86990_);
            closeablehttpclient = HttpClientBuilder.create().setDefaultRequestConfig(this.requestConfig).build();
            CloseableHttpResponse closeablehttpresponse = closeablehttpclient.execute((HttpUriRequest)httpget);
            long l = Long.parseLong(closeablehttpresponse.getFirstHeader("Content-Length").getValue());
            return l;
        }
        catch (Throwable throwable) {
            LOGGER.error("Unable to get content length for download");
            i = 0L;
        }
        finally {
            if (httpget != null) {
                httpget.releaseConnection();
            }
            if (closeablehttpclient != null) {
                try {
                    closeablehttpclient.close();
                }
                catch (IOException ioexception) {
                    LOGGER.error("Could not close http client", (Throwable)ioexception);
                }
            }
        }
        return i;
    }

    public void download(WorldDownload p_86983_, String p_86984_, RealmsDownloadLatestWorldScreen.DownloadStatus p_86985_, LevelStorageSource p_86986_) {
        if (this.currentThread == null) {
            this.currentThread = new Thread(() -> this.lambda$0(p_86983_, p_86985_, p_86984_, p_86986_));
            this.currentThread.setUncaughtExceptionHandler(new RealmsDefaultUncaughtExceptionHandler(LOGGER));
            this.currentThread.start();
        }
    }

    public void cancel() {
        if (this.request != null) {
            this.request.abort();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        this.cancelled = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isExtracting() {
        return this.extracting;
    }

    public static String findAvailableFolderName(String p_87002_) {
        p_87002_ = p_87002_.replaceAll("[\\./\"]", "_");
        String[] stringArray = INVALID_FILE_NAMES;
        int n = INVALID_FILE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (p_87002_.equalsIgnoreCase(s)) {
                p_87002_ = "_" + p_87002_ + "_";
            }
            ++n2;
        }
        return p_87002_;
    }

    void untarGzipArchive(String p_86992_, @Nullable File p_86993_, LevelStorageSource p_86994_) throws IOException {
        String s;
        Pattern pattern = Pattern.compile(".*-([0-9]+)$");
        int i = 1;
        char[] cArray = SharedConstants.ILLEGAL_FILE_CHARACTERS;
        int n = SharedConstants.ILLEGAL_FILE_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c0 = cArray[n2];
            p_86992_ = p_86992_.replace(c0, '_');
            ++n2;
        }
        if (StringUtils.isEmpty((CharSequence)p_86992_)) {
            p_86992_ = "Realm";
        }
        p_86992_ = FileDownload.findAvailableFolderName(p_86992_);
        try {
            for (LevelSummary levelsummary : p_86994_.getLevelList()) {
                if (!levelsummary.getLevelId().toLowerCase(Locale.ROOT).startsWith(p_86992_.toLowerCase(Locale.ROOT))) continue;
                Matcher matcher = pattern.matcher(levelsummary.getLevelId());
                if (matcher.matches()) {
                    int j = Integer.parseInt(matcher.group(1));
                    if (j <= i) continue;
                    i = j;
                    continue;
                }
                ++i;
            }
        }
        catch (Exception exception1) {
            LOGGER.error("Error getting level list", (Throwable)exception1);
            this.error = true;
            return;
        }
        if (p_86994_.isNewLevelIdAcceptable(p_86992_) && i <= 1) {
            s = p_86992_;
        } else {
            s = String.valueOf(p_86992_) + (i == 1 ? "" : "-" + i);
            if (!p_86994_.isNewLevelIdAcceptable(s)) {
                boolean flag = false;
                while (!flag) {
                    s = String.valueOf(p_86992_) + (++i == 1 ? "" : "-" + i);
                    if (!p_86994_.isNewLevelIdAcceptable(s)) continue;
                    flag = true;
                }
            }
        }
        TarArchiveInputStream tararchiveinputstream = null;
        File file1 = new File(Minecraft.getInstance().gameDirectory.getAbsolutePath(), "saves");
        try {
            try {
                file1.mkdir();
                tararchiveinputstream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(p_86993_))));
                TarArchiveEntry tararchiveentry = tararchiveinputstream.getNextTarEntry();
                while (tararchiveentry != null) {
                    File file2 = new File(file1, tararchiveentry.getName().replace("world", s));
                    if (tararchiveentry.isDirectory()) {
                        file2.mkdirs();
                    } else {
                        file2.createNewFile();
                        try (FileOutputStream fileoutputstream = new FileOutputStream(file2);){
                            IOUtils.copy((InputStream)tararchiveinputstream, (OutputStream)fileoutputstream);
                        }
                    }
                    tararchiveentry = tararchiveinputstream.getNextTarEntry();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error extracting world", (Throwable)exception);
                this.error = true;
                if (tararchiveinputstream != null) {
                    tararchiveinputstream.close();
                }
                if (p_86993_ != null) {
                    p_86993_.delete();
                }
                try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = p_86994_.createAccess(s);){
                    levelstoragesource$levelstorageaccess.renameLevel(s.trim());
                    Path path = levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.LEVEL_DATA_FILE);
                    FileDownload.deletePlayerTag(path.toFile());
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to rename unpacked realms level {}", (Object)s, (Object)ioexception);
                }
                this.resourcePackPath = new File(file1, String.valueOf(s) + File.separator + "resources.zip");
            }
        }
        finally {
            if (tararchiveinputstream != null) {
                tararchiveinputstream.close();
            }
            if (p_86993_ != null) {
                p_86993_.delete();
            }
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = p_86994_.createAccess(s);){
                levelstoragesource$levelstorageaccess.renameLevel(s.trim());
                Path path = levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.LEVEL_DATA_FILE);
                FileDownload.deletePlayerTag(path.toFile());
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to rename unpacked realms level {}", (Object)s, (Object)ioexception);
            }
            this.resourcePackPath = new File(file1, String.valueOf(s) + File.separator + "resources.zip");
        }
    }

    private static void deletePlayerTag(File p_86988_) {
        if (p_86988_.exists()) {
            try {
                CompoundTag compoundtag = NbtIo.readCompressed(p_86988_);
                CompoundTag compoundtag1 = compoundtag.getCompound("Data");
                compoundtag1.remove("Player");
                NbtIo.writeCompressed(compoundtag, p_86988_);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$0(WorldDownload var1_1, RealmsDownloadLatestWorldScreen.DownloadStatus var2_2, String var3_3, LevelStorageSource var4_4) {
        closeablehttpclient = null;
        try {
            this.tempFile = File.createTempFile("backup", ".tar.gz");
            this.request = new HttpGet(var1_1.downloadLink);
            closeablehttpclient = HttpClientBuilder.create().setDefaultRequestConfig(this.requestConfig).build();
            httpresponse = closeablehttpclient.execute((HttpUriRequest)this.request);
            var2_2.totalBytes = Long.parseLong(httpresponse.getFirstHeader("Content-Length").getValue());
            if (httpresponse.getStatusLine().getStatusCode() == 200) {
                outputstream = new FileOutputStream(this.tempFile);
                filedownload$progresslistener = new ProgressListener(var3_3.trim(), this.tempFile, var4_4, var2_2);
                filedownload$downloadcountingoutputstream = new DownloadCountingOutputStream(outputstream);
                filedownload$downloadcountingoutputstream.setListener(filedownload$progresslistener);
                IOUtils.copy((InputStream)httpresponse.getEntity().getContent(), (OutputStream)filedownload$downloadcountingoutputstream);
                return;
            }
            try {
                this.error = true;
                this.request.abort();
            }
            catch (Exception exception1) {
                FileDownload.LOGGER.error("Caught exception while downloading: {}", (Object)exception1.getMessage());
                this.error = true;
                return;
            }
        }
        finally {
            block43: {
                block44: {
                    block41: {
                        this.request.releaseConnection();
                        if (this.tempFile != null) {
                            this.tempFile.delete();
                        }
                        if (this.error) break block43;
                        if (var1_1.resourcePackUrl.isEmpty() || var1_1.resourcePackHash.isEmpty()) break block44;
                        this.tempFile = File.createTempFile("resources", ".tar.gz");
                        this.request = new HttpGet(var1_1.resourcePackUrl);
                        httpresponse1 = closeablehttpclient.execute((HttpUriRequest)this.request);
                        var2_2.totalBytes = Long.parseLong(httpresponse1.getFirstHeader("Content-Length").getValue());
                        if (httpresponse1.getStatusLine().getStatusCode() == 200) break block41;
                        this.error = true;
                        this.request.abort();
                        this.request.releaseConnection();
                        if (this.tempFile != null) {
                            this.tempFile.delete();
                        }
                        return;
                    }
                    try {
                        try {
                            outputstream1 = new FileOutputStream(this.tempFile);
                            filedownload$resourcepackprogresslistener = new ResourcePackProgressListener(this.tempFile, var2_2, var1_1);
                            filedownload$downloadcountingoutputstream1 = new DownloadCountingOutputStream(outputstream1);
                            filedownload$downloadcountingoutputstream1.setListener(filedownload$resourcepackprogresslistener);
                            IOUtils.copy((InputStream)httpresponse1.getEntity().getContent(), (OutputStream)filedownload$downloadcountingoutputstream1);
                        }
                        catch (Exception exception) {
                            FileDownload.LOGGER.error("Caught exception while downloading: {}", (Object)exception.getMessage());
                            this.error = true;
                            this.request.releaseConnection();
                            if (this.tempFile == null) ** GOTO lbl76
                            this.tempFile.delete();
                        }
                    }
                    catch (Throwable var15_35) {
                        this.request.releaseConnection();
                        if (this.tempFile != null) {
                            this.tempFile.delete();
                        }
                        throw var15_35;
                    }
                    this.request.releaseConnection();
                    if (this.tempFile != null) {
                        this.tempFile.delete();
                    }
                    break block43;
                }
                this.finished = true;
            }
            if (closeablehttpclient != null) {
                try {
                    closeablehttpclient.close();
                }
                catch (IOException ioexception) {
                    FileDownload.LOGGER.error("Failed to close Realms download client");
                }
            }
        }
    }

    static class DownloadCountingOutputStream
    extends CountingOutputStream {
        @Nullable
        private ActionListener listener;

        public DownloadCountingOutputStream(OutputStream p_193509_) {
            super(p_193509_);
        }

        public void setListener(ActionListener p_87017_) {
            this.listener = p_87017_;
        }

        protected void afterWrite(int p_87019_) throws IOException {
            super.afterWrite(p_87019_);
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent((Object)this, 0, null));
            }
        }
    }

    class ProgressListener
    implements ActionListener {
        private final String worldName;
        private final File tempFile;
        private final LevelStorageSource levelStorageSource;
        private final RealmsDownloadLatestWorldScreen.DownloadStatus downloadStatus;

        ProgressListener(String p_87027_, File p_87028_, LevelStorageSource p_87029_, RealmsDownloadLatestWorldScreen.DownloadStatus p_87030_) {
            this.worldName = p_87027_;
            this.tempFile = p_87028_;
            this.levelStorageSource = p_87029_;
            this.downloadStatus = p_87030_;
        }

        @Override
        public void actionPerformed(ActionEvent p_87039_) {
            this.downloadStatus.bytesWritten = ((DownloadCountingOutputStream)((Object)p_87039_.getSource())).getByteCount();
            if (this.downloadStatus.bytesWritten >= this.downloadStatus.totalBytes && !FileDownload.this.cancelled && !FileDownload.this.error) {
                try {
                    FileDownload.this.extracting = true;
                    FileDownload.this.untarGzipArchive(this.worldName, this.tempFile, this.levelStorageSource);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Error extracting archive", (Throwable)ioexception);
                    FileDownload.this.error = true;
                }
            }
        }
    }

    class ResourcePackProgressListener
    implements ActionListener {
        private final File tempFile;
        private final RealmsDownloadLatestWorldScreen.DownloadStatus downloadStatus;
        private final WorldDownload worldDownload;

        ResourcePackProgressListener(File p_87046_, RealmsDownloadLatestWorldScreen.DownloadStatus p_87047_, WorldDownload p_87048_) {
            this.tempFile = p_87046_;
            this.downloadStatus = p_87047_;
            this.worldDownload = p_87048_;
        }

        @Override
        public void actionPerformed(ActionEvent p_87056_) {
            this.downloadStatus.bytesWritten = ((DownloadCountingOutputStream)((Object)p_87056_.getSource())).getByteCount();
            if (this.downloadStatus.bytesWritten >= this.downloadStatus.totalBytes && !FileDownload.this.cancelled) {
                try {
                    String s = Hashing.sha1().hashBytes(Files.toByteArray((File)this.tempFile)).toString();
                    if (s.equals(this.worldDownload.resourcePackHash)) {
                        FileUtils.copyFile((File)this.tempFile, (File)FileDownload.this.resourcePackPath);
                        FileDownload.this.finished = true;
                    } else {
                        LOGGER.error("Resourcepack had wrong hash (expected {}, found {}). Deleting it.", (Object)this.worldDownload.resourcePackHash, (Object)s);
                        FileUtils.deleteQuietly((File)this.tempFile);
                        FileDownload.this.error = true;
                    }
                }
                catch (IOException ioexception) {
                    LOGGER.error("Error copying resourcepack file: {}", (Object)ioexception.getMessage());
                    FileDownload.this.error = true;
                }
            }
        }
    }
}

