/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClientConfig;
import com.mojang.realmsclient.client.RealmsError;
import com.mojang.realmsclient.client.Request;
import com.mojang.realmsclient.dto.BackupList;
import com.mojang.realmsclient.dto.GuardedSerializer;
import com.mojang.realmsclient.dto.Ops;
import com.mojang.realmsclient.dto.PendingInvite;
import com.mojang.realmsclient.dto.PendingInvitesList;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsDescriptionDto;
import com.mojang.realmsclient.dto.RealmsNews;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerAddress;
import com.mojang.realmsclient.dto.RealmsServerList;
import com.mojang.realmsclient.dto.RealmsServerPlayerLists;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.dto.RealmsWorldResetDto;
import com.mojang.realmsclient.dto.ServerActivityList;
import com.mojang.realmsclient.dto.Subscription;
import com.mojang.realmsclient.dto.UploadInfo;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.dto.WorldTemplatePaginatedList;
import com.mojang.realmsclient.exception.RealmsHttpException;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.util.WorldGenerationInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.slf4j.Logger;

public class RealmsClient {
    public static Environment currentEnvironment = Environment.PRODUCTION;
    private static boolean initialized;
    private static final Logger LOGGER;
    private final String sessionId;
    private final String username;
    private final Minecraft minecraft;
    private static final String WORLDS_RESOURCE_PATH = "worlds";
    private static final String INVITES_RESOURCE_PATH = "invites";
    private static final String MCO_RESOURCE_PATH = "mco";
    private static final String SUBSCRIPTION_RESOURCE = "subscriptions";
    private static final String ACTIVITIES_RESOURCE = "activities";
    private static final String OPS_RESOURCE = "ops";
    private static final String REGIONS_RESOURCE = "regions/ping/stat";
    private static final String TRIALS_RESOURCE = "trial";
    private static final String PATH_INITIALIZE = "/$WORLD_ID/initialize";
    private static final String PATH_GET_ACTIVTIES = "/$WORLD_ID";
    private static final String PATH_GET_LIVESTATS = "/liveplayerlist";
    private static final String PATH_GET_SUBSCRIPTION = "/$WORLD_ID";
    private static final String PATH_OP = "/$WORLD_ID/$PROFILE_UUID";
    private static final String PATH_PUT_INTO_MINIGAMES_MODE = "/minigames/$MINIGAME_ID/$WORLD_ID";
    private static final String PATH_AVAILABLE = "/available";
    private static final String PATH_TEMPLATES = "/templates/$WORLD_TYPE";
    private static final String PATH_WORLD_JOIN = "/v1/$ID/join/pc";
    private static final String PATH_WORLD_GET = "/$ID";
    private static final String PATH_WORLD_INVITES = "/$WORLD_ID";
    private static final String PATH_WORLD_UNINVITE = "/$WORLD_ID/invite/$UUID";
    private static final String PATH_PENDING_INVITES_COUNT = "/count/pending";
    private static final String PATH_PENDING_INVITES = "/pending";
    private static final String PATH_ACCEPT_INVITE = "/accept/$INVITATION_ID";
    private static final String PATH_REJECT_INVITE = "/reject/$INVITATION_ID";
    private static final String PATH_UNINVITE_MYSELF = "/$WORLD_ID";
    private static final String PATH_WORLD_UPDATE = "/$WORLD_ID";
    private static final String PATH_SLOT = "/$WORLD_ID/slot/$SLOT_ID";
    private static final String PATH_WORLD_OPEN = "/$WORLD_ID/open";
    private static final String PATH_WORLD_CLOSE = "/$WORLD_ID/close";
    private static final String PATH_WORLD_RESET = "/$WORLD_ID/reset";
    private static final String PATH_DELETE_WORLD = "/$WORLD_ID";
    private static final String PATH_WORLD_BACKUPS = "/$WORLD_ID/backups";
    private static final String PATH_WORLD_DOWNLOAD = "/$WORLD_ID/slot/$SLOT_ID/download";
    private static final String PATH_WORLD_UPLOAD = "/$WORLD_ID/backups/upload";
    private static final String PATH_CLIENT_COMPATIBLE = "/client/compatible";
    private static final String PATH_TOS_AGREED = "/tos/agreed";
    private static final String PATH_NEWS = "/v1/news";
    private static final String PATH_STAGE_AVAILABLE = "/stageAvailable";
    private static final GuardedSerializer GSON;

    static {
        LOGGER = LogUtils.getLogger();
        GSON = new GuardedSerializer();
    }

    public static RealmsClient create() {
        Minecraft minecraft = Minecraft.getInstance();
        String s = minecraft.getUser().getName();
        String s1 = minecraft.getUser().getSessionId();
        if (!initialized) {
            initialized = true;
            String s2 = System.getenv("realms.environment");
            if (s2 == null) {
                s2 = System.getProperty("realms.environment");
            }
            if (s2 != null) {
                if ("LOCAL".equals(s2)) {
                    RealmsClient.switchToLocal();
                } else if ("STAGE".equals(s2)) {
                    RealmsClient.switchToStage();
                }
            }
        }
        return new RealmsClient(s1, s, minecraft);
    }

    public static void switchToStage() {
        currentEnvironment = Environment.STAGE;
    }

    public static void switchToProd() {
        currentEnvironment = Environment.PRODUCTION;
    }

    public static void switchToLocal() {
        currentEnvironment = Environment.LOCAL;
    }

    public RealmsClient(String pSessionId, String pUsername, Minecraft pMinecraft) {
        this.sessionId = pSessionId;
        this.username = pUsername;
        this.minecraft = pMinecraft;
        RealmsClientConfig.setProxy(pMinecraft.getProxy());
    }

    public RealmsServerList listWorlds() throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH);
        String s1 = this.execute(Request.get(s));
        return RealmsServerList.parse(s1);
    }

    public RealmsServer getOwnWorld(long pServerId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_GET.replace("$ID", String.valueOf(pServerId)));
        String s1 = this.execute(Request.get(s));
        return RealmsServer.parse(s1);
    }

    public ServerActivityList getActivity(long pWorldId) throws RealmsServiceException {
        String s = this.url(ACTIVITIES_RESOURCE + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.get(s));
        return ServerActivityList.parse(s1);
    }

    public RealmsServerPlayerLists getLiveStats() throws RealmsServiceException {
        String s = this.url("activities/liveplayerlist");
        String s1 = this.execute(Request.get(s));
        return RealmsServerPlayerLists.parse(s1);
    }

    public RealmsServerAddress join(long pServerId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_JOIN.replace("$ID", "" + pServerId));
        String s1 = this.execute(Request.get(s, 5000, 30000));
        return RealmsServerAddress.parse(s1);
    }

    public void initializeWorld(long pWorldId, String p_87193_, String pName) throws RealmsServiceException {
        RealmsDescriptionDto realmsdescriptiondto = new RealmsDescriptionDto(p_87193_, pName);
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_INITIALIZE.replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = GSON.toJson(realmsdescriptiondto);
        this.execute(Request.post(s, s1, 5000, 10000));
    }

    public Boolean mcoEnabled() throws RealmsServiceException {
        String s = this.url("mco/available");
        String s1 = this.execute(Request.get(s));
        return Boolean.valueOf(s1);
    }

    public Boolean stageAvailable() throws RealmsServiceException {
        String s = this.url("mco/stageAvailable");
        String s1 = this.execute(Request.get(s));
        return Boolean.valueOf(s1);
    }

    public CompatibleVersionResponse clientCompatible() throws RealmsServiceException {
        String s = this.url("mco/client/compatible");
        String s1 = this.execute(Request.get(s));
        try {
            return CompatibleVersionResponse.valueOf(s1);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            throw new RealmsServiceException(500, "Could not check compatible version, got response: " + s1);
        }
    }

    public void uninvite(long pWorldId, String p_87185_) throws RealmsServiceException {
        String s = this.url(INVITES_RESOURCE_PATH + PATH_WORLD_UNINVITE.replace("$WORLD_ID", String.valueOf(pWorldId)).replace("$UUID", p_87185_));
        this.execute(Request.delete(s));
    }

    public void uninviteMyselfFrom(long pWorldId) throws RealmsServiceException {
        String s = this.url(INVITES_RESOURCE_PATH + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(pWorldId)));
        this.execute(Request.delete(s));
    }

    public RealmsServer invite(long p_87213_, String p_87214_) throws RealmsServiceException {
        PlayerInfo playerinfo = new PlayerInfo();
        playerinfo.setName(p_87214_);
        String s = this.url(INVITES_RESOURCE_PATH + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(p_87213_)));
        String s1 = this.execute(Request.post(s, GSON.toJson(playerinfo)));
        return RealmsServer.parse(s1);
    }

    public BackupList backupsFor(long pWorldId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_BACKUPS.replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.get(s));
        return BackupList.parse(s1);
    }

    public void update(long pWorldId, String p_87217_, String pName) throws RealmsServiceException {
        RealmsDescriptionDto realmsdescriptiondto = new RealmsDescriptionDto(p_87217_, pName);
        String s = this.url(WORLDS_RESOURCE_PATH + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(pWorldId)));
        this.execute(Request.post(s, GSON.toJson(realmsdescriptiondto)));
    }

    public void updateSlot(long pWorldId, int p_87181_, RealmsWorldOptions pSlotId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_SLOT.replace("$WORLD_ID", String.valueOf(pWorldId)).replace("$SLOT_ID", String.valueOf(p_87181_)));
        String s1 = pSlotId.toJson();
        this.execute(Request.post(s, s1));
    }

    public boolean switchSlot(long pWorldId, int p_87178_) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_SLOT.replace("$WORLD_ID", String.valueOf(pWorldId)).replace("$SLOT_ID", String.valueOf(p_87178_)));
        String s1 = this.execute(Request.put(s, ""));
        return Boolean.valueOf(s1);
    }

    public void restoreWorld(long pWorldId, String p_87226_) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_BACKUPS.replace("$WORLD_ID", String.valueOf(pWorldId)), "backupId=" + p_87226_);
        this.execute(Request.put(s, "", 40000, 600000));
    }

    public WorldTemplatePaginatedList fetchWorldTemplates(int pPage, int pPageSize, RealmsServer.WorldType pWorldType) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_TEMPLATES.replace("$WORLD_TYPE", pWorldType.toString()), String.format("page=%d&pageSize=%d", pPage, pPageSize));
        String s1 = this.execute(Request.get(s));
        return WorldTemplatePaginatedList.parse(s1);
    }

    public Boolean putIntoMinigameMode(long pWorldId, String p_87234_) throws RealmsServiceException {
        String s = PATH_PUT_INTO_MINIGAMES_MODE.replace("$MINIGAME_ID", p_87234_).replace("$WORLD_ID", String.valueOf(pWorldId));
        String s1 = this.url(WORLDS_RESOURCE_PATH + s);
        return Boolean.valueOf(this.execute(Request.put(s1, "")));
    }

    public Ops op(long pWorldId, String p_87240_) throws RealmsServiceException {
        String s = PATH_OP.replace("$WORLD_ID", String.valueOf(pWorldId)).replace("$PROFILE_UUID", p_87240_);
        String s1 = this.url(OPS_RESOURCE + s);
        return Ops.parse(this.execute(Request.post(s1, "")));
    }

    public Ops deop(long pWorldId, String p_87246_) throws RealmsServiceException {
        String s = PATH_OP.replace("$WORLD_ID", String.valueOf(pWorldId)).replace("$PROFILE_UUID", p_87246_);
        String s1 = this.url(OPS_RESOURCE + s);
        return Ops.parse(this.execute(Request.delete(s1)));
    }

    public Boolean open(long pWorldId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_OPEN.replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.put(s, ""));
        return Boolean.valueOf(s1);
    }

    public Boolean close(long pWorldId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_CLOSE.replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.put(s, ""));
        return Boolean.valueOf(s1);
    }

    public Boolean resetWorldWithSeed(long pWorldId, WorldGenerationInfo p_167277_) throws RealmsServiceException {
        RealmsWorldResetDto realmsworldresetdto = new RealmsWorldResetDto(p_167277_.getSeed(), -1L, p_167277_.getLevelType().getDtoIndex(), p_167277_.shouldGenerateStructures());
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_RESET.replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.post(s, GSON.toJson(realmsworldresetdto), 30000, 80000));
        return Boolean.valueOf(s1);
    }

    public Boolean resetWorldWithTemplate(long pWorldId, String p_87252_) throws RealmsServiceException {
        RealmsWorldResetDto realmsworldresetdto = new RealmsWorldResetDto(null, Long.valueOf(p_87252_), -1, false);
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_RESET.replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.post(s, GSON.toJson(realmsworldresetdto), 30000, 80000));
        return Boolean.valueOf(s1);
    }

    public Subscription subscriptionFor(long pWorldId) throws RealmsServiceException {
        String s = this.url(SUBSCRIPTION_RESOURCE + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(pWorldId)));
        String s1 = this.execute(Request.get(s));
        return Subscription.parse(s1);
    }

    public int pendingInvitesCount() throws RealmsServiceException {
        return this.pendingInvites().pendingInvites.size();
    }

    public PendingInvitesList pendingInvites() throws RealmsServiceException {
        String s = this.url("invites/pending");
        String s1 = this.execute(Request.get(s));
        PendingInvitesList pendinginviteslist = PendingInvitesList.parse(s1);
        pendinginviteslist.pendingInvites.removeIf(this::isBlocked);
        return pendinginviteslist;
    }

    private boolean isBlocked(PendingInvite p_87198_) {
        try {
            UUID uuid = UUID.fromString(p_87198_.worldOwnerUuid);
            return this.minecraft.getPlayerSocialManager().isBlocked(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return false;
        }
    }

    public void acceptInvitation(String pInviteId) throws RealmsServiceException {
        String s = this.url(INVITES_RESOURCE_PATH + PATH_ACCEPT_INVITE.replace("$INVITATION_ID", pInviteId));
        this.execute(Request.put(s, ""));
    }

    public WorldDownload requestDownloadInfo(long pWorldId, int p_87211_) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_DOWNLOAD.replace("$WORLD_ID", String.valueOf(pWorldId)).replace("$SLOT_ID", String.valueOf(p_87211_)));
        String s1 = this.execute(Request.get(s));
        return WorldDownload.parse(s1);
    }

    @Nullable
    public UploadInfo requestUploadInfo(long pWorldId, @Nullable String p_87258_) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + PATH_WORLD_UPLOAD.replace("$WORLD_ID", String.valueOf(pWorldId)));
        return UploadInfo.parse(this.execute(Request.put(s, UploadInfo.createRequest(p_87258_))));
    }

    public void rejectInvitation(String pInviteId) throws RealmsServiceException {
        String s = this.url(INVITES_RESOURCE_PATH + PATH_REJECT_INVITE.replace("$INVITATION_ID", pInviteId));
        this.execute(Request.put(s, ""));
    }

    public void agreeToTos() throws RealmsServiceException {
        String s = this.url("mco/tos/agreed");
        this.execute(Request.post(s, ""));
    }

    public RealmsNews getNews() throws RealmsServiceException {
        String s = this.url("mco/v1/news");
        String s1 = this.execute(Request.get(s, 5000, 10000));
        return RealmsNews.parse(s1);
    }

    public void sendPingResults(PingResult pPingResult) throws RealmsServiceException {
        String s = this.url(REGIONS_RESOURCE);
        this.execute(Request.post(s, GSON.toJson(pPingResult)));
    }

    public Boolean trialAvailable() throws RealmsServiceException {
        String s = this.url(TRIALS_RESOURCE);
        String s1 = this.execute(Request.get(s));
        return Boolean.valueOf(s1);
    }

    public void deleteWorld(long pWorldId) throws RealmsServiceException {
        String s = this.url(WORLDS_RESOURCE_PATH + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(pWorldId)));
        this.execute(Request.delete(s));
    }

    private String url(String p_87228_) {
        return this.url(p_87228_, null);
    }

    private String url(String p_87204_, @Nullable String p_87205_) {
        try {
            return new URI(RealmsClient.currentEnvironment.protocol, RealmsClient.currentEnvironment.baseUrl, "/" + p_87204_, p_87205_, null).toASCIIString();
        }
        catch (URISyntaxException urisyntaxexception) {
            throw new IllegalArgumentException(p_87204_, urisyntaxexception);
        }
    }

    private String execute(Request<?> pRequest) throws RealmsServiceException {
        pRequest.cookie("sid", this.sessionId);
        pRequest.cookie("user", this.username);
        pRequest.cookie("version", SharedConstants.getCurrentVersion().getName());
        try {
            int i = pRequest.responseCode();
            if (i != 503 && i != 277) {
                String s1 = pRequest.text();
                if (i >= 200 && i < 300) {
                    return s1;
                }
                if (i == 401) {
                    String s2 = pRequest.getHeader("WWW-Authenticate");
                    LOGGER.info("Could not authorize you against Realms server: {}", (Object)s2);
                    throw new RealmsServiceException(i, s2);
                }
                RealmsError realmserror = RealmsError.parse(s1);
                if (realmserror != null) {
                    LOGGER.error("Realms http code: {} -  error code: {} -  message: {} - raw body: {}", new Object[]{i, realmserror.getErrorCode(), realmserror.getErrorMessage(), s1});
                    throw new RealmsServiceException(i, s1, realmserror);
                }
                LOGGER.error("Realms http code: {} - raw body (message failed to parse): {}", (Object)i, (Object)s1);
                String s = RealmsClient.getHttpCodeDescription(i);
                throw new RealmsServiceException(i, s);
            }
            int j = pRequest.getRetryAfterHeader();
            throw new RetryCallException(j, i);
        }
        catch (RealmsHttpException realmshttpexception) {
            throw new RealmsServiceException(500, "Could not connect to Realms: " + realmshttpexception.getMessage());
        }
    }

    private static String getHttpCodeDescription(int p_200937_) {
        return switch (p_200937_) {
            case 429 -> I18n.a("mco.errorMessage.serviceBusy", new Object[0]);
            default -> "Unknown error";
        };
    }

    public static enum CompatibleVersionResponse {
        COMPATIBLE,
        OUTDATED,
        OTHER;

    }

    public static enum Environment {
        PRODUCTION("pc.realms.minecraft.net", "https"),
        STAGE("pc-stage.realms.minecraft.net", "https"),
        LOCAL("localhost:8080", "http");

        public String baseUrl;
        public String protocol;

        private Environment(String p_87286_, String p_87287_) {
            this.baseUrl = p_87286_;
            this.protocol = p_87287_;
        }
    }
}

