/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsServerPing;
import com.mojang.realmsclient.dto.RealmsServerPlayerList;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.realmsclient.util.JsonUtils;
import com.mojang.realmsclient.util.RealmsUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;

public class RealmsServer
extends ValueObject {
    private static final Logger LOGGER = LogUtils.getLogger();
    public long id;
    public String remoteSubscriptionId;
    public String name;
    public String motd;
    public State state;
    public String owner;
    public String ownerUUID;
    public List<PlayerInfo> players;
    public Map<Integer, RealmsWorldOptions> slots;
    public boolean expired;
    public boolean expiredTrial;
    public int daysLeft;
    public WorldType worldType;
    public int activeSlot;
    public String minigameName;
    public int minigameId;
    public String minigameImage;
    public RealmsServerPing serverPing = new RealmsServerPing();

    public String getDescription() {
        return this.motd;
    }

    public String getName() {
        return this.name;
    }

    public String getMinigameName() {
        return this.minigameName;
    }

    public void setName(String pName) {
        this.name = pName;
    }

    public void setDescription(String pMotd) {
        this.motd = pMotd;
    }

    public void updateServerPing(RealmsServerPlayerList pRealmsServerPlayerList) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (String s : pRealmsServerPlayerList.players) {
            if (s.equals(Minecraft.getInstance().getUser().getUuid())) continue;
            String s1 = "";
            try {
                s1 = RealmsUtil.uuidToName(s);
            }
            catch (Exception exception) {
                LOGGER.error("Could not get name for {}", (Object)s, (Object)exception);
                continue;
            }
            list.add(s1);
            ++i;
        }
        this.serverPing.nrOfPlayers = String.valueOf(i);
        this.serverPing.playerList = Joiner.on((char)'\n').join((Iterable)list);
    }

    public static RealmsServer parse(JsonObject pJson) {
        RealmsServer realmsserver = new RealmsServer();
        try {
            realmsserver.id = JsonUtils.getLongOr("id", pJson, -1L);
            realmsserver.remoteSubscriptionId = JsonUtils.getStringOr("remoteSubscriptionId", pJson, null);
            realmsserver.name = JsonUtils.getStringOr("name", pJson, null);
            realmsserver.motd = JsonUtils.getStringOr("motd", pJson, null);
            realmsserver.state = RealmsServer.getState(JsonUtils.getStringOr("state", pJson, State.CLOSED.name()));
            realmsserver.owner = JsonUtils.getStringOr("owner", pJson, null);
            if (pJson.get("players") != null && pJson.get("players").isJsonArray()) {
                realmsserver.players = RealmsServer.parseInvited(pJson.get("players").getAsJsonArray());
                RealmsServer.sortInvited(realmsserver);
            } else {
                realmsserver.players = Lists.newArrayList();
            }
            realmsserver.daysLeft = JsonUtils.getIntOr("daysLeft", pJson, 0);
            realmsserver.expired = JsonUtils.getBooleanOr("expired", pJson, false);
            realmsserver.expiredTrial = JsonUtils.getBooleanOr("expiredTrial", pJson, false);
            realmsserver.worldType = RealmsServer.getWorldType(JsonUtils.getStringOr("worldType", pJson, WorldType.NORMAL.name()));
            realmsserver.ownerUUID = JsonUtils.getStringOr("ownerUUID", pJson, "");
            realmsserver.slots = pJson.get("slots") != null && pJson.get("slots").isJsonArray() ? RealmsServer.parseSlots(pJson.get("slots").getAsJsonArray()) : RealmsServer.createEmptySlots();
            realmsserver.minigameName = JsonUtils.getStringOr("minigameName", pJson, null);
            realmsserver.activeSlot = JsonUtils.getIntOr("activeSlot", pJson, -1);
            realmsserver.minigameId = JsonUtils.getIntOr("minigameId", pJson, -1);
            realmsserver.minigameImage = JsonUtils.getStringOr("minigameImage", pJson, null);
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse McoServer: {}", (Object)exception.getMessage());
        }
        return realmsserver;
    }

    private static void sortInvited(RealmsServer pRealmsServer) {
        pRealmsServer.players.sort((p_87502_, p_87503_) -> ComparisonChain.start().compareFalseFirst(p_87503_.getAccepted(), p_87502_.getAccepted()).compare((Comparable)((Object)p_87502_.getName().toLowerCase(Locale.ROOT)), (Comparable)((Object)p_87503_.getName().toLowerCase(Locale.ROOT))).result());
    }

    private static List<PlayerInfo> parseInvited(JsonArray pJsonArray) {
        ArrayList list = Lists.newArrayList();
        for (JsonElement jsonelement : pJsonArray) {
            try {
                JsonObject jsonobject = jsonelement.getAsJsonObject();
                PlayerInfo playerinfo = new PlayerInfo();
                playerinfo.setName(JsonUtils.getStringOr("name", jsonobject, null));
                playerinfo.setUuid(JsonUtils.getStringOr("uuid", jsonobject, null));
                playerinfo.setOperator(JsonUtils.getBooleanOr("operator", jsonobject, false));
                playerinfo.setAccepted(JsonUtils.getBooleanOr("accepted", jsonobject, false));
                playerinfo.setOnline(JsonUtils.getBooleanOr("online", jsonobject, false));
                list.add(playerinfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    private static Map<Integer, RealmsWorldOptions> parseSlots(JsonArray pJsonArray) {
        HashMap map = Maps.newHashMap();
        for (JsonElement jsonelement : pJsonArray) {
            try {
                JsonObject jsonobject = jsonelement.getAsJsonObject();
                JsonParser jsonparser = new JsonParser();
                JsonElement jsonelement1 = jsonparser.parse(jsonobject.get("options").getAsString());
                RealmsWorldOptions realmsworldoptions = jsonelement1 == null ? RealmsWorldOptions.createDefaults() : RealmsWorldOptions.parse(jsonelement1.getAsJsonObject());
                int i = JsonUtils.getIntOr("slotId", jsonobject, -1);
                map.put(i, realmsworldoptions);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int j = 1;
        while (j <= 3) {
            if (!map.containsKey(j)) {
                map.put(j, RealmsWorldOptions.createEmptyDefaults());
            }
            ++j;
        }
        return map;
    }

    private static Map<Integer, RealmsWorldOptions> createEmptySlots() {
        HashMap map = Maps.newHashMap();
        map.put(1, RealmsWorldOptions.createEmptyDefaults());
        map.put(2, RealmsWorldOptions.createEmptyDefaults());
        map.put(3, RealmsWorldOptions.createEmptyDefaults());
        return map;
    }

    public static RealmsServer parse(String pJson) {
        try {
            return RealmsServer.parse(new JsonParser().parse(pJson).getAsJsonObject());
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse McoServer: {}", (Object)exception.getMessage());
            return new RealmsServer();
        }
    }

    private static State getState(String pName) {
        try {
            return State.valueOf(pName);
        }
        catch (Exception exception) {
            return State.CLOSED;
        }
    }

    private static WorldType getWorldType(String pName) {
        try {
            return WorldType.valueOf(pName);
        }
        catch (Exception exception) {
            return WorldType.NORMAL;
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.motd, this.state, this.owner, this.expired});
    }

    public boolean equals(Object pOther) {
        if (pOther == null) {
            return false;
        }
        if (pOther == this) {
            return true;
        }
        if (pOther.getClass() != this.getClass()) {
            return false;
        }
        RealmsServer realmsserver = (RealmsServer)pOther;
        return new EqualsBuilder().append(this.id, realmsserver.id).append((Object)this.name, (Object)realmsserver.name).append((Object)this.motd, (Object)realmsserver.motd).append((Object)this.state, (Object)realmsserver.state).append((Object)this.owner, (Object)realmsserver.owner).append(this.expired, realmsserver.expired).append((Object)this.worldType, (Object)this.worldType).isEquals();
    }

    public RealmsServer clone() {
        RealmsServer realmsserver = new RealmsServer();
        realmsserver.id = this.id;
        realmsserver.remoteSubscriptionId = this.remoteSubscriptionId;
        realmsserver.name = this.name;
        realmsserver.motd = this.motd;
        realmsserver.state = this.state;
        realmsserver.owner = this.owner;
        realmsserver.players = this.players;
        realmsserver.slots = this.cloneSlots(this.slots);
        realmsserver.expired = this.expired;
        realmsserver.expiredTrial = this.expiredTrial;
        realmsserver.daysLeft = this.daysLeft;
        realmsserver.serverPing = new RealmsServerPing();
        realmsserver.serverPing.nrOfPlayers = this.serverPing.nrOfPlayers;
        realmsserver.serverPing.playerList = this.serverPing.playerList;
        realmsserver.worldType = this.worldType;
        realmsserver.ownerUUID = this.ownerUUID;
        realmsserver.minigameName = this.minigameName;
        realmsserver.activeSlot = this.activeSlot;
        realmsserver.minigameId = this.minigameId;
        realmsserver.minigameImage = this.minigameImage;
        return realmsserver;
    }

    public Map<Integer, RealmsWorldOptions> cloneSlots(Map<Integer, RealmsWorldOptions> pSlots) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Integer, RealmsWorldOptions> entry : pSlots.entrySet()) {
            map.put(entry.getKey(), entry.getValue().clone());
        }
        return map;
    }

    public String getWorldName(int pSlot) {
        return String.valueOf(this.name) + " (" + this.slots.get(pSlot).getSlotName(pSlot) + ")";
    }

    public ServerData toServerData(String pIp) {
        return new ServerData(this.name, pIp, false);
    }

    public static class McoServerComparator
    implements Comparator<RealmsServer> {
        private final String refOwner;

        public McoServerComparator(String pRefOwner) {
            this.refOwner = pRefOwner;
        }

        @Override
        public int compare(RealmsServer p_87536_, RealmsServer p_87537_) {
            return ComparisonChain.start().compareTrueFirst(p_87536_.state == State.UNINITIALIZED, p_87537_.state == State.UNINITIALIZED).compareTrueFirst(p_87536_.expiredTrial, p_87537_.expiredTrial).compareTrueFirst(p_87536_.owner.equals(this.refOwner), p_87537_.owner.equals(this.refOwner)).compareFalseFirst(p_87536_.expired, p_87537_.expired).compareTrueFirst(p_87536_.state == State.OPEN, p_87537_.state == State.OPEN).compare(p_87536_.id, p_87537_.id).result();
        }
    }

    public static enum State {
        CLOSED,
        OPEN,
        UNINITIALIZED;

    }

    public static enum WorldType {
        NORMAL,
        MINIGAME,
        ADVENTUREMAP,
        EXPERIENCE,
        INSPIRATION;

    }
}

