/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.realmsclient.dto.Backup;
import com.mojang.realmsclient.gui.screens.RealmsSlotOptionsScreen;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.realms.RealmsScreen;

public class RealmsBackupInfoScreen
extends RealmsScreen {
    private static final Component TEXT_UNKNOWN = new TextComponent("UNKNOWN");
    private final Screen lastScreen;
    final Backup backup;
    private BackupInfoList backupInfoList;

    public RealmsBackupInfoScreen(Screen pLastScreen, Backup pBackup) {
        super(new TextComponent("Changes from last backup"));
        this.lastScreen = pLastScreen;
        this.backup = pBackup;
    }

    @Override
    public void tick() {
    }

    @Override
    public void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 120 + 24, 200, 20, CommonComponents.GUI_BACK, p_88066_ -> this.minecraft.setScreen(this.lastScreen)));
        this.backupInfoList = new BackupInfoList(this.minecraft);
        this.addWidget(this.backupInfoList);
        this.magicalSpecialHackyFocus(this.backupInfoList);
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.setScreen(this.lastScreen);
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        this.backupInfoList.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        RealmsBackupInfoScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    Component checkForSpecificMetadata(String p_88068_, String p_88069_) {
        String s = p_88068_.toLowerCase(Locale.ROOT);
        if (s.contains("game") && s.contains("mode")) {
            return this.gameModeMetadata(p_88069_);
        }
        return s.contains("game") && s.contains("difficulty") ? this.gameDifficultyMetadata(p_88069_) : new TextComponent(p_88069_);
    }

    private Component gameDifficultyMetadata(String p_88074_) {
        try {
            return RealmsSlotOptionsScreen.DIFFICULTIES.get(Integer.parseInt(p_88074_)).getDisplayName();
        }
        catch (Exception exception) {
            return TEXT_UNKNOWN;
        }
    }

    private Component gameModeMetadata(String p_88076_) {
        try {
            return RealmsSlotOptionsScreen.GAME_MODES.get(Integer.parseInt(p_88076_)).getShortDisplayName();
        }
        catch (Exception exception) {
            return TEXT_UNKNOWN;
        }
    }

    class BackupInfoList
    extends ObjectSelectionList<BackupInfoListEntry> {
        public BackupInfoList(Minecraft p_88082_) {
            super(p_88082_, RealmsBackupInfoScreen.this.width, RealmsBackupInfoScreen.this.height, 32, RealmsBackupInfoScreen.this.height - 64, 36);
            this.setRenderSelection(false);
            if (RealmsBackupInfoScreen.this.backup.changeList != null) {
                RealmsBackupInfoScreen.this.backup.changeList.forEach((p_88084_, p_88085_) -> {
                    RealmsBackupInfoScreen realmsBackupInfoScreen = RealmsBackupInfoScreen.this;
                    realmsBackupInfoScreen.getClass();
                    this.addEntry(realmsBackupInfoScreen.new BackupInfoListEntry((String)p_88084_, (String)p_88085_));
                });
            }
        }
    }

    class BackupInfoListEntry
    extends ObjectSelectionList.Entry<BackupInfoListEntry> {
        private final String key;
        private final String value;

        public BackupInfoListEntry(String p_88091_, String p_88092_) {
            this.key = p_88091_;
            this.value = p_88092_;
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            Font font = ((RealmsBackupInfoScreen)RealmsBackupInfoScreen.this).minecraft.font;
            GuiComponent.drawString(pPoseStack, font, this.key, pLeft, pTop, 0xA0A0A0);
            GuiComponent.drawString(pPoseStack, font, RealmsBackupInfoScreen.this.checkForSpecificMetadata(this.key, this.value), pLeft, pTop + 12, 0xFFFFFF);
        }

        @Override
        public Component getNarration() {
            return new TranslatableComponent("narrator.select", String.valueOf(this.key) + " " + this.value);
        }
    }
}

