/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.realmsclient.exception.RealmsServiceException;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.realms.RealmsScreen;

public class RealmsGenericErrorScreen
extends RealmsScreen {
    private final Screen nextScreen;
    private final Pair<Component, Component> lines;
    private MultiLineLabel line2Split = MultiLineLabel.EMPTY;

    public RealmsGenericErrorScreen(RealmsServiceException pServiceException, Screen pNextScreen) {
        super(NarratorChatListener.NO_TITLE);
        this.nextScreen = pNextScreen;
        this.lines = RealmsGenericErrorScreen.errorMessage(pServiceException);
    }

    public RealmsGenericErrorScreen(Component pServiceException, Screen pNextScreen) {
        super(NarratorChatListener.NO_TITLE);
        this.nextScreen = pNextScreen;
        this.lines = RealmsGenericErrorScreen.errorMessage(pServiceException);
    }

    public RealmsGenericErrorScreen(Component pLine1, Component pLine2, Screen pNextScreen) {
        super(NarratorChatListener.NO_TITLE);
        this.nextScreen = pNextScreen;
        this.lines = RealmsGenericErrorScreen.errorMessage(pLine1, pLine2);
    }

    private static Pair<Component, Component> errorMessage(RealmsServiceException p_200950_) {
        if (p_200950_.realmsError == null) {
            return Pair.of((Object)new TextComponent("An error occurred (" + p_200950_.httpResultCode + "):"), (Object)new TextComponent(p_200950_.rawResponse));
        }
        String s = "mco.errorMessage." + p_200950_.realmsError.getErrorCode();
        return Pair.of((Object)new TextComponent("Realms (" + p_200950_.realmsError + "):"), (Object)(I18n.exists(s) ? new TranslatableComponent(s) : Component.nullToEmpty(p_200950_.realmsError.getErrorMessage())));
    }

    private static Pair<Component, Component> errorMessage(Component p_200952_) {
        return Pair.of((Object)new TextComponent("An error occurred: "), (Object)p_200952_);
    }

    private static Pair<Component, Component> errorMessage(Component p_200954_, Component p_200955_) {
        return Pair.of((Object)p_200954_, (Object)p_200955_);
    }

    @Override
    public void init() {
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height - 52, 200, 20, new TextComponent("Ok"), p_88686_ -> this.minecraft.setScreen(this.nextScreen)));
        this.line2Split = MultiLineLabel.create(this.font, (FormattedText)this.lines.getSecond(), this.width * 3 / 4);
    }

    @Override
    public Component getNarrationMessage() {
        return new TextComponent("").append((Component)this.lines.getFirst()).append(": ").append((Component)this.lines.getSecond());
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        RealmsGenericErrorScreen.drawCenteredString(pPoseStack, this.font, (Component)this.lines.getFirst(), this.width / 2, 80, 0xFFFFFF);
        this.line2Split.renderCentered(pPoseStack, this.width / 2, 100, 9, 0xFF0000);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

