/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsPlayerScreen;
import javax.annotation.Nullable;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.realms.RealmsScreen;
import org.slf4j.Logger;

public class RealmsInviteScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component NAME_LABEL = new TranslatableComponent("mco.configure.world.invite.profile.name");
    private static final Component NO_SUCH_PLAYER_ERROR_TEXT = new TranslatableComponent("mco.configure.world.players.error");
    private EditBox profileName;
    private final RealmsServer serverData;
    private final RealmsConfigureWorldScreen configureScreen;
    private final Screen lastScreen;
    @Nullable
    private Component errorMsg;

    public RealmsInviteScreen(RealmsConfigureWorldScreen pConfigureScreen, Screen pLastScreen, RealmsServer pServerData) {
        super(NarratorChatListener.NO_TITLE);
        this.configureScreen = pConfigureScreen;
        this.lastScreen = pLastScreen;
        this.serverData = pServerData;
    }

    @Override
    public void tick() {
        this.profileName.tick();
    }

    @Override
    public void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.profileName = new EditBox(this.minecraft.font, this.width / 2 - 100, RealmsInviteScreen.row(2), 200, 20, null, new TranslatableComponent("mco.configure.world.invite.profile.name"));
        this.addWidget(this.profileName);
        this.setInitialFocus(this.profileName);
        this.addRenderableWidget(new Button(this.width / 2 - 100, RealmsInviteScreen.row(10), 200, 20, new TranslatableComponent("mco.configure.world.buttons.invite"), p_88721_ -> this.onInvite()));
        this.addRenderableWidget(new Button(this.width / 2 - 100, RealmsInviteScreen.row(12), 200, 20, CommonComponents.GUI_CANCEL, p_88716_ -> this.minecraft.setScreen(this.lastScreen)));
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    private void onInvite() {
        block5: {
            RealmsClient realmsclient = RealmsClient.create();
            if (this.profileName.getValue() != null && !this.profileName.getValue().isEmpty()) {
                try {
                    RealmsServer realmsserver = realmsclient.invite(this.serverData.id, this.profileName.getValue().trim());
                    if (realmsserver != null) {
                        this.serverData.players = realmsserver.players;
                        this.minecraft.setScreen(new RealmsPlayerScreen(this.configureScreen, this.serverData));
                        break block5;
                    }
                    this.showError(NO_SUCH_PLAYER_ERROR_TEXT);
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't invite user");
                    this.showError(NO_SUCH_PLAYER_ERROR_TEXT);
                }
            } else {
                this.showError(NO_SUCH_PLAYER_ERROR_TEXT);
            }
        }
    }

    private void showError(Component pErrorMsg) {
        this.errorMsg = pErrorMsg;
        NarratorChatListener.INSTANCE.sayNow(pErrorMsg);
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.setScreen(this.lastScreen);
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        this.font.draw(pPoseStack, NAME_LABEL, (float)(this.width / 2 - 100), (float)RealmsInviteScreen.row(1), 0xA0A0A0);
        if (this.errorMsg != null) {
            RealmsInviteScreen.drawCenteredString(pPoseStack, this.font, this.errorMsg, this.width / 2, RealmsInviteScreen.row(5), 0xFF0000);
        }
        this.profileName.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

