/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.PendingInvite;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RowButton;
import com.mojang.realmsclient.util.RealmsTextureManager;
import com.mojang.realmsclient.util.RealmsUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class RealmsPendingInvitesScreen
extends RealmsScreen {
    static final Logger LOGGER = LogUtils.getLogger();
    static final ResourceLocation ACCEPT_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/accept_icon.png");
    static final ResourceLocation REJECT_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/reject_icon.png");
    private static final Component NO_PENDING_INVITES_TEXT = new TranslatableComponent("mco.invites.nopending");
    static final Component ACCEPT_INVITE_TOOLTIP = new TranslatableComponent("mco.invites.button.accept");
    static final Component REJECT_INVITE_TOOLTIP = new TranslatableComponent("mco.invites.button.reject");
    private final Screen lastScreen;
    @Nullable
    Component toolTip;
    boolean loaded;
    PendingInvitationSelectionList pendingInvitationSelectionList;
    int selectedInvite = -1;
    private Button acceptButton;
    private Button rejectButton;

    public RealmsPendingInvitesScreen(Screen pLastScreen) {
        super(new TranslatableComponent("mco.invites.title"));
        this.lastScreen = pLastScreen;
    }

    @Override
    public void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.pendingInvitationSelectionList = new PendingInvitationSelectionList();
        new Thread("Realms-pending-invitations-fetcher"){

            @Override
            public void run() {
                RealmsClient realmsclient = RealmsClient.create();
                try {
                    try {
                        List<PendingInvite> list = realmsclient.pendingInvites().pendingInvites;
                        List list1 = list.stream().map(p_88969_ -> {
                            RealmsPendingInvitesScreen realmsPendingInvitesScreen = RealmsPendingInvitesScreen.this;
                            realmsPendingInvitesScreen.getClass();
                            return realmsPendingInvitesScreen.new Entry((PendingInvite)p_88969_);
                        }).collect(Collectors.toList());
                        RealmsPendingInvitesScreen.this.minecraft.execute(() -> RealmsPendingInvitesScreen.this.pendingInvitationSelectionList.replaceEntries(list1));
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        LOGGER.error("Couldn't list invites");
                        RealmsPendingInvitesScreen.this.loaded = true;
                    }
                }
                finally {
                    RealmsPendingInvitesScreen.this.loaded = true;
                }
            }
        }.start();
        this.addWidget(this.pendingInvitationSelectionList);
        this.acceptButton = this.addRenderableWidget(new Button(this.width / 2 - 174, this.height - 32, 100, 20, new TranslatableComponent("mco.invites.button.accept"), p_88940_ -> {
            this.accept(this.selectedInvite);
            this.selectedInvite = -1;
            this.updateButtonStates();
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 50, this.height - 32, 100, 20, CommonComponents.GUI_DONE, p_88930_ -> this.minecraft.setScreen(new RealmsMainScreen(this.lastScreen))));
        this.rejectButton = this.addRenderableWidget(new Button(this.width / 2 + 74, this.height - 32, 100, 20, new TranslatableComponent("mco.invites.button.reject"), p_88920_ -> {
            this.reject(this.selectedInvite);
            this.selectedInvite = -1;
            this.updateButtonStates();
        }));
        this.updateButtonStates();
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.setScreen(new RealmsMainScreen(this.lastScreen));
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    void updateList(int p_88893_) {
        this.pendingInvitationSelectionList.removeAtIndex(p_88893_);
    }

    void reject(int p_88923_) {
        if (p_88923_ < this.pendingInvitationSelectionList.getItemCount()) {
            new Thread("Realms-reject-invitation"){

                @Override
                public void run() {
                    try {
                        RealmsClient realmsclient = RealmsClient.create();
                        realmsclient.rejectInvitation(((Entry)RealmsPendingInvitesScreen.this.pendingInvitationSelectionList.children().get((int)p_88923_)).pendingInvite.invitationId);
                        RealmsPendingInvitesScreen.this.minecraft.execute(() -> RealmsPendingInvitesScreen.this.updateList(p_88923_));
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        LOGGER.error("Couldn't reject invite");
                    }
                }
            }.start();
        }
    }

    void accept(int p_88933_) {
        if (p_88933_ < this.pendingInvitationSelectionList.getItemCount()) {
            new Thread("Realms-accept-invitation"){

                @Override
                public void run() {
                    try {
                        RealmsClient realmsclient = RealmsClient.create();
                        realmsclient.acceptInvitation(((Entry)RealmsPendingInvitesScreen.this.pendingInvitationSelectionList.children().get((int)p_88933_)).pendingInvite.invitationId);
                        RealmsPendingInvitesScreen.this.minecraft.execute(() -> RealmsPendingInvitesScreen.this.updateList(p_88933_));
                    }
                    catch (RealmsServiceException realmsserviceexception) {
                        LOGGER.error("Couldn't accept invite");
                    }
                }
            }.start();
        }
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.toolTip = null;
        this.renderBackground(pPoseStack);
        this.pendingInvitationSelectionList.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        RealmsPendingInvitesScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 12, 0xFFFFFF);
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(pPoseStack, this.toolTip, pMouseX, pMouseY);
        }
        if (this.pendingInvitationSelectionList.getItemCount() == 0 && this.loaded) {
            RealmsPendingInvitesScreen.drawCenteredString(pPoseStack, this.font, NO_PENDING_INVITES_TEXT, this.width / 2, this.height / 2 - 20, 0xFFFFFF);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderMousehoverTooltip(PoseStack pPoseStack, @Nullable Component pToolTip, int pMouseX, int pMouseY) {
        if (pToolTip != null) {
            int i = pMouseX + 12;
            int j = pMouseY - 12;
            int k = this.font.width(pToolTip);
            this.fillGradient(pPoseStack, i - 3, j - 3, i + k + 3, j + 8 + 3, -1073741824, -1073741824);
            this.font.drawShadow(pPoseStack, pToolTip, (float)i, (float)j, 0xFFFFFF);
        }
    }

    void updateButtonStates() {
        this.acceptButton.visible = this.shouldAcceptAndRejectButtonBeVisible(this.selectedInvite);
        this.rejectButton.visible = this.shouldAcceptAndRejectButtonBeVisible(this.selectedInvite);
    }

    private boolean shouldAcceptAndRejectButtonBeVisible(int p_88963_) {
        return p_88963_ != -1;
    }

    class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private static final int TEXT_LEFT = 38;
        final PendingInvite pendingInvite;
        private final List<RowButton> rowButtons;

        Entry(PendingInvite p_88996_) {
            this.pendingInvite = p_88996_;
            this.rowButtons = Arrays.asList(new AcceptRowButton(), new RejectRowButton());
        }

        @Override
        public void render(PoseStack p_89006_, int p_89007_, int p_89008_, int p_89009_, int p_89010_, int p_89011_, int p_89012_, int p_89013_, boolean p_89014_, float p_89015_) {
            this.renderPendingInvitationItem(p_89006_, this.pendingInvite, p_89009_, p_89008_, p_89012_, p_89013_);
        }

        @Override
        public boolean mouseClicked(double p_88998_, double p_88999_, int p_89000_) {
            RowButton.rowButtonMouseClicked(RealmsPendingInvitesScreen.this.pendingInvitationSelectionList, this, this.rowButtons, p_89000_, p_88998_, p_88999_);
            return true;
        }

        private void renderPendingInvitationItem(PoseStack p_89017_, PendingInvite p_89018_, int p_89019_, int p_89020_, int p_89021_, int p_89022_) {
            RealmsPendingInvitesScreen.this.font.draw(p_89017_, p_89018_.worldName, (float)(p_89019_ + 38), (float)(p_89020_ + 1), 0xFFFFFF);
            RealmsPendingInvitesScreen.this.font.draw(p_89017_, p_89018_.worldOwnerName, (float)(p_89019_ + 38), (float)(p_89020_ + 12), 0x6C6C6C);
            RealmsPendingInvitesScreen.this.font.draw(p_89017_, RealmsUtil.convertToAgePresentationFromInstant(p_89018_.date), (float)(p_89019_ + 38), (float)(p_89020_ + 24), 0x6C6C6C);
            RowButton.drawButtonsInRow(p_89017_, this.rowButtons, RealmsPendingInvitesScreen.this.pendingInvitationSelectionList, p_89019_, p_89020_, p_89021_, p_89022_);
            RealmsTextureManager.withBoundFace(p_89018_.worldOwnerUuid, () -> {
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                GuiComponent.blit(p_89017_, p_89019_, p_89020_, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                GuiComponent.blit(p_89017_, p_89019_, p_89020_, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
            });
        }

        @Override
        public Component getNarration() {
            Component component = CommonComponents.a(new TextComponent(this.pendingInvite.worldName), new TextComponent(this.pendingInvite.worldOwnerName), new TextComponent(RealmsUtil.convertToAgePresentationFromInstant(this.pendingInvite.date)));
            return new TranslatableComponent("narrator.select", component);
        }

        class AcceptRowButton
        extends RowButton {
            AcceptRowButton() {
                super(15, 15, 215, 5);
            }

            @Override
            protected void draw(PoseStack p_89031_, int p_89032_, int p_89033_, boolean p_89034_) {
                RenderSystem.setShaderTexture(0, ACCEPT_ICON_LOCATION);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                float f = p_89034_ ? 19.0f : 0.0f;
                GuiComponent.blit(p_89031_, p_89032_, p_89033_, f, 0.0f, 18, 18, 37, 18);
                if (p_89034_) {
                    ((Entry)Entry.this).RealmsPendingInvitesScreen.this.toolTip = ACCEPT_INVITE_TOOLTIP;
                }
            }

            @Override
            public void onClick(int p_89029_) {
                RealmsPendingInvitesScreen.this.accept(p_89029_);
            }
        }

        class RejectRowButton
        extends RowButton {
            RejectRowButton() {
                super(15, 15, 235, 5);
            }

            @Override
            protected void draw(PoseStack p_89041_, int p_89042_, int p_89043_, boolean p_89044_) {
                RenderSystem.setShaderTexture(0, REJECT_ICON_LOCATION);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                float f = p_89044_ ? 19.0f : 0.0f;
                GuiComponent.blit(p_89041_, p_89042_, p_89043_, f, 0.0f, 18, 18, 37, 18);
                if (p_89044_) {
                    ((Entry)Entry.this).RealmsPendingInvitesScreen.this.toolTip = REJECT_INVITE_TOOLTIP;
                }
            }

            @Override
            public void onClick(int p_89039_) {
                RealmsPendingInvitesScreen.this.reject(p_89039_);
            }
        }
    }

    class PendingInvitationSelectionList
    extends RealmsObjectSelectionList<Entry> {
        public PendingInvitationSelectionList() {
            super(RealmsPendingInvitesScreen.this.width, RealmsPendingInvitesScreen.this.height, 32, RealmsPendingInvitesScreen.this.height - 40, 36);
        }

        public void removeAtIndex(int p_89058_) {
            this.remove(p_89058_);
        }

        @Override
        public int getMaxPosition() {
            return this.getItemCount() * 36;
        }

        @Override
        public int getRowWidth() {
            return 260;
        }

        @Override
        public boolean isFocused() {
            return RealmsPendingInvitesScreen.this.getFocused() == this;
        }

        @Override
        public void renderBackground(PoseStack p_89051_) {
            RealmsPendingInvitesScreen.this.renderBackground(p_89051_);
        }

        @Override
        public void selectItem(int p_89049_) {
            super.selectItem(p_89049_);
            this.selectInviteListItem(p_89049_);
        }

        public void selectInviteListItem(int p_89061_) {
            RealmsPendingInvitesScreen.this.selectedInvite = p_89061_;
            RealmsPendingInvitesScreen.this.updateButtonStates();
        }

        @Override
        public void setSelected(@Nullable Entry p_89053_) {
            super.setSelected(p_89053_);
            RealmsPendingInvitesScreen.this.selectedInvite = this.children().indexOf(p_89053_);
            RealmsPendingInvitesScreen.this.updateButtonStates();
        }
    }
}

