/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.realmsclient.util.LevelType;
import com.mojang.realmsclient.util.WorldGenerationInfo;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.realms.RealmsScreen;

public class RealmsResetNormalWorldScreen
extends RealmsScreen {
    private static final Component SEED_LABEL = new TranslatableComponent("mco.reset.world.seed");
    private final Consumer<WorldGenerationInfo> callback;
    private EditBox seedEdit;
    private LevelType levelType = LevelType.DEFAULT;
    private boolean generateStructures = true;
    private final Component buttonTitle;

    public RealmsResetNormalWorldScreen(Consumer<WorldGenerationInfo> pCallback, Component pButtonTitle) {
        super(new TranslatableComponent("mco.reset.world.generate"));
        this.callback = pCallback;
        this.buttonTitle = pButtonTitle;
    }

    @Override
    public void tick() {
        this.seedEdit.tick();
        super.tick();
    }

    @Override
    public void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.seedEdit = new EditBox(this.minecraft.font, this.width / 2 - 100, RealmsResetNormalWorldScreen.row(2), 200, 20, null, new TranslatableComponent("mco.reset.world.seed"));
        this.seedEdit.setMaxLength(32);
        this.addWidget(this.seedEdit);
        this.setInitialFocus(this.seedEdit);
        this.addRenderableWidget(CycleButton.builder(LevelType::getName).a((LevelType[])LevelType.values()).withInitialValue(this.levelType).create(this.width / 2 - 102, RealmsResetNormalWorldScreen.row(4), 205, 20, new TranslatableComponent("selectWorld.mapType"), (p_167441_, p_167442_) -> {
            this.levelType = p_167442_;
        }));
        this.addRenderableWidget(CycleButton.onOffBuilder(this.generateStructures).create(this.width / 2 - 102, RealmsResetNormalWorldScreen.row(6) - 2, 205, 20, new TranslatableComponent("selectWorld.mapFeatures"), (p_167444_, p_167445_) -> {
            this.generateStructures = p_167445_;
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 102, RealmsResetNormalWorldScreen.row(12), 97, 20, this.buttonTitle, p_89291_ -> this.callback.accept(new WorldGenerationInfo(this.seedEdit.getValue(), this.levelType, this.generateStructures))));
        this.addRenderableWidget(new Button(this.width / 2 + 8, RealmsResetNormalWorldScreen.row(12), 97, 20, CommonComponents.GUI_BACK, p_89288_ -> this.onClose()));
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    @Override
    public void onClose() {
        this.callback.accept(null);
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        RealmsResetNormalWorldScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 17, 0xFFFFFF);
        this.font.draw(pPoseStack, SEED_LABEL, (float)(this.width / 2 - 100), (float)RealmsResetNormalWorldScreen.row(1), 0xA0A0A0);
        this.seedEdit.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

