/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.google.gson.annotations.SerializedName;
import com.mojang.realmsclient.dto.GuardedSerializer;
import com.mojang.realmsclient.dto.ReflectionBasedSerialization;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class RealmsPersistence {
    private static final String FILE_NAME = "realms_persistence.json";
    private static final GuardedSerializer GSON = new GuardedSerializer();

    public RealmsPersistenceData read() {
        return RealmsPersistence.readFile();
    }

    public void save(RealmsPersistenceData pPersistenceData) {
        RealmsPersistence.writeFile(pPersistenceData);
    }

    public static RealmsPersistenceData readFile() {
        File file1 = RealmsPersistence.getPathToData();
        try {
            String s = FileUtils.readFileToString((File)file1, (Charset)StandardCharsets.UTF_8);
            RealmsPersistenceData realmspersistence$realmspersistencedata = GSON.fromJson(s, RealmsPersistenceData.class);
            return realmspersistence$realmspersistencedata != null ? realmspersistence$realmspersistencedata : new RealmsPersistenceData();
        }
        catch (IOException ioexception) {
            return new RealmsPersistenceData();
        }
    }

    public static void writeFile(RealmsPersistenceData pPersistenceData) {
        File file1 = RealmsPersistence.getPathToData();
        try {
            FileUtils.writeStringToFile((File)file1, (String)GSON.toJson(pPersistenceData), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File getPathToData() {
        return new File(Minecraft.getInstance().gameDirectory, FILE_NAME);
    }

    public static class RealmsPersistenceData
    implements ReflectionBasedSerialization {
        @SerializedName(value="newsLink")
        public String newsLink;
        @SerializedName(value="hasUnreadNews")
        public boolean hasUnreadNews;
    }
}

