/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.annotation.Nullable;

public class SkinProcessor {
    private int[] pixels;
    private int width;
    private int height;

    @Nullable
    public BufferedImage process(@Nullable BufferedImage pSkinTexture) {
        boolean flag;
        if (pSkinTexture == null) {
            return null;
        }
        this.width = 64;
        this.height = 64;
        BufferedImage bufferedimage = new BufferedImage(this.width, this.height, 2);
        Graphics graphics = bufferedimage.getGraphics();
        graphics.drawImage(pSkinTexture, 0, 0, null);
        boolean bl = flag = pSkinTexture.getHeight() == 32;
        if (flag) {
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 32, 64, 32);
            graphics.drawImage(bufferedimage, 24, 48, 20, 52, 4, 16, 8, 20, null);
            graphics.drawImage(bufferedimage, 28, 48, 24, 52, 8, 16, 12, 20, null);
            graphics.drawImage(bufferedimage, 20, 52, 16, 64, 8, 20, 12, 32, null);
            graphics.drawImage(bufferedimage, 24, 52, 20, 64, 4, 20, 8, 32, null);
            graphics.drawImage(bufferedimage, 28, 52, 24, 64, 0, 20, 4, 32, null);
            graphics.drawImage(bufferedimage, 32, 52, 28, 64, 12, 20, 16, 32, null);
            graphics.drawImage(bufferedimage, 40, 48, 36, 52, 44, 16, 48, 20, null);
            graphics.drawImage(bufferedimage, 44, 48, 40, 52, 48, 16, 52, 20, null);
            graphics.drawImage(bufferedimage, 36, 52, 32, 64, 48, 20, 52, 32, null);
            graphics.drawImage(bufferedimage, 40, 52, 36, 64, 44, 20, 48, 32, null);
            graphics.drawImage(bufferedimage, 44, 52, 40, 64, 40, 20, 44, 32, null);
            graphics.drawImage(bufferedimage, 48, 52, 44, 64, 52, 20, 56, 32, null);
        }
        graphics.dispose();
        this.pixels = ((DataBufferInt)bufferedimage.getRaster().getDataBuffer()).getData();
        this.setNoAlpha(0, 0, 32, 16);
        if (flag) {
            this.doLegacyTransparencyHack(32, 0, 64, 32);
        }
        this.setNoAlpha(0, 16, 64, 32);
        this.setNoAlpha(16, 48, 48, 64);
        return bufferedimage;
    }

    private void doLegacyTransparencyHack(int p_90237_, int p_90238_, int p_90239_, int p_90240_) {
        int i = p_90237_;
        while (i < p_90239_) {
            int j = p_90238_;
            while (j < p_90240_) {
                int k = this.pixels[i + j * this.width];
                if ((k >> 24 & 0xFF) < 128) {
                    return;
                }
                ++j;
            }
            ++i;
        }
        int l = p_90237_;
        while (l < p_90239_) {
            int i1 = p_90238_;
            while (i1 < p_90240_) {
                int n = l + i1 * this.width;
                this.pixels[n] = this.pixels[n] & 0xFFFFFF;
                ++i1;
            }
            ++l;
        }
    }

    private void setNoAlpha(int p_90244_, int p_90245_, int p_90246_, int p_90247_) {
        int i = p_90244_;
        while (i < p_90246_) {
            int j = p_90245_;
            while (j < p_90247_) {
                int n = i + j * this.width;
                this.pixels[n] = this.pixels[n] | 0xFF000000;
                ++j;
            }
            ++i;
        }
    }
}

