/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TextRenderingUtils {
    private TextRenderingUtils() {
    }

    @VisibleForTesting
    protected static List<String> lineBreak(String p_90249_) {
        return Arrays.asList(p_90249_.split("\\n"));
    }

    public static List<Line> a(String p_90257_, LineSegment ... p_90258_) {
        return TextRenderingUtils.decompose(p_90257_, Arrays.asList(p_90258_));
    }

    private static List<Line> decompose(String p_90254_, List<LineSegment> p_90255_) {
        List<String> list = TextRenderingUtils.lineBreak(p_90254_);
        return TextRenderingUtils.insertLinks(list, p_90255_);
    }

    private static List<Line> insertLinks(List<String> p_90260_, List<LineSegment> p_90261_) {
        int i = 0;
        ArrayList list = Lists.newArrayList();
        for (String s : p_90260_) {
            ArrayList list1 = Lists.newArrayList();
            for (String s1 : TextRenderingUtils.split(s, "%link")) {
                if ("%link".equals(s1)) {
                    list1.add(p_90261_.get(i++));
                    continue;
                }
                list1.add(LineSegment.text(s1));
            }
            list.add(new Line(list1));
        }
        return list;
    }

    public static List<String> split(String pToSplit, String pDelimiter) {
        int j;
        if (pDelimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter cannot be the empty string");
        }
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while ((j = pToSplit.indexOf(pDelimiter, i)) != -1) {
            if (j > i) {
                list.add(pToSplit.substring(i, j));
            }
            list.add(pDelimiter);
            i = j + pDelimiter.length();
        }
        if (i < pToSplit.length()) {
            list.add(pToSplit.substring(i));
        }
        return list;
    }

    public static class Line {
        public final List<LineSegment> segments;

        Line(LineSegment ... p_167625_) {
            this(Arrays.asList(p_167625_));
        }

        Line(List<LineSegment> p_90264_) {
            this.segments = p_90264_;
        }

        public String toString() {
            return "Line{segments=" + this.segments + "}";
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther != null && this.getClass() == pOther.getClass()) {
                Line textrenderingutils$line = (Line)pOther;
                return Objects.equals(this.segments, textrenderingutils$line.segments);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.segments);
        }
    }

    public static class LineSegment {
        private final String fullText;
        @Nullable
        private final String linkTitle;
        @Nullable
        private final String linkUrl;

        private LineSegment(String p_90273_) {
            this.fullText = p_90273_;
            this.linkTitle = null;
            this.linkUrl = null;
        }

        private LineSegment(String p_90275_, @Nullable String p_90276_, @Nullable String p_90277_) {
            this.fullText = p_90275_;
            this.linkTitle = p_90276_;
            this.linkUrl = p_90277_;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther != null && this.getClass() == pOther.getClass()) {
                LineSegment textrenderingutils$linesegment = (LineSegment)pOther;
                return Objects.equals(this.fullText, textrenderingutils$linesegment.fullText) && Objects.equals(this.linkTitle, textrenderingutils$linesegment.linkTitle) && Objects.equals(this.linkUrl, textrenderingutils$linesegment.linkUrl);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.fullText, this.linkTitle, this.linkUrl);
        }

        public String toString() {
            return "Segment{fullText='" + this.fullText + "', linkTitle='" + this.linkTitle + "', linkUrl='" + this.linkUrl + "'}";
        }

        public String renderedText() {
            return this.isLink() ? this.linkTitle : this.fullText;
        }

        public boolean isLink() {
            return this.linkTitle != null;
        }

        public String getLinkUrl() {
            if (!this.isLink()) {
                throw new IllegalStateException("Not a link: " + this);
            }
            return this.linkUrl;
        }

        public static LineSegment link(String p_90282_, String p_90283_) {
            return new LineSegment(null, p_90282_, p_90283_);
        }

        @VisibleForTesting
        protected static LineSegment text(String p_90280_) {
            return new LineSegment(p_90280_);
        }
    }
}

