/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util.task;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.util.task.LongRunningTask;
import net.minecraft.network.chat.TranslatableComponent;
import org.slf4j.Logger;

public class CloseServerTask
extends LongRunningTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RealmsServer serverData;
    private final RealmsConfigureWorldScreen configureScreen;

    public CloseServerTask(RealmsServer pServerData, RealmsConfigureWorldScreen pConfigureScreen) {
        this.serverData = pServerData;
        this.configureScreen = pConfigureScreen;
    }

    @Override
    public void run() {
        this.setTitle(new TranslatableComponent("mco.configure.world.closing"));
        RealmsClient realmsclient = RealmsClient.create();
        int i = 0;
        while (i < 25) {
            if (this.aborted()) {
                return;
            }
            try {
                boolean flag = realmsclient.close(this.serverData.id);
                if (flag) {
                    this.configureScreen.stateChanged();
                    this.serverData.state = RealmsServer.State.CLOSED;
                    CloseServerTask.setScreen(this.configureScreen);
                    break;
                }
            }
            catch (RetryCallException retrycallexception) {
                if (this.aborted()) {
                    return;
                }
                CloseServerTask.pause(retrycallexception.delaySeconds);
            }
            catch (Exception exception) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Failed to close server", (Throwable)exception);
                this.error("Failed to close the server");
            }
            ++i;
        }
    }
}

