/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util.task;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerAddress;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.screens.RealmsBrokenWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsTermsScreen;
import com.mojang.realmsclient.util.task.ConnectTask;
import com.mojang.realmsclient.util.task.LongRunningTask;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.slf4j.Logger;

public class GetServerDetailsTask
extends LongRunningTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RealmsServer server;
    private final Screen lastScreen;
    private final RealmsMainScreen mainScreen;
    private final ReentrantLock connectLock;

    public GetServerDetailsTask(RealmsMainScreen pMainScreen, Screen pLastScreen, RealmsServer pServer, ReentrantLock pConnectLock) {
        this.lastScreen = pLastScreen;
        this.mainScreen = pMainScreen;
        this.server = pServer;
        this.connectLock = pConnectLock;
    }

    @Override
    public void run() {
        RealmsServerAddress realmsserveraddress;
        this.setTitle(new TranslatableComponent("mco.connect.connecting"));
        try {
            realmsserveraddress = this.fetchServerAddress();
        }
        catch (CancellationException cancellationexception) {
            LOGGER.info("User aborted connecting to realms");
            return;
        }
        catch (RealmsServiceException realmsserviceexception) {
            switch (realmsserviceexception.realmsErrorCodeOrDefault(-1)) {
                case 6002: {
                    GetServerDetailsTask.setScreen(new RealmsTermsScreen(this.lastScreen, this.mainScreen, this.server));
                    return;
                }
                case 6006: {
                    boolean flag1 = this.server.ownerUUID.equals(Minecraft.getInstance().getUser().getUuid());
                    GetServerDetailsTask.setScreen(flag1 ? new RealmsBrokenWorldScreen(this.lastScreen, this.mainScreen, this.server.id, this.server.worldType == RealmsServer.WorldType.MINIGAME) : new RealmsGenericErrorScreen(new TranslatableComponent("mco.brokenworld.nonowner.title"), new TranslatableComponent("mco.brokenworld.nonowner.error"), this.lastScreen));
                    return;
                }
            }
            this.error(realmsserviceexception.toString());
            LOGGER.error("Couldn't connect to world", (Throwable)realmsserviceexception);
            return;
        }
        catch (TimeoutException timeoutexception) {
            this.error(new TranslatableComponent("mco.errorMessage.connectionFailure"));
            return;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't connect to world", (Throwable)exception);
            this.error(exception.getLocalizedMessage());
            return;
        }
        boolean flag = realmsserveraddress.resourcePackUrl != null && realmsserveraddress.resourcePackHash != null;
        RealmsLongRunningMcoTaskScreen screen = flag ? this.resourcePackDownloadConfirmationScreen(realmsserveraddress, this::connectScreen) : this.connectScreen(realmsserveraddress);
        GetServerDetailsTask.setScreen(screen);
    }

    private RealmsServerAddress fetchServerAddress() throws RealmsServiceException, TimeoutException, CancellationException {
        RealmsClient realmsclient = RealmsClient.create();
        int i = 0;
        while (i < 40) {
            if (this.aborted()) {
                throw new CancellationException();
            }
            try {
                return realmsclient.join(this.server.id);
            }
            catch (RetryCallException retrycallexception) {
                GetServerDetailsTask.pause(retrycallexception.delaySeconds);
                ++i;
            }
        }
        throw new TimeoutException();
    }

    public RealmsLongRunningMcoTaskScreen connectScreen(RealmsServerAddress p_167638_) {
        return new RealmsLongRunningMcoTaskScreen(this.lastScreen, new ConnectTask(this.lastScreen, this.server, p_167638_));
    }

    private RealmsLongConfirmationScreen resourcePackDownloadConfirmationScreen(RealmsServerAddress p_167640_, Function<RealmsServerAddress, Screen> p_167641_) {
        BooleanConsumer booleanconsumer = p_167645_ -> {
            try {
                if (p_167645_) {
                    ((CompletableFuture)this.scheduleResourcePackDownload(p_167640_).thenRun(() -> GetServerDetailsTask.setScreen((Screen)p_167641_.apply(p_167640_)))).exceptionally(p_202341_ -> {
                        Minecraft.getInstance().getClientPackSource().clearServerPack();
                        LOGGER.error("Failed to download resource pack from {}", (Object)p_167640_, p_202341_);
                        GetServerDetailsTask.setScreen(new RealmsGenericErrorScreen(new TextComponent("Failed to download resource pack!"), this.lastScreen));
                        return null;
                    });
                    return;
                }
                GetServerDetailsTask.setScreen(this.lastScreen);
            }
            finally {
                if (this.connectLock.isHeldByCurrentThread()) {
                    this.connectLock.unlock();
                }
            }
        };
        return new RealmsLongConfirmationScreen(booleanconsumer, RealmsLongConfirmationScreen.Type.Info, new TranslatableComponent("mco.configure.world.resourcepack.question.line1"), new TranslatableComponent("mco.configure.world.resourcepack.question.line2"), true);
    }

    private CompletableFuture<?> scheduleResourcePackDownload(RealmsServerAddress pServerAddress) {
        try {
            return Minecraft.getInstance().getClientPackSource().downloadAndSelectResourcePack(pServerAddress.resourcePackUrl, pServerAddress.resourcePackHash, false);
        }
        catch (Exception exception) {
            CompletableFuture completablefuture = new CompletableFuture();
            completablefuture.completeExceptionally(exception);
            return completablefuture;
        }
    }
}

