/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util.task;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.util.task.LongRunningTask;
import net.minecraft.network.chat.TranslatableComponent;
import org.slf4j.Logger;

public class SwitchSlotTask
extends LongRunningTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long worldId;
    private final int slot;
    private final Runnable callback;

    public SwitchSlotTask(long pWorldId, int p_90460_, Runnable pSlot) {
        this.worldId = pWorldId;
        this.slot = p_90460_;
        this.callback = pSlot;
    }

    @Override
    public void run() {
        RealmsClient realmsclient = RealmsClient.create();
        this.setTitle(new TranslatableComponent("mco.minigame.world.slot.screen.title"));
        int i = 0;
        while (i < 25) {
            try {
                if (this.aborted()) {
                    return;
                }
                if (realmsclient.switchSlot(this.worldId, this.slot)) {
                    this.callback.run();
                    break;
                }
            }
            catch (RetryCallException retrycallexception) {
                if (this.aborted()) {
                    return;
                }
                SwitchSlotTask.pause(retrycallexception.delaySeconds);
            }
            catch (Exception exception) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't switch world!");
                this.error(exception.toString());
            }
            ++i;
        }
    }
}

