/*
 * Decompiled with CFR 0.152.
 */
package hu.dominikhun250.diamondclient;

import net.arikia.dev.drpc.DiscordEventHandlers;
import net.arikia.dev.drpc.DiscordRPC;
import net.arikia.dev.drpc.DiscordRichPresence;
import net.arikia.dev.drpc.DiscordUser;
import net.arikia.dev.drpc.callbacks.ReadyCallback;

public class DiscordRPCHandler {
    private static final String APPLICATION_ID = "1256319857004384276";
    private static boolean running = false;
    private static Thread callbackThread;

    public static void start() {
        if (running) {
            return;
        }
        try {
            DiscordEventHandlers handlers = new DiscordEventHandlers.Builder().setReadyEventHandler(new ReadyCallback(){

                @Override
                public void apply(DiscordUser user) {
                    System.out.println("[DiamondClient] Discord RPC connected to: " + user.username);
                }
            }).build();
            DiscordRPC.discordInitialize(APPLICATION_ID, handlers, true);
            DiscordRichPresence presence = new DiscordRichPresence.Builder("Minecraft 1.18.2").setDetails("Made by: Dominikhun250").setStartTimestamps(System.currentTimeMillis() / 1000L).setBigImage("mc", "DiamondClient").build();
            DiscordRPC.discordUpdatePresence(presence);
            callbackThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        DiscordRPC.discordRunCallbacks();
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        System.err.println("[DiamondClient] Discord RPC callback error:");
                        e.printStackTrace();
                        break;
                    }
                }
            }, "Discord-RPC-Callback");
            callbackThread.setDaemon(true);
            callbackThread.start();
            running = true;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("[DiamondClient] Discord not detected - RPC disabled");
        }
        catch (Exception e) {
            System.err.println("[DiamondClient] Failed to initialize Discord RPC:");
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        if (!running) {
            return;
        }
        try {
            try {
                DiscordRPC.discordShutdown();
                if (callbackThread != null) {
                    callbackThread.interrupt();
                }
            }
            catch (Exception e) {
                System.err.println("[DiamondClient] Error while shutting down Discord RPC:");
                e.printStackTrace();
                running = false;
            }
        }
        finally {
            running = false;
        }
    }

    public static void updatePresence(String details, String state) {
        if (!running) {
            return;
        }
        try {
            DiscordRichPresence presence = new DiscordRichPresence.Builder(state).setDetails(details).setStartTimestamps(System.currentTimeMillis() / 1000L).setBigImage("mc", "DiamondClient").build();
            DiscordRPC.discordUpdatePresence(presence);
        }
        catch (Exception e) {
            System.err.println("[DiamondClient] Failed to update Discord RPC:");
            e.printStackTrace();
        }
    }
}

