/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUtil {
    public static FoundRectangle getLargestRectangleAround(BlockPos pCenterPos, Direction.Axis pAxis1, int pMax1, Direction.Axis pAxis2, int pMax2, Predicate<BlockPos> pPosPredicate) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pCenterPos.mutable();
        Direction direction = Direction.get(Direction.AxisDirection.NEGATIVE, pAxis1);
        Direction direction1 = direction.getOpposite();
        Direction direction2 = Direction.get(Direction.AxisDirection.NEGATIVE, pAxis2);
        Direction direction3 = direction2.getOpposite();
        int i = BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos), direction, pMax1);
        int j = BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos), direction1, pMax1);
        int k = i;
        IntBounds[] ablockutil$intbounds = new IntBounds[i + 1 + j];
        ablockutil$intbounds[i] = new IntBounds(BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos), direction2, pMax2), BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos), direction3, pMax2));
        int l = ablockutil$intbounds[i].min;
        int i1 = 1;
        while (i1 <= i) {
            IntBounds blockutil$intbounds = ablockutil$intbounds[k - (i1 - 1)];
            ablockutil$intbounds[k - i1] = new IntBounds(BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos).move(direction, i1), direction2, blockutil$intbounds.min), BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos).move(direction, i1), direction3, blockutil$intbounds.max));
            ++i1;
        }
        int l2 = 1;
        while (l2 <= j) {
            IntBounds blockutil$intbounds2 = ablockutil$intbounds[k + l2 - 1];
            ablockutil$intbounds[k + l2] = new IntBounds(BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos).move(direction1, l2), direction2, blockutil$intbounds2.min), BlockUtil.getLimit(pPosPredicate, blockpos$mutableblockpos.set(pCenterPos).move(direction1, l2), direction3, blockutil$intbounds2.max));
            ++l2;
        }
        int i3 = 0;
        int j3 = 0;
        int j1 = 0;
        int k1 = 0;
        int[] aint = new int[ablockutil$intbounds.length];
        int l1 = l;
        while (l1 >= 0) {
            int i2 = 0;
            while (i2 < ablockutil$intbounds.length) {
                IntBounds blockutil$intbounds1 = ablockutil$intbounds[i2];
                int j2 = l - blockutil$intbounds1.min;
                int k2 = l + blockutil$intbounds1.max;
                aint[i2] = l1 >= j2 && l1 <= k2 ? k2 + 1 - l1 : 0;
                ++i2;
            }
            Pair<IntBounds, Integer> pair = BlockUtil.a(aint);
            IntBounds blockutil$intbounds3 = (IntBounds)pair.getFirst();
            int k3 = 1 + blockutil$intbounds3.max - blockutil$intbounds3.min;
            int l3 = (Integer)pair.getSecond();
            if (k3 * l3 > j1 * k1) {
                i3 = blockutil$intbounds3.min;
                j3 = l1;
                j1 = k3;
                k1 = l3;
            }
            --l1;
        }
        return new FoundRectangle(pCenterPos.relative(pAxis1, i3 - k).relative(pAxis2, j3 - l), j1, k1);
    }

    private static int getLimit(Predicate<BlockPos> pPosPredicate, BlockPos.MutableBlockPos pCenterPos, Direction pDirection, int pMax) {
        int i = 0;
        while (i < pMax && pPosPredicate.test(pCenterPos.move(pDirection))) {
            ++i;
        }
        return i;
    }

    @VisibleForTesting
    static Pair<IntBounds, Integer> a(int[] p_124347_) {
        int i = 0;
        int j = 0;
        int k = 0;
        IntArrayList intstack = new IntArrayList();
        intstack.push(0);
        int l = 1;
        while (l <= p_124347_.length) {
            int i1 = l == p_124347_.length ? 0 : p_124347_[l];
            while (!intstack.isEmpty()) {
                int k1;
                int j1 = p_124347_[intstack.topInt()];
                if (i1 >= j1) {
                    intstack.push(l);
                    break;
                }
                intstack.popInt();
                int n = k1 = intstack.isEmpty() ? 0 : intstack.topInt() + 1;
                if (j1 * (l - k1) <= k * (j - i)) continue;
                j = l;
                i = k1;
                k = j1;
            }
            if (intstack.isEmpty()) {
                intstack.push(l);
            }
            ++l;
        }
        return new Pair((Object)new IntBounds(i, j - 1), (Object)k);
    }

    public static Optional<BlockPos> getTopConnectedBlock(BlockGetter pGetter, BlockPos pPos, Block pBaseBlock, Direction pDirection, Block pEndBlock) {
        BlockState blockstate;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        do {
            blockpos$mutableblockpos.move(pDirection);
        } while ((blockstate = pGetter.getBlockState(blockpos$mutableblockpos)).is(pBaseBlock));
        return blockstate.is(pEndBlock) ? Optional.of(blockpos$mutableblockpos) : Optional.empty();
    }

    public static class FoundRectangle {
        public final BlockPos minCorner;
        public final int axis1Size;
        public final int axis2Size;

        public FoundRectangle(BlockPos pMinCorner, int pAxis1Size, int pAxis2Size) {
            this.minCorner = pMinCorner;
            this.axis1Size = pAxis1Size;
            this.axis2Size = pAxis2Size;
        }
    }

    public static class IntBounds {
        public final int min;
        public final int max;

        public IntBounds(int pMin, int pMax) {
            this.min = pMin;
            this.max = pMax;
        }

        public String toString() {
            return "IntBounds{min=" + this.min + ", max=" + this.max + "}";
        }
    }
}

