/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum ChatFormatting {
    BLACK("BLACK", '0', 0, 0),
    DARK_BLUE("DARK_BLUE", '1', 1, 170),
    DARK_GREEN("DARK_GREEN", '2', 2, 43520),
    DARK_AQUA("DARK_AQUA", '3', 3, 43690),
    DARK_RED("DARK_RED", '4', 4, 0xAA0000),
    DARK_PURPLE("DARK_PURPLE", '5', 5, 0xAA00AA),
    GOLD("GOLD", '6', 6, 0xFFAA00),
    GRAY("GRAY", '7', 7, 0xAAAAAA),
    DARK_GRAY("DARK_GRAY", '8', 8, 0x555555),
    BLUE("BLUE", '9', 9, 0x5555FF),
    GREEN("GREEN", 'a', 10, 0x55FF55),
    AQUA("AQUA", 'b', 11, 0x55FFFF),
    RED("RED", 'c', 12, 0xFF5555),
    LIGHT_PURPLE("LIGHT_PURPLE", 'd', 13, 0xFF55FF),
    YELLOW("YELLOW", 'e', 14, 0xFFFF55),
    WHITE("WHITE", 'f', 15, 0xFFFFFF),
    OBFUSCATED("OBFUSCATED", 'k', true),
    BOLD("BOLD", 'l', true),
    STRIKETHROUGH("STRIKETHROUGH", 'm', true),
    UNDERLINE("UNDERLINE", 'n', true),
    ITALIC("ITALIC", 'o', true),
    RESET("RESET", 'r', -1, null);

    public static final char PREFIX_CODE = '\u00a7';
    private static final Map<String, ChatFormatting> FORMATTING_BY_NAME;
    private static final Pattern STRIP_FORMATTING_PATTERN;
    private final String name;
    private final char code;
    private final boolean isFormat;
    private final String toString;
    private final int id;
    @Nullable
    private final Integer color;

    static {
        FORMATTING_BY_NAME = Arrays.stream(ChatFormatting.values()).collect(Collectors.toMap(p_126660_ -> ChatFormatting.cleanName(p_126660_.name), p_126652_ -> p_126652_));
        STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }

    private static String cleanName(String pString) {
        return pString.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    private ChatFormatting(String p_126627_, char p_126628_, int p_126629_, Integer p_126630_) {
        this(p_126627_, p_126628_, false, p_126629_, p_126630_);
    }

    private ChatFormatting(String pName, char pCode, boolean pIsFormat) {
        this(pName, pCode, pIsFormat, -1, null);
    }

    private ChatFormatting(@Nullable String p_126640_, char p_126641_, boolean p_126642_, int p_126643_, Integer p_126644_) {
        this.name = p_126640_;
        this.code = p_126641_;
        this.isFormat = p_126642_;
        this.id = p_126643_;
        this.color = p_126644_;
        this.toString = "\u00a7" + p_126641_;
    }

    public char getChar() {
        return this.code;
    }

    public int getId() {
        return this.id;
    }

    public boolean isFormat() {
        return this.isFormat;
    }

    public boolean isColor() {
        return !this.isFormat && this != RESET;
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.toString;
    }

    @Nullable
    public static String stripFormatting(@Nullable String pText) {
        return pText == null ? null : STRIP_FORMATTING_PATTERN.matcher(pText).replaceAll("");
    }

    @Nullable
    public static ChatFormatting getByName(@Nullable String pFriendlyName) {
        return pFriendlyName == null ? null : FORMATTING_BY_NAME.get(ChatFormatting.cleanName(pFriendlyName));
    }

    @Nullable
    public static ChatFormatting getById(int pIndex) {
        if (pIndex < 0) {
            return RESET;
        }
        ChatFormatting[] chatFormattingArray = ChatFormatting.values();
        int n = chatFormattingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatFormatting chatformatting = chatFormattingArray[n2];
            if (chatformatting.getId() == pIndex) {
                return chatformatting;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static ChatFormatting getByCode(char pFormattingCode) {
        char c0 = Character.toString(pFormattingCode).toLowerCase(Locale.ROOT).charAt(0);
        ChatFormatting[] chatFormattingArray = ChatFormatting.values();
        int n = chatFormattingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatFormatting chatformatting = chatFormattingArray[n2];
            if (chatformatting.code == c0) {
                return chatformatting;
            }
            ++n2;
        }
        return null;
    }

    public static Collection<String> getNames(boolean pGetColor, boolean pGetFancyStyling) {
        ArrayList list = Lists.newArrayList();
        ChatFormatting[] chatFormattingArray = ChatFormatting.values();
        int n = chatFormattingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatFormatting chatformatting = chatFormattingArray[n2];
            if (!(chatformatting.isColor() && !pGetColor || chatformatting.isFormat() && !pGetFancyStyling)) {
                list.add(chatformatting.getName());
            }
            ++n2;
        }
        return list;
    }
}

