/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.bridge.game.PackType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class DetectedVersion
implements WorldVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final WorldVersion BUILT_IN = new DetectedVersion();
    private final String id;
    private final String name;
    private final boolean stable;
    private final DataVersion worldVersion;
    private final int protocolVersion;
    private final int resourcePackVersion;
    private final int dataPackVersion;
    private final Date buildTime;
    private final String releaseTarget;

    private DetectedVersion() {
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.name = "1.18.2";
        this.stable = true;
        this.worldVersion = new DataVersion(2975, "main");
        this.protocolVersion = SharedConstants.getProtocolVersion();
        this.resourcePackVersion = 8;
        this.dataPackVersion = 9;
        this.buildTime = new Date();
        this.releaseTarget = "1.18.2";
    }

    private DetectedVersion(JsonObject pJson) {
        this.id = GsonHelper.getAsString(pJson, "id");
        this.name = GsonHelper.getAsString(pJson, "name");
        this.releaseTarget = GsonHelper.getAsString(pJson, "release_target");
        this.stable = GsonHelper.getAsBoolean(pJson, "stable");
        this.worldVersion = new DataVersion(GsonHelper.getAsInt(pJson, "world_version"), GsonHelper.getAsString(pJson, "series_id", DataVersion.MAIN_SERIES));
        this.protocolVersion = GsonHelper.getAsInt(pJson, "protocol_version");
        JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "pack_version");
        this.resourcePackVersion = GsonHelper.getAsInt(jsonobject, "resource");
        this.dataPackVersion = GsonHelper.getAsInt(jsonobject, "data");
        this.buildTime = Date.from(ZonedDateTime.parse(GsonHelper.getAsString(pJson, "build_time")).toInstant());
    }

    public static WorldVersion tryDetectVersion() {
        try {
            WorldVersion worldversion;
            block14: {
                DetectedVersion detectedversion;
                try (InputStream inputstream = DetectedVersion.class.getResourceAsStream("/version.json");){
                    if (inputstream == null) {
                        LOGGER.warn("Missing version information!");
                        worldversion = BUILT_IN;
                        break block14;
                    }
                    try (InputStreamReader inputstreamreader = new InputStreamReader(inputstream);){
                        detectedversion = new DetectedVersion(GsonHelper.parse(inputstreamreader));
                    }
                }
                return detectedversion;
            }
            return worldversion;
        }
        catch (JsonParseException | IOException ioexception) {
            throw new IllegalStateException("Game version information is corrupt", ioexception);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseTarget() {
        return this.releaseTarget;
    }

    @Override
    public DataVersion getDataVersion() {
        return this.worldVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getPackVersion(PackType pType) {
        return pType == PackType.DATA ? this.dataPackVersion : this.resourcePackVersion;
    }

    public Date getBuildTime() {
        return this.buildTime;
    }

    public boolean isStable() {
        return this.stable;
    }
}

