/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final Pattern COPY_COUNTER_PATTERN = Pattern.compile("(<name>.*) \\((<count>\\d*)\\)", 66);
    private static final int MAX_FILE_NAME = 255;
    private static final Pattern RESERVED_WINDOWS_FILENAMES = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);

    public static String findAvailableName(Path pDirPath, String pFileName, String pFileFormat) throws IOException {
        char[] cArray = SharedConstants.ILLEGAL_FILE_CHARACTERS;
        int n = SharedConstants.ILLEGAL_FILE_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c0 = cArray[n2];
            pFileName = pFileName.replace(c0, '_');
            ++n2;
        }
        if (RESERVED_WINDOWS_FILENAMES.matcher(pFileName = pFileName.replaceAll("[./\"]", "_")).matches()) {
            pFileName = "_" + pFileName + "_";
        }
        Matcher matcher = COPY_COUNTER_PATTERN.matcher(pFileName);
        int j = 0;
        if (matcher.matches()) {
            pFileName = matcher.group("name");
            j = Integer.parseInt(matcher.group("count"));
        }
        if (pFileName.length() > 255 - pFileFormat.length()) {
            pFileName = pFileName.substring(0, 255 - pFileFormat.length());
        }
        while (true) {
            String s = pFileName;
            if (j != 0) {
                String s1 = " (" + j + ")";
                int i = 255 - s1.length();
                if (pFileName.length() > i) {
                    s = pFileName.substring(0, i);
                }
                s = String.valueOf(s) + s1;
            }
            s = String.valueOf(s) + pFileFormat;
            Path path = pDirPath.resolve(s);
            try {
                Path path1 = Files.createDirectory(path, new FileAttribute[0]);
                Files.deleteIfExists(path1);
                return pDirPath.relativize(path1).toString();
            }
            catch (FileAlreadyExistsException filealreadyexistsexception) {
                ++j;
                continue;
            }
            break;
        }
    }

    public static boolean isPathNormalized(Path pPath) {
        Path path = pPath.normalize();
        return path.equals(pPath);
    }

    public static boolean isPathPortable(Path pPath) {
        for (Path path : pPath) {
            if (!RESERVED_WINDOWS_FILENAMES.matcher(path.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public static Path createPathToResource(Path pDirPath, String pLocationPath, String pFileFormat) {
        String s = String.valueOf(pLocationPath) + pFileFormat;
        Path path = Paths.get(s, new String[0]);
        if (path.endsWith(pFileFormat)) {
            throw new InvalidPathException(s, "empty resource name");
        }
        return pDirPath.resolve(path);
    }

    public static String getFullResourcePath(String pPath) {
        return FilenameUtils.getFullPath((String)pPath).replace(File.separator, "/");
    }

    public static String normalizeResourcePath(String pPath) {
        return FilenameUtils.normalize((String)pPath).replace(File.separator, "/");
    }
}

