/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class SystemReport {
    public static final long BYTES_PER_MEBIBYTE = 0x100000L;
    private static final long ONE_GIGA = 1000000000L;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String OPERATING_SYSTEM = String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String JAVA_VERSION = String.valueOf(System.getProperty("java.version")) + ", " + System.getProperty("java.vendor");
    private static final String JAVA_VM_VERSION = String.valueOf(System.getProperty("java.vm.name")) + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> entries = Maps.newLinkedHashMap();

    public SystemReport() {
        this.setDetail("Minecraft Version", SharedConstants.getCurrentVersion().getName());
        this.setDetail("Minecraft Version ID", SharedConstants.getCurrentVersion().getId());
        this.setDetail("Operating System", OPERATING_SYSTEM);
        this.setDetail("Java Version", JAVA_VERSION);
        this.setDetail("Java VM Version", JAVA_VM_VERSION);
        this.setDetail("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long i = runtime.maxMemory();
            long j = runtime.totalMemory();
            long k = runtime.freeMemory();
            long l = i / 0x100000L;
            long i1 = j / 0x100000L;
            long j1 = k / 0x100000L;
            return String.valueOf(k) + " bytes (" + j1 + " MiB) / " + j + " bytes (" + i1 + " MiB) up to " + i + " bytes (" + l + " MiB)";
        });
        this.setDetail("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.ignoreErrors("hardware", () -> this.putHardware(new SystemInfo()));
        this.setDetail("JVM Flags", () -> {
            List list = Util.getVmArguments().collect(Collectors.toList());
            return String.format("%d total; %s", list.size(), String.join((CharSequence)" ", list));
        });
    }

    public void setDetail(String pIdentifier, String pValue) {
        this.entries.put(pIdentifier, pValue);
    }

    public void setDetail(String pIdentifier, Supplier<String> pValue) {
        try {
            this.setDetail(pIdentifier, pValue.get());
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to get system info for {}", (Object)pIdentifier, (Object)exception);
            this.setDetail(pIdentifier, "ERR");
        }
    }

    private void putHardware(SystemInfo pInfo) {
        HardwareAbstractionLayer hardwareabstractionlayer = pInfo.getHardware();
        this.ignoreErrors("processor", () -> this.putProcessor(hardwareabstractionlayer.getProcessor()));
        this.ignoreErrors("graphics", () -> this.putGraphics(hardwareabstractionlayer.getGraphicsCards()));
        this.ignoreErrors("memory", () -> this.putMemory(hardwareabstractionlayer.getMemory()));
    }

    private void ignoreErrors(String pGroupIdentifier, Runnable pExecutor) {
        try {
            pExecutor.run();
        }
        catch (Throwable throwable) {
            LOGGER.warn("Failed retrieving info for group {}", (Object)pGroupIdentifier, (Object)throwable);
        }
    }

    private void putPhysicalMemory(List<PhysicalMemory> pMemorySlots) {
        int i = 0;
        for (PhysicalMemory physicalmemory : pMemorySlots) {
            String s = String.format("Memory slot #%d ", i++);
            this.setDetail(String.valueOf(s) + "capacity (MB)", () -> String.format("%.2f", Float.valueOf((float)physicalmemory.getCapacity() / 1048576.0f)));
            this.setDetail(String.valueOf(s) + "clockSpeed (GHz)", () -> String.format("%.2f", Float.valueOf((float)physicalmemory.getClockSpeed() / 1.0E9f)));
            this.setDetail(String.valueOf(s) + "type", () -> ((PhysicalMemory)physicalmemory).getMemoryType());
        }
    }

    private void putVirtualMemory(VirtualMemory pMemory) {
        this.setDetail("Virtual memory max (MB)", () -> String.format("%.2f", Float.valueOf((float)pMemory.getVirtualMax() / 1048576.0f)));
        this.setDetail("Virtual memory used (MB)", () -> String.format("%.2f", Float.valueOf((float)pMemory.getVirtualInUse() / 1048576.0f)));
        this.setDetail("Swap memory total (MB)", () -> String.format("%.2f", Float.valueOf((float)pMemory.getSwapTotal() / 1048576.0f)));
        this.setDetail("Swap memory used (MB)", () -> String.format("%.2f", Float.valueOf((float)pMemory.getSwapUsed() / 1048576.0f)));
    }

    private void putMemory(GlobalMemory pMemory) {
        this.ignoreErrors("physical memory", () -> this.putPhysicalMemory(pMemory.getPhysicalMemory()));
        this.ignoreErrors("virtual memory", () -> this.putVirtualMemory(pMemory.getVirtualMemory()));
    }

    private void putGraphics(List<GraphicsCard> pGpus) {
        int i = 0;
        for (GraphicsCard graphicscard : pGpus) {
            String s = String.format("Graphics card #%d ", i++);
            this.setDetail(String.valueOf(s) + "name", () -> ((GraphicsCard)graphicscard).getName());
            this.setDetail(String.valueOf(s) + "vendor", () -> ((GraphicsCard)graphicscard).getVendor());
            this.setDetail(String.valueOf(s) + "VRAM (MB)", () -> String.format("%.2f", Float.valueOf((float)graphicscard.getVRam() / 1048576.0f)));
            this.setDetail(String.valueOf(s) + "deviceId", () -> ((GraphicsCard)graphicscard).getDeviceId());
            this.setDetail(String.valueOf(s) + "versionInfo", () -> ((GraphicsCard)graphicscard).getVersionInfo());
        }
    }

    private void putProcessor(CentralProcessor pCpu) {
        CentralProcessor.ProcessorIdentifier processoridentifier = pCpu.getProcessorIdentifier();
        this.setDetail("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getVendor());
        this.setDetail("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getName());
        this.setDetail("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getIdentifier());
        this.setDetail("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getMicroarchitecture());
        this.setDetail("Frequency (GHz)", () -> String.format("%.2f", Float.valueOf((float)processoridentifier.getVendorFreq() / 1.0E9f)));
        this.setDetail("Number of physical packages", () -> String.valueOf(pCpu.getPhysicalPackageCount()));
        this.setDetail("Number of physical CPUs", () -> String.valueOf(pCpu.getPhysicalProcessorCount()));
        this.setDetail("Number of logical CPUs", () -> String.valueOf(pCpu.getLogicalProcessorCount()));
    }

    public void appendToCrashReportString(StringBuilder pReportAppender) {
        pReportAppender.append("-- ").append("System Details").append(" --\n");
        pReportAppender.append("Details:");
        this.entries.forEach((p_143529_, p_143530_) -> {
            pReportAppender.append("\n\t");
            pReportAppender.append((String)p_143529_);
            pReportAppender.append(": ");
            pReportAppender.append((String)p_143530_);
        });
    }

    public String toLineSeparatedString() {
        return this.entries.entrySet().stream().map(p_143534_ -> String.valueOf((String)p_143534_.getKey()) + ": " + (String)p_143534_.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

