/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Ticker;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.block.state.properties.Property;
import net.optifine.SmartExecutorService;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class Util {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_MAX_THREADS = 255;
    private static final String MAX_THREADS_SYSTEM_PROPERTY = "max.bg.threads";
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ExecutorService BOOTSTRAP_EXECUTOR = Util.makeExecutor("Bootstrap");
    private static final ExecutorService BACKGROUND_EXECUTOR = Util.makeExecutor("Main");
    private static final ExecutorService IO_POOL = Util.makeIoExecutor();
    public static LongSupplier timeSource = System::nanoTime;
    public static final Ticker TICKER = new Ticker(){

        public long read() {
            return timeSource.getAsLong();
        }
    };
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final FileSystemProvider ZIP_FILE_SYSTEM_PROVIDER = FileSystemProvider.installedProviders().stream().filter(p_201864_0_ -> p_201864_0_.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    private static Consumer<String> thePauser = p_201904_0_ -> {};
    private static Exception exceptionOpenUrl;
    private static final ExecutorService CAPE_EXECUTOR;
    private static LongSupplier INNER_CLASS_SHIFT;

    static {
        CAPE_EXECUTOR = Util.makeExecutor("Cape");
        INNER_CLASS_SHIFT = () -> 0L;
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String getPropertyName(Property<T> pProperty, Object pValue) {
        return pProperty.getName((Comparable)pValue);
    }

    public static String makeDescriptionId(String pType, @Nullable ResourceLocation pId) {
        return pId == null ? String.valueOf(pType) + ".unregistered_sadface" : String.valueOf(pType) + "." + pId.getNamespace() + "." + pId.getPath().replace('/', '.');
    }

    public static long getMillis() {
        return Util.getNanos() / 1000000L;
    }

    public static long getNanos() {
        return timeSource.getAsLong();
    }

    public static long getEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    private static ExecutorService makeExecutor(String pServiceName) {
        int i = Mth.clamp(Runtime.getRuntime().availableProcessors() - 1, 1, Util.getMaxThreads());
        Object executorservice = i <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(i, p_201861_1_ -> {
            ForkJoinWorkerThread forkjoinworkerthread = new ForkJoinWorkerThread(p_201861_1_){

                @Override
                protected void onTermination(Throwable p_onTermination_1_) {
                    if (p_onTermination_1_ != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)p_onTermination_1_);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(p_onTermination_1_);
                }
            };
            forkjoinworkerthread.setName("Worker-" + pServiceName + "-" + WORKER_COUNT.getAndIncrement());
            if (pServiceName.equals("Bootstrap")) {
                forkjoinworkerthread.setPriority(1);
            }
            return forkjoinworkerthread;
        }, Util::onThreadException, true);
        if (pServiceName.equals("Bootstrap")) {
            executorservice = Util.createSmartExecutor((ExecutorService)executorservice);
        }
        return executorservice;
    }

    private static ExecutorService createSmartExecutor(ExecutorService executor) {
        int i = Runtime.getRuntime().availableProcessors();
        if (i <= 1) {
            return executor;
        }
        SmartExecutorService executorservice = new SmartExecutorService(executor);
        return executorservice;
    }

    private static int getMaxThreads() {
        String s = System.getProperty(MAX_THREADS_SYSTEM_PROPERTY);
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                if (i >= 1 && i <= 255) {
                    return i;
                }
                LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, s, 255});
            }
            catch (NumberFormatException numberformatexception1) {
                LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, s, 255});
            }
        }
        return 255;
    }

    public static ExecutorService bootstrapExecutor() {
        return BOOTSTRAP_EXECUTOR;
    }

    public static ExecutorService backgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static ExecutorService ioPool() {
        return IO_POOL;
    }

    public static void shutdownExecutors() {
        Util.shutdownExecutor(BACKGROUND_EXECUTOR);
        Util.shutdownExecutor(IO_POOL);
        Util.shutdownExecutor(CAPE_EXECUTOR);
    }

    private static void shutdownExecutor(ExecutorService pService) {
        boolean flag;
        pService.shutdown();
        try {
            flag = pService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedexception) {
            flag = false;
        }
        if (!flag) {
            pService.shutdownNow();
        }
    }

    private static ExecutorService makeIoExecutor() {
        return Executors.newCachedThreadPool(p_201859_0_ -> {
            Thread thread = new Thread(p_201859_0_);
            thread.setName("IO-Worker-" + WORKER_COUNT.getAndIncrement());
            thread.setUncaughtExceptionHandler(Util::onThreadException);
            return thread;
        });
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable pThrowable) {
        CompletableFuture completablefuture = new CompletableFuture();
        completablefuture.completeExceptionally(pThrowable);
        return completablefuture;
    }

    public static void throwAsRuntime(Throwable pThrowable) {
        throw pThrowable instanceof RuntimeException ? (RuntimeException)pThrowable : new RuntimeException(pThrowable);
    }

    private static void onThreadException(Thread p_137496_, Throwable p_137497_) {
        Util.pauseInIde(p_137497_);
        if (p_137497_ instanceof CompletionException) {
            p_137497_ = p_137497_.getCause();
        }
        if (p_137497_ instanceof ReportedException) {
            Bootstrap.realStdoutPrintln(((ReportedException)p_137497_).getReport().getFriendlyReport());
            System.exit(-1);
        }
        LOGGER.error(String.format("Caught exception in thread %s", p_137496_), p_137497_);
    }

    @Nullable
    public static Type<?> fetchChoiceType(DSL.TypeReference pType, String pChoiceName) {
        return !SharedConstants.CHECK_DATA_FIXER_SCHEMA ? null : Util.doFetchChoiceType(pType, pChoiceName);
    }

    @Nullable
    private static Type<?> doFetchChoiceType(DSL.TypeReference pType, String pChoiceName) {
        Type type;
        block2: {
            type = null;
            try {
                type = DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getWorldVersion())).getChoiceType(pType, pChoiceName);
            }
            catch (IllegalArgumentException illegalargumentexception) {
                LOGGER.debug("No data fixer registered for {}", (Object)pChoiceName);
                if (!SharedConstants.IS_RUNNING_IN_IDE) break block2;
                throw illegalargumentexception;
            }
        }
        return type;
    }

    public static Runnable wrapThreadWithTaskName(String pName, Runnable pTask) {
        return SharedConstants.IS_RUNNING_IN_IDE ? () -> {
            Thread thread = Thread.currentThread();
            String s = thread.getName();
            thread.setName(pName);
            try {
                pTask.run();
            }
            finally {
                thread.setName(s);
            }
        } : pTask;
    }

    public static <V> Supplier<V> wrapThreadWithTaskName(String pName, Supplier<V> pTask) {
        return SharedConstants.IS_RUNNING_IN_IDE ? () -> {
            Object object;
            Thread thread = Thread.currentThread();
            String s = thread.getName();
            thread.setName(pName);
            try {
                object = pTask.get();
            }
            finally {
                thread.setName(s);
            }
            return object;
        } : pTask;
    }

    public static OS getPlatform() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (s.contains("win")) {
            return OS.WINDOWS;
        }
        if (s.contains("mac")) {
            return OS.OSX;
        }
        if (s.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (s.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (s.contains("linux")) {
            return OS.LINUX;
        }
        return s.contains("unix") ? OS.LINUX : OS.UNKNOWN;
    }

    public static Stream<String> getVmArguments() {
        RuntimeMXBean runtimemxbean = ManagementFactory.getRuntimeMXBean();
        return runtimemxbean.getInputArguments().stream().filter(p_201902_0_ -> p_201902_0_.startsWith("-X"));
    }

    public static <T> T lastOf(List<T> pList) {
        return pList.get(pList.size() - 1);
    }

    public static <T> T findNextInIterable(Iterable<T> pIterable, @Nullable T pElement) {
        Iterator<T> iterator = pIterable.iterator();
        T t = iterator.next();
        if (pElement != null) {
            T t1 = t;
            while (t1 != pElement) {
                if (!iterator.hasNext()) continue;
                t1 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return t;
    }

    public static <T> T findPreviousInIterable(Iterable<T> pIterable, @Nullable T pCurrent) {
        Iterator<T> iterator = pIterable.iterator();
        T t = null;
        while (iterator.hasNext()) {
            T t1 = iterator.next();
            if (t1 == pCurrent) {
                if (t != null) break;
                t = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : pCurrent);
                break;
            }
            t = t1;
        }
        return t;
    }

    public static <T> T make(Supplier<T> pSupplier) {
        return pSupplier.get();
    }

    public static <T> T make(T pObject, Consumer<T> pConsumer) {
        pConsumer.accept(pObject);
        return pObject;
    }

    public static <K> Hash.Strategy<K> identityStrategy() {
        return IdentityStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> sequence(List<? extends CompletableFuture<V>> pFutures) {
        if (pFutures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (pFutures.size() == 1) {
            return pFutures.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf(pFutures.toArray(new CompletableFuture[0]));
        return completablefuture.thenApply(p_203744_1_ -> pFutures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFast(List<? extends CompletableFuture<? extends V>> pCompletableFutures) {
        ArrayList list = Lists.newArrayListWithCapacity((int)pCompletableFutures.size());
        CompletableFuture[] completablefuture = new CompletableFuture[pCompletableFutures.size()];
        CompletableFuture completablefuture1 = new CompletableFuture();
        pCompletableFutures.forEach(p_203726_3_ -> {
            int i = list.size();
            list.add(null);
            completableFutureArray[i] = p_203726_3_.whenComplete((p_203731_3_, p_203731_4_) -> {
                if (p_203731_4_ != null) {
                    completablefuture1.completeExceptionally((Throwable)p_203731_4_);
                } else {
                    list.set(i, p_203731_3_);
                }
            });
        });
        return CompletableFuture.allOf(completablefuture).applyToEither((CompletionStage)completablefuture1, p_203723_1_ -> list);
    }

    public static Exception getExceptionOpenUrl() {
        return exceptionOpenUrl;
    }

    public static void setExceptionOpenUrl(Exception exceptionOpenUrl) {
        Util.exceptionOpenUrl = exceptionOpenUrl;
    }

    public static ExecutorService getCapeExecutor() {
        return CAPE_EXECUTOR;
    }

    public static <T> Optional<T> ifElse(Optional<T> pOpt, Consumer<T> pConsumer, Runnable pOrElse) {
        if (pOpt.isPresent()) {
            pConsumer.accept(pOpt.get());
        } else {
            pOrElse.run();
        }
        return pOpt;
    }

    public static Runnable name(Runnable pRunnable, Supplier<String> pSupplier) {
        return pRunnable;
    }

    public static void logAndPauseIfInIde(String pError) {
        LOGGER.error(pError);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(pError);
        }
    }

    public static void logAndPauseIfInIde(String p_200891_, Throwable p_200892_) {
        LOGGER.error(p_200891_, p_200892_);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(p_200891_);
        }
    }

    public static <T extends Throwable> T pauseInIde(T pThrowable) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.error("Trying to throw a fatal exception, pausing in IDE", pThrowable);
            Util.doPause(pThrowable.getMessage());
        }
        return pThrowable;
    }

    public static void setPause(Consumer<String> p_183970_) {
        thePauser = p_183970_;
    }

    private static void doPause(String p_183985_) {
        boolean flag;
        Instant instant = Instant.now();
        LOGGER.warn("Did you remember to set a breakpoint here?");
        boolean bl = flag = Duration.between(instant, Instant.now()).toMillis() > 500L;
        if (!flag) {
            thePauser.accept(p_183985_);
        }
    }

    public static String describeError(Throwable pThrowable) {
        if (pThrowable.getCause() != null) {
            return Util.describeError(pThrowable.getCause());
        }
        return pThrowable.getMessage() != null ? pThrowable.getMessage() : pThrowable.toString();
    }

    public static <T> T a(T[] p_137546_, Random p_137547_) {
        return p_137546_[p_137547_.nextInt(p_137546_.length)];
    }

    public static int a(int[] p_137543_, Random p_137544_) {
        return p_137543_[p_137544_.nextInt(p_137543_.length)];
    }

    public static <T> T getRandom(List<T> pSelections, Random pRandom) {
        return pSelections.get(pRandom.nextInt(pSelections.size()));
    }

    public static <T> Optional<T> getRandomSafe(List<T> p_203748_, Random p_203749_) {
        return p_203748_.isEmpty() ? Optional.empty() : Optional.of(Util.getRandom(p_203748_, p_203749_));
    }

    private static BooleanSupplier createRenamer(Path pFilePath, Path pNewName) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(pFilePath, pNewName, new CopyOption[0]);
                    return true;
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to rename", (Throwable)ioexception);
                    return false;
                }
            }

            public String toString() {
                return "rename " + pFilePath + " to " + pNewName;
            }
        };
    }

    private static BooleanSupplier createDeleter(Path pFilePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(pFilePath);
                    return true;
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to delete", (Throwable)ioexception);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + pFilePath;
            }
        };
    }

    private static BooleanSupplier createFileDeletedCheck(Path pFilePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(pFilePath, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + pFilePath + " is deleted";
            }
        };
    }

    private static BooleanSupplier createFileCreatedCheck(Path pFilePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(pFilePath, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + pFilePath + " is present";
            }
        };
    }

    private static boolean a(BooleanSupplier ... p_137549_) {
        BooleanSupplier[] booleanSupplierArray = p_137549_;
        int n = p_137549_.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanSupplier booleansupplier = booleanSupplierArray[n2];
            if (!booleansupplier.getAsBoolean()) {
                LOGGER.warn("Failed to execute {}", (Object)booleansupplier);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean a(int p_137450_, String p_137451_, BooleanSupplier ... p_137452_) {
        int i = 0;
        while (i < p_137450_) {
            if (Util.a(p_137452_)) {
                return true;
            }
            LOGGER.error("Failed to {}, retrying {}/{}", new Object[]{p_137451_, i, p_137450_});
            ++i;
        }
        LOGGER.error("Failed to {}, aborting, progress might be lost", (Object)p_137451_);
        return false;
    }

    public static void safeReplaceFile(File pCurrent, File pLatest, File pOldBackup) {
        Util.safeReplaceFile(pCurrent.toPath(), pLatest.toPath(), pOldBackup.toPath());
    }

    public static void safeReplaceFile(Path pCurrent, Path pLatest, Path pOldBackup) {
        Util.safeReplaceOrMoveFile(pCurrent, pLatest, pOldBackup, false);
    }

    public static void safeReplaceOrMoveFile(File p_212225_, File p_212226_, File p_212227_, boolean p_212228_) {
        Util.safeReplaceOrMoveFile(p_212225_.toPath(), p_212226_.toPath(), p_212227_.toPath(), p_212228_);
    }

    public static void safeReplaceOrMoveFile(Path p_212230_, Path p_212231_, Path p_212232_, boolean p_212233_) {
        int i = 10;
        if (!(Files.exists(p_212230_, new LinkOption[0]) && !Util.a(10, "create backup " + p_212232_, Util.createDeleter(p_212232_), Util.createRenamer(p_212230_, p_212232_), Util.createFileCreatedCheck(p_212232_)) || !Util.a(10, "remove old " + p_212230_, Util.createDeleter(p_212230_), Util.createFileDeletedCheck(p_212230_)) || Util.a(10, "replace " + p_212230_ + " with " + p_212231_, Util.createRenamer(p_212231_, p_212230_), Util.createFileCreatedCheck(p_212230_)) || p_212233_)) {
            Util.a(10, "restore " + p_212230_ + " from " + p_212232_, Util.createRenamer(p_212232_, p_212230_), Util.createFileCreatedCheck(p_212230_));
        }
    }

    public static int offsetByCodepoints(String pText, int pCursorPos, int pDirection) {
        int i = pText.length();
        if (pDirection >= 0) {
            int j = 0;
            while (pCursorPos < i && j < pDirection) {
                if (Character.isHighSurrogate(pText.charAt(pCursorPos++)) && pCursorPos < i && Character.isLowSurrogate(pText.charAt(pCursorPos))) {
                    ++pCursorPos;
                }
                ++j;
            }
        } else {
            int k = pDirection;
            while (pCursorPos > 0 && k < 0) {
                if (Character.isLowSurrogate(pText.charAt(--pCursorPos)) && pCursorPos > 0 && Character.isHighSurrogate(pText.charAt(pCursorPos - 1))) {
                    --pCursorPos;
                }
                ++k;
            }
        }
        return pCursorPos;
    }

    public static Consumer<String> prefix(String pPrefix, Consumer<String> pConsumer) {
        return p_203737_2_ -> pConsumer.accept(String.valueOf(pPrefix) + p_203737_2_);
    }

    public static DataResult<int[]> fixedSize(IntStream pList, int pExpectedSize) {
        int[] aint = pList.limit(pExpectedSize + 1).toArray();
        if (aint.length != pExpectedSize) {
            String s = "Input is not a list of " + pExpectedSize + " ints";
            return aint.length >= pExpectedSize ? DataResult.error((String)s, (Object)Arrays.copyOf(aint, pExpectedSize)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)aint);
    }

    public static <T> DataResult<List<T>> fixedSize(List<T> pList, int pExpectedSize) {
        if (pList.size() != pExpectedSize) {
            String s = "Input is not a list of " + pExpectedSize + " elements";
            return pList.size() >= pExpectedSize ? DataResult.error((String)s, pList.subList(0, pExpectedSize)) : DataResult.error((String)s);
        }
        return DataResult.success(pList);
    }

    public static void startTimerHackThread() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedexception) {
                    LOGGER.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    public static void copyBetweenDirs(Path pFromDirectory, Path pToDirectory, Path pFilePath) throws IOException {
        Path path = pFromDirectory.relativize(pFilePath);
        Path path1 = pToDirectory.resolve(path);
        Files.copy(pFilePath, path1, new CopyOption[0]);
    }

    public static String sanitizeName(String pFileName, CharPredicate pCharacterValidator) {
        return pFileName.toLowerCase(Locale.ROOT).chars().mapToObj(p_203741_1_ -> pCharacterValidator.test((char)p_203741_1_) ? Character.toString((char)p_203741_1_) : "_").collect(Collectors.joining());
    }

    public static <T, R> Function<T, R> memoize(Function<T, R> pMemoBiFunction) {
        return new Function<T, R>(){
            private final Map<T, R> cache = Maps.newHashMap();

            @Override
            public R apply(T p_apply_1_) {
                return this.cache.computeIfAbsent(p_apply_1_, pMemoBiFunction);
            }

            public String toString() {
                return "memoize/1[function=" + pMemoBiFunction + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(BiFunction<T, U, R> pMemoBiFunction) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = Maps.newHashMap();

            @Override
            public R apply(T p_apply_1_, U p_apply_2_) {
                return this.cache.computeIfAbsent(Pair.of(p_apply_1_, p_apply_2_), p_211551_1_ -> pMemoBiFunction.apply(p_211551_1_.getFirst(), p_211551_1_.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + pMemoBiFunction + ", size=" + this.cache.size() + "]";
            }
        };
    }

    static enum IdentityStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object p_137626_) {
            return System.identityHashCode(p_137626_);
        }

        public boolean equals(Object p_137623_, Object p_137624_) {
            return p_137623_ == p_137624_;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OS {
        LINUX("linux"),
        SOLARIS("solaris"),
        WINDOWS("windows"){

            @Override
            protected String[] getOpenUrlArguments(URL p_137662_) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", p_137662_.toString()};
            }
        }
        ,
        OSX("mac"){

            @Override
            protected String[] getOpenUrlArguments(URL p_137667_) {
                return new String[]{"open", p_137667_.toString()};
            }
        }
        ,
        UNKNOWN("unknown");

        private final String telemetryName;

        private OS(String p_183998_) {
            this.telemetryName = p_183998_;
        }

        public void openUrl(URL pUrl) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.getOpenUrlArguments(pUrl)));
                for (String s : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    LOGGER.error(s);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException ioexception) {
                LOGGER.error("Couldn't open url '{}'", (Object)pUrl, (Object)ioexception);
                exceptionOpenUrl = ioexception;
            }
        }

        public void openUri(URI pUri) {
            try {
                this.openUrl(pUri.toURL());
            }
            catch (MalformedURLException malformedurlexception) {
                LOGGER.error("Couldn't open uri '{}'", (Object)pUri, (Object)malformedurlexception);
            }
        }

        public void openFile(File pFile) {
            try {
                this.openUrl(pFile.toURI().toURL());
            }
            catch (MalformedURLException malformedurlexception) {
                LOGGER.error("Couldn't open file '{}'", (Object)pFile, (Object)malformedurlexception);
            }
        }

        protected String[] getOpenUrlArguments(URL pUrl) {
            String s = pUrl.toString();
            if ("file".equals(pUrl.getProtocol())) {
                s = s.replace("file:", "file://");
            }
            return new String[]{"xdg-open", s};
        }

        public void openUri(String pUri) {
            try {
                this.openUrl(new URI(pUri).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException malformedurlexception) {
                LOGGER.error("Couldn't open uri '{}'", (Object)pUri, (Object)malformedurlexception);
            }
        }

        public String telemetryName() {
            return this.telemetryName;
        }
    }
}

