/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.ArrayUtils;

public class Advancement {
    @Nullable
    private final Advancement parent;
    @Nullable
    private final DisplayInfo display;
    private final AdvancementRewards rewards;
    private final ResourceLocation id;
    private final Map<String, Criterion> criteria;
    private final String[][] requirements;
    private final Set<Advancement> children = Sets.newLinkedHashSet();
    private final Component chatComponent;

    public Advancement(ResourceLocation pId, @Nullable Advancement pParent, @Nullable DisplayInfo pDisplay, AdvancementRewards pRewards, Map<String, Criterion> pCriteria, String[][] pRequirements) {
        this.id = pId;
        this.display = pDisplay;
        this.criteria = ImmutableMap.copyOf(pCriteria);
        this.parent = pParent;
        this.rewards = pRewards;
        this.requirements = pRequirements;
        if (pParent != null) {
            pParent.addChild(this);
        }
        if (pDisplay == null) {
            this.chatComponent = new TextComponent(pId.toString());
        } else {
            Component component = pDisplay.getTitle();
            ChatFormatting chatformatting = pDisplay.getFrame().getChatColor();
            MutableComponent component1 = ComponentUtils.mergeStyles(component.copy(), Style.EMPTY.withColor(chatformatting)).append("\n").append(pDisplay.getDescription());
            MutableComponent component2 = component.copy().withStyle(p_138316_ -> p_138316_.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, component1)));
            this.chatComponent = ComponentUtils.wrapInSquareBrackets(component2).withStyle(chatformatting);
        }
    }

    public Builder deconstruct() {
        return new Builder(this.parent == null ? null : this.parent.getId(), this.display, this.rewards, this.criteria, this.requirements);
    }

    @Nullable
    public Advancement getParent() {
        return this.parent;
    }

    @Nullable
    public DisplayInfo getDisplay() {
        return this.display;
    }

    public AdvancementRewards getRewards() {
        return this.rewards;
    }

    public String toString() {
        return "SimpleAdvancement{id=" + this.getId() + ", parent=" + (this.parent == null ? "null" : this.parent.getId()) + ", display=" + this.display + ", rewards=" + this.rewards + ", criteria=" + this.criteria + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
    }

    public Iterable<Advancement> getChildren() {
        return this.children;
    }

    public Map<String, Criterion> getCriteria() {
        return this.criteria;
    }

    public int getMaxCriteraRequired() {
        return this.requirements.length;
    }

    public void addChild(Advancement pChild) {
        this.children.add(pChild);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)pOther;
        return this.id.equals(advancement.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String[][] getRequirements() {
        return this.requirements;
    }

    public Component getChatComponent() {
        return this.chatComponent;
    }

    public static class Builder {
        @Nullable
        private ResourceLocation parentId;
        @Nullable
        private Advancement parent;
        @Nullable
        private DisplayInfo display;
        private AdvancementRewards rewards = AdvancementRewards.EMPTY;
        private Map<String, Criterion> criteria = Maps.newLinkedHashMap();
        @Nullable
        private String[][] requirements;
        private RequirementsStrategy requirementsStrategy = RequirementsStrategy.AND;

        Builder(@Nullable ResourceLocation pParentId, @Nullable DisplayInfo pDisplay, AdvancementRewards pRewards, Map<String, Criterion> pCriteria, String[][] pRequirements) {
            this.parentId = pParentId;
            this.display = pDisplay;
            this.rewards = pRewards;
            this.criteria = pCriteria;
            this.requirements = pRequirements;
        }

        private Builder() {
        }

        public static Builder advancement() {
            return new Builder();
        }

        public Builder parent(Advancement pParent) {
            this.parent = pParent;
            return this;
        }

        public Builder parent(ResourceLocation pParent) {
            this.parentId = pParent;
            return this;
        }

        public Builder display(ItemStack pStack, Component pTitle, Component pDescription, @Nullable ResourceLocation pBackground, FrameType pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
            return this.display(new DisplayInfo(pStack, pTitle, pDescription, pBackground, pFrame, pShowToast, pAnnounceToChat, pHidden));
        }

        public Builder display(ItemLike pStack, Component pTitle, Component pDescription, @Nullable ResourceLocation pBackground, FrameType pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
            return this.display(new DisplayInfo(new ItemStack(pStack.asItem()), pTitle, pDescription, pBackground, pFrame, pShowToast, pAnnounceToChat, pHidden));
        }

        public Builder display(DisplayInfo pDisplay) {
            this.display = pDisplay;
            return this;
        }

        public Builder rewards(AdvancementRewards.Builder pRewardsBuilder) {
            return this.rewards(pRewardsBuilder.build());
        }

        public Builder rewards(AdvancementRewards pRewardsBuilder) {
            this.rewards = pRewardsBuilder;
            return this;
        }

        public Builder addCriterion(String pKey, CriterionTriggerInstance pCriterion) {
            return this.addCriterion(pKey, new Criterion(pCriterion));
        }

        public Builder addCriterion(String pKey, Criterion pCriterion) {
            if (this.criteria.containsKey(pKey)) {
                throw new IllegalArgumentException("Duplicate criterion " + pKey);
            }
            this.criteria.put(pKey, pCriterion);
            return this;
        }

        public Builder requirements(RequirementsStrategy pStrategy) {
            this.requirementsStrategy = pStrategy;
            return this;
        }

        public Builder a(String[][] p_143952_) {
            this.requirements = p_143952_;
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, Advancement> pParentLookup) {
            if (this.parentId == null) {
                return true;
            }
            if (this.parent == null) {
                this.parent = pParentLookup.apply(this.parentId);
            }
            return this.parent != null;
        }

        public Advancement build(ResourceLocation pId) {
            if (!this.canBuild(p_138407_ -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            return new Advancement(pId, this.parent, this.display, this.rewards, this.criteria, this.requirements);
        }

        public Advancement save(Consumer<Advancement> pConsumer, String pId) {
            Advancement advancement = this.build(new ResourceLocation(pId));
            pConsumer.accept(advancement);
            return advancement;
        }

        public JsonObject serializeToJson() {
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            JsonObject jsonobject = new JsonObject();
            if (this.parent != null) {
                jsonobject.addProperty("parent", this.parent.getId().toString());
            } else if (this.parentId != null) {
                jsonobject.addProperty("parent", this.parentId.toString());
            }
            if (this.display != null) {
                jsonobject.add("display", this.display.serializeToJson());
            }
            jsonobject.add("rewards", this.rewards.serializeToJson());
            JsonObject jsonobject1 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.criteria.entrySet()) {
                jsonobject1.add(entry.getKey(), entry.getValue().serializeToJson());
            }
            jsonobject.add("criteria", (JsonElement)jsonobject1);
            JsonArray jsonarray1 = new JsonArray();
            String[][] stringArray = this.requirements;
            int n = this.requirements.length;
            int n2 = 0;
            while (n2 < n) {
                String[] astring = stringArray[n2];
                JsonArray jsonarray = new JsonArray();
                String[] stringArray2 = astring;
                int n3 = astring.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    jsonarray.add(s);
                    ++n4;
                }
                jsonarray1.add((JsonElement)jsonarray);
                ++n2;
            }
            jsonobject.add("requirements", (JsonElement)jsonarray1);
            return jsonobject;
        }

        public void serializeToNetwork(FriendlyByteBuf pBuffer) {
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            if (this.parentId == null) {
                pBuffer.writeBoolean(false);
            } else {
                pBuffer.writeBoolean(true);
                pBuffer.writeResourceLocation(this.parentId);
            }
            if (this.display == null) {
                pBuffer.writeBoolean(false);
            } else {
                pBuffer.writeBoolean(true);
                this.display.serializeToNetwork(pBuffer);
            }
            Criterion.serializeToNetwork(this.criteria, pBuffer);
            pBuffer.writeVarInt(this.requirements.length);
            String[][] stringArray = this.requirements;
            int n = this.requirements.length;
            int n2 = 0;
            while (n2 < n) {
                String[] astring = stringArray[n2];
                pBuffer.writeVarInt(astring.length);
                String[] stringArray2 = astring;
                int n3 = astring.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    pBuffer.writeUtf(s);
                    ++n4;
                }
                ++n2;
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.parentId + ", display=" + this.display + ", rewards=" + this.rewards + ", criteria=" + this.criteria + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
        }

        public static Builder fromJson(JsonObject pJson, DeserializationContext pContext) {
            int n;
            ResourceLocation resourcelocation = pJson.has("parent") ? new ResourceLocation(GsonHelper.getAsString(pJson, "parent")) : null;
            DisplayInfo displayinfo = pJson.has("display") ? DisplayInfo.fromJson(GsonHelper.getAsJsonObject(pJson, "display")) : null;
            AdvancementRewards advancementrewards = pJson.has("rewards") ? AdvancementRewards.deserialize(GsonHelper.getAsJsonObject(pJson, "rewards")) : AdvancementRewards.EMPTY;
            Map<String, Criterion> map = Criterion.criteriaFromJson(GsonHelper.getAsJsonObject(pJson, "criteria"), pContext);
            if (map.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, "requirements", new JsonArray());
            String[][] astring = new String[jsonarray.size()][];
            int i = 0;
            while (i < jsonarray.size()) {
                JsonArray jsonarray1 = GsonHelper.convertToJsonArray(jsonarray.get(i), "requirements[" + i + "]");
                astring[i] = new String[jsonarray1.size()];
                int j = 0;
                while (j < jsonarray1.size()) {
                    astring[i][j] = GsonHelper.convertToString(jsonarray1.get(j), "requirements[" + i + "][" + j + "]");
                    ++j;
                }
                ++i;
            }
            if (astring.length == 0) {
                astring = new String[map.size()][];
                int k = 0;
                for (String s2 : map.keySet()) {
                    astring[k++] = new String[]{s2};
                }
            }
            String[][] stringArray = astring;
            int j = astring.length;
            int n2 = 0;
            while (n2 < j) {
                String[] astring1 = stringArray[n2];
                if (astring1.length == 0 && map.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray2 = astring1;
                int n3 = astring1.length;
                n = 0;
                while (n < n3) {
                    String s = stringArray2[n];
                    if (!map.containsKey(s)) {
                        throw new JsonSyntaxException("Unknown required criterion '" + s + "'");
                    }
                    ++n;
                }
                ++n2;
            }
            for (String s1 : map.keySet()) {
                boolean flag = false;
                String[][] stringArray3 = astring;
                n = astring.length;
                int n4 = 0;
                while (n4 < n) {
                    Object[] astring2 = stringArray3[n4];
                    if (ArrayUtils.contains((Object[])astring2, (Object)s1)) {
                        flag = true;
                        break;
                    }
                    ++n4;
                }
                if (flag) continue;
                throw new JsonSyntaxException("Criterion '" + s1 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new Builder(resourcelocation, displayinfo, advancementrewards, map, astring);
        }

        public static Builder fromNetwork(FriendlyByteBuf pBuffer) {
            ResourceLocation resourcelocation = pBuffer.readBoolean() ? pBuffer.readResourceLocation() : null;
            DisplayInfo displayinfo = pBuffer.readBoolean() ? DisplayInfo.fromNetwork(pBuffer) : null;
            Map<String, Criterion> map = Criterion.criteriaFromNetwork(pBuffer);
            String[][] astring = new String[pBuffer.readVarInt()][];
            int i = 0;
            while (i < astring.length) {
                astring[i] = new String[pBuffer.readVarInt()];
                int j = 0;
                while (j < astring[i].length) {
                    astring[i][j] = pBuffer.readUtf();
                    ++j;
                }
                ++i;
            }
            return new Builder(resourcelocation, displayinfo, AdvancementRewards.EMPTY, map, astring);
        }

        public Map<String, Criterion> getCriteria() {
            return this.criteria;
        }
    }
}

