/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AdvancementRewards {
    public static final AdvancementRewards EMPTY = new AdvancementRewards(0, new ResourceLocation[0], new ResourceLocation[0], CommandFunction.CacheableFunction.NONE);
    private final int experience;
    private final ResourceLocation[] loot;
    private final ResourceLocation[] recipes;
    private final CommandFunction.CacheableFunction function;

    public AdvancementRewards(int pExperience, ResourceLocation[] pLoot, ResourceLocation[] pRecipes, CommandFunction.CacheableFunction pFunction) {
        this.experience = pExperience;
        this.loot = pLoot;
        this.recipes = pRecipes;
        this.function = pFunction;
    }

    public ResourceLocation[] getRecipes() {
        return this.recipes;
    }

    public void grant(ServerPlayer pPlayer) {
        pPlayer.giveExperiencePoints(this.experience);
        LootContext lootcontext = new LootContext.Builder(pPlayer.getLevel()).withParameter(LootContextParams.THIS_ENTITY, pPlayer).withParameter(LootContextParams.ORIGIN, pPlayer.position()).withRandom(pPlayer.getRandom()).create(LootContextParamSets.ADVANCEMENT_REWARD);
        boolean flag = false;
        ResourceLocation[] resourceLocationArray = this.loot;
        int n = this.loot.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceLocation resourcelocation = resourceLocationArray[n2];
            for (ItemStack itemstack : pPlayer.server.getLootTables().get(resourcelocation).getRandomItems(lootcontext)) {
                if (pPlayer.addItem(itemstack)) {
                    pPlayer.level.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((pPlayer.getRandom().nextFloat() - pPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    flag = true;
                    continue;
                }
                ItemEntity itementity = pPlayer.drop(itemstack, false);
                if (itementity == null) continue;
                itementity.setNoPickUpDelay();
                itementity.setOwner(pPlayer.getUUID());
            }
            ++n2;
        }
        if (flag) {
            pPlayer.containerMenu.broadcastChanges();
        }
        if (this.recipes.length > 0) {
            pPlayer.a(this.recipes);
        }
        MinecraftServer minecraftserver = pPlayer.server;
        this.function.get(minecraftserver.getFunctions()).ifPresent(p_9996_ -> minecraftserver.getFunctions().execute((CommandFunction)p_9996_, pPlayer.createCommandSourceStack().withSuppressedOutput().withPermission(2)));
    }

    public String toString() {
        return "AdvancementRewards{experience=" + this.experience + ", loot=" + Arrays.toString(this.loot) + ", recipes=" + Arrays.toString(this.recipes) + ", function=" + this.function + "}";
    }

    public JsonElement serializeToJson() {
        int n;
        int n2;
        ResourceLocation[] resourceLocationArray;
        if (this == EMPTY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (this.experience != 0) {
            jsonobject.addProperty("experience", (Number)this.experience);
        }
        if (this.loot.length > 0) {
            JsonArray jsonarray = new JsonArray();
            resourceLocationArray = this.loot;
            n2 = this.loot.length;
            n = 0;
            while (n < n2) {
                ResourceLocation resourcelocation = resourceLocationArray[n];
                jsonarray.add(resourcelocation.toString());
                ++n;
            }
            jsonobject.add("loot", (JsonElement)jsonarray);
        }
        if (this.recipes.length > 0) {
            JsonArray jsonarray1 = new JsonArray();
            resourceLocationArray = this.recipes;
            n2 = this.recipes.length;
            n = 0;
            while (n < n2) {
                ResourceLocation resourcelocation1 = resourceLocationArray[n];
                jsonarray1.add(resourcelocation1.toString());
                ++n;
            }
            jsonobject.add("recipes", (JsonElement)jsonarray1);
        }
        if (this.function.getId() != null) {
            jsonobject.addProperty("function", this.function.getId().toString());
        }
        return jsonobject;
    }

    public static AdvancementRewards deserialize(JsonObject pJson) throws JsonParseException {
        int i = GsonHelper.getAsInt(pJson, "experience", 0);
        JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, "loot", new JsonArray());
        ResourceLocation[] aresourcelocation = new ResourceLocation[jsonarray.size()];
        int j = 0;
        while (j < aresourcelocation.length) {
            aresourcelocation[j] = new ResourceLocation(GsonHelper.convertToString(jsonarray.get(j), "loot[" + j + "]"));
            ++j;
        }
        JsonArray jsonarray1 = GsonHelper.getAsJsonArray(pJson, "recipes", new JsonArray());
        ResourceLocation[] aresourcelocation1 = new ResourceLocation[jsonarray1.size()];
        int k = 0;
        while (k < aresourcelocation1.length) {
            aresourcelocation1[k] = new ResourceLocation(GsonHelper.convertToString(jsonarray1.get(k), "recipes[" + k + "]"));
            ++k;
        }
        CommandFunction.CacheableFunction commandfunction$cacheablefunction = pJson.has("function") ? new CommandFunction.CacheableFunction(new ResourceLocation(GsonHelper.getAsString(pJson, "function"))) : CommandFunction.CacheableFunction.NONE;
        return new AdvancementRewards(i, aresourcelocation, aresourcelocation1, commandfunction$cacheablefunction);
    }

    public static class Builder {
        private int experience;
        private final List<ResourceLocation> loot = Lists.newArrayList();
        private final List<ResourceLocation> recipes = Lists.newArrayList();
        @Nullable
        private ResourceLocation function;

        public static Builder experience(int pExperience) {
            return new Builder().addExperience(pExperience);
        }

        public Builder addExperience(int pExperience) {
            this.experience += pExperience;
            return this;
        }

        public static Builder loot(ResourceLocation pLootTableId) {
            return new Builder().addLootTable(pLootTableId);
        }

        public Builder addLootTable(ResourceLocation pLootTableId) {
            this.loot.add(pLootTableId);
            return this;
        }

        public static Builder recipe(ResourceLocation pRecipeId) {
            return new Builder().addRecipe(pRecipeId);
        }

        public Builder addRecipe(ResourceLocation pRecipeId) {
            this.recipes.add(pRecipeId);
            return this;
        }

        public static Builder function(ResourceLocation pFunctionId) {
            return new Builder().runs(pFunctionId);
        }

        public Builder runs(ResourceLocation pFunctionId) {
            this.function = pFunctionId;
            return this;
        }

        public AdvancementRewards build() {
            return new AdvancementRewards(this.experience, this.loot.toArray(new ResourceLocation[0]), this.recipes.toArray(new ResourceLocation[0]), this.function == null ? CommandFunction.CacheableFunction.NONE : new CommandFunction.CacheableFunction(this.function));
        }
    }
}

