/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.gson.JsonObject;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;

public interface CriterionTrigger<T extends CriterionTriggerInstance> {
    public ResourceLocation getId();

    public void addPlayerListener(PlayerAdvancements var1, Listener<T> var2);

    public void removePlayerListener(PlayerAdvancements var1, Listener<T> var2);

    public void removePlayerListeners(PlayerAdvancements var1);

    public T createInstance(JsonObject var1, DeserializationContext var2);

    public static class Listener<T extends CriterionTriggerInstance> {
        private final T trigger;
        private final Advancement advancement;
        private final String criterion;

        public Listener(T pTrigger, Advancement pAdvancement, String pCriterion) {
            this.trigger = pTrigger;
            this.advancement = pAdvancement;
            this.criterion = pCriterion;
        }

        public T getTriggerInstance() {
            return this.trigger;
        }

        public void run(PlayerAdvancements pPlayerAdvancements) {
            pPlayerAdvancements.award(this.advancement, this.criterion);
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther != null && this.getClass() == pOther.getClass()) {
                Listener listener = (Listener)pOther;
                if (!this.trigger.equals(listener.trigger)) {
                    return false;
                }
                return !this.advancement.equals(listener.advancement) ? false : this.criterion.equals(listener.criterion);
            }
            return false;
        }

        public int hashCode() {
            int i = this.trigger.hashCode();
            i = 31 * i + this.advancement.hashCode();
            return 31 * i + this.criterion.hashCode();
        }
    }
}

