/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;

public class TreeNodePosition {
    private final Advancement advancement;
    @Nullable
    private final TreeNodePosition parent;
    @Nullable
    private final TreeNodePosition previousSibling;
    private final int childIndex;
    private final List<TreeNodePosition> children = Lists.newArrayList();
    private TreeNodePosition ancestor;
    @Nullable
    private TreeNodePosition thread;
    private int x;
    private float y;
    private float mod;
    private float change;
    private float shift;

    public TreeNodePosition(Advancement pAdvancement, @Nullable TreeNodePosition pParent, @Nullable TreeNodePosition pPreviousSibling, int pChildIndex, int pX) {
        if (pAdvancement.getDisplay() == null) {
            throw new IllegalArgumentException("Can't position an invisible advancement!");
        }
        this.advancement = pAdvancement;
        this.parent = pParent;
        this.previousSibling = pPreviousSibling;
        this.childIndex = pChildIndex;
        this.ancestor = this;
        this.x = pX;
        this.y = -1.0f;
        TreeNodePosition treenodeposition = null;
        for (Advancement advancement : pAdvancement.getChildren()) {
            treenodeposition = this.addChild(advancement, treenodeposition);
        }
    }

    @Nullable
    private TreeNodePosition addChild(Advancement pAdvancement, @Nullable TreeNodePosition pPrevious) {
        if (pAdvancement.getDisplay() != null) {
            pPrevious = new TreeNodePosition(pAdvancement, this, pPrevious, this.children.size() + 1, this.x + 1);
            this.children.add(pPrevious);
        } else {
            for (Advancement advancement : pAdvancement.getChildren()) {
                pPrevious = this.addChild(advancement, pPrevious);
            }
        }
        return pPrevious;
    }

    private void firstWalk() {
        if (this.children.isEmpty()) {
            this.y = this.previousSibling != null ? this.previousSibling.y + 1.0f : 0.0f;
        } else {
            TreeNodePosition treenodeposition = null;
            for (TreeNodePosition treenodeposition1 : this.children) {
                treenodeposition1.firstWalk();
                treenodeposition = treenodeposition1.apportion(treenodeposition == null ? treenodeposition1 : treenodeposition);
            }
            this.executeShifts();
            float f = (this.children.get((int)0).y + this.children.get((int)(this.children.size() - 1)).y) / 2.0f;
            if (this.previousSibling != null) {
                this.y = this.previousSibling.y + 1.0f;
                this.mod = this.y - f;
            } else {
                this.y = f;
            }
        }
    }

    private float secondWalk(float pOffsetY, int pColumnX, float pSubtreeTopY) {
        this.y += pOffsetY;
        this.x = pColumnX;
        if (this.y < pSubtreeTopY) {
            pSubtreeTopY = this.y;
        }
        for (TreeNodePosition treenodeposition : this.children) {
            pSubtreeTopY = treenodeposition.secondWalk(pOffsetY + this.mod, pColumnX + 1, pSubtreeTopY);
        }
        return pSubtreeTopY;
    }

    private void thirdWalk(float pY) {
        this.y += pY;
        for (TreeNodePosition treenodeposition : this.children) {
            treenodeposition.thirdWalk(pY);
        }
    }

    private void executeShifts() {
        float f = 0.0f;
        float f1 = 0.0f;
        int i = this.children.size() - 1;
        while (i >= 0) {
            TreeNodePosition treenodeposition = this.children.get(i);
            treenodeposition.y += f;
            treenodeposition.mod += f;
            f += treenodeposition.shift + (f1 += treenodeposition.change);
            --i;
        }
    }

    @Nullable
    private TreeNodePosition previousOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        return !this.children.isEmpty() ? this.children.get(0) : null;
    }

    @Nullable
    private TreeNodePosition nextOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        return !this.children.isEmpty() ? this.children.get(this.children.size() - 1) : null;
    }

    private TreeNodePosition apportion(TreeNodePosition pNode) {
        if (this.previousSibling == null) {
            return pNode;
        }
        TreeNodePosition treenodeposition = this;
        TreeNodePosition treenodeposition1 = this;
        TreeNodePosition treenodeposition2 = this.previousSibling;
        TreeNodePosition treenodeposition3 = this.parent.children.get(0);
        float f = this.mod;
        float f1 = this.mod;
        float f2 = treenodeposition2.mod;
        float f3 = treenodeposition3.mod;
        while (treenodeposition2.nextOrThread() != null && treenodeposition.previousOrThread() != null) {
            treenodeposition2 = treenodeposition2.nextOrThread();
            treenodeposition = treenodeposition.previousOrThread();
            treenodeposition3 = treenodeposition3.previousOrThread();
            treenodeposition1 = treenodeposition1.nextOrThread();
            treenodeposition1.ancestor = this;
            float f4 = treenodeposition2.y + f2 - (treenodeposition.y + f) + 1.0f;
            if (f4 > 0.0f) {
                treenodeposition2.getAncestor(this, pNode).moveSubtree(this, f4);
                f += f4;
                f1 += f4;
            }
            f2 += treenodeposition2.mod;
            f += treenodeposition.mod;
            f3 += treenodeposition3.mod;
            f1 += treenodeposition1.mod;
        }
        if (treenodeposition2.nextOrThread() != null && treenodeposition1.nextOrThread() == null) {
            treenodeposition1.thread = treenodeposition2.nextOrThread();
            treenodeposition1.mod += f2 - f1;
        } else {
            if (treenodeposition.previousOrThread() != null && treenodeposition3.previousOrThread() == null) {
                treenodeposition3.thread = treenodeposition.previousOrThread();
                treenodeposition3.mod += f - f3;
            }
            pNode = this;
        }
        return pNode;
    }

    private void moveSubtree(TreeNodePosition pNode, float pShift) {
        float f = pNode.childIndex - this.childIndex;
        if (f != 0.0f) {
            pNode.change -= pShift / f;
            this.change += pShift / f;
        }
        pNode.shift += pShift;
        pNode.y += pShift;
        pNode.mod += pShift;
    }

    private TreeNodePosition getAncestor(TreeNodePosition pSelf, TreeNodePosition pOther) {
        return this.ancestor != null && pSelf.parent.children.contains(this.ancestor) ? this.ancestor : pOther;
    }

    private void finalizePosition() {
        if (this.advancement.getDisplay() != null) {
            this.advancement.getDisplay().setLocation(this.x, this.y);
        }
        if (!this.children.isEmpty()) {
            for (TreeNodePosition treenodeposition : this.children) {
                treenodeposition.finalizePosition();
            }
        }
    }

    public static void run(Advancement pRoot) {
        if (pRoot.getDisplay() == null) {
            throw new IllegalArgumentException("Can't position children of an invisible root!");
        }
        TreeNodePosition treenodeposition = new TreeNodePosition(pRoot, null, null, 1, 0);
        treenodeposition.firstWalk();
        float f = treenodeposition.secondWalk(0.0f, 0, treenodeposition.y);
        if (f < 0.0f) {
            treenodeposition.thirdWalk(-f);
        }
        treenodeposition.finalizePosition();
    }
}

