/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BeeNestDestroyedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("bee_nest_destroyed");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        Block block = BeeNestDestroyedTrigger.deserializeBlock(pJson);
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("item"));
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("num_bees_inside"));
        return new TriggerInstance(pEntityPredicate, block, itempredicate, minmaxbounds$ints);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject pJson) {
        if (pJson.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(pJson, "block"));
            return Registry.BLOCK.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + resourcelocation + "'"));
        }
        return null;
    }

    public void trigger(ServerPlayer pPlayer, BlockState pState, ItemStack pStack, int pNumBees) {
        this.trigger(pPlayer, p_146660_ -> p_146660_.matches(pState, pStack, pNumBees));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Block block;
        private final ItemPredicate item;
        private final MinMaxBounds.Ints numBees;

        public TriggerInstance(EntityPredicate.Composite pPlayer, @Nullable Block pBlock, ItemPredicate pItem, MinMaxBounds.Ints pNumBees) {
            super(ID, pPlayer);
            this.block = pBlock;
            this.item = pItem;
            this.numBees = pNumBees;
        }

        public static TriggerInstance destroyedBeeNest(Block pBlock, ItemPredicate.Builder pItemPredicateBuilder, MinMaxBounds.Ints pBeesContained) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pBlock, pItemPredicateBuilder.build(), pBeesContained);
        }

        public boolean matches(BlockState pState, ItemStack pStack, int pNumBees) {
            if (this.block != null && !pState.is(this.block)) {
                return false;
            }
            return !this.item.matches(pStack) ? false : this.numBees.matches(pNumBees);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            if (this.block != null) {
                jsonobject.addProperty("block", Registry.BLOCK.getKey(this.block).toString());
            }
            jsonobject.add("item", this.item.serializeToJson());
            jsonobject.add("num_bees_inside", this.numBees.serializeToJson());
            return jsonobject;
        }
    }
}

