/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;

public class BredAnimalsTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("bred_animals");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pJson, "parent", pConditionsParser);
        EntityPredicate.Composite entitypredicate$composite1 = EntityPredicate.Composite.fromJson(pJson, "partner", pConditionsParser);
        EntityPredicate.Composite entitypredicate$composite2 = EntityPredicate.Composite.fromJson(pJson, "child", pConditionsParser);
        return new TriggerInstance(pEntityPredicate, entitypredicate$composite, entitypredicate$composite1, entitypredicate$composite2);
    }

    public void trigger(ServerPlayer p_147279_, Animal p_147280_, Animal p_147281_, @Nullable AgeableMob p_147282_) {
        LootContext lootcontext = EntityPredicate.createContext(p_147279_, p_147280_);
        LootContext lootcontext1 = EntityPredicate.createContext(p_147279_, p_147281_);
        LootContext lootcontext2 = p_147282_ != null ? EntityPredicate.createContext(p_147279_, p_147282_) : null;
        this.trigger(p_147279_, p_18653_ -> p_18653_.matches(lootcontext, lootcontext1, lootcontext2));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite parent;
        private final EntityPredicate.Composite partner;
        private final EntityPredicate.Composite child;

        public TriggerInstance(EntityPredicate.Composite pPlayer, EntityPredicate.Composite pParent, EntityPredicate.Composite pPartner, EntityPredicate.Composite pChild) {
            super(ID, pPlayer);
            this.parent = pParent;
            this.partner = pPartner;
            this.child = pChild;
        }

        public static TriggerInstance bredAnimals() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY);
        }

        public static TriggerInstance bredAnimals(EntityPredicate.Builder pChildBuilder) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pChildBuilder.build()));
        }

        public static TriggerInstance bredAnimals(EntityPredicate pParent, EntityPredicate pPartner, EntityPredicate pChild) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pParent), EntityPredicate.Composite.wrap(pPartner), EntityPredicate.Composite.wrap(pChild));
        }

        public boolean matches(LootContext pParentContext, LootContext pPartnerContext, @Nullable LootContext pChildContext) {
            if (this.child == EntityPredicate.Composite.ANY || pChildContext != null && this.child.matches(pChildContext)) {
                return this.parent.matches(pParentContext) && this.partner.matches(pPartnerContext) || this.parent.matches(pPartnerContext) && this.partner.matches(pParentContext);
            }
            return false;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("parent", this.parent.toJson(pConditions));
            jsonobject.add("partner", this.partner.toJson(pConditions));
            jsonobject.add("child", this.child.toJson(pConditions));
            return jsonobject;
        }
    }
}

