/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.alchemy.Potion;

public class BrewedPotionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("brewed_potion");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        Potion potion = null;
        if (pJson.has("potion")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(pJson, "potion"));
            potion = Registry.POTION.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + resourcelocation + "'"));
        }
        return new TriggerInstance(pEntityPredicate, potion);
    }

    public void trigger(ServerPlayer pPlayer, Potion pPotion) {
        this.trigger(pPlayer, (T p_19125_) -> p_19125_.matches(pPotion));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Potion potion;

        public TriggerInstance(EntityPredicate.Composite pPlayer, @Nullable Potion pPotion) {
            super(ID, pPlayer);
            this.potion = pPotion;
        }

        public static TriggerInstance brewedPotion() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, null);
        }

        public boolean matches(Potion pPotion) {
            return this.potion == null || this.potion == pPotion;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            if (this.potion != null) {
                jsonobject.addProperty("potion", Registry.POTION.getKey(this.potion).toString());
            }
            return jsonobject;
        }
    }
}

