/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class ChangeDimensionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("changed_dimension");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ResourceKey<Level> resourcekey = pJson.has("from") ? ResourceKey.create(Registry.DIMENSION_REGISTRY, new ResourceLocation(GsonHelper.getAsString(pJson, "from"))) : null;
        ResourceKey<Level> resourcekey1 = pJson.has("to") ? ResourceKey.create(Registry.DIMENSION_REGISTRY, new ResourceLocation(GsonHelper.getAsString(pJson, "to"))) : null;
        return new TriggerInstance(pEntityPredicate, resourcekey, resourcekey1);
    }

    public void trigger(ServerPlayer pPlayer, ResourceKey<Level> pFromLevel, ResourceKey<Level> pToLevel) {
        this.trigger(pPlayer, p_19768_ -> p_19768_.matches(pFromLevel, pToLevel));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final ResourceKey<Level> from;
        @Nullable
        private final ResourceKey<Level> to;

        public TriggerInstance(EntityPredicate.Composite pPlayer, @Nullable ResourceKey<Level> pFrom, @Nullable ResourceKey<Level> pTo) {
            super(ID, pPlayer);
            this.from = pFrom;
            this.to = pTo;
        }

        public static TriggerInstance changedDimension() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, null, null);
        }

        public static TriggerInstance changedDimension(ResourceKey<Level> pFrom, ResourceKey<Level> pTo) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pFrom, pTo);
        }

        public static TriggerInstance changedDimensionTo(ResourceKey<Level> pTo) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, null, pTo);
        }

        public static TriggerInstance changedDimensionFrom(ResourceKey<Level> pFrom) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pFrom, null);
        }

        public boolean matches(ResourceKey<Level> pFromLevel, ResourceKey<Level> pToLevel) {
            if (this.from != null && this.from != pFromLevel) {
                return false;
            }
            return this.to == null || this.to == pToLevel;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            if (this.from != null) {
                jsonobject.addProperty("from", this.from.location().toString());
            }
            if (this.to != null) {
                jsonobject.addProperty("to", this.to.location().toString());
            }
            return jsonobject;
        }
    }
}

