/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class ChanneledLightningTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("channeled_lightning");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        EntityPredicate.Composite[] aentitypredicate$composite = EntityPredicate.Composite.fromJsonArray(pJson, "victims", pConditionsParser);
        return new TriggerInstance(pEntityPredicate, aentitypredicate$composite);
    }

    @Override
    public void trigger(ServerPlayer pPlayer, Collection<? extends Entity> pEntityTriggered) {
        List list = pEntityTriggered.stream().map(p_21720_ -> EntityPredicate.createContext(pPlayer, p_21720_)).collect(Collectors.toList());
        this.trigger(pPlayer, (T p_21730_) -> p_21730_.matches(list));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite[] victims;

        public TriggerInstance(EntityPredicate.Composite pPlayer, EntityPredicate.Composite[] pVictims) {
            super(ID, pPlayer);
            this.victims = pVictims;
        }

        public static TriggerInstance a(EntityPredicate ... p_21747_) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, (EntityPredicate.Composite[])Stream.of(p_21747_).map(EntityPredicate.Composite::wrap).toArray(EntityPredicate.Composite[]::new));
        }

        public boolean matches(Collection<? extends LootContext> pVictims) {
            EntityPredicate.Composite[] compositeArray = this.victims;
            int n = this.victims.length;
            int n2 = 0;
            while (n2 < n) {
                EntityPredicate.Composite entitypredicate$composite = compositeArray[n2];
                boolean flag = false;
                for (LootContext lootContext : pVictims) {
                    if (!entitypredicate$composite.matches(lootContext)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("victims", EntityPredicate.Composite.a(this.victims, pConditions));
            return jsonobject;
        }
    }
}

